/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jetty.v11.server;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public class HandleInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        HttpChannel httpChannel = (HttpChannel)objInst;
        Request servletRequest = httpChannel.getRequest();
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            next.setHeadValue(servletRequest.getHeader(next.getHeadKey()));
        }
        AbstractSpan span = ContextManager.createEntrySpan((String)servletRequest.getRequestURI(), (ContextCarrier)contextCarrier);
        Tags.URL.set(span, servletRequest.getRequestURL().toString());
        Tags.HTTP.METHOD.set(span, servletRequest.getMethod());
        span.setComponent((Component)ComponentsDefine.JETTY_SERVER);
        SpanLayer.asHttp((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        HttpChannel httpChannel = (HttpChannel)objInst;
        Response servletResponse = httpChannel.getResponse();
        AbstractSpan span = ContextManager.activeSpan();
        Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(servletResponse.getStatus()));
        if (servletResponse.getStatus() >= 400) {
            span.errorOccurred();
        }
        ContextManager.stopSpan();
        ContextManager.getRuntimeContext().remove((Object)"SW_FORWARD_REQUEST_FLAG");
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

