/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.profile;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.TracingContext;
import org.apache.skywalking.apm.agent.core.profile.ProfileStatus;

public class ProfileStatusContext {
    private volatile ProfileStatus status;
    private volatile boolean fromFirstSegment;
    private volatile long firstSegmentCreateTime;
    private volatile AtomicInteger subThreadProfilingCount;

    private ProfileStatusContext(ProfileStatus status, long firstSegmentCreateTime, AtomicInteger subThreadProfilingCount) {
        this.status = status;
        this.fromFirstSegment = true;
        this.firstSegmentCreateTime = firstSegmentCreateTime;
        this.subThreadProfilingCount = subThreadProfilingCount;
    }

    public static ProfileStatusContext createWithNone() {
        return new ProfileStatusContext(ProfileStatus.NONE, 0L, null);
    }

    public static ProfileStatusContext createWithPending(long firstSegmentCreateTime) {
        return new ProfileStatusContext(ProfileStatus.PENDING, firstSegmentCreateTime, new AtomicInteger(0));
    }

    public ProfileStatus get() {
        return this.status;
    }

    public long firstSegmentCreateTime() {
        return this.firstSegmentCreateTime;
    }

    public boolean isFromFirstSegment() {
        return this.fromFirstSegment;
    }

    public boolean isBeingWatched() {
        return this.status != ProfileStatus.NONE;
    }

    public boolean isProfiling() {
        return this.status == ProfileStatus.PROFILING;
    }

    public ProfileStatusContext clone() {
        return new ProfileStatusContext(this.status, this.firstSegmentCreateTime, this.subThreadProfilingCount);
    }

    public boolean continued(ContextSnapshot snapshot) {
        this.status = snapshot.getProfileStatusContext().get();
        this.fromFirstSegment = false;
        this.firstSegmentCreateTime = snapshot.getProfileStatusContext().firstSegmentCreateTime();
        this.subThreadProfilingCount = snapshot.getProfileStatusContext().subThreadProfilingCount;
        return this.isBeingWatched() && this.subThreadProfilingCount != null && this.subThreadProfilingCount.incrementAndGet() <= Config.Profile.MAX_ACCEPT_SUB_PARALLEL;
    }

    void updateStatus(ProfileStatus status, TracingContext tracingContext) {
        this.status = status;
        if (this.firstSegmentCreateTime == 0L && tracingContext != null) {
            this.firstSegmentCreateTime = tracingContext.createTime();
        }
    }

    void updateStatus(ProfileStatusContext statusContext) {
        this.status = statusContext.get();
        this.firstSegmentCreateTime = statusContext.firstSegmentCreateTime();
        this.subThreadProfilingCount = statusContext.subThreadProfilingCount;
    }
}

