/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.logging.core;

import org.apache.skywalking.apm.agent.core.boot.AgentPackageNotFoundException;
import org.apache.skywalking.apm.agent.core.boot.AgentPackagePath;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.SnifferConfigInitializer;
import org.apache.skywalking.apm.agent.core.logging.core.FileWriter;
import org.apache.skywalking.apm.agent.core.logging.core.IWriter;
import org.apache.skywalking.apm.agent.core.logging.core.SystemOutWriter;
import org.apache.skywalking.apm.agent.core.plugin.PluginFinder;
import org.apache.skywalking.apm.util.StringUtil;

public class WriterFactory {
    private static IWriter WRITER;

    public static IWriter getLogWriter() {
        switch (Config.Logging.OUTPUT) {
            case FILE: {
                if (WRITER != null) {
                    return WRITER;
                }
                if (SnifferConfigInitializer.isInitCompleted() && PluginFinder.isPluginInitCompleted() && AgentPackagePath.isPathFound()) {
                    if (StringUtil.isEmpty(Config.Logging.DIR)) {
                        try {
                            Config.Logging.DIR = AgentPackagePath.getPath() + "/logs";
                        }
                        catch (AgentPackageNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    WRITER = FileWriter.get();
                    break;
                }
                return SystemOutWriter.INSTANCE;
            }
            default: {
                return SystemOutWriter.INSTANCE;
            }
        }
        return WRITER;
    }
}

