/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor;

import com.google.common.eventbus.Subscribe;
import io.micrometer.core.instrument.Meter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.dashboard.client.model.InterfaceInfo;
import org.apache.servicecomb.dashboard.client.model.MonitorData;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.metrics.PolledEvent;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.data.MonitorConstant;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.model.MonitorDataProvider;
import org.apache.servicecomb.metrics.core.publish.PublishModelFactory;
import org.apache.servicecomb.metrics.core.publish.model.DefaultPublishModel;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerf;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerfGroup;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerfGroups;
import org.apache.servicecomb.metrics.core.publish.model.invocation.PerfInfo;
import org.apache.servicecomb.registry.sc.SCRegistration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class MetricsMonitorDataProvider
implements MonitorDataProvider {
    public static final String CODE_SUCCESS = "2[0-9]{2}";
    public static final String CODE_TIMEOUT = "408";
    public static final String NAME_PROVIDER = "Provider.";
    public static final String NAME_CONSUMER = "Consumer.";
    private volatile List<Meter> meters = null;
    private SCRegistration scRegistration;
    private Environment environment;
    private MonitorConstant monitorConstant;

    public MetricsMonitorDataProvider() {
        EventManager.register((Object)this);
    }

    @Autowired
    public void setSCRegistration(SCRegistration scRegistration) {
        this.scRegistration = scRegistration;
    }

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Autowired
    public void setMonitorConstant(MonitorConstant monitorConstant) {
        this.monitorConstant = monitorConstant;
    }

    @Override
    public boolean enabled() {
        return (Boolean)this.environment.getProperty("servicecomb.monitor.provider.metrics.enabled", Boolean.TYPE, (Object)true);
    }

    @Override
    public String getURL() {
        return String.format(this.monitorConstant.getMonitorUri(), this.scRegistration.getMicroserviceInstance().getServiceName());
    }

    @Override
    public void extractServiceInfo(MonitorData monitorData) {
        monitorData.setAppId(this.scRegistration.getMicroserviceInstance().getApplication());
        monitorData.setName(this.scRegistration.getMicroserviceInstance().getServiceName());
        monitorData.setVersion(this.scRegistration.getMicroserviceInstance().getVersion());
        monitorData.setServiceId(this.scRegistration.getMicroserviceInstance().getBackendMicroservice().getServiceId());
        monitorData.setInstance(this.scRegistration.getMicroserviceInstance().getBackendMicroserviceInstance().getHostName());
        monitorData.setInstanceId(this.scRegistration.getMicroserviceInstance().getInstanceId());
        monitorData.setEnvironment(this.scRegistration.getMicroserviceInstance().getEnvironment());
    }

    @Override
    public void extractInterfaceInfo(MonitorData monitorData) {
        if (this.meters == null) {
            return;
        }
        PublishModelFactory factory = new PublishModelFactory(this.meters);
        DefaultPublishModel model = factory.createDefaultPublishModel();
        HashMap<String, InterfaceInfo> combinedResults = new HashMap<String, InterfaceInfo>();
        this.extractProviderInfo(model, combinedResults);
        this.extractConsumerInfo(model, combinedResults);
        this.extractEdgeInfo(model, combinedResults);
        combinedResults.forEach((k, v) -> {
            v.setFailureRate(v.getTotal() == 0L ? 0.0 : (double)v.getFailure() / (double)v.getTotal());
            monitorData.addInterfaceInfo(v);
        });
    }

    private void extractProviderInfo(DefaultPublishModel model, Map<String, InterfaceInfo> combinedResults) {
        OperationPerfGroups producerPerf = model.getProducer().getOperationPerfGroups();
        if (producerPerf == null) {
            return;
        }
        for (Map statusMap : producerPerf.getGroups().values()) {
            for (OperationPerfGroup perfGroup : statusMap.values()) {
                for (int i = 0; i < perfGroup.getOperationPerfs().size(); ++i) {
                    OperationPerf operationPerf = (OperationPerf)perfGroup.getOperationPerfs().get(i);
                    PerfInfo stageTotal = operationPerf.findStage("total");
                    String name = NAME_PROVIDER + operationPerf.getOperation();
                    InterfaceInfo interfaceInfo = combinedResults.computeIfAbsent(name, k -> {
                        InterfaceInfo obj = new InterfaceInfo();
                        obj.setName(name);
                        return obj;
                    });
                    interfaceInfo.setTotal((long)this.doubleToInt((double)interfaceInfo.getTotal() + stageTotal.getTotalRequests()));
                    if (perfGroup.getStatus().matches(CODE_SUCCESS)) {
                        interfaceInfo.setQps(stageTotal.getTotalRequests() / 10.0);
                        interfaceInfo.setLatency(this.doubleToInt(stageTotal.calcMsLatency()));
                        continue;
                    }
                    interfaceInfo.setFailure((long)this.doubleToInt((double)interfaceInfo.getTotal() + stageTotal.getTotalRequests()));
                    if (!perfGroup.getStatus().equals(CODE_TIMEOUT)) continue;
                    interfaceInfo.setCountTimeout((long)this.doubleToInt((double)interfaceInfo.getCountTimeout() + stageTotal.getTotalRequests()));
                }
            }
        }
    }

    private void extractEdgeInfo(DefaultPublishModel model, Map<String, InterfaceInfo> combinedResults) {
        OperationPerfGroups edgePerf = model.getEdge().getOperationPerfGroups();
        if (edgePerf == null) {
            return;
        }
        for (Map statusMap : edgePerf.getGroups().values()) {
            for (OperationPerfGroup perfGroup : statusMap.values()) {
                for (int i = 0; i < perfGroup.getOperationPerfs().size(); ++i) {
                    OperationPerf operationPerf = (OperationPerf)perfGroup.getOperationPerfs().get(i);
                    PerfInfo stageTotal = operationPerf.findStage("total");
                    String name = NAME_CONSUMER + operationPerf.getOperation();
                    InterfaceInfo interfaceInfo = combinedResults.computeIfAbsent(name, k -> {
                        InterfaceInfo obj = new InterfaceInfo();
                        obj.setName(name);
                        return obj;
                    });
                    interfaceInfo.setTotal((long)this.doubleToInt((double)interfaceInfo.getTotal() + stageTotal.getTotalRequests()));
                    if (perfGroup.getStatus().matches(CODE_SUCCESS)) {
                        interfaceInfo.setQps(stageTotal.getTotalRequests() / 10.0);
                        interfaceInfo.setLatency(this.doubleToInt(stageTotal.calcMsLatency()));
                        continue;
                    }
                    interfaceInfo.setFailure((long)this.doubleToInt((double)interfaceInfo.getTotal() + stageTotal.getTotalRequests()));
                    if (!perfGroup.getStatus().equals(CODE_TIMEOUT)) continue;
                    interfaceInfo.setCountTimeout((long)this.doubleToInt((double)interfaceInfo.getCountTimeout() + stageTotal.getTotalRequests()));
                }
            }
        }
    }

    private void extractConsumerInfo(DefaultPublishModel model, Map<String, InterfaceInfo> combinedResults) {
        OperationPerfGroups consumerPerf = model.getConsumer().getOperationPerfGroups();
        if (consumerPerf == null) {
            return;
        }
        for (Map statusMap : consumerPerf.getGroups().values()) {
            for (OperationPerfGroup perfGroup : statusMap.values()) {
                for (int i = 0; i < perfGroup.getOperationPerfs().size(); ++i) {
                    OperationPerf operationPerf = (OperationPerf)perfGroup.getOperationPerfs().get(i);
                    PerfInfo stageTotal = operationPerf.findStage("total");
                    String name = NAME_CONSUMER + operationPerf.getOperation();
                    InterfaceInfo interfaceInfo = combinedResults.computeIfAbsent(name, k -> {
                        InterfaceInfo obj = new InterfaceInfo();
                        obj.setName(name);
                        return obj;
                    });
                    interfaceInfo.setTotal((long)this.doubleToInt((double)interfaceInfo.getTotal() + stageTotal.getTotalRequests()));
                    if (perfGroup.getStatus().matches(CODE_SUCCESS)) {
                        interfaceInfo.setQps(stageTotal.getTotalRequests() / 10.0);
                        interfaceInfo.setLatency(this.doubleToInt(stageTotal.calcMsLatency()));
                        continue;
                    }
                    interfaceInfo.setFailure((long)this.doubleToInt((double)interfaceInfo.getTotal() + stageTotal.getTotalRequests()));
                    if (!perfGroup.getStatus().equals(CODE_TIMEOUT)) continue;
                    interfaceInfo.setCountTimeout((long)this.doubleToInt((double)interfaceInfo.getCountTimeout() + stageTotal.getTotalRequests()));
                }
            }
        }
    }

    private int doubleToInt(Double d) {
        return d.intValue();
    }

    @Subscribe
    public void onPolledEvent(PolledEvent event) {
        this.meters = event.getMeters();
    }
}

