/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AbstractConsumeAllOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.ColumnMerger;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public class FullOuterTimeJoinOperator
extends AbstractConsumeAllOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(FullOuterTimeJoinOperator.class) + RamUsageEstimator.shallowSizeOfInstance(TimeSelector.class);
    private final int[] inputIndex;
    private final int[] shadowInputIndex;
    private final boolean[] noMoreTsBlocks;
    private final TimeSelector timeSelector;
    private final int outputColumnCount;
    private final List<TSDataType> dataTypes;
    private final List<ColumnMerger> mergers;
    private final TsBlockBuilder tsBlockBuilder;
    private boolean finished;
    private final TimeComparator comparator;

    public FullOuterTimeJoinOperator(OperatorContext operatorContext, List<Operator> children, Ordering mergeOrder, List<TSDataType> dataTypes, List<ColumnMerger> mergers, TimeComparator comparator) {
        super(operatorContext, children);
        Preconditions.checkArgument((!children.isEmpty() ? 1 : 0) != 0, (Object)"child size of TimeJoinOperator should be larger than 0");
        this.inputIndex = new int[this.inputOperatorsCount];
        this.shadowInputIndex = new int[this.inputOperatorsCount];
        this.noMoreTsBlocks = new boolean[this.inputOperatorsCount];
        this.timeSelector = new TimeSelector(this.inputOperatorsCount << 1, Ordering.ASC == mergeOrder);
        this.outputColumnCount = dataTypes.size();
        this.dataTypes = dataTypes;
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.mergers = mergers;
        this.comparator = comparator;
        this.maxReturnSize = Math.min(this.maxReturnSize, (1L + (long)this.outputColumnCount) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte());
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        boolean hasReadyChild = false;
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] || !this.isEmpty(i) || this.children.get(i) == null) continue;
            ListenableFuture<?> blocked = ((Operator)this.children.get(i)).isBlocked();
            if (blocked.isDone()) {
                hasReadyChild = true;
                this.canCallNext[i] = true;
                continue;
            }
            listenableFutures.add(blocked);
        }
        return hasReadyChild || listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    @Override
    public TsBlock next() throws Exception {
        long currentTime;
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        this.tsBlockBuilder.reset();
        if (!this.prepareInput()) {
            return null;
        }
        long currentEndTime = 0L;
        boolean init = false;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i]) continue;
            currentEndTime = init ? this.comparator.getCurrentEndTime(currentEndTime, this.inputTsBlocks[i].getEndTime()) : this.inputTsBlocks[i].getEndTime();
            init = true;
        }
        if (this.timeSelector.isEmpty()) {
            TsBlockBuilder emptyTsBlockBuilder = new TsBlockBuilder(0, this.dataTypes);
            return emptyTsBlockBuilder.build();
        }
        TimeColumnBuilder timeBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        do {
            currentTime = this.timeSelector.pollFirst();
            timeBuilder.writeLong(currentTime);
            this.appendOneRow(currentTime);
            this.tsBlockBuilder.declarePosition();
            this.prepareForTimeHeap();
        } while (this.comparator.lessThan(currentTime, currentEndTime) && !this.timeSelector.isEmpty());
        this.resultTsBlock = this.tsBlockBuilder.build();
        return this.checkTsBlockSizeAndGetResult();
    }

    private void appendOneRow(long currentTime) {
        for (int i = 0; i < this.outputColumnCount; ++i) {
            ColumnMerger merger = this.mergers.get(i);
            merger.mergeColumn(this.inputTsBlocks, this.inputIndex, this.shadowInputIndex, currentTime, this.tsBlockBuilder.getColumnBuilder(i));
        }
    }

    private void prepareForTimeHeap() {
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.inputIndex[i] == this.shadowInputIndex[i]) continue;
            this.inputIndex[i] = this.shadowInputIndex[i];
            if (this.isEmpty(i)) continue;
            this.updateTimeSelector(i);
        }
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.finished) {
            return false;
        }
        if (this.retainedTsBlock != null) {
            return true;
        }
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.isEmpty(i)) {
                return true;
            }
            if (this.noMoreTsBlocks[i]) continue;
            if (!this.canCallNext[i] || ((Operator)this.children.get(i)).hasNextWithTimer()) {
                return true;
            }
            this.noMoreTsBlocks[i] = true;
            this.inputTsBlocks[i] = null;
            ((Operator)this.children.get(i)).close();
            this.children.set(i, null);
        }
        return false;
    }

    @Override
    public boolean isFinished() throws Exception {
        if (this.finished) {
            return true;
        }
        if (this.retainedTsBlock != null) {
            return false;
        }
        this.finished = true;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] && this.isEmpty(i)) continue;
            this.finished = false;
            break;
        }
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = 0L;
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, maxPeekMemory + child.calculateMaxPeekMemoryWithCounter());
            maxPeekMemory += child.calculateMaxReturnSize() + child.calculateRetainedSizeAfterCallingNext();
        }
        return Math.max(maxPeekMemory += this.calculateMaxReturnSize(), childrenMaxPeekMemory);
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long currentRetainedSize = 0L;
        long minChildReturnSize = Long.MAX_VALUE;
        for (Operator child : this.children) {
            long maxReturnSize = child.calculateMaxReturnSize();
            currentRetainedSize += maxReturnSize + child.calculateRetainedSizeAfterCallingNext();
            minChildReturnSize = Math.min(minChildReturnSize, maxReturnSize);
        }
        return currentRetainedSize - minChildReturnSize;
    }

    private void updateTimeSelector(int index) {
        this.timeSelector.add(this.inputTsBlocks[index].getTimeByIndex(this.inputIndex[index]));
    }

    @Override
    protected boolean canSkipCurrentChild(int currentChildIndex) {
        return this.noMoreTsBlocks[currentChildIndex] || !this.isEmpty(currentChildIndex) || this.children.get(currentChildIndex) == null;
    }

    @Override
    protected void processCurrentInputTsBlock(int currentInputIndex) {
        this.updateTimeSelector(currentInputIndex);
    }

    @Override
    protected void handleFinishedChild(int currentChildIndex) throws Exception {
        this.noMoreTsBlocks[currentChildIndex] = true;
        this.inputTsBlocks[currentChildIndex] = null;
        ((Operator)this.children.get(currentChildIndex)).close();
        this.children.set(currentChildIndex, null);
    }

    @TestOnly
    public List<Operator> getChildren() {
        return this.children;
    }

    @Override
    protected TsBlock getNextTsBlock(int childIndex) throws Exception {
        this.inputIndex[childIndex] = 0;
        return ((Operator)this.children.get(childIndex)).nextWithTimer();
    }

    @Override
    protected boolean isEmpty(int columnIndex) {
        return this.inputTsBlocks[columnIndex] == null || this.inputTsBlocks[columnIndex].getPositionCount() == this.inputIndex[columnIndex];
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.children.stream().mapToLong(MemoryEstimationHelper::getEstimatedSizeOfAccountableObject).sum() + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + RamUsageEstimator.sizeOf((boolean[])this.canCallNext) + RamUsageEstimator.sizeOf((boolean[])this.noMoreTsBlocks) + RamUsageEstimator.sizeOf((int[])this.inputIndex) + RamUsageEstimator.sizeOf((int[])this.shadowInputIndex) + this.tsBlockBuilder.getRetainedSizeInBytes();
    }
}

