#The data was derived from twelve monthly electrical power demand
#time series from Italy and first used in the paper "Intelligent
#Icons: Integrating Lite-Weight Data Mining and Visualization into
#GUI Operating Systems". The classification task is to distinguish
#days from Oct to March (inclusive) from April to September.
@problemName ItalyPowerDemand
@timeStamps false
@missing false
@univariate true
@equalLength true
@seriesLength 24
@classLabel true 1 2
@data
0.47297301,-0.39603003,-0.72190616,-1.1564077,-1.2107204,-1.0477823,-0.77621885,-1.3193458,-0.83053154,0.25572225,0.96178719,1.1247253,0.58159839,0.20140956,-0.23309196,-0.34171734,-0.66759347,-0.72190616,-0.45034272,-0.015841201,0.79884913,2.2652918,1.9394156,1.2876634:2
-1.0987371,-1.1345655,-1.6003345,-1.7078197,-1.6361629,-1.457021,-1.0270804,-0.7046249,0.4777118,1.2301079,1.2659363,1.1226227,0.76433888,0.65685372,0.51354018,0.62102534,0.72851049,0.37022664,0.40605503,0.37022664,0.083599559,1.0151376,0.62102534,0.11942795:2
-1.0294417,-1.2401589,-1.3455176,-1.5562348,-1.4772159,-1.3455176,-1.4508762,-0.76604505,0.26120162,0.97237239,1.1304104,1.1830897,0.76165513,0.89335341,0.89335341,1.077731,1.1040707,0.78799479,0.62995684,0.36656025,0.050484349,-0.054874285,0.26120162,-0.10755361:2
0.29127426,-0.32389698,-0.88314355,-1.1068422,-1.2746162,-0.65944492,-0.88314355,-0.49167095,-1.1627668,-0.32389698,0.57089755,0.62682221,0.62682221,-0.10019835,-0.32389698,-0.32389698,-0.65944492,-0.54759561,-0.54759561,0.40312358,2.3604866,2.0249387,1.80124,0.9064455:2
-0.8146062,-1.2711438,-1.5665504,-1.6202607,-1.6471159,-1.4054195,-1.0294474,-0.46548926,0.79670278,1.4143712,1.3069506,1.3338058,1.0921094,0.55500643,0.68928218,0.55500643,0.52815128,0.25959978,0.12532403,0.20588948,0.23274463,0.79670278,0.25959978,-0.33121351:2
-1.146064,-1.4167468,-1.5833208,-1.5833208,-1.6249643,-1.4583903,-0.87538126,-8.6758111E-4,0.39474574,1.0193983,0.97775486,0.83200259,0.62378504,0.37392399,0.43638925,0.54049803,0.56131978,0.6446068,1.2900811,1.3525464,0.72789382,0.47803276,-0.021689336,-0.54223318:1
-0.97403341,-1.092547,-1.2999457,-1.4480877,-1.4480877,-1.2999457,-1.3295741,-0.70737788,0.27035908,1.2184677,1.3073528,1.4258664,1.0406973,0.80367015,0.95181212,1.0703257,0.89255533,0.80367015,0.53701462,-0.055553242,-0.23332359,-0.26295199,0.092588721,-0.26295199:2
0.15976135,-0.26043289,-0.83819998,-1.1008214,-1.2058699,-1.1533456,-1.1533456,-1.6260641,-0.99577282,-0.10286005,0.47490703,0.73752844,0.73752844,0.52743132,-0.20790861,-0.10286005,-0.26043289,-0.31295716,0.10723707,0.31733419,0.73752844,2.2082082,2.1031597,1.2102469:2
-0.94792101,-1.2675946,-1.4807103,-1.5606287,-1.6139077,-1.5339893,-1.1077578,-0.25529488,0.5438891,1.2365152,1.3430731,1.3430731,0.97012056,0.57052857,0.59716804,0.73036537,0.83692323,0.51724964,0.35741284,0.19757604,0.65044697,0.4639707,-0.095458087,-0.49505008:2
-0.78212756,-1.059806,-1.2819487,-1.4763237,-1.4763237,-1.420788,-1.4763237,-0.83766324,0.32858615,1.0505501,1.2726928,1.2171571,1.1060857,0.80063947,0.82840731,1.0227822,1.1060857,0.85617516,0.5507289,0.18974694,-0.11569933,-0.087931488,0.050907726,-0.36560991:2
0.59099724,-0.081516851,-0.44834272,-0.63175565,-0.75403094,-0.81516858,-1.8545085,-1.9156462,-0.99858152,-0.44834272,0.71327253,0.89668546,0.83554782,0.46872196,-0.020379208,-0.20379215,-0.57061801,-0.32606743,-0.20379215,-0.081516851,0.77441017,1.3246489,2.3028512,1.4469242:2
-0.94846695,-1.2803728,-1.556961,-1.5846198,-1.6399374,-1.5293021,-1.252714,-0.42294941,0.18554458,0.95999148,1.0429679,1.0429679,0.84935621,0.71106212,0.76637976,0.93233266,1.0429679,0.60042685,0.43447394,0.40681512,0.76637976,0.65574448,0.13022694,-0.31231414:2
-0.42086305,-0.99570041,-1.4062985,-1.4884181,-1.4884181,-1.3241789,-0.99570041,-1.5705377,-0.010264954,0.81093125,1.1394097,1.0572901,1.3857686,0.72881163,0.56457239,0.64669201,0.48245277,0.48245277,0.15397429,-0.092384574,-0.50298267,1.3857686,1.0572901,0.40033315:2
-0.90972049,-1.2692149,-1.5328441,-1.6287092,-1.6287092,-1.4369789,-1.2692149,-0.33452949,0.64808848,1.0794817,1.0315491,1.0555154,0.83981881,0.36049298,0.6001559,0.50429073,0.43239186,0.28859411,0.36049298,1.4150098,0.93568398,0.69602106,0.12083006,-0.35849578:1
-0.89763649,-1.2205166,-1.4537077,-1.4895833,-1.5613344,-1.3998944,-1.1667032,-0.82588537,0.73470164,1.0575817,1.0934573,1.0217062,0.94995501,0.64501273,0.53738604,0.62707495,0.84232832,1.0934573,0.9678928,0.75263942,0.44769714,0.10687928,-0.28775192,-0.57475642:1
0.17739201,-0.43881178,-0.99899705,-1.2230712,-1.2230712,-1.2230712,-1.5031638,-0.94297852,0.51350316,1.7459107,2.1380404,2.0260034,1.1857255,0.28942905,-0.046682098,-0.046682098,-0.046682098,-0.2707562,-0.2707562,0.0093364283,-0.15871915,-0.38279325,0.56952169,0.12137348:2
-1.0710089,-1.3514185,-1.5383582,-1.5757461,-1.5757461,-1.5009703,-0.94015106,-0.042840357,0.55536678,0.96663419,1.078798,1.0414101,0.87316433,0.53667281,0.63014268,0.70491857,0.83577638,1.0601041,1.0227161,0.70491857,0.38712103,0.20018129,-0.32324995,-0.67843544:1
-1.0254206,-1.420235,-1.5957081,-1.6615105,-1.5957081,-1.4860374,-1.0473548,-0.10418712,0.70737574,0.97058532,1.0144536,0.97058532,0.8170464,0.57577095,0.55383682,0.64157335,0.64157335,0.57577095,0.90478293,0.97058532,0.751244,0.46610029,-0.038384728,-0.58673802:1
-0.55696205,-0.86174909,-1.2971591,-1.4713232,-1.6890282,-1.2971591,-1.1665361,-0.64404406,-0.55696205,-0.078010977,0.61864513,0.83635016,0.87989117,0.18323507,-0.12155199,-0.25217501,-0.12155199,1.0975962,1.3588422,1.4894653,1.4459243,1.2717602,0.66218614,0.27031708:1
-0.94057316,-1.3966086,-1.5391197,-1.6246264,-1.710133,-1.4821153,-1.1115865,-4.0798612E-9,0.57004434,1.3681064,1.2825998,1.2825998,0.94057316,0.42753326,0.22801774,0.68405321,0.68405321,0.51303991,0.25651995,0.39903104,0.54154212,0.54154212,0.3420266,-0.25651995:2
-0.83104875,-1.2197852,-1.5188132,-1.6085216,-1.7281328,-1.4889104,-0.89085436,-0.47221511,0.72389703,1.4415643,1.3817587,1.1425363,0.90331385,0.36506338,0.48467459,0.51457741,0.42486899,0.18564656,0.15574376,0.75379983,1.0229251,0.66409142,-0.023673061,-0.3825067:1
-0.19043577,-0.70301056,-1.1728708,-1.3010144,-1.4291581,-1.3010144,-1.0020125,-0.57486687,-0.70301056,-0.1477212,0.53571185,0.57842642,0.19399531,-0.062292074,-0.2758649,-0.31857946,-0.40400859,0.15128075,1.6462905,1.9025779,1.6462905,1.6035759,1.0482866,0.27942444:1
-1.0085494,-1.3532015,-1.6183186,-1.3797132,-1.6978537,-1.5918069,-1.0350611,-0.26622169,0.71471135,1.2449454,1.2979688,1.1388986,0.90029328,0.50261772,0.58215283,0.68819964,0.79424646,0.29052409,0.3700592,0.23750068,0.92680499,0.52912942,0.051918752,-0.3192451:2
-0.99558473,-1.381318,-1.5741846,-1.6384735,-1.5956142,-1.4884661,-1.038444,0.1616151,0.6544965,1.1902372,1.3188149,1.083089,0.71878538,0.41877061,0.50448912,0.56877799,0.52591874,0.54734837,0.84736314,0.99737052,0.6544965,0.18304472,-0.13839967,-0.52413294:1
-0.35403304,-1.1383523,-1.4520801,-1.6089439,-1.5827999,-1.478224,-1.6873758,-0.79848065,0.50871823,1.1623176,1.1884616,1.0577417,0.95316585,0.58715016,0.56100618,0.69172607,0.79630198,0.66558209,0.56100618,0.45643027,0.84858993,0.32571038,0.038126629,-0.30174508:2
-0.86862771,-1.4191243,-1.634536,-1.5148628,-1.6824053,-1.4669936,-1.0361702,-0.0069809333,0.56745025,1.1658161,1.2854893,1.1418815,0.92646974,0.39990783,0.4477771,0.3759732,0.42384246,0.28023466,0.3041693,1.3812278,0.78286194,0.47171173,0.0169537,-0.3420658:1
-0.020367296,-0.65582713,-1.1446424,-1.4379315,-1.3401685,-1.38905,-0.80247171,-0.46030103,-0.50918256,0.32180338,0.5173295,0.61509255,0.46844796,0.028514229,-0.46030103,-0.75359018,-0.80247171,-0.11813035,1.3971969,1.9348937,1.7882491,1.3483154,1.0061447,0.46844796:1
-0.17490922,-0.74548688,-0.94926461,-1.275309,-1.1937979,-1.1122868,-0.90850907,-0.58246469,-1.0715313,-0.29717586,0.23264625,0.47717953,0.43642398,-0.01188703,-0.33793141,-0.46019805,-0.4194425,-0.093398122,1.6590904,2.1074014,1.7406015,1.5368237,1.0477572,0.39566843:1
-0.63956426,-0.96442231,-1.2892803,-1.4246378,-1.5058523,-1.4246378,-1.6412099,-0.69370728,0.41622436,1.1471549,1.2283694,1.41787,1.0930119,0.57865338,0.79522541,1.0117974,1.0388689,0.82229692,0.55158188,0.17258083,-0.23349171,-0.043991193,-0.016919689,-0.39592073:2
-1.0897357,-1.3974257,-1.5422211,-1.5603205,-1.5965193,-1.3793263,-1.0716363,-0.2209637,0.77450417,0.97359775,1.0459954,0.82880242,0.84690184,0.44871469,0.41251585,0.52111235,0.5754106,1.1364925,1.1183931,1.0097966,0.53921177,0.37631702,-0.14856604,-0.60105144:1
-0.79128645,-1.207145,-1.4843841,-1.6923133,-1.7847264,-1.5074873,-1.1840418,-0.14439534,0.57180553,1.1493869,1.1955934,1.0800771,0.89525109,0.43318601,0.36387625,0.57180553,0.47939252,0.31766974,0.61801204,1.3342129,0.73352831,0.41008276,-0.098188825,-0.25991161:1
-0.96183803,-1.3469298,-1.4966877,-1.6250517,-1.6892336,-1.4752937,-1.068808,0.12925534,0.49295314,1.1347728,1.0064088,0.94222688,0.79246896,0.17204332,0.40737718,0.62131706,0.66410504,0.92083289,1.2417427,0.74968099,0.74968099,0.3859832,-0.084684537,-0.66232221:1
-0.018251308,-0.60229311,-0.89431402,-1.1863349,-1.3323454,-1.2350051,-1.0889946,-0.65096326,-0.55362296,-0.018251308,0.61446065,0.6631308,0.61446065,0.079088992,-0.35894236,-0.50495281,-0.50495281,-0.60229311,-0.21293191,1.1498323,2.025895,2.025895,1.4905234,1.1011622:1
-0.97254477,-1.1832466,-1.3939483,-1.4641823,-1.4641823,-1.4641823,-1.5578275,-0.66819777,0.43213373,1.0642391,1.1110617,1.0408278,1.0642391,0.87694859,0.80671466,1.0174165,1.0642391,0.73648074,0.57260159,0.26825458,0.080964106,-0.01268113,0.24484327,-0.1999716:2
-0.12519455,-0.66174264,-1.3056003,-1.5202196,-1.5202196,-1.3056003,-0.87636187,-1.7348388,-0.23250417,0.84059201,1.1625208,1.1625208,0.84059201,0.62597277,0.51866316,0.30404391,0.30404391,0.41135353,-0.017884932,-0.017884932,-0.66174264,1.4844497,1.4844497,0.84059201:2
-0.95305042,-1.2704584,-1.5283524,-1.5878664,-1.6077043,-1.4093244,-1.1712684,-0.31823454,0.85220727,1.0704253,1.1101013,0.91172126,0.91172126,0.55463733,0.57447532,0.55463733,0.6935033,1.0505873,1.0505873,0.79269328,0.35625735,0.17771538,-0.23888255,-0.5761285:1
-0.51602112,-0.95570773,-1.5419565,-1.6152376,-1.6885187,-1.5419565,-0.95570773,-1.1022699,0.21678992,0.94960094,1.3892876,1.3160065,1.1694443,0.72975763,0.14350882,0.58319543,0.65647653,0.36335212,0.36335212,0.14350882,-0.2961778,0.87631984,0.94960094,0.36335212:2
-0.46628815,-0.98507233,-1.3556324,-1.3556324,-1.5409125,-1.3926884,-0.98507233,-0.6515682,0.42305613,1.2012324,1.3865124,1.2382884,0.60833619,0.16366405,-0.058672019,-0.058672019,-0.16984005,-0.16984005,-0.16984005,1.3865124,1.9794086,0.90478429,0.34894411,-0.28100809:1
-0.82049493,-1.1716533,-1.4957994,-1.6038481,-1.6578725,-1.5498238,-1.1716533,-0.73945839,0.58413837,1.1513941,1.4215159,0.96230888,0.85426016,0.50310183,0.69218709,0.8002358,0.88127234,0.47608965,0.36804095,0.61115055,0.36804095,0.74621144,0.15194352,-0.36128788:2
-0.83732496,-1.1801104,-1.4371996,-1.54432,-1.6300164,-1.4800477,-1.1372623,-0.4302672,0.59808925,1.2836602,1.3907807,1.1979639,1.005147,0.55524107,0.51239288,0.61951335,0.55524107,0.31957605,0.49096879,1.0694193,0.68378563,0.25530377,-0.21602627,-0.64450812:1
-0.60117264,-1.0125013,-1.3605486,-1.4871113,-1.4871113,-1.4238299,-1.6769553,-0.9175793,0.34804732,1.139064,1.328908,1.1707046,0.94921996,0.69609463,0.85429796,1.1074233,0.85429796,0.7277353,0.60117263,0.22148466,0.031640662,-0.15820333,0.22148466,-0.12656266:2
-0.71844777,-1.0185589,-1.4278013,-1.5096497,-1.5369326,-1.4005184,-1.5914982,-0.71844777,0.4819966,1.3277642,1.3823299,1.1367844,1.0822188,0.75482487,0.70025922,0.94580466,0.83667335,0.59112791,0.40014812,0.29101682,-0.11822558,-0.11822558,0.31829964,-0.09094275:2
-0.63787557,-1.0646077,-1.4113275,-1.4113275,-1.4379982,-1.3846567,-1.6246935,-0.87791237,0.32227163,1.042382,1.2557481,1.2024066,1.1223943,0.77567448,0.80234523,0.93569901,1.0957235,0.77567448,0.72233297,0.24225936,-0.077789707,-0.26448499,0.055564072,-0.15780197:2
0.52578889,0.071052553,-0.61105195,-0.95210421,-1.1794724,-0.95210421,-0.38368379,-1.6342087,-1.5205246,0.41210481,1.0942093,1.0942093,1.2078934,0.29842072,-0.61105195,-0.83842012,-0.49736787,-0.2699997,-0.042631532,-0.042631532,0.071052553,2.2310502,1.6626297,0.86684114:2
-0.95003815,-1.2765887,-1.4686773,-1.5839305,-1.6415571,-1.4878862,-1.1805444,-0.29693694,0.74034143,1.0861009,1.0861009,1.0284743,0.87480345,0.58667056,0.49062627,0.62508828,0.77875915,0.77875915,1.0284743,0.93243002,0.45220855,0.18328453,-0.29693694,-0.48902553:1
-0.94013807,-1.239753,-1.539368,-1.539368,-1.6085099,-1.4241315,-1.239753,-0.68661769,0.37355843,1.1341195,1.318498,1.1802142,1.0649776,0.65012611,0.58098419,0.76536264,0.78840995,0.60403149,0.55793688,0.51184227,0.32746381,0.60403149,0.12003806,-0.3639554:2
1.1842634,0.44920332,0.20418333,-0.12251,-0.20418334,0.040836659,0.20418333,-1.7559767,-1.5109567,-0.69422335,-0.36753001,-0.20418334,-0.28585667,-0.44920334,-0.44920334,-0.36753001,-0.69422335,-0.61255001,-0.61255001,-0.20418334,0.20418333,2.4093634,2.1643434,1.6743034:2
-1.0970935,-1.4084309,-1.5418612,-1.6085763,-1.586338,-1.4306693,-1.0748552,-0.34098853,0.50407,1.1934599,1.2156983,1.0377912,0.92659926,0.50407,0.54854676,0.57078514,0.48183161,0.28168617,0.3706397,1.2156983,0.88212249,0.54854676,-0.0074128002,-0.18531986:1
0.88616328,0.18392067,-0.31768118,-0.51832193,-0.71896268,-0.6186423,-0.21736081,-1.3208849,-1.2205645,-0.21736081,0.18392067,0.18392067,0.18392067,-0.41800156,-1.0199238,-0.41800156,-0.31768118,-0.31768118,-0.31768118,0.18392067,-0.21736081,3.2938523,1.7890467,1.2874448:2
-0.90000882,-1.2265236,-1.527922,-1.6535046,-1.6786211,-1.5028054,-1.0255914,-0.44791137,0.55674964,1.3102454,1.1344297,1.1846628,0.83303142,0.53163312,0.50651659,0.45628354,0.53163312,0.38093397,0.25535134,0.95861405,1.0339636,0.60698269,0.18000176,-0.49814442:1
-0.52648646,-0.81839974,-1.2771206,-1.4856301,-1.6107358,-1.4856301,-1.2354187,-0.69329404,0.30755151,1.2249932,1.308397,1.3918008,1.0581856,0.68286859,0.5994648,0.97478188,1.1415894,0.89137809,0.72457049,0.22414772,-0.44308266,-0.44308266,-0.067765573,-0.44308266:2
-0.73976337,-0.99916092,-1.3738463,-1.546778,-1.4603121,-1.3450243,-1.4603121,-0.62447557,0.35547071,1.1624853,1.3930609,1.4795267,1.2201292,0.73015605,0.758978,0.758978,0.9895536,0.73015605,0.49958046,0.12489511,-0.13450243,-0.13450243,-0.048036575,-0.33625608:2
-0.73277393,-1.1008039,-1.3899703,-1.4688338,-1.4951217,-1.3636824,-1.5739853,-0.65391037,0.37131594,1.1336637,1.265103,1.1862394,1.0285123,0.76563374,0.94964872,0.97593658,1.0022244,0.71305804,0.73934589,0.21358881,-0.075577576,-0.15444114,-0.02300187,-0.31216826:2
-0.63682035,-1.1261286,-1.4139571,-1.4715227,-1.4715227,-1.3276085,-1.4139571,-0.69438603,0.34179623,1.2340643,1.3779785,1.2340643,1.1764986,0.68719032,1.0038016,0.88867021,0.97501873,0.744756,0.48571044,0.19788203,-0.14751206,-0.26264342,0.025184982,-0.40655763:2
-0.981618,-1.3164107,-1.5631,-1.5807207,-1.5631,-1.351652,-1.140204,-0.31203265,0.48089736,0.99189671,1.0447587,1.0800001,0.95665538,0.65710404,0.4632767,0.55138003,0.86855204,1.0623794,1.0271381,0.83331071,0.4632767,0.1989667,-0.22392931,-0.64682532:1
-1.0574151,-1.3836699,-1.6633169,-1.6167091,-1.6167091,-1.4535817,-1.0574151,-0.42820943,0.52725107,1.1331528,1.1797607,1.1098489,0.87680978,0.66707455,0.64377064,0.66707455,0.78359413,0.52725107,0.38742758,0.59716281,0.34081975,0.78359413,0.31751584,-0.26508203:2
-0.066713873,-0.60042481,-0.97402246,-1.1875068,-1.6144756,-1.2408779,-1.881331,-1.2408779,0.41362596,1.6945322,1.9080166,1.3209346,1.1608213,0.46699706,0.040028314,0.093399407,0.040028314,-0.12008497,-0.013342779,0.25351268,0.093399407,0.25351268,0.8939658,0.30688378:2
-0.76494385,-1.2013619,-1.5214018,-1.6377799,-1.6086854,-1.4923073,-1.1431728,-0.6485657,0.51521575,1.3880518,1.3007682,1.2134846,1.0971065,0.74797204,0.54431028,0.77706657,0.57340482,0.48612121,0.28245946,0.16608131,0.16608131,0.74797204,0.28245946,-0.27033673:2
-0.87292059,-1.1822508,-1.4353392,-1.491581,-1.491581,-1.4634601,-1.2947345,-0.67607407,0.84245622,1.1799074,1.3205121,1.2361493,1.0955446,0.81433528,0.58936784,0.87057715,0.92681901,0.72997249,0.36440039,0.33627946,-0.085534515,-0.057413583,-0.0011717203,-0.2542601:2
-0.9881326,-1.2604079,-1.5326833,-1.6960485,-1.6143659,-1.4510007,-1.0970427,-0.36189931,0.67274699,1.4623455,1.2172977,1.1900701,1.0267049,0.67274699,0.61829193,0.67274699,0.56383686,0.45492672,0.31878905,0.29156151,0.26433398,0.69997453,0.10096877,-0.22576164:2
-0.67649377,-1.0202496,-1.3904481,-1.4697764,-1.6548756,-1.4962191,-1.6284329,-0.75582203,0.40765911,1.2273845,1.3331555,1.2273845,1.0951707,0.64564388,0.61920114,0.77785765,0.77785765,0.46054462,0.43410187,0.35477361,0.19611709,0.3018881,0.53987288,-0.30629523:2
0.79402173,0.59057132,-0.2910471,-0.42668071,-0.49449752,-0.96921513,-1.3761159,-2.3933679,-0.96921513,-0.2232303,0.1836705,0.59057132,0.59057132,0.45493772,-0.49449752,-0.35886391,-0.56231433,-0.42668071,-0.35886391,0.38712092,0.59057132,1.2687393,2.3538081,1.5400065:2
-0.77096295,-1.3399089,-1.6120135,-1.6120135,-1.6367503,-1.5625399,-1.2409618,-0.15254347,0.73798058,1.2079794,1.1337691,1.1337691,0.96061159,0.4906128,0.51534958,0.61429668,0.54008636,0.29271856,0.21850822,0.26798178,1.1090323,0.61429668,0.39166568,-0.30096414:2
-0.9805479,-1.1841722,-1.5914208,-1.6495991,-1.7077775,-1.5041532,-0.86419117,-0.39876423,0.70662476,1.3465868,1.3174976,1.1429625,1.055695,0.64844639,0.6193572,0.6193572,0.67753557,0.53208965,0.15393026,0.29937618,0.15393026,0.82298149,0.066662715,-0.28240749:2
-0.98805752,-1.227215,-1.5215626,-1.6871332,-1.5767528,-1.4111823,-1.1536281,-0.32577537,0.55726751,1.1275661,1.201153,1.1643595,0.90680532,0.57566424,0.55726751,0.63085442,0.74123478,0.74123478,0.9619955,0.79642496,0.50207733,0.1341428,-0.25218846,-0.45455245:1
-0.70834621,-1.1179922,-1.374021,-1.4508296,-1.4764325,-1.3996238,-1.6556526,-0.78515483,0.44378317,1.0326493,1.2118694,1.2118694,1.0582522,0.80222342,0.72541479,0.95584067,0.95584067,0.69981192,0.72541479,0.52059179,-0.093877204,-0.22189158,0.18775442,-0.24749446:2
-0.38646425,-1.1508991,-1.3037861,-1.5076353,-1.5585977,-1.3547484,-1.60956,-1.2528237,-0.080690332,0.83663144,1.1424054,1.2952923,1.1933677,0.78566912,0.53085751,0.53085751,0.47989519,0.37797055,0.17412126,0.32700823,0.12315894,0.63278215,1.2952923,0.47989519:2
-0.96238881,-1.2513833,-1.4959172,-1.5626082,-1.5626082,-1.5181475,-1.2513833,-0.40663011,0.4381231,1.0605728,1.1717246,1.0383425,0.90496041,0.5270445,0.50481415,0.63819623,0.79380867,0.9494211,1.0828032,0.79380867,0.4825838,0.21581963,-0.16209629,-0.42886046:1
-0.62617113,-1.1475544,-1.6075985,-1.6689378,-1.6996074,-1.4235809,-0.99420641,-0.56483192,0.87663959,1.3060141,1.4593621,1.2446749,1.0299876,0.53927392,0.72329155,0.72329155,0.72329155,0.4472651,0.17123864,0.14056903,0.048560206,0.50860431,0.10989942,-0.31947507:2
-0.90183284,-1.2058214,-1.5706077,-1.6618043,-1.6314054,-1.5706077,-1.1146248,0.040531802,0.80050329,1.3476828,1.2260873,1.1652896,0.83090215,0.3445204,0.43571698,0.55731242,0.4965147,0.19252611,0.10132953,0.28372269,1.2260873,0.70930671,0.19252611,-0.29385566:2
-1.1112308,-1.3828398,-1.5309902,-1.6050654,-1.6050654,-1.2840729,-1.0124639,-0.5680127,0.46904002,1.1851002,1.2838671,1.2591754,1.111025,0.51842348,0.49373175,0.7653408,0.86410772,0.56780695,0.32088963,0.34558137,0.2961979,0.71595733,0.32088963,-0.41739314:2
-1.064927,-1.3944072,-1.5591473,-1.6297502,-1.6532845,-1.3708729,-1.1119956,-0.0058835571,0.70014538,1.3120371,1.3355714,1.1943656,0.98255695,0.511871,0.4883367,0.5354053,0.5354053,0.4177338,0.25299372,0.4648024,0.4883367,0.77074828,0.22945942,-0.42950092:2
-0.3452791,-0.94376287,-1.2660234,-1.4962094,-1.4501722,-1.3580978,-1.2199861,-0.7135768,0.20716745,0.94376286,1.3580978,1.3120606,0.94376286,0.16113024,-0.023018614,-0.16113025,-0.25320467,-0.20716746,-0.20716746,0.34527909,1.9565816,1.404135,0.80565122,0.20716745:2
-0.98413405,-1.2032814,-1.4467785,-1.6172265,-1.5441773,-1.5685271,-1.0815329,-0.083194833,1.012542,1.3047385,1.4021374,1.1342906,0.76904496,0.47684846,0.40379933,0.45249875,0.25770108,0.23335137,0.25770108,1.1342906,0.8907935,0.37944962,-0.058845125,-0.52148959:1
-0.99607153,-1.2325017,-1.5477419,-1.652822,-1.626552,-1.3638518,-1.1536916,-0.28678103,0.50131952,0.79028972,1.1318,1.0529899,0.94790983,0.36996943,0.23861933,0.1860793,0.21234932,0.55385956,1.3682301,1.3419601,0.79028972,0.55385956,0.10726924,-0.28678103:1
-0.84033036,-1.1590763,-1.5067992,-1.4778223,-1.5067992,-1.3908916,-1.4778223,-0.75339964,0.37669981,1.1011225,1.3619147,1.2460071,1.0431687,0.81135343,0.84033034,0.81135343,0.89828416,0.60851507,0.40567672,0.37669981,0.37669981,-0.057953831,0.086930713,-0.17386147:2
-1.0094511,-1.3793264,-1.4409722,-1.564264,-1.564264,-1.4615209,-1.071097,-0.3724438,0.51114701,1.0659599,1.0454112,0.94266811,0.675536,0.4084039,0.3262094,0.30566078,0.57279289,1.3125433,1.2098002,1.0659599,0.675536,0.34675802,-0.1053117,-0.49573555:1
0.36402167,-0.39822505,-0.92593434,-1.2191061,-1.5122779,-1.3950092,-1.8054498,-1.043203,0.59855912,1.5953433,1.7712464,1.8298807,1.2435371,0.12948422,0.24675294,0.012215489,0.24675294,-0.22232196,0.12948422,-0.10505323,-0.1636876,-0.33959069,0.59855912,0.36402167:2
-0.98822287,-1.3995063,-1.5366008,-1.4909027,-1.6051481,-1.4223554,-1.1710155,-0.097108611,0.7254584,1.2281382,1.2509873,1.1138928,0.93110016,0.63406207,0.45126939,0.47411848,0.47411848,0.29132581,0.10853315,1.2052891,0.74830749,0.5883639,0.017136808,-0.53124121:1
-0.99980966,-1.3810678,-1.5002109,-1.5955255,-1.6431827,-1.4048964,-0.9521524,-0.18963619,0.52522275,0.97796675,0.95413812,0.90648086,0.66819454,0.4060796,0.31076507,0.47756549,0.38225096,0.52522275,1.4068821,1.4307108,0.88265223,0.50139412,-0.16580756,-0.52323703:1
-0.18641131,-0.62192094,-1.0970224,-1.2949813,-1.3741649,-1.4533484,-1.2157977,-0.66151272,-1.0970224,-0.18641131,0.40746546,0.76379152,0.96175044,0.36787367,-0.22600309,-0.10722774,-0.18641131,-0.028044172,0.60542438,1.7535861,1.951545,1.5160354,0.92215866,0.48664903:1
-0.87876633,-1.2233002,-1.5432244,-1.5186149,-1.5432244,-1.5432244,-1.2725193,-0.58345162,0.57319765,1.2376557,1.2376557,1.2376557,1.0899984,0.96695059,0.77007412,0.74546456,0.77007412,0.52397853,0.32710206,0.22866383,0.0071777951,0.081006472,0.3024925,0.0071777951:2
1.1199341,0.39544841,-0.11169154,-0.47393437,-0.69128007,-0.76372864,-1.8504571,-1.6331114,-1.0535229,-0.40148581,0.39544841,0.68524268,0.54034555,0.25055128,-0.18414011,-0.54638294,-0.54638294,-0.40148581,-0.32903724,-0.11169154,0.39544841,0.83013981,2.4964569,1.9893169:2
-0.059531806,-0.49609832,-0.89297698,-1.0120406,-1.1311042,-1.0914163,-1.0517284,-1.0517284,-1.488295,-0.77391338,0.33734685,0.41672258,0.4960983,-0.099219672,0.05953179,-0.059531806,0.17859539,-0.13890753,0.57547403,1.0120406,2.4011159,1.8454858,1.3692314,0.65484977:2
-0.75366866,-1.1758313,-1.3706757,-1.4356238,-1.5330459,-1.4356238,-1.0784092,-0.81861676,0.41539726,1.2597227,1.2921967,1.3896189,1.0324043,0.77261183,0.77261183,1.0324043,1.0973524,0.74013778,0.3829232,0.22055294,-0.29903191,-0.26655785,0.025708618,-0.26655785:2
-0.91857356,-1.2541649,-1.4348679,-1.4348679,-1.4864973,-1.3832384,-1.5897561,-0.58298229,0.37216212,1.198233,1.0691594,1.1724183,1.1466036,0.63030926,0.86264169,0.99171525,0.96590053,0.78519754,0.50123569,0.21727384,-0.015058583,-0.092502724,0.29471799,-0.015058583:2
0.11858497,-0.5804422,-1.1296778,-1.2794694,-1.3293999,-1.2794694,-1.9784965,-1.0298168,0.46809855,1.4667088,1.8162224,1.8162224,1.2170562,0.46809855,-0.031206572,0.11858497,0.31830701,0.21844599,-0.18099811,0.31830701,-0.081137084,-0.18099811,0.56795957,0.16851548:2
-1.1111432,-1.3841886,-1.5844219,-1.5662189,-1.6026249,-1.4387977,-1.1111432,-0.25560085,0.72736267,0.96400203,1.0368141,0.98220506,0.78197175,0.59994147,0.59994147,0.65455055,0.65455055,0.69095661,1.1096263,0.945799,0.58173844,0.27228696,-0.05536754,-0.49224022:1
-0.83474434,-1.1254733,-1.3369125,-1.469062,-1.5219218,-1.4162022,-1.6012115,-0.67616494,0.38103107,1.0946384,1.3060776,1.2267879,1.0417786,0.80390947,0.83033937,0.90962907,0.88319917,0.77747957,0.59247027,0.27531146,-0.12113702,-0.14756693,0.27531146,-0.14756693:2
-0.89578054,-1.1576409,-1.5242453,-1.6289895,-1.6028034,-1.4718733,-1.2100129,-0.84340848,0.4920792,1.1991021,1.1991021,1.0681719,0.8848697,0.5706373,0.51826524,0.51826524,0.54445127,0.8063116,0.8848697,0.78012557,0.43970714,0.6491954,0.099288706,-0.31968782:2
0.20775913,-0.36959257,-0.84197124,-1.1044038,-1.1568904,-1.2618634,-1.0519173,-1.4718095,-0.78948472,0.10278609,0.57516475,0.89008387,1.10003,0.26024565,-0.42207909,-0.054673463,-0.47456561,-0.26461953,-0.1596465,-0.002186945,0.94257039,2.2547334,1.9923008,1.10003:2
-1.0649145,-1.3625071,-1.4850452,-1.5725724,-1.555067,-1.4150234,-1.0299036,-0.3822022,0.40554279,1.0707497,1.1407715,0.93070612,0.79066257,0.5280809,0.59810268,0.66812446,0.82567346,1.0882551,1.0532442,0.91320068,0.5280809,0.17797202,-0.29467498,-0.55725664:1
-0.92661512,-1.3078511,-1.5620084,-1.6382556,-1.5874241,-1.5874241,-1.1807724,0.039182586,0.8270702,1.4878792,1.1320589,1.1066432,0.8270702,0.44583425,0.36958707,0.47124998,0.44583425,0.16626123,0.11542977,0.54749717,1.0558118,0.75082301,0.064598315,-0.062480331:1
-0.4258851,-0.72108342,-1.3483799,-1.4959791,-1.6066784,-1.5328789,-1.0531816,-0.61038405,-0.27828593,0.01691241,0.57040928,0.64420887,0.4966097,0.090711991,-0.31518572,-0.16758656,-0.13068676,1.1239062,1.3822047,1.7512026,1.5667037,1.2715053,0.42281012,0.34901053:1
0.1123275,-0.52616566,-1.0227714,-1.0227714,-1.3065462,-1.1646588,-1.3774899,-1.1646588,0.1123275,1.6021449,2.240638,1.9568633,1.3183701,0.39610224,-0.10050355,-0.24239092,-0.17144724,-0.38427829,-0.17144724,0.041383812,-0.17144724,0.5379896,0.60893329,-0.10050355:2
-0.053806337,-0.43642924,-1.1538472,-1.3451587,-1.3451587,-1.3451587,-1.2495029,-1.0103636,-0.86688001,-0.43642924,0.56795588,0.95057878,0.71143947,0.47230015,-0.29294565,-0.1016342,-0.43642924,0.47230015,1.572341,1.6679967,1.572341,1.4288574,0.52012801,0.13750512:1
-0.37158954,-0.9232276,-1.382926,-1.5668053,-1.5668053,-1.4748656,-0.73934824,-1.2909863,-0.27964986,0.73168658,1.3752643,1.191385,1.2833247,0.91556594,0.2719882,0.45586755,0.73168658,0.36392788,0.18004852,-0.18771018,-0.55546889,1.2833247,1.0994453,0.45586755:2
-1.1308538,-1.4047873,-1.4469309,-1.5733618,-1.5101464,-1.4890745,-0.94120749,-0.2879814,0.53381918,1.102758,1.0184708,0.84989633,0.63917823,0.34417289,0.3652447,0.49167556,0.59703461,0.74453728,1.2924043,1.2924043,0.91311176,0.32310108,-0.14047873,-0.58298673:1
-0.78153981,-1.2110884,-1.4688175,-1.5547272,-1.5547272,-1.4401809,-0.92472267,-0.18017177,0.87938143,1.1657471,1.2802934,1.2802934,0.79347171,0.39255968,0.020284237,0.020284237,0.27801339,0.93665457,1.2516568,1.1371106,0.62165227,0.048920809,-0.29471806,-0.69563009:1
-0.73916774,-1.2325692,-1.5241246,-1.5689793,-1.6586887,-1.5016973,-1.1652872,-0.44761232,0.56161796,1.1671561,1.1895835,1.1447288,0.74103668,0.49433595,0.47190861,0.60647264,0.60647264,0.47190861,0.74103668,1.2344382,0.76346402,0.38219925,-0.11120223,-0.62703104:1
-0.97117231,-1.3479202,-1.5739689,-1.624202,-1.5990854,-1.5237359,-1.2976871,-0.29302613,0.48558615,1.0381497,1.0381497,0.96280014,0.83721752,0.58605226,0.4353531,0.76186794,0.73675142,0.56093573,0.48558615,0.38512005,1.0632662,0.76186794,0.48558615,-0.39349223:2
-0.73670703,-1.0028086,-1.4167443,-1.3576106,-1.4463111,-1.4463111,-1.6237121,-0.73670703,0.41639962,1.1260037,1.2738379,1.2442711,1.1260037,0.74163483,0.80076851,1.0964369,1.0373032,0.65293432,0.44596646,0.32769911,0.032030738,-0.26363763,0.0024639004,-0.29320447:2
-0.98769112,-1.2928185,-1.5788755,-1.597946,-1.559805,-1.3691004,-1.0258321,-0.20580209,0.55701647,1.0337781,1.0147076,1.0147076,0.8621439,0.46166415,0.42352322,0.57608694,0.74772111,1.071919,1.1482009,1.0528485,0.48073462,0.19467765,-0.32022488,-0.70163416:1
-0.78102183,-1.2415753,-1.540935,-1.5179073,-1.5639627,-1.5179073,-1.2646029,-0.044136361,0.80788747,1.2914685,1.2914685,1.2914685,1.1993579,0.85394281,0.71577678,0.60063843,0.64669377,0.27825103,0.18614035,0.18614035,0.48550007,0.27825103,-0.18230238,-0.45863444:2
-0.0032255405,-0.62252939,-1.0483008,-1.2031267,-1.3579527,-1.2805397,-0.9708878,-1.5127787,-1.0095943,-0.041932031,0.38383936,0.61607831,0.57737181,0.19030691,-0.11934501,0.03548095,-0.080638522,-0.11934501,0.42254585,1.777273,1.8159795,1.5450341,1.4289146,0.57737181:1
0.97425839,0.2905683,-0.3247528,-0.52985984,-0.80333586,-0.94007389,-1.9656091,-1.281919,-1.0768119,-0.18801478,0.63241335,0.83752037,0.63241335,0.017092251,-0.25638379,-0.39312182,-0.52985984,-0.52985984,-0.3247528,0.017092251,0.42730631,0.90588938,2.5467457,1.8630556:2
-0.11019751,-0.68986666,-1.3782238,-1.7042877,-1.5593704,-1.5593704,-1.1608479,-0.11019751,0.32455434,1.0853701,1.4838926,1.2302874,0.94045281,0.21586638,-0.14642683,-0.14642683,-0.11019751,-0.21888548,0.28832502,1.5925806,1.411434,0.72307688,0.14340773,-0.54494937:1
-0.82170091,-1.2345361,-1.3615624,-1.6156148,-1.6156148,-1.4250755,-1.0757534,-0.21832633,0.73437037,0.98842283,1.2107187,1.0836925,0.70261382,0.16275235,-0.15481321,-0.091300101,0.09923924,1.0836925,1.2107187,1.337745,0.92490972,0.51207448,0.035726126,-0.47237878:1
-0.86816171,-1.2694029,-1.5273437,-1.5846639,-1.5846639,-1.4700235,-1.0114622,-0.5242407,0.65082276,1.3100047,1.4819652,1.3386648,1.0520639,0.67948284,0.59350259,0.82278327,0.59350259,0.42154209,0.24958158,0.13494124,-0.0083591802,0.62216267,0.16360133,-0.26629993:2
-0.96976485,-1.2823122,-1.490677,-1.615696,-1.6365324,-1.574023,-1.1572932,-0.032122918,1.0097015,1.0722109,1.1138839,0.94719199,0.67631765,0.38460683,0.38460683,0.50962575,0.5929717,0.48878927,1.1972298,1.0513744,0.5929717,0.32209737,-0.2196513,-0.36550672:1
-0.46532339,-0.91745947,-1.3695955,-1.5052363,-1.5956636,-1.5052363,-1.2339547,-0.10361452,0.30330795,1.2075801,1.3884345,1.2527937,0.66501681,0.25809434,-0.28446896,-0.14882812,-0.10361452,-0.37489617,0.032026299,1.1171529,1.7049298,1.1171529,0.48416238,0.077239907:1
-0.80506393,-1.1529148,-1.3110288,-1.5007656,-1.5323884,-1.43752,-0.99480076,-0.26747623,0.5230939,0.93419037,1.2820412,1.0606816,0.68120793,0.080374625,-0.17260781,-0.1093622,-0.014493791,0.58633951,1.5034009,1.6298921,1.1239272,0.58633951,-0.20423062,-0.48883586:1
-0.13243129,-0.91399301,-1.2266177,-1.4871382,-1.5392424,-1.4871382,-1.0182012,-0.39295186,0.33650575,1.4306921,1.8996291,1.5349003,1.1180674,0.70123455,-0.23663952,-0.1845354,-0.13243129,-0.34084774,-0.1845354,-0.028223055,0.54492221,1.3264839,0.64913044,-0.23663952:2
-0.081477511,-0.62234949,-1.0384049,-1.2464325,-1.3296436,-1.0800104,-0.91358824,-1.3712492,-0.83037718,0.0017335621,0.75063322,0.83384429,0.75063322,0.25136679,-0.16468858,-0.12308305,-0.41432181,-0.41432181,-0.16468858,1.7491661,1.7907717,1.7907717,1.1666886,0.70902768:1
-1.0137094,-1.3691659,-1.507399,-1.5468941,-1.6653797,-1.4284086,-1.0532045,-0.046077694,0.68458294,1.0795346,1.0005443,0.8623112,0.68458294,0.36862158,0.348874,0.46735951,0.54634985,1.1190298,1.2375153,1.0597871,0.64508777,0.32912641,-0.14481562,-0.65825283:1
0.010431441,-0.61545501,-0.99098688,-1.6168733,-1.7420506,-1.2413415,-0.7406323,-1.8672279,-0.49027772,0.5111406,0.76149518,1.3873816,1.0118498,1.0118498,0.26078602,0.26078602,0.010431441,-0.11474585,0.26078602,0.13560873,0.13560873,1.7629135,1.2622043,0.63631789:2
0.27547177,-0.61929368,-1.215804,-1.6631867,-1.3649316,-1.5140591,-1.215804,-0.61929368,-0.072492568,-0.32103853,0.32518096,0.77256369,0.67314531,0.17605339,-0.42045691,-0.27132934,-0.32103853,0.17605339,1.5182016,1.7170383,1.6673291,1.4187832,0.7228545,0.17605339:1
-0.92038492,-1.1828713,-1.4857402,-1.6068877,-1.6876528,-1.5059315,-1.16268,-0.21369083,0.53338578,1.0785498,0.95740223,0.81606341,0.71510711,0.35166444,0.43242948,0.3718557,0.69491585,1.0785498,1.2400799,1.2198886,0.65453333,0.31128192,-0.23388209,-0.45598595:1
-0.99830116,-1.2736946,-1.4113913,-1.5261386,-1.5720375,-1.4572902,-1.2277957,-0.58521102,0.37866597,1.1130484,1.2048462,1.0671495,0.81470556,0.37866597,0.49341323,0.63110994,0.83765501,0.72290775,0.92945282,1.2048462,0.67700885,0.14917145,-0.17212088,-0.37866595:1
-0.96811603,-1.3994791,-1.4583013,-1.5955532,-1.5955532,-1.3994791,-1.1641901,-0.22303434,0.58086961,1.0122327,1.2083068,1.0514475,0.87498082,0.5612622,0.48283254,0.62008443,0.58086961,0.93380306,1.0514475,0.97301789,0.50243996,0.12989911,-0.18381951,-0.57596778:1
-0.88813553,-1.1495266,-1.505969,-1.5534946,-1.5534946,-1.505969,-1.2208151,-0.79308424,0.41881977,0.8465506,0.82278778,0.75149931,0.79902495,0.20495436,0.22871718,0.58515954,0.96536472,0.96536472,1.1792301,1.3930956,0.79902495,0.53763389,-0.056436704,-0.27030212:1
-0.65172771,-1.3661828,-1.4427316,-1.4427316,-1.4937641,-1.4427316,-1.4937641,-0.80482524,0.29237376,1.0068289,1.1854427,1.210959,1.0068289,0.64960134,0.70063385,0.70063385,1.3385402,0.75166636,0.57305257,0.34340627,-0.013821314,0.26685751,0.26685751,-0.14140259:2
0.40066425,-0.40583411,-0.96417915,-0.90214082,-1.3364091,-1.1502941,-0.77806414,-1.4604858,-1.2123325,0.33862592,0.95900929,1.0830859,0.95900929,0.46270259,0.27658758,0.58677927,-0.65398746,-0.77806414,-0.65398746,-0.28175744,0.83493262,1.9516226,1.5793926,1.1451243:2
1.1750734,0.23501467,-0.12654636,-0.4881074,-0.70504401,-0.70504401,-1.5727905,-1.9343516,-1.2112295,-0.27117078,0.6688879,0.5242635,0.4519513,0.16270247,-0.12654636,-0.41579519,-0.4881074,-0.56041961,-0.27117078,0.090390257,0.4519513,0.5965757,2.3320687,2.1874443:2
-0.91420779,-1.0957526,-1.4069722,-1.4069722,-1.4847772,-1.4069722,-1.5366471,-0.65485807,0.25286598,1.1087201,1.16059,1.3161998,1.16059,0.74563045,0.97904523,0.9012403,1.0827851,0.71969548,0.40847581,0.25286598,-0.084288667,-0.21396353,0.097256142,0.019451224:2
0.021728189,-0.40493443,-0.83159706,-0.97381793,-1.1634458,-1.3056667,-0.87900402,-1.4004806,-0.7841901,0.021728189,0.49579777,0.6854256,0.49579777,0.069135147,-0.26271356,-0.45234139,-0.59456226,-0.54715531,0.21135602,1.7757857,2.0602274,1.7757857,1.39653,0.59061168:1
-0.69159792,-1.2853181,-1.3885737,-1.5950851,-1.5434573,-1.5176433,-1.2853181,-0.58834225,0.52165629,0.96049292,0.98630684,0.96049292,0.6765398,0.39258669,0.28933101,0.72816764,0.49584237,0.36677277,1.2960739,1.2186321,1.1670043,0.44421453,-0.072063862,-0.53671441:1
-0.42981357,-0.94558985,-1.2984894,-1.3799277,-1.4613661,-1.3527816,-1.4885122,-0.70127476,0.46600839,1.2532459,1.3618303,1.6332915,1.4704148,0.79176182,0.7646157,0.9003463,0.6288851,0.57459286,0.16740107,0.14025495,-0.37552132,-0.40266745,-0.02262177,-0.29408296:2
-0.20376853,-0.70436518,-1.397499,-1.4745139,-1.6670511,-1.5900362,-1.0124247,-0.70436518,0.48936531,1.2595141,1.3750364,0.98996197,0.48936531,0.1427984,-0.24227596,-0.24227596,-0.20376853,0.065783526,1.2980215,1.606081,1.2595141,0.64339506,0.1427984,-0.31929082:1
0.9549031,0.27722993,-0.46204989,-0.70847649,-0.8316898,-0.89329645,-1.7557896,-1.5709696,-0.9549031,0.27722993,0.8316898,0.89329645,0.89329645,0.27722993,-0.27722993,-0.21562328,-0.46204989,-0.58526319,-0.58526319,-0.21562328,-0.030803328,0.89329645,2.1254295,2.1254295:2
-1.1357919,-1.4564861,-1.5967898,-1.65692,-1.5567031,-1.4564861,-0.9153147,-0.37414325,0.5278092,0.96876372,1.1291108,0.94872033,0.70819968,0.46767903,0.66811291,0.54785258,0.70819968,0.76832984,0.5278092,1.2493711,0.78837323,0.50776581,-0.053449039,-0.31401309:1
1.4048443,0.79182131,0.17879836,-0.17150047,-0.4342246,-0.4342246,-0.25907518,-1.6602705,-1.0472476,-0.52179931,0.0036489434,0.26637307,0.17879836,-0.083925764,-0.87209813,-0.4342246,-0.69694871,-1.1348223,-0.87209813,-0.34664989,0.26637307,1.4048443,2.2805914,2.1930167:2
-0.53437707,-1.0919879,-1.5380766,-1.6124247,-1.7239469,-1.5009025,-1.0176398,-0.79459546,0.39497435,1.2499777,1.2871517,1.3614998,1.1756295,0.65519275,0.76671492,0.76671492,0.76671492,0.54367058,0.20910407,-0.088288387,-0.12546244,0.69236681,0.13475596,0.023233785:2
0.87310195,0.33234204,-0.41120284,-0.6815828,-0.95196275,-1.0195578,-0.41120284,-1.6279127,-1.2899377,-0.54639282,0.12955707,0.53512701,0.53512701,0.26474705,-0.27601286,-0.27601286,-0.47879783,-0.61398781,-0.47879783,-0.34360785,0.67031698,2.3601917,2.0898117,1.6166468:2
-1.0865339,-1.4191934,-1.5300799,-1.4376745,-1.3822313,-1.4376745,-1.4007123,-0.34729041,0.61372608,0.87246129,0.90942346,0.76157477,0.59524499,0.33650978,0.41043413,0.68765042,0.83549911,1.2605641,1.2605641,1.0572721,0.72461259,0.18866109,-0.14399846,-0.32880933:1
-0.1734977,-0.99804123,-1.2041771,-1.410313,-1.5339945,-1.4515402,-1.0392684,-0.66822382,0.1563197,1.2282263,1.3106807,1.3106807,0.69227298,0.23877405,-0.21472488,-0.1734977,-0.25595205,-0.29717923,0.19754688,1.9703155,1.393135,0.89840887,0.28000123,-0.25595205:1
-0.17238814,-0.7835824,-1.1597019,-1.3947767,-1.4888065,-1.4888065,-1.3477617,-0.17238814,0.48582106,1.3320901,1.6611947,1.42612,0.8619406,0.2037314,-0.17238814,-0.21940308,-0.26641802,-0.4544778,-0.4544778,0.39179118,1.7552246,1.0970154,0.43880612,-0.078358256:2
-1.1578002,-1.3178032,-1.4778063,-1.5666969,-1.5666969,-1.4600282,-1.1222439,-0.28667223,0.35334016,0.97557441,1.0289088,1.0822431,0.90446192,0.60223386,0.60223386,0.65556822,0.83334944,1.0289088,1.0466869,0.86890568,0.46000889,0.1400027,-0.16222538,-0.46445344:1
-0.94694814,-1.2333105,-1.4676069,-1.5977716,-1.6498375,-1.4676069,-1.1552117,-0.42628937,0.45883054,0.9013905,1.109654,0.9013905,0.82329168,0.4327976,0.30263291,0.58899524,0.40676467,0.97948932,1.3179175,1.2137858,0.69312699,0.32866585,-0.087861164,-0.42628937:1
-0.56349014,-0.76278771,-1.5030358,-1.4745647,-1.5030358,-1.5030358,-1.7308045,-0.73431663,0.57535308,1.2017169,1.2017169,1.3440723,1.0593615,0.68923741,0.74617957,0.91700605,0.91700605,0.71770849,0.4045266,0.20522903,-0.022539612,-0.16489501,0.034402548,-0.051010693:2
1.0431286,-0.034937331,-0.75364793,-0.39429263,-0.99321813,-0.75364793,-0.51407773,-1.2327883,-0.51407773,0.92334346,1.522269,1.522269,1.0431286,-0.034937331,-0.87343303,-1.4723585,-0.39429263,-0.75364793,-0.63386283,-0.39429263,-0.63386283,1.7618392,1.2826988,1.2826988:2
-1.1148502,-1.2294877,-1.4587628,-1.5504729,-1.5046179,-1.5275454,-1.1607052,-0.58751745,0.37543798,1.498886,1.1091183,0.94862575,0.67349563,0.32958296,0.37543798,0.51300305,0.55885807,0.44422051,1.1779008,1.1549733,0.62764061,0.51300305,0.054452841,-0.22067729:1
-0.85666051,-1.2034533,-1.5007042,-1.5254751,-1.5007042,-1.4263914,-1.5007042,-0.55940963,0.65436481,1.2488666,1.2240957,1.1993248,0.95161568,0.80299024,1.0011575,0.82776115,0.82776115,0.55528118,0.28280119,0.3075721,-0.014449684,-0.039220591,0.23325938,0.010321223:2
-0.59915023,-0.92595944,-1.2527686,-1.4978755,-1.3889391,-1.2527686,-1.5523437,-0.73532073,0.62638432,1.5523437,1.6885142,1.2527686,1.089364,0.59915022,0.65361842,0.84425713,0.92595944,0.65361842,0.272341,-2.4652778E-9,-0.272341,-0.35404332,-0.1361705,-0.1906387:2
-0.98058699,-1.2455562,-1.5346136,-1.7032304,-1.5827898,-1.5587017,-1.1251157,-0.18567922,0.56105232,1.1632552,1.1873433,1.115079,0.72966912,0.29608306,0.41652363,0.48878797,0.46469986,0.32017117,0.58514043,1.2836958,0.94646214,0.60922854,0.0070256899,-0.25794357:1
-0.9284231,-1.3455275,-1.4772446,-1.7187261,-1.7187261,-1.3455275,-1.1259989,0.015549942,0.67413579,1.2668631,1.1790516,1.0253816,0.84975868,0.4985129,0.38874859,0.45460718,0.45460718,0.38874859,0.73999438,1.2229573,0.71804151,0.41070145,-0.16007295,-0.46741301:1
0.31561781,-0.59701203,-1.053327,-1.2814844,-1.0989584,-1.2814844,-0.55138054,-1.3271159,-0.59701203,0.26998632,0.63503826,0.86319573,0.68066976,0.22435483,-0.46011755,-0.50574904,-0.55138054,-0.55138054,-0.32322307,1.7301941,1.8670886,1.8670886,1.1369847,0.58940677:1
-1.1355205,-1.3928062,-1.5907183,-1.6105095,-1.6105095,-1.3334326,-1.1553117,-0.027212901,0.70506175,1.0810947,1.1602595,0.90297382,0.8436002,0.46756727,0.44777606,0.40819364,0.5665233,0.40819364,1.1602595,1.1008859,0.62589692,0.46756727,-0.10637773,-0.38345462:1
-0.030968151,-0.59932495,-1.0802423,-1.3425608,-1.47372,-1.0802423,-1.0802423,-0.5556052,-0.94908299,-0.64304471,0.10019111,1.1057454,0.9745862,0.66854792,-0.074687905,-0.20584717,-0.33700643,-0.5556052,0.36250964,1.717822,1.892701,1.4555035,1.1494652,0.58110841:1
0.80827891,0.0076978914,-0.60813367,-0.79288313,-0.9776326,-1.1007989,-1.8397968,-1.9629631,-0.85446629,0.0076978914,0.62352944,0.86986207,0.80827891,0.31561367,-0.17705157,-0.23863473,-0.17705157,-0.17705157,-0.17705157,0.25403052,0.62352944,0.74669576,2.1631084,1.8551926:2
-0.81884402,-1.2746953,-1.3506705,-1.6039213,-1.6039213,-1.5785962,-1.14807,-0.7428688,0.49805976,1.0298863,0.95391107,0.77663556,0.6500102,0.16883382,0.59936006,0.52338484,0.54870991,0.42208455,1.3844373,1.4097624,0.85261078,0.54870991,-0.0084416908,-0.23636735:1
-1.1294263,-1.3954107,-1.5646736,-1.6130344,-1.709756,-1.5163128,-0.91180267,-0.25893181,0.51484108,1.288614,1.1918924,1.1435315,0.9259079,0.65992349,0.7082843,0.63574309,0.7566451,0.53902148,0.29721745,0.27303705,0.39393906,0.7324647,0.15213503,-0.1138494:2
-0.83453801,-1.484665,-1.6596992,-1.6096894,-1.6346943,-1.3096308,-1.0345771,-0.58448917,0.69075994,1.1908576,1.1658527,1.0158234,0.79077947,0.49072086,0.51572575,0.54073063,0.54073063,0.31568667,0.34069156,1.1658527,0.96581366,0.5907404,0.11564759,-0.28443056:1
-0.98381213,-1.0871899,-1.4800256,-1.5420523,-1.5834034,-1.3973234,-1.2939455,-0.32219416,0.60820608,1.1044196,1.2698241,1.0423929,0.9183395,0.40145047,0.40145047,0.50482828,0.58753052,1.0423929,1.1457707,0.95969062,0.44280159,0.1740193,-0.34286972,-0.5703009:1
-0.96069078,-1.3150439,-1.4095381,-1.6457736,-1.6693971,-1.4095381,-1.1260556,-0.44097282,0.4330983,1.0473104,1.1181811,1.0000634,0.74020437,0.2677335,0.22048641,0.40947476,0.6457102,0.90556918,1.2599223,1.2126752,0.71658083,0.38585122,-0.1102432,-0.27560801:1
-0.6937758,-1.1622076,-1.3751311,-1.4177158,-1.5028852,-1.4603005,-1.0770381,-0.7363605,0.072748872,0.88185825,1.2225359,1.6057982,1.3077053,0.88185825,0.83927355,0.92444295,1.0521971,0.71151943,0.3282571,0.11533357,-0.35309817,-0.52343698,-0.012420536,0.3708418:2
-0.42980032,-1.0146832,-1.1741967,-1.5198094,-1.413467,-1.4400526,-1.546395,-0.77541294,0.42093845,1.1653349,1.4577763,1.4046052,1.1653349,0.87289342,0.9260646,1.0324069,0.79313666,0.63362315,0.23483935,0.128497,-0.2702868,-0.11077328,-0.16394445,-0.37662914:2
-0.60929763,-0.97357522,-1.1817339,-1.4939718,-1.5460115,-1.4939718,-1.6500908,-0.55725798,0.37945583,1.0559714,1.3161696,1.3682093,1.0039317,1.0559714,0.69169377,0.89985239,0.95189205,0.43149549,0.11925755,-0.19298039,-0.34909936,0.84781274,0.22333686,-0.29705971:2
-0.78336904,-1.2859436,-1.4458537,-1.468698,-1.6286081,-1.5600752,-1.2174107,-0.48639318,0.58728882,1.2497735,1.1583963,1.3183064,1.1127077,0.70151031,0.61013312,0.7700432,0.72435461,0.47306733,0.42737873,0.42737873,0.61013312,0.40453443,-0.12088441,-0.57777037:2
-0.38380847,-0.7350908,-1.2424986,-1.5547496,-1.4376555,-1.28153,-0.969279,-0.69605943,0.43585029,1.56776,1.4116346,1.2164777,0.90422672,0.16263071,-0.22768299,-0.22768299,-0.18865162,-0.22768299,-0.22768299,1.6458228,1.5287287,0.90422672,0.0065052251,-0.38380847:1
0.37346372,-0.047622894,-0.52886474,-0.76948566,-1.0101066,-1.130417,-1.7921246,-1.8522798,-0.70933043,0.49377419,0.9148608,1.1554817,0.9148608,0.37346372,0.43361896,0.25315326,-0.34839904,-0.46870951,-0.58901997,-0.46870951,0.31330849,0.61408465,1.997655,1.8773445:2
0.18444349,-0.36130711,-0.84641875,-0.96769665,-1.0889746,-0.84641875,-0.54322397,-0.96769665,-0.30066815,0.48763826,0.73019408,0.73019408,0.42699931,-0.058112327,-0.48258502,-0.78577979,-0.9070577,-0.72514084,-0.66450188,-0.058112327,0.79083304,2.3068069,2.185529,1.7610563:2
0.013716411,-0.77634935,-0.90802698,-1.4347375,-1.5664151,-1.5005763,-0.97386579,-1.1055434,-0.052122403,1.1329763,1.6596868,1.593848,1.4621703,0.079555224,-0.38131647,-0.052122403,-0.11796122,-0.31547766,-0.18380003,0.27707167,0.40874929,1.593848,0.86962098,0.27707167:2
-0.42461124,-0.98492297,-1.2300593,-1.4401762,-1.6502931,-1.4401762,-1.0199424,-0.66974763,-0.73978659,0.065661523,0.55593429,0.7310317,0.69601222,0.38083687,-0.17947486,-0.07441641,-0.039396927,0.55593429,1.5014603,1.6765577,1.5714993,1.2213045,0.7310317,0.20573946:1
-0.7225603,-0.94529448,-1.2634862,-1.5816778,-1.5816778,-1.6771353,-1.3271245,-0.78619863,0.61384479,1.3775048,1.4411432,1.3456857,1.0593132,0.45474895,0.7093023,0.58202562,0.83657897,0.42292978,0.13655727,0.1047381,-0.086176923,0.7093023,0.2001956,-0.022538586:2
0.35757055,-7.2222217E-10,-0.83433131,-1.1919018,-1.4898773,-1.1919018,-1.6686626,-1.0131166,0.59595092,1.4302822,2.0262331,1.9666381,1.311092,0.65554602,0.059595093,-7.2222217E-10,0.23838037,0.11919018,-0.17878528,-0.059595093,-0.59595093,-0.53635583,0.11919018,-0.11919018:2
-0.82687512,-1.3632265,-1.5992211,-1.556313,-1.4061346,-1.4919509,-1.2130481,-0.18325341,0.58909263,1.2970765,1.1254441,1.10399,0.82508725,0.56763857,0.31018989,0.28873584,0.37455206,0.35309801,1.1254441,1.2112603,0.86799537,0.24582772,-0.16179935,-0.48361021:1
-0.86429084,-1.3307011,-1.6743718,-1.5516322,-1.6989197,-1.4779885,-1.3307011,-0.029662044,0.70677513,1.1486374,1.0749937,0.95225419,0.5840356,0.38765235,0.33855654,0.55948769,0.5840356,0.33855654,0.55948769,1.2959249,0.92770628,0.55948769,0.019433768,-0.078757856:1
-0.88710392,-1.2159146,-1.6543289,-1.5721263,-1.7091307,-1.4625227,-1.1063111,-0.33908606,0.81175147,1.3323684,1.3597693,1.1679631,1.0309586,0.53774253,0.37333717,0.674747,0.64734611,0.40073807,0.23633271,0.20893181,0.31853539,0.78435057,0.29113449,-0.22948248:2
-0.66198057,-1.0717781,-1.1033009,-1.4815755,-1.4185298,-1.4815755,-1.355484,-0.91416365,0.31522883,1.1978696,1.355484,1.2609154,1.1978696,0.88264075,1.0087323,0.9772094,0.94568652,0.69350345,0.53588903,0.15761441,-0.28370597,-0.34675173,-0.2206602,-0.18913731:2
1.0961392,0.50422405,-1.0742165,-1.0742165,-1.4030582,-1.2715215,-1.9292051,-1.2715215,0.30691899,1.2934443,1.6222861,1.3592127,1.3592127,0.70152909,0.04384557,-0.087691137,-0.087691137,-0.41653291,-0.35076456,-0.35076456,-0.2849962,-0.15345949,0.96460251,0.50422405:2
-0.93614976,-1.2613386,-1.4387144,-1.4091517,-1.5274022,-1.3500265,-1.2613386,-0.4927104,0.63066931,1.1036713,1.281047,1.0741087,0.92629555,0.42373094,0.068979453,0.098542076,0.21679257,1.0149834,1.1036713,1.2514844,0.83760768,0.33504307,-0.10839629,-0.58139827:1
-0.85472817,-1.3070357,-1.49328,-1.7061306,-1.7061306,-1.253823,-1.0675788,-0.4556333,0.74165131,1.1939588,1.2205651,0.9545019,0.92789558,0.52880071,0.50219439,0.50219439,0.47558806,0.34255644,0.28934379,1.2205651,0.98110823,0.63522601,-0.16296373,-0.50884595:1
-0.61995826,-0.88512851,-1.2386888,-1.3270789,-1.5333224,-1.5038591,-1.7690293,-0.9735186,0.38179605,1.1478435,1.2951603,1.2951603,1.0005267,0.70589304,0.76481976,0.94159993,1.0889167,0.7353564,0.44072278,0.17555252,-0.17800782,-0.17800782,0.20501588,0.02823571:2
-0.54884231,-1.0942757,-1.3669923,-1.4488073,-1.476079,-1.3397207,-1.6942524,-0.73974399,0.40566604,1.0874578,1.1692728,1.3329028,1.1692728,0.6783827,0.81474104,0.86928438,1.0874578,0.78746938,0.56929603,0.3511227,-0.057952306,-0.35794065,-0.057952306,-0.13976731:2
-0.90248601,-1.37497,-1.4495728,-1.37497,-1.5490431,-1.5241755,-1.3252349,-0.38026679,0.51496617,1.062053,1.1117881,1.0123178,0.6144365,0.44036343,0.39062827,0.41549585,0.49009859,0.41549585,1.3853315,1.360464,0.76364199,0.44036343,-0.15645855,-0.38026679:1
-0.92785495,-1.2531011,-1.6000303,-1.6217133,-1.534981,-1.4482487,-1.1880518,-0.60260882,0.65500958,0.93688956,1.0236218,1.1320372,0.8067911,0.63332649,0.67669265,0.7200588,0.74174188,0.69837573,0.65500958,1.1537203,0.61164342,0.30808036,-0.12558114,-0.45082729:1
-1.03352,-1.2905612,-1.440502,-1.6332829,-1.5904427,-1.5047623,-1.2048808,-0.17671585,0.76576869,1.1084904,1.0656501,0.89428931,0.78718879,0.35878673,0.31594653,0.35878673,0.63724807,0.8728692,1.237011,1.1084904,0.59440786,0.29452642,-0.17671585,-0.34807668:1
-1.038822,-1.5560038,-1.4846684,-1.5203361,-1.5916715,-1.5381699,-1.0566559,-0.21846472,0.78023113,1.1012405,1.1190744,1.0655728,0.85156655,0.47705561,0.42355404,0.54839103,0.54839103,0.90506811,0.85156655,0.94073582,0.58405873,0.2452155,-0.057960031,-0.37896941:1
-0.84085003,-1.1696035,-1.5489343,-1.6500892,-1.4224907,-1.4477794,-1.1948922,-0.23392069,0.55002973,1.1063816,1.3339802,1.0305155,0.90407185,0.47416356,0.34771995,0.52474101,0.47416356,0.65118463,1.2834027,1.0305155,0.65118463,0.14541016,-0.28449814,-0.71440642:1
-0.83972602,-1.2348912,-1.4818694,-1.7041498,-1.5559629,-1.5312651,-1.1854955,-0.49395647,0.59274777,1.2842868,1.0126108,1.0620064,0.88912166,0.44456083,0.49395647,0.54335212,0.5186543,0.44456083,0.74093472,1.2842868,0.74093472,0.44456083,-0.074093472,-0.39516518:1
-1.0449312,-1.3185131,-1.4279459,-1.6103339,-1.5738563,-1.3367519,-1.1908415,-0.22418523,0.90662027,1.0707695,0.97957546,0.99781426,0.83366507,0.45065031,0.46888911,0.72423228,0.81542627,0.97957546,1.107247,0.85190387,0.39593391,0.12235194,-0.40657321,-0.57072241:1
-0.9670071,-1.3627332,-1.4791232,-1.6187912,-1.5489572,-1.5024012,-1.1066751,-0.26866697,0.49950718,1.1047353,1.1047353,0.94178928,0.70900923,0.26672713,0.35983915,0.38311716,0.42967316,0.40639516,1.3840713,1.3142373,0.84867725,0.45295117,-0.035886921,-0.31522298:1
-0.31592034,-0.81662428,-1.0312117,-1.2815637,-1.5319156,-1.3530928,-1.2100345,-0.85238885,-0.95968255,-0.17286207,0.50666471,0.75701668,0.75701668,0.22054817,-0.20862664,-0.28015578,-0.28015578,0.93583951,1.2934852,1.6511308,1.6868954,1.221956,0.90007495,0.36360644:1
-1.0614552,-1.4047169,-1.5763478,-1.6989412,-1.5518291,-1.3801982,-1.0369365,-0.22781953,0.58129738,1.2187835,1.1697461,0.99811518,0.77744694,0.40966652,0.53225999,0.70389085,0.55677868,0.60581607,0.65485346,1.2187835,0.63033477,0.43418521,-0.17878214,-0.37493169:1
-0.46343095,-1.2412172,-1.6301103,-1.5134423,-1.5523317,-1.5523317,-1.1634385,-0.2689844,0.23657664,1.2476987,1.5199239,1.3643667,1.0921415,0.62546975,0.8588056,0.74213767,0.78102698,0.4699125,0.15879802,0.042130088,-0.15231647,0.66435906,0.0032407777,-0.2689844:2
-1.0508381,-1.3295134,-1.4887564,-1.6280941,-1.568378,-1.4290403,-1.150365,-0.21481221,0.64111908,1.059132,1.0392266,0.93969976,0.80036211,0.30272763,0.48187605,0.46197067,0.60130832,1.1785643,1.1387535,0.93969976,0.56149757,0.3425384,-0.035663802,-0.59301441:1
-1.0473637,-1.3445468,-1.4188425,-1.6417298,-1.7160255,-1.4931383,-1.072129,-0.52729346,0.61190809,1.0824478,1.3548656,1.1567436,0.93385635,0.53761233,0.68620384,0.76049959,0.76049959,0.51284708,0.21566407,0.24042932,0.042307309,0.78526485,0.53761233,0.042307309:2
-0.82080657,-0.86344587,-1.460396,-1.5030353,-1.5456746,-1.5030353,-1.1192816,-0.94872447,0.11725807,1.1832406,1.2685192,1.2685192,1.2685192,0.75684759,0.92740479,0.92740479,1.0126834,0.45837247,0.45837247,0.15989737,-0.47969216,0.24517597,0.28781527,-0.095938445:2
-0.79079043,-0.95582495,-1.5334458,-1.285894,-1.615963,-1.3684113,-0.87330769,-1.285894,0.034382193,0.94207207,1.1071066,1.3546584,1.1896239,1.0245893,0.19941672,0.61200303,0.94207207,0.52948576,0.034382193,-0.04813507,-0.6257559,0.85955481,1.1071066,0.4469685:2
-0.16402365,-0.21651121,-0.5314366,-0.95133714,-1.0563123,-1.1087999,-0.84636201,-0.58392417,-0.42646148,-0.84636201,-0.47894904,-0.16402365,0.15090175,-0.16402365,-0.68889931,-0.5314366,-0.58392417,-0.059048511,1.5155785,1.8829915,2.0404542,2.0929417,1.1481655,0.57080229:1
0.18083203,-0.38280028,-0.66461643,-1.2282488,-1.3409752,-1.2282488,-0.89006935,-0.6082532,-0.21371059,-0.49552674,0.63173789,1.0262805,0.63173789,0.1244688,-1.1155223,-1.1718855,-0.83370612,0.068105571,1.4771864,1.6462761,1.7590025,1.4208231,0.91355403,0.2935585:1
-1.1252464,-1.3811334,-1.4992351,-1.5582859,-1.6173367,-1.4795514,-1.0858792,-0.14106589,0.5478605,1.0202672,1.0005836,0.88248189,0.68564578,0.42975883,0.44944245,0.48880967,0.62659495,0.80374745,1.1974197,1.1777361,0.70532939,0.50849328,-0.082015054,-0.55442172:1
-0.75408393,-1.0641745,-1.5152154,-1.7689258,-1.6279756,-1.6279756,-1.1205546,-0.61313366,0.37351821,1.1064596,1.1346496,1.2755999,1.0218894,0.57084859,0.59903864,0.79636902,0.99369939,0.65541875,0.37351821,0.34532815,0.59903864,0.48627842,-0.1057127,-0.13390275:2
-0.69498736,-0.86635412,-1.4090155,-1.6375045,-1.4946988,-1.4661377,-1.6089433,-0.58074286,0.79019111,1.3899747,1.3328525,1.4185358,0.79019111,0.70450774,0.67594661,0.70450774,0.93299674,0.56170211,0.33321312,0.10472412,-0.0380815,-0.09520375,0.21896862,-0.066642626:2
0.48686846,0.017126027,-0.3938986,-0.51133421,-0.98107663,-1.0397944,-0.86364103,-1.3921013,-1.1572301,-0.57005201,0.31071505,0.25199724,0.60430406,-0.041591776,-0.3351808,-0.3938986,-0.57005201,-0.74620542,-0.51133421,0.42815065,2.0722492,1.9548136,1.7199423,1.6612245:2
1.1710645,0.66005455,-0.055359415,-0.15756141,-0.46416739,-0.3619654,-0.15756141,-1.8949953,-1.3839853,-0.56636938,0.25124657,-0.055359415,-0.2597634,-0.2597634,-0.66857138,-0.66857138,-0.66857138,-0.66857138,-0.055359415,-0.055359415,0.14904457,1.6820745,2.3974884,2.0908825:2
-0.75758784,-1.2642101,-1.3486471,-1.6301039,-1.5175212,-1.4049385,-1.1516274,-0.56056809,0.50896769,1.5222121,1.4659208,1.3533381,1.1000269,0.64969609,0.67784177,0.81857016,0.84671584,0.28380226,0.11492819,0.058636837,0.25565658,0.3682393,-0.082091555,-0.30725698:2
-1.1717221,-1.4754082,-1.5766369,-1.5766369,-1.5766369,-1.4754082,-1.0704934,-0.037960759,0.48842845,1.0553091,1.1160463,0.99457192,0.6706401,0.42769123,0.42769123,0.52891993,0.4681827,0.6706401,1.3185037,0.99457192,0.58965715,0.44793697,-0.037960759,-0.19992667:1
-0.04318015,-0.7064273,-1.1624097,-1.3282215,-1.4111274,-1.3282215,-0.99659792,-0.7064273,-0.78933319,-0.33335078,0.78587878,0.95169056,0.95169056,-0.001727203,-0.16753899,-0.29189783,-0.49916256,-0.33335078,1.0345965,1.7392965,1.7392965,1.4905789,0.99314351,0.41280226:1
-0.82030428,-1.079727,-1.5697477,-1.540923,-1.6273972,-1.5697477,-1.2238507,-0.4744073,1.0533043,1.4856755,1.3703765,1.1686033,0.96683009,0.41915988,0.50563412,0.59210837,0.67858261,0.36151038,-0.04203609,0.24621139,0.18856189,0.67858261,0.24621139,-0.013211342:2
-0.66140638,-1.4294912,-1.5924182,-1.5924182,-1.6622441,-1.5924182,-1.0105358,-0.17262514,0.82821267,1.1540668,1.1540668,0.89803857,0.75838676,0.33943142,0.31615612,0.5023585,0.4790832,0.40925731,1.1773421,1.1773421,0.73511147,0.24633023,-0.12607454,-0.33555222:1
0.45372639,-0.34184864,-1.0379768,-1.0379768,-1.4854878,-1.2368706,-1.5352112,-1.1374237,0.80179047,2.0448764,1.8957061,1.6470889,1.1001311,0.40400295,-0.093231434,-0.14295488,0.0062154446,-0.44129551,-0.093231434,-0.14295488,-0.24240176,0.10566232,0.55317327,-0.043507995:2
-0.73730694,-1.1184379,-1.3906743,-1.717358,-1.6356871,-1.3634507,-1.2545561,-0.68285966,0.70554602,1.3589134,1.4950316,1.2227952,1.0594534,0.46053326,0.51498054,0.89611151,0.73276967,0.43330962,0.43330962,0.079402282,-0.056715922,0.56942782,0.10662593,-0.1111632:2
-1.1053679,-1.404495,-1.5914494,-1.5914494,-1.5914494,-1.3671041,-1.0866725,-0.2640731,0.57722172,1.0446078,1.0446078,0.98852142,0.85765334,0.53983084,0.53983084,0.44635364,0.55852628,1.0259123,1.1006941,0.98852142,0.5211354,0.29679011,-0.15190046,-0.37624575:1
-0.91136151,-1.3150917,-1.4813336,-1.6238266,-1.5525801,-1.4813336,-1.1963475,-0.12764999,0.91729874,1.1310383,1.1072894,0.98854524,0.79855457,0.32357787,0.29982904,0.29982904,0.44232205,0.51356855,1.2972801,1.1785359,0.67981039,0.2760802,-0.080152312,-0.4838825:1
-0.17078575,-0.83998709,-1.2164129,-1.5091885,-1.6764888,-1.4673634,-0.96546234,-0.75633692,-0.25443592,-0.42173625,0.24746508,0.70754101,0.83301626,0.20564,-0.0453105,-0.21261083,-0.12896067,0.83301626,1.3767424,1.711343,1.6695179,1.2930922,0.66571592,0.12198983:1
-1.2003447,-1.3323198,-1.6339771,-1.5397092,-1.5585628,-1.4454413,-1.0872232,-0.12569055,0.70386708,0.98667081,1.0432315,0.94896365,0.77928141,0.47762408,0.40220975,0.55303841,0.57189199,1.0809387,1.0809387,0.94896365,0.51533125,0.40220975,-0.050276225,-0.52161579:1
-0.73981382,-1.3472399,-1.4874151,-1.6275904,-1.6275904,-1.393965,-1.0668894,-0.13238774,0.70866377,1.3160898,1.3861775,1.1291895,1.1992771,0.35822564,0.3348631,0.3348631,0.35822564,0.26477547,0.26477547,1.2460022,0.7787514,0.35822564,-0.13238774,-0.48282586:1
-1.0169723,-1.3481783,-1.4755652,-1.6284295,-1.6539069,-1.5010426,-1.0424497,-0.4819472,0.61358035,1.2759924,1.1995602,1.1740828,0.99574113,0.66453512,0.63905774,0.63905774,0.74096728,0.48619343,0.28237435,0.15498743,0.23141958,0.91930897,0.33332912,-0.20169596:2
0.54095839,0.13268791,-0.19392848,-0.60219896,-0.76550715,-0.60219896,-0.52054486,-1.500394,-1.4187399,-0.60219896,-0.030620288,0.13268791,0.13268791,-0.11227438,-0.27558257,-0.52054486,-0.52054486,-0.43889077,-0.35723667,0.051033808,0.86757477,2.5006567,2.1740403,1.929078:2
-0.87288758,-1.3261177,-1.5023739,-1.6534506,-1.67863,-1.4268355,-0.99878483,0.033572597,0.73859718,1.5191602,1.3932629,1.3177246,1.116289,0.48680268,0.26018764,0.58752048,0.63787938,0.31054654,0.15946985,0.083931496,0.20982875,0.71341773,0.1846493,-0.29376025:2
-0.99658473,-1.2336577,-1.365365,-1.4970722,-1.4443893,-1.3126821,-1.4180479,-0.73317026,0.55756062,1.2424382,1.2951211,1.2687797,0.95268232,0.7156093,0.79463364,0.92634087,1.0580481,0.68926785,0.42585339,0.26780471,-0.17999988,-0.12731699,0.24146326,-0.12731699:2
-0.95419574,-1.3605967,-1.5231571,-1.6450774,-1.6450774,-1.462197,-1.0354759,-0.22267391,0.75268855,1.0981294,1.1794096,1.0981294,0.75268855,0.38692763,0.30564743,0.36660758,0.54948804,0.61044819,1.1997297,1.0981294,0.65108829,0.24468728,-0.1007536,-0.34459421:1
-0.30272858,-0.89756368,-1.2374694,-1.4923988,-1.5773752,-1.4499106,-1.0675166,-0.60014613,-0.21775213,-0.3452168,0.41957119,0.58952408,0.67450052,0.2496183,-0.26024036,-0.21775213,-0.3452168,0.67450052,1.4392885,1.6942178,1.6942178,1.2268474,0.92942985,0.41957119:1
-0.90733655,-1.2994266,-1.4200697,-1.5407128,-1.5407128,-1.4502305,-1.0279797,-0.72637191,0.23877278,1.1134352,1.143596,1.0832744,0.99279208,0.87214899,0.90230976,0.99279208,1.1134352,0.81182745,0.60070204,0.41973742,-0.0025133962,-0.30412112,0.26893355,-0.33428189:2
-0.77500399,-1.1173371,-1.4596701,-1.5452534,-1.6878922,-1.4311424,-1.4596701,-0.48972646,0.50874496,1.1078278,1.3360499,1.2789943,0.96518904,0.70843925,0.79402251,0.9937168,0.85107802,0.56580047,0.33757843,0.30905068,-0.06181013,0.023773134,0.36610619,-0.11886565:2
-0.77763577,-1.1286688,-1.3334381,-1.5089547,-1.5089547,-1.3626909,-1.5089547,-0.71913025,0.39247449,1.2993099,1.3578154,1.3578154,1.0360351,0.74350756,0.68500205,0.83126583,0.94827685,0.7142548,0.48023276,0.24621071,-0.10482238,-0.16332789,0.21695795,-0.19258064:2
0.20626657,-0.17453325,-0.99053285,-1.2081327,-1.2081327,-1.3169327,-0.66413301,-1.1537328,-0.8817329,-0.22893322,0.5326664,0.7502663,0.58706638,0.20626657,0.15186659,-0.33773317,-0.60973303,-0.44653311,-0.22893322,0.5326664,0.69586632,2.4366655,2.1102656,1.2398661:2
0.52589062,-0.07774035,-0.5167447,-0.84599795,-1.0106246,-1.1203757,-1.8337577,-1.7240066,-1.2850023,-0.1326159,0.47101508,0.74539279,0.74539279,0.2515129,-0.07774035,-0.022864808,-0.18749144,-0.29724252,-0.1326159,0.52589062,1.074646,2.1172814,1.5685259,1.2392727:2
-0.95005819,-1.2750187,-1.5187391,-1.5999792,-1.6812193,-1.4374989,-1.0312983,-0.54385753,0.53934419,1.1351051,1.053865,0.97262488,0.78306458,0.34978389,0.4851841,0.53934419,0.45810406,0.32270385,0.45810406,1.4329856,1.1621852,0.64766436,0.02482337,-0.32721719:1
-0.79550393,-1.203723,-1.4235333,-1.4863363,-1.5491392,-1.4863363,-1.2351245,-0.41868629,0.58616078,1.1513873,1.2455917,1.2455917,0.93157695,0.80597107,0.83737254,1.2141902,0.96297842,0.74316813,0.39775195,0.20934313,-0.26167893,-0.16747452,0.052335775,-0.35588334:2
-0.5066519,-0.9853781,-1.4641043,-1.4162317,-1.5119769,-1.128996,-1.3204864,-0.31516142,0.45080051,1.4561255,1.6954886,1.3603803,1.0252719,0.40292789,-0.07579831,-0.07579831,-0.17154356,-0.41090666,-0.31516142,0.35505527,1.5518708,0.92952672,0.49867313,-0.02792569:1
-0.66859246,-1.0930956,-1.3194973,-1.3760977,-1.4326981,-1.2911971,-1.545899,-1.0647954,0.095513207,1.0860206,1.284122,1.3690227,1.3124222,0.85961888,0.88791909,0.97281972,0.88791909,0.68981762,0.37851531,0.26531447,-0.15918868,-0.10258826,0.15211363,-0.18748889:2
-0.76906173,-1.039501,-1.3775501,-1.6479894,-1.5127697,-1.5127697,-0.90428137,-1.1071108,-0.29579297,0.78596417,1.5296722,1.1916231,0.98879363,0.71835435,0.44791506,0.78596417,0.78596417,0.44791506,0.31269542,0.17747578,-0.29579297,1.3268427,0.65074453,0.31269542:2
0.0018942,-0.45271337,-0.81639942,-1.0437032,-1.1800855,-1.0437032,-0.81639942,-1.1800855,-0.77093866,-0.13448807,0.59288403,0.59288403,0.41104101,0.22919798,-0.3163311,-0.45271337,-0.63455639,-0.63455639,-0.27087034,1.9567067,2.1385498,1.7748637,1.2747954,0.77472706:1
-0.9103363,-1.1901137,-1.3172852,-1.4698911,-1.5207597,-1.4190225,-1.215548,-0.83403337,0.89549962,1.4550544,1.4550544,1.3533172,1.0481055,0.69202515,0.71745946,0.64115653,0.5394193,0.23420759,0.056167429,-0.020135497,0.23420759,0.64115653,0.2596419,-0.3253472:2
0.27485841,-0.49218832,-0.90127989,-1.3103715,-1.2592351,-1.1569622,-1.0035528,-0.64559766,-1.1058257,-0.083096725,0.47940421,0.58167711,0.63281355,0.070312619,-0.28764252,-0.18536963,-0.38991542,-0.59446121,-0.13423318,0.73508645,2.2180435,2.0646341,1.5021332,0.9907687:1
-0.84154944,-1.2139798,-1.4718163,-1.5864102,-1.5864102,-1.5004648,-1.2426283,-0.35452508,0.30439022,1.106548,1.3643844,1.3643844,1.106548,0.70546911,0.59087514,0.84871157,0.96330553,0.56222665,0.33303872,0.10385078,-0.039391678,0.61952363,0.16114777,-0.2972281:2
-0.81666336,-1.2325768,-1.3885443,-1.596501,-1.6224956,-1.4145389,-1.5185173,-0.14080404,0.32709858,1.0809417,1.18492,1.1589255,0.87298497,0.74301202,0.84699038,1.0289525,1.1069363,0.7950012,0.48306612,0.17113104,-0.11480945,-0.062820267,0.30110399,-0.19279322:2
-0.648886,-1.1346019,-1.2863881,-1.529246,-1.5596032,-1.4685315,-1.2863881,-0.67924325,0.26183121,1.1725484,1.2636201,1.2636201,0.92969049,0.89933325,0.68683258,1.1725484,1.1421912,0.86897601,0.41361741,0.14040225,-0.13281292,-0.041741198,-0.041741198,-0.40602808:2
-1.0301707,-1.4011413,-1.5538939,-1.6193593,-1.6193593,-1.4229631,-1.0738143,0.19184998,0.99925652,1.1956527,1.2174745,1.1083655,0.91196933,0.45371156,0.34460257,0.41006796,0.41006796,0.25731537,0.27913717,1.1301873,0.80286033,0.47553336,-0.048189807,-0.41916038:1
-1.1441806,-1.3795032,-1.5424188,-1.596724,-1.6148257,-1.3614014,-0.9993667,-0.23909377,0.62978958,0.97372257,1.082333,1.0642313,0.95562083,0.5392809,0.5392809,0.70219653,0.75650174,0.75650174,0.97372257,0.91941736,0.55738264,0.21344964,-0.16668682,-0.61923024:1
-0.76227642,-1.1933018,-1.336977,-1.5285438,-1.5285438,-1.5285438,-1.0975184,-0.61860128,0.33923296,1.1055004,1.3449589,1.3928506,1.2491755,1.0097169,0.77025837,0.8660418,0.67447495,0.81815008,0.4829081,0.0039909748,-0.33125101,-0.13968416,0.24344954,-0.23546759:2
-0.72883983,-0.98607743,-1.3719339,-1.5327074,-1.7256356,-1.4362433,-1.0182322,-0.053591143,0.62165754,1.0396686,1.1361327,1.0396686,0.68596694,0.10718235,-0.15005524,-0.24651934,-0.11790054,0.10718235,1.3290609,1.6184532,1.2969062,0.71812164,0.075027655,-0.40729283:1
-0.66987364,-1.1857122,-1.3863161,-1.4722892,-1.58692,-1.5009469,-1.58692,-0.44061207,0.59106501,1.2215343,1.3361651,1.2788497,1.1355612,0.73435349,0.73435349,0.84898428,0.84898428,0.50509192,0.24717264,0.21851495,0.046568771,0.16119955,0.18985725,-0.26866589:2
-0.88848275,-1.3065923,-1.557458,-1.6968278,-1.557458,-1.5017101,-0.99997862,-0.47037322,0.67245949,1.3414347,1.3135608,1.2578128,0.95119918,0.56096362,0.58883759,0.70033346,0.70033346,0.44946774,0.36584584,0.11498012,0.14285409,0.78395537,0.33797187,-0.30312941:2
-1.0436529,-1.3266775,-1.5288378,-1.5692699,-1.609702,-1.5086218,-1.1851652,0.0075810113,0.65449423,1.079031,1.0385989,0.89708668,0.55341403,0.35125365,0.37146969,0.4321178,0.57363007,0.93751876,1.2609753,1.1194631,0.65449423,0.37146969,-0.053067103,-0.4776039:1
-0.60178749,-0.99699122,-1.3562673,-1.4999778,-1.5359054,-1.4640502,-1.1766293,-0.70957033,-0.3143666,-0.27843899,0.36825802,0.65567891,0.79938936,0.40418563,0.044909513,-0.026945711,0.0089819006,1.0868103,1.3023759,1.5897968,1.482014,1.1945931,0.69160652,0.33233041:1
-1.0279646,-1.3235883,-1.5117126,-1.646087,-1.5923373,-1.4579628,-1.162339,-0.27546763,0.63827865,1.1220267,1.2295262,1.0951518,0.79952799,0.53077908,0.55765397,0.69202843,0.63827865,0.45015441,0.31577996,0.93390244,0.96077733,0.45015441,0.12765573,-0.54421653:1
-0.91104907,-1.3138876,-1.5153068,-1.6943461,-1.6272064,-1.4257871,-0.93342898,-0.12775202,0.96886385,1.1702831,1.1479032,0.92410402,0.70030486,0.25270655,0.29746638,0.23032663,0.6107852,1.0583835,1.0807634,1.0136237,0.6107852,0.25270655,-0.15013193,-0.62011016:1
-0.99765612,-1.344667,-1.5582121,-1.6115984,-1.6382915,-1.4781327,-1.0243493,-0.30363448,0.57723917,0.79078429,1.0310226,0.89755685,0.87086371,0.44377347,0.2035352,0.36369404,0.41708033,0.73739801,1.3513403,1.2712608,0.81747743,0.49715975,0.043376357,-0.35702076:1
-0.5491846,-0.93939471,-1.4163182,-1.5030316,-1.6331016,-1.5030316,-1.2428915,0.23123562,0.66480242,1.2717959,1.401866,1.0983692,0.57808906,0.23123562,-0.1156178,-0.15897448,-0.15897448,-0.28904452,0.014452234,1.5752927,1.3585093,0.88158582,0.36130566,-0.15897448:1
0.022959187,-0.67833949,-1.0790816,-1.4297309,-1.5299164,-1.3796382,-1.6801947,-1.0790816,0.27342299,1.2752782,1.9765769,1.3754638,1.1750927,0.32351575,-0.077226338,-0.1273191,0.022959187,-0.027133576,0.022959187,0.47379404,0.27342299,1.1249999,0.72425786,0.022959187:2
-0.88935968,-1.1119895,-1.3902767,-1.5294203,-1.5294203,-1.4459342,-1.5850778,-0.6945586,0.55773403,1.0029936,1.2256234,1.1977947,1.0308224,0.61339148,0.94733618,0.91950746,0.80819256,0.72470638,0.55773403,0.52990531,0.056816978,-0.026669198,0.19596061,-0.16581282:2
-1.0000126,-1.3138998,-1.5312064,-1.6277871,-1.6519323,-1.4104805,-1.0000126,-0.4446736,0.69014953,1.173053,1.2213433,1.0523271,0.73843988,0.42455263,0.40040745,0.47284297,0.52113332,0.35211711,0.42455263,1.2937789,0.95574643,0.64185918,0.086520208,-0.46881878:1
-0.5237663,-0.83607415,-1.070305,-1.6168438,-1.6168438,-1.5387668,-0.83607415,-1.3826129,-0.21145844,1.037773,1.1939269,1.3500808,1.1158499,0.5693112,0.72546513,0.64738816,0.5693112,0.3350803,0.17892637,0.022772453,-0.5237663,1.5062347,0.88161905,0.022772453:2
-0.20557423,-0.98675633,-1.2745603,-1.4390197,-1.5212494,-0.98675633,-0.86341179,-0.6989524,0.90452665,1.7679384,1.891283,1.6445939,1.0278712,0.45226333,0.12334455,-0.28780392,-0.49337816,-0.32891877,-0.45226331,6.40625E-9,0.20557425,1.1512157,0.49337818,-0.12334453:2
-1.1625199,-1.3409117,-1.5193035,-1.6263385,-1.6263385,-1.4479467,-0.93061053,-0.038651552,0.81762906,1.01386,1.0316992,0.97818168,0.83546824,0.51436301,0.49652383,0.63923727,0.67491562,0.99602086,1.0495384,0.8711466,0.42516711,0.19325778,-0.23488253,-0.6095053:1
-0.99751921,-1.292716,-1.5288735,-1.7059915,-1.6469522,-1.4403144,-0.90896017,-0.14144847,0.62606322,1.0983781,1.1869372,1.1574175,1.1574175,0.56702386,0.74414194,0.8031813,0.68510258,0.41942546,0.065189291,0.15374834,0.8031813,0.8031813,-0.082409111,-0.52520432:2
-0.8492309,-1.1928886,-1.4043702,-1.5365462,-1.5365462,-1.377935,-1.6158518,-0.76992529,0.47252926,1.1598446,1.2655854,1.1069741,1.1069741,0.7368813,0.68401089,0.86905731,0.84262211,0.65757569,0.41965885,0.41965885,0.20817723,0.18174202,0.28748284,-0.13548042:2
-0.16778057,-0.80616518,-1.2481237,-1.4445498,-1.5427628,-1.5427628,-1.2972303,-0.16778057,0.32328451,1.2563082,1.6982667,1.3054147,0.91256261,0.12685848,-0.11867406,-0.21688708,-0.31510009,-0.51152613,0.66703007,0.12685848,1.6000537,1.2072017,0.37239102,-0.21688708:2
0.74071412,0.1181684,-0.57354906,-0.57354906,-0.7810643,-0.57354906,-0.43520557,-0.089346839,-0.57354906,0.25651189,0.74071412,0.94822935,0.67154237,0.048996654,-0.7810643,-1.1960948,-1.126923,-1.126923,-1.3344383,-0.85023605,1.0174011,2.1933208,1.7782903,1.5016033:1
-0.78167669,-1.191886,-1.3833171,-1.5200535,-1.5747481,-1.4653589,-1.6020954,-0.53555109,0.47629863,1.2146754,1.4334538,1.1599809,0.94120255,0.5583405,0.74977152,0.88650797,0.85916068,0.64038236,0.47629863,0.2848676,0.066089279,0.066089279,0.36690947,-0.12534174:2
-1.2498364,-1.4140485,-1.5600148,-1.5782606,-1.6147522,-1.4322943,-0.8666749,-0.17333498,0.50175915,0.92141225,1.0673786,0.93965804,0.73895438,0.48351336,0.428776,0.53825073,0.5747423,0.95790382,1.286328,1.0491328,0.62947965,0.33754706,-0.17333498,-0.39228443:1
0.55361298,0.090891679,-0.5040357,-0.63624178,-0.70234482,-0.76844787,-1.2311692,-1.4955813,-1.1650661,-0.5040357,0.024788637,0.28920081,0.35530385,0.090891679,-0.30572657,-0.37182961,-0.30572657,-0.30572657,-0.30572657,0.024788637,0.61971602,2.4044982,2.2722921,1.8756738:2
-1.0468305,-1.3498092,-1.5129516,-1.6294819,-1.652788,-1.4663395,-1.0002183,-0.37095477,0.65451181,1.1672451,1.0740209,0.88757239,0.65451181,0.39814517,0.46806334,0.58459363,0.53798152,0.39814517,0.51467546,1.4236117,1.0507148,0.46806334,0.14177852,-0.39426083:1
-1.0642282,-1.3416376,-1.5001572,-1.5794171,-1.599232,-1.4208974,-1.143488,-0.21218515,0.50115324,0.85782244,0.95689721,0.95689721,0.87763739,0.5209682,0.62004297,0.65967288,0.81819253,1.0757869,1.1154169,0.95689721,0.5209682,0.26337378,-0.29144497,-0.54903939:1
-0.39375112,-0.83950709,-1.4635654,-1.5527166,-1.6418678,-1.3744142,-0.92865828,-1.285263,-0.30459992,1.3001216,1.5675751,1.2109704,1.1218192,0.67606322,0.67606322,0.49776082,0.49776082,0.40860963,0.052004852,0.14115605,-0.30459992,1.2109704,0.58691201,0.14115605:2
-0.099111129,-0.65413341,-1.0505779,-1.2488002,-1.3280891,-1.1298668,-0.8920001,-0.65413341,-0.8127112,-0.13875557,0.4162667,0.61448894,0.53520005,-0.059466681,-0.13875557,-0.49555562,-0.57484452,-0.57484452,0.97128898,1.9624003,2.0416892,1.6452447,1.0902224,0.5748445:1
-0.0071746957,-0.52375274,-1.083379,-1.1264271,-1.2986198,-1.2555716,-0.95423444,-0.4376564,-0.82508993,0.078921646,0.55245152,0.68159603,0.55245152,0.12196982,-0.22241555,-0.48070457,-0.65289725,-0.69594542,-0.050222865,1.7578003,2.0160893,1.9730411,1.1981741,0.68159603:1
0.3207932,-0.1603966,-0.8340623,-1.3152521,-1.4114901,-1.2190142,-0.6415864,-1.4114901,-0.25663456,1.3794108,2.0530765,1.8606006,1.4756487,0.70574502,-0.35287252,-0.1603966,-0.1603966,-0.25663456,-0.25663456,0.032079316,-0.73782435,-0.1603966,1.0906969,0.41703115:2
0.94351038,0.25732101,-0.20013856,-0.08577367,-0.42886835,-0.20013856,0.25732101,-1.2294226,-0.77196303,-0.20013856,0.25732101,0.25732101,-0.08577367,-0.08577367,-1.5725173,-0.77196303,-0.88632793,-0.54323325,-0.54323325,-0.77196303,-0.08577367,2.5446189,2.2015242,1.7440646:2
-1.0125705,-1.3538179,-1.5488164,-1.5975661,-1.5000668,-1.2563186,-1.0125705,-0.91507122,0.57179255,1.2055378,1.3274119,1.2055378,1.0349141,0.79116589,0.644917,0.76679108,0.76679108,0.47429329,0.42554365,0.35241921,0.23054513,0.69366663,0.08429623,-0.37882528:2
-0.68518273,-1.1296256,-1.3666618,-1.4555503,-1.4851799,-1.4555503,-1.3962913,-0.65555321,0.35185059,1.0925887,1.2999953,1.2703658,1.0629592,0.85555249,0.82592297,1.0925887,1.1222182,0.82592297,0.29259155,0.17407345,-0.21111036,-0.24073988,0.025925833,-0.21111036:2
0.16543842,-0.60803994,-1.1236922,-1.3815183,-1.4846487,-1.3299531,-2.1034314,-0.91743128,0.47482976,1.7123952,1.7123952,1.3514386,1.0936125,0.11387319,0.11387319,0.11387319,0.16543842,-0.0923877,0.06230797,0.32013409,0.42326454,0.42326454,0.73265587,0.06230797:2
-1.0175031,-1.3466701,-1.4701077,-1.6346912,-1.6141183,-1.4289618,-1.058649,-0.17401275,0.73119643,0.95749873,1.1015093,1.0397905,0.73119643,0.42260239,0.40202946,0.42260239,0.46374827,0.54604001,1.4101033,1.1220822,0.64890469,0.38145652,-0.0094292675,-0.62661736:1
-0.24861742,-0.79771111,-1.1271673,-1.4932298,-1.4932298,-1.3101985,-1.0173486,-0.68789237,-0.72449862,-0.10219244,0.41029501,0.73975122,0.77635746,0.19065753,-0.10219244,-0.24861742,-0.35843616,-0.065586192,1.4352699,1.7647261,1.6915136,1.4352699,1.0326012,0.30047627:1
-0.85778719,-1.2819676,-1.5364759,-1.621312,-1.7061481,-1.5364759,-0.91434459,-0.34877062,0.81065601,1.3479513,1.3479513,1.2065578,1.093443,0.64098381,0.61270511,0.64098381,0.47131162,0.32991813,0.18852464,0.21680334,0.21680334,0.75409861,0.30163944,-0.37704932:2
-0.94329127,-1.1153575,-1.5332324,-1.7052986,-1.7052986,-1.3365854,-1.1891001,-0.47625455,0.43323802,0.72820858,0.85111299,0.92485563,0.94943651,0.4578189,0.48239978,0.38407626,0.62988506,0.92485563,1.268988,1.3181497,0.72820858,0.40865714,-0.058379587,-0.42709279:1
-0.89108777,-1.2080997,-1.5738826,-1.5738826,-1.6226536,-1.500726,-1.2080997,-0.62284698,0.35257408,0.84028462,1.181682,1.2548386,0.98659778,0.81589909,0.62081488,0.86467015,0.84028462,0.84028462,0.52327277,0.35257408,0.40134513,0.62081488,0.059947764,-0.35460619:2
-1.0732529,-1.2879035,-1.5293854,-1.6367107,-1.663542,-1.5025541,-0.99275891,-0.40246983,0.40246984,0.99275892,1.1537469,1.0464216,0.99275892,0.67078306,0.85860232,0.88543364,0.99275892,0.50979513,0.40246984,0.26831323,0.67078306,0.5902891,0.080493972,-0.42930115:2
-0.37067751,-0.842724,-1.2058366,-1.387393,-1.5689493,-1.532638,-1.1695254,-0.80641273,-0.47961131,-0.26174371,0.53710417,0.86390557,1.0454619,0.35554783,0.065057691,-0.0075648441,-0.22543245,0.17399149,1.5538196,1.6264421,1.4085745,1.335952,0.64603797,0.24661402:1
-1.0155388,-1.3407822,-1.5440594,-1.5643871,-1.6050426,-1.4220931,-1.0561942,-0.080463882,0.97657733,1.0375605,1.1188714,0.9359219,0.79362789,0.38707358,0.34641815,0.46838444,0.46838444,0.44805672,1.2001822,1.1188714,0.85461104,0.32609043,-0.30406876,-0.54800135:1
-0.14490473,-0.90565448,-1.23169,-1.7750827,-1.5577256,-1.23169,-0.79697594,-1.23169,0.18113087,1.2679162,0.83320208,1.3765948,1.1592377,1.3765948,0.72452355,0.18113087,0.2898094,-0.036226197,-0.3622618,-0.47094033,-0.25358326,1.3765948,0.94188061,0.2898094:2
-0.60358877,-1.0785439,-1.4347602,-1.553499,-1.6722377,-1.4347602,-0.84106632,-1.0785439,0.049474493,1.0587541,1.4149704,1.4149704,1.355601,0.76190714,0.70253775,0.76190714,0.64316836,0.64316836,0.22758265,0.10884388,-0.42548061,0.64316836,0.40569081,-0.069264281:2
-0.67451348,-1.1463043,-1.3821998,-1.677069,-1.7360429,-1.3527128,-1.0873305,-0.11426185,0.85880678,0.97675449,1.1536761,1.0062414,0.79983292,0.15112051,-0.084774922,-0.20272263,-0.14374877,0.092146646,1.3011107,1.3895715,1.183163,0.770346,0.15112051,-0.23220956:1
-1.0736609,-1.3838835,-1.5971615,-1.6165504,-1.5971615,-1.4420502,-0.99610534,-0.10421542,0.72950777,1.0978971,1.117286,0.98156361,0.76828559,0.38050738,0.39989629,0.55500757,0.4192852,0.67134104,1.2142305,1.0785082,0.61317431,0.28356281,0.012118053,-0.51138255:1
-0.99495555,-1.3812679,-1.5744241,-1.5985686,-1.5985686,-1.429557,-1.0191001,-0.34305343,0.71930559,1.202196,1.1056179,1.0573289,0.81588368,0.42957131,0.45371584,0.45371584,0.45371584,0.35713774,0.57443845,1.3229186,0.88831725,0.57443845,-0.0050301017,-0.46377604:1
-0.76406636,-1.1501209,-1.3753194,-1.4718331,-1.6005179,-1.5040043,-1.0536073,-0.76406636,0.4262686,1.2627202,1.2948914,1.3270626,1.1018641,0.84449439,0.84449439,0.97317925,0.94100803,0.71580953,0.39409738,0.16889888,-0.2171557,-0.088470846,-0.024128416,-0.28149813:2
-0.96916733,-1.3359228,-1.5289519,-1.6254665,-1.5675578,-1.4324374,-1.046379,-0.13914187,0.63297486,1.057639,1.2506682,1.1541536,0.84530695,0.51715735,0.26621942,0.4592486,0.5750661,0.32412817,1.1734565,1.2120624,0.49785443,0.36273401,-0.11983895,-0.56380606:1
-0.37866805,-0.89663887,-1.2733449,-1.5558744,-1.650051,-1.3675214,-1.3204332,-0.89663887,0.65727357,1.2223326,1.7403034,1.3635974,1.0339796,0.5160088,-0.0019620058,-0.19031503,-0.14322678,-0.19031503,0.092214505,0.37474403,0.79853834,1.0810679,0.79853834,0.18639101:2
-0.96361473,-1.2606556,-1.5576965,-1.5576965,-1.6425653,-1.3879588,-0.87874591,-0.96361473,-0.030057709,0.94593372,1.2005402,1.2429746,0.94593372,0.69132726,0.73376167,0.8610649,0.8610649,0.60645844,0.47915521,0.18211434,0.054811111,1.073237,0.47915521,-0.11492653:2
-1.0578487,-1.4154314,-1.5431395,-1.6197644,-1.645306,-1.4665146,-1.2110984,0.14260737,0.5768149,1.2664386,1.1642721,1.0876473,0.85777271,0.62789814,0.52573166,0.5768149,0.60235652,0.34694033,0.21923223,0.50019004,0.90885595,0.73006462,0.19369061,-0.36822501:2
-0.90659539,-1.3105954,-1.4837383,-1.5991669,-1.628024,-1.5414526,-1.0797382,-0.35830958,0.68054772,1.1134049,1.2576907,1.1711192,1.0556906,0.47854769,0.56511913,0.73826201,0.70940486,0.44969054,0.18997622,0.074547626,1.0556906,0.73826201,-0.040880964,-0.32945244:2
-1.0029463,-1.3557068,-1.4594598,-1.666966,-1.666966,-1.4387092,-1.1066994,-0.13142055,0.63635215,1.0928657,1.1758681,1.072115,0.84385829,0.38734479,0.24209049,0.4080954,0.44959663,0.42884602,1.1758681,1.1343669,0.67785338,0.47034724,0.076085586,-0.44267976:1
-0.64793158,-1.088868,-1.2946383,-1.5004086,-1.4416171,-1.4122213,-1.5004086,-0.67732734,0.23394126,1.2040014,1.3215844,1.3509802,1.0864183,0.79246072,0.85125224,1.0276268,1.0570226,0.70427344,0.29273279,0.29273279,-0.20699516,-0.38336972,0.11635822,-0.1775994:2
-0.85907822,-1.1899824,-1.3936157,-1.5463407,-1.5463407,-1.4954324,-1.5463407,-0.40090318,0.66817193,1.2027095,1.2281636,1.1772553,1.0754386,0.66817193,0.79544277,0.87180528,0.82089694,0.6936261,0.46453858,0.18454272,0.057271869,0.23545106,0.10818022,-0.27363233:2
0.019050876,-0.66678106,-1.2383077,-1.2954603,-1.5812237,-1.4669183,-1.2954603,-0.89539171,0.47627218,1.5621728,2.0193941,1.2764095,0.93349346,0.30481419,-0.095254446,-0.095254446,-0.20955977,-0.15240711,-0.20955977,0.1333562,0.076203539,1.3907148,0.8763408,0.1333562:2
-0.95666169,-1.2932464,-1.5577057,-1.6538728,-1.6779145,-1.4615387,-1.0047452,-0.01903306,0.67817798,1.183055,1.183055,1.1349714,0.75030326,0.38967685,0.43776037,0.38967685,0.46180213,0.36563509,0.65413622,1.3032638,0.89455381,0.38967685,-0.091158339,-0.49986825:1
-1.0983096,-1.4108721,-1.5411064,-1.619247,-1.619247,-1.5150596,-1.1243565,0.021705719,0.59473685,1.1938148,1.2459086,1.1156742,0.85520554,0.59473685,0.59473685,0.75101806,0.67287745,0.59473685,0.17798694,0.17798694,0.77706493,0.64683058,0.23008068,-0.31690358:2
-0.82635576,-1.370105,-1.5704337,-1.6562888,-1.6849072,-1.5131969,-1.2270131,-0.11089623,0.54732654,1.1196942,1.2055493,0.97660228,0.91936551,0.49008978,0.60456331,0.66180007,0.74765521,0.51870816,0.26114273,0.49008978,1.0052206,0.66180007,0.11805082,-0.36846166:2
-0.78321889,-1.2807932,-1.5295804,-1.6401525,-1.6677955,-1.5295804,-1.3084363,-0.25800152,0.87536228,1.1241495,1.2347215,1.1241495,0.82007624,0.59893209,0.62657511,0.70950417,0.65421813,0.54364605,0.21192982,0.46071699,0.79243322,0.57128907,0.018428676,-0.36857359:1
-0.40782256,-0.84607966,-1.333032,-1.4304225,-1.5765082,-1.2356415,-1.8686796,-1.0895558,0.127825,1.2478153,1.3452058,1.5399867,1.1991201,0.71216778,0.56608208,0.46869163,0.51738686,0.32260593,0.22521546,0.22521546,0.030434526,0.127825,0.90694871,0.22521546:2
1.2410089,0.64361782,0.046226695,-0.46582284,-0.63650602,-0.55116442,-2.0019714,-1.8312882,-0.97787238,0.13156828,0.55827623,0.55827623,0.64361782,0.13156828,-0.46582284,-0.63650602,-0.38048125,-0.46582284,-0.46582284,-0.29513966,0.13156828,0.98498418,1.9237416,2.1797664:2
-0.94434673,-1.3768719,-1.4850032,-1.5931345,-1.5931345,-1.4850032,-1.0092255,-0.014417511,0.65599657,1.2615319,1.2182793,1.1317743,0.91551172,0.43973396,0.28835014,0.4181077,0.46136022,0.54786527,0.82900666,1.110148,0.72087535,0.33160266,-0.079296295,-0.74971038:1
1.0553533,0.29359451,-0.27772455,-0.9125235,-0.9125235,-0.78556371,-1.9916817,-1.6108023,-0.97600339,-0.15076476,0.61099398,0.80143367,0.67447388,0.23011461,-0.08728486,-0.15076476,-0.27772455,-0.34120445,-0.34120445,-0.27772455,0.4205543,0.73795377,2.3884311,1.8805919:2
-0.98157161,-1.2517289,-1.548902,-1.6029335,-1.6569649,-1.5218863,-1.2247132,-0.36020977,0.66638807,1.1256555,1.2607342,1.1256555,0.72041953,0.63937233,0.66638807,0.6934038,0.6934038,0.5313094,0.28816781,0.36921501,0.90952966,0.6934038,0.072041957,-0.3061783:1
-1.088945,-1.3624021,-1.5186633,-1.5772612,-1.5967938,-1.4991306,-1.088945,-0.092780076,0.57132989,1.0205808,1.0205808,0.84478694,0.68852577,0.41506872,0.37600343,0.51273196,0.57132989,1.2354399,1.1573093,1.0205808,0.64946048,0.31740549,-0.092780076,-0.483433:1
-0.82828519,-1.259185,-1.6039049,-1.7475381,-1.6613582,-1.5177249,-1.1155517,-0.1962988,0.78040744,1.2113072,1.2974872,1.1251273,1.0102207,0.4931409,0.57932086,0.66550082,0.63677417,0.4931409,0.34950763,0.1771477,0.40696093,0.69422747,0.34950763,-0.33993207:2
0.060790377,-0.77290618,-1.0855424,-1.4502847,-1.6066028,-1.6066028,-1.1897545,-0.6686941,0.32132055,1.3113352,1.3634413,1.1029111,0.73816883,0.11289641,-0.1997398,-0.40816394,-0.3560579,-0.30395186,-0.095527727,1.0508051,1.8323956,1.1550171,0.63395676,0.060790377:1
-0.63667677,-1.1502984,-1.5034133,-1.6318187,-1.6318187,-1.4392106,-0.70087947,-0.28356193,0.48687047,1.2894043,1.4178097,1.1609989,0.71157991,0.19795832,-0.31566328,-0.18725788,-0.058852478,0.32636371,1.2252016,1.4820124,0.93628937,0.48687047,0.19795832,-0.37986598:1
0.10265191,-0.52445791,-0.92759993,-1.1067742,-1.330742,-1.1963613,-0.61404503,-1.2411548,-0.65883858,0.19223903,0.46100038,0.59538105,0.46100038,0.013064795,-0.34528368,-0.47966435,-0.56925147,-0.61404503,0.013064795,1.8048071,2.118362,1.8048071,1.2672844,0.77455529:1
-1.1455804,-1.3193178,-1.5364894,-1.6016409,-1.6016409,-1.4713379,-0.92840879,0.048863625,0.54835842,1.026136,1.026136,0.96098455,0.59179275,0.37462109,0.46148976,0.61350991,0.70037857,0.70037857,1.1781562,1.2650248,0.67866141,0.3094696,-0.21174236,-0.66780281:1
-1.0555549,-1.3922102,-1.5605379,-1.6236608,-1.6026199,-1.4342922,-1.0134729,0.038575095,0.81709065,1.1116641,0.94333641,0.94333641,0.83813161,0.41731239,0.31210759,0.41731239,0.50147623,0.88021353,1.153746,1.0485412,0.66980392,0.33314855,-0.15079355,-0.59265373:1
-0.50894799,-1.0114536,-1.3593422,-1.5526136,-1.5526136,-1.2820336,-0.77952795,-0.50894799,0.72798891,1.3851117,1.3851117,1.0372232,0.76664319,0.2254833,-0.19971378,-0.19971378,-0.35433088,-0.19971378,-0.27702234,1.6170374,1.5010745,1.0758774,0.26413758,-0.19971378:1
-0.98589936,-1.3076573,-1.5551634,-1.6789165,-1.6294153,-1.4314104,-0.98589936,-0.51563774,0.54863856,1.093152,1.0189002,0.96939896,0.8456459,0.32588305,0.37538428,0.57338917,0.69714223,0.57338917,0.49913733,1.2664063,1.0436508,0.647641,0.053626325,-0.44138591:1
-0.59637766,-1.1054197,-1.4347998,-1.674349,-1.6144617,-1.4347998,-1.075476,-0.23705388,0.33187544,0.96069206,1.2900722,1.2301849,1.0205793,0.30193179,-0.14722294,-0.11727929,-0.11727929,0.032438952,1.2002412,1.4996777,1.1104103,0.60136827,0.032438952,-0.057391994:1
-0.38248378,-1.1318398,-1.4440714,-1.6314104,-1.6314104,-1.4440714,-1.1006166,-0.25759112,0.24197954,0.99133552,1.272344,1.1162282,0.77277336,0.2732027,-0.10147529,-0.13269845,-0.10147529,0.085863702,1.3347903,1.5845757,1.1786745,0.61665753,0.1795332,-0.28881428:1
-0.80659665,-1.090681,-1.4559323,-1.4965158,-1.5370993,-1.4965158,-1.2935984,-0.7254297,0.16740685,1.1008269,1.3849112,1.4254947,1.1008269,0.77615904,0.69499209,0.77615904,0.857326,0.57324165,0.32974077,0.16740685,-0.19784446,0.69499209,0.32974077,-0.27901142:2
-1.0509161,-1.2250324,-1.5981388,-1.6478863,-1.6478863,-1.3245274,-1.0509161,-0.3047035,0.56587793,1.2125955,1.162848,0.98873177,0.73999422,0.36688789,0.51613042,0.49125667,0.6404992,0.34201414,0.51613042,1.3867118,0.93898426,0.54100418,-0.055965945,-0.50369354:1
-1.0855598,-1.2618943,-1.4602707,-1.5925217,-1.6145635,-1.4602707,-1.0855598,-0.093677739,0.45736781,1.052497,1.0084134,0.89820426,0.72186968,0.36920052,0.45736781,0.47940964,0.45736781,0.7439115,1.3390407,1.2288316,0.63370239,0.65574421,-0.15980321,-0.68880695:1
-0.91297508,-1.2765492,-1.6158851,-1.7128382,-1.6643616,-1.4219789,-1.1068813,0.032317706,0.54132151,1.1715167,1.1230401,1.026087,0.80794255,0.37165357,0.49284495,0.42013012,0.51708323,0.29893874,0.49284495,1.3654229,0.92913394,0.54132151,-0.016158847,-0.40397127:1
-1.0673255,-1.3820756,-1.5273449,-1.5999795,-1.5999795,-1.5031333,-1.0673255,-0.050440727,0.72432868,1.0390787,1.1117134,0.96644411,0.91802103,0.53063633,0.48221324,0.65169405,0.43379016,0.28852089,0.50642479,1.3296173,0.82117485,0.55484787,-0.050440727,-0.51046006:1
-0.6608612,-1.1376348,-1.5508386,-1.6461933,-1.6461933,-1.3919141,-0.94692536,-0.056947961,0.83302945,0.92838417,1.1826634,1.0873087,0.92838417,0.29268602,0.29268602,0.22911621,0.32447093,0.83302945,1.3733729,1.1508785,0.70588982,0.10197658,-0.37479703,-0.85157064:1
-0.90468972,-1.1961334,-1.3904292,-1.511864,-1.511864,-1.4390031,-1.511864,-0.8318288,0.38251981,0.9168332,1.086842,1.1597029,1.0382681,0.89254623,0.79539834,0.89254623,1.0139811,0.7468244,0.55252862,0.40680679,-0.0060717462,0.50395468,0.13965009,-0.22465449:2
0.53996143,-0.13244337,-0.68259276,-0.9882313,-1.2327422,-0.80484817,-0.86597588,-1.8440193,-0.86597588,0.17319518,0.78447226,0.47883372,0.84559998,0.050939758,-0.25469879,-0.13244337,-0.37695421,-0.49920963,-0.49920963,-0.010187953,0.66221684,2.5571759,1.7625157,1.3346217:2
-0.38018325,-0.60687637,-1.1169359,-1.5703221,-1.5703221,-1.343629,-1.0602626,-1.1736092,0.46991594,1.2066686,1.6033815,1.3200151,1.3766884,0.35656938,-0.21016341,-0.32350997,-0.26683669,-0.32350997,-0.040143569,0.46991594,0.63993579,1.4333617,0.97997547,0.12987627:2
0.81586664,0.20776728,-0.33952214,-0.70438176,-0.9476215,-0.9476215,-2.0422003,-1.7381507,-1.1300513,-0.035472467,0.93748651,0.87667657,0.81586664,0.39019709,0.14695734,-0.096282402,-0.33952214,-0.64357182,-0.40033208,-0.096282402,0.57262689,1.3631561,2.1536852,1.1807263:2
-0.808256,-1.4079298,-1.4600754,-1.5122209,-1.4861481,-1.4079298,-1.4600754,-0.59967381,0.52145549,1.0950565,1.3557843,1.1732748,1.0950565,0.75611046,0.70396491,0.96469265,0.88647433,0.54752826,0.31287329,0.28680052,3.1944447E-9,0.13036387,0.31287329,3.1944447E-9:2
0.72065838,-0.24618765,-0.89075167,-1.2130337,-1.2130337,-1.2130337,-0.89075167,-1.965025,-0.46104232,0.72065838,1.2577951,1.1503677,1.2577951,-0.13876031,-0.35361498,-0.24618765,0.076094365,0.076094365,-0.03133297,-0.03133297,-0.67589699,1.9023591,1.4726497,0.93551306:2
-1.1035904,-1.3431857,-1.5174369,-1.6045624,-1.6045624,-1.4520927,-1.1471532,-0.058083719,0.55179522,1.1616742,1.1181114,1.0092044,0.8349533,0.39932549,0.44288827,0.39932549,0.48645105,0.46466966,1.0092044,1.2270183,0.72604635,0.48645105,-0.014520936,-0.47193014:1
-0.98817866,-1.3751577,-1.5410059,-1.5594335,-1.6331438,-1.4120129,-1.1171717,-0.28793085,0.67030301,0.98357178,1.0757096,1.0572821,0.85457876,0.50445485,0.59659272,0.63344787,0.67030301,0.76244089,1.0757096,0.9651442,0.59659272,0.20961366,-0.14051025,-0.6011996:1
-0.08641224,-0.56500306,-1.0435938,-1.4158311,-1.4158311,-1.2563009,-1.8412452,-1.0967706,0.60488561,1.5088905,1.8811278,1.6684207,1.2430067,0.44535533,-0.033235483,0.07311803,0.07311803,-0.033235483,0.019941274,0.28582506,0.28582506,0.07311803,0.71123912,-0.08641224:2
-1.1447578,-1.3366166,-1.4709178,-1.5860331,-1.6435908,-1.4133601,-1.0680142,-0.16627766,0.65871536,0.94650363,0.96568951,0.81220244,0.6203436,0.3709271,0.44767064,0.6203436,0.77383067,1.1383625,1.1767342,1.0040613,0.67790125,0.33255533,-0.031976478,-0.68429654:1
-0.39932659,-0.79269307,-1.2933413,-1.5079049,-1.579426,-1.3648625,-1.1860596,-0.54236894,-0.75693248,0.24436403,0.7092517,0.85229406,0.78077288,0.20860344,-0.22052364,-0.22052364,-0.22052364,0.42316698,1.4244635,1.4959847,1.6747876,1.2814211,0.78077288,0.20860344:1
-0.91968282,-1.3246807,-1.5018673,-1.6031168,-1.6537416,-1.5018673,-0.94499519,-0.38812303,0.54843469,1.5356172,1.4596801,1.0546821,0.97874499,0.57374706,0.6243718,0.67499655,0.70030892,0.3712481,0.11812439,0.06749965,0.34593572,0.82687077,0.14343676,-0.18562406:2
0.087697773,-0.44968431,-0.98706638,-1.1661937,-1.3453211,-1.3005393,-0.8975027,-0.49446615,-0.8975027,-0.001865907,0.49073434,0.53551618,0.40117065,-0.001865907,-0.40490247,-0.36012063,-0.49446615,-0.49446615,0.17726145,2.0580987,2.1924442,1.8341895,0.89377089,0.62507986:1
-0.20356277,-0.62838942,-1.0532161,-1.308112,-1.43556,-1.308112,-1.0107334,-0.75583741,-0.92576807,-0.20356277,0.47615986,0.68857319,0.81602118,0.0088505532,-0.33101076,-0.41597609,-0.62838942,0.68857319,1.4107785,1.7081571,1.7506398,1.4957438,0.77353851,0.39119453:1
-1.044008,-1.3143014,-1.5575654,-1.611624,-1.6656827,-1.5035067,-1.125096,-0.15204001,0.30745867,1.1994267,1.3345734,1.2805147,1.0102214,0.57775201,0.57775201,0.57775201,0.73992802,0.38854667,0.2534,0.19934133,0.36151733,0.87507469,0.38854667,-0.097981346:2
-0.90912205,-1.3496118,-1.4964418,-1.5845397,-1.5845397,-1.4377098,-1.1440499,-0.7916581,0.089321541,0.88220321,0.99966716,1.0290331,1.1171311,0.67664129,0.85283723,0.94093519,0.99966716,0.79410525,0.50044537,0.29488346,0.35361543,0.76473925,0.35361543,-0.35116827:2
-1.1775332,-1.3717655,-1.5271513,-1.6242674,-1.6242674,-1.4494584,-0.96387767,0.18209276,0.88132896,0.99786833,1.0755612,0.90075219,0.66767345,0.43459472,0.47344118,0.37632504,0.53171086,1.056138,1.1338309,0.92017542,0.4928644,0.33747858,-0.070409192,-0.65310602:1
-0.89810684,-1.2587366,-1.4806626,-1.5916256,-1.6748478,-1.5084033,-1.0090698,-0.4542548,0.51667149,1.0992273,1.1824495,1.237931,0.93278275,0.76633825,0.7385975,0.905042,0.98826426,0.65537524,0.29474548,0.12830097,0.37796773,0.54441224,0.12830097,-0.62069931:2
-0.72938187,-1.1678542,-1.4039547,-1.5388693,-1.6063266,-1.4376833,-1.1003969,0.28247737,0.75467835,1.1931507,1.3280653,0.92332156,0.65349243,0.012648239,-0.22345225,-0.25718089,-0.12226633,0.3836633,1.4629798,1.5304371,0.82213564,0.45112058,0.14756281,-0.35836682:1
-0.98344467,-1.3189141,-1.5585351,-1.6304214,-1.6064593,-1.3668383,-1.055331,-0.48024049,0.52616786,0.64597837,0.95748573,1.0533341,0.8137131,0.57409207,0.45428155,0.47824365,0.52616786,1.1012583,1.2450309,1.1971067,0.66994048,0.35843314,-0.16873314,-0.43231628:1
-0.17613367,-0.6783762,-0.97135101,-1.3480329,-1.43174,-1.1387652,-0.92949747,-0.38540139,-0.76208329,-0.13428012,0.45166951,0.66093723,0.70279078,0.15869469,-0.25984076,-0.34354784,-0.46910848,-0.55281557,0.32610887,2.0839577,2.1258113,1.7072758,0.9120585,0.45166951:1
-1.0642386,-1.365489,-1.5591499,-1.5591499,-1.6452214,-1.4085247,-0.99968498,-0.0098623671,0.63567412,0.95844235,1.022996,0.89388871,0.63567412,0.37745952,0.37745952,0.48504894,0.42049529,0.70022776,1.3888,1.2596927,0.72174565,0.44201317,-0.03138025,-0.67691673:1
-0.78291773,-1.0867995,-1.2387404,-1.3653578,-1.4160048,-1.2134169,-1.3147109,-0.58032986,0.23002165,1.3189315,1.4202254,1.6987837,1.3442549,0.86310875,0.81246178,0.83778526,0.78713829,0.53390345,0.33131558,0.12872771,-0.58032986,-0.40306546,0.027433767,-0.3524185:2
-0.66071545,-1.0814159,-1.4373932,-1.5992011,-1.6639242,-1.5021163,-1.0490543,0.083600733,0.63374748,1.2162558,1.2486174,1.0544479,0.7308322,0.18068545,-0.14293028,-0.20765343,-0.078207134,0.6013859,1.2809789,1.3780636,1.0220863,0.50430118,-0.013483986,-0.49890758:1
-0.98924226,-1.36972,-1.5219111,-1.6233719,-1.6233719,-1.4965459,-1.1414333,-0.22828668,0.3551126,1.0653378,1.0653378,1.0146074,0.7102252,0.48193853,0.48193853,0.76095557,0.76095557,0.50730371,0.55803408,1.2936245,0.83705112,0.50730371,0.050730361,-0.45657336:1
-0.97087183,-1.2603243,-1.5208315,-1.6655577,-1.6655577,-1.5497767,-1.2024338,-0.18935015,0.62111675,0.79478824,1.2289669,1.1131859,0.96845972,0.56322625,0.5921715,0.70795249,0.85267873,0.62111675,0.38955478,0.2158833,0.91056922,0.67900724,0.2158833,-0.44985737:2
-0.96404552,-1.2411365,-1.5736456,-1.6567728,-1.6844819,-1.3796819,-1.0471728,-0.46528185,0.69850005,1.2249728,1.2249728,1.3358092,0.97559098,0.53224549,0.69850005,0.78162733,0.83704552,0.39370003,0.25515456,0.17202729,-0.077354553,0.69850005,0.42140912,-0.16048183:2
-1.1180706,-1.4317926,-1.5991111,-1.6200259,-1.6409407,-1.2644742,-1.0553262,-0.0095859435,0.59694335,1.2034727,1.0779839,1.0570691,0.78517658,0.47145453,0.42962492,0.55511375,0.65968777,0.45053973,0.78517658,1.1616431,0.76426178,0.42962492,-0.13507477,-0.55337084:1
-0.9850985,-1.3390261,-1.5513827,-1.598573,-1.6929537,-1.4805972,-1.0794792,0.053089139,0.73734918,1.1856575,1.0912768,1.0204913,0.73734918,0.43061192,0.40701675,0.43061192,0.40701675,0.33623123,0.73734918,1.3272285,0.85532505,0.45420709,0.029493965,-0.51319503:1
-0.98741278,-1.3241043,-1.5830978,-1.6348965,-1.5830978,-1.4795004,-1.0392115,-0.39172771,0.5147496,0.95503857,1.058636,0.87734052,0.74784376,0.4111522,0.43705155,0.5147496,0.61834701,0.30755479,0.30755479,1.4212269,1.2140321,0.82554182,0.17805803,-0.36582835:1
-0.65754763,-1.0757758,-1.3545945,-1.4940039,-1.4940039,-1.4382402,-1.6612952,-0.54602011,0.62501875,1.1826563,1.3499476,1.2663019,0.98748316,0.68078251,0.8201919,0.98748316,0.93171941,0.68078251,0.40196373,0.20679059,-0.15567382,-0.18355569,0.17890871,-0.23931945:2
-0.99642917,-1.3424233,-1.5459492,-1.5663018,-1.5866544,-1.4441862,-1.0574869,-0.039857174,0.57072069,0.9981252,1.2423563,1.1405934,0.79459924,0.50966291,0.40789993,0.50966291,0.57072069,0.77424665,1.1202408,1.0184778,0.61142588,0.24507917,-0.28408832,-0.65043504:1
-0.77132521,-1.1467596,-1.4066758,-1.4644349,-1.4644349,-1.3777962,-1.4066758,-0.82908435,0.38385762,1.2502448,1.2502448,1.3368835,1.0480878,0.75929203,0.84593075,0.93256946,0.99032859,0.70153289,0.44161676,0.26833934,-0.19373379,-0.19373379,0.26833934,-0.22261336:2
-1.1362322,-1.3898119,-1.5458609,-1.6043793,-1.5653671,-1.4288242,-1.0582076,-0.063394926,0.67783808,0.95092392,1.0874668,0.93141779,0.814381,0.52178902,0.50228289,0.52178902,0.59981355,0.67783808,1.106973,1.1264791,0.67783808,0.34623384,-0.10240719,-0.64857888:1
0.14222256,-0.058562231,-0.46013181,-0.92862963,-0.92862963,-0.92862963,-2.3341232,-1.6648405,-1.263271,-0.32627528,0.61072038,0.7445769,1.4138596,0.4099356,0.27607908,0.00836603,0.20915082,-0.12549049,0.27607908,0.27607908,0.4099356,0.94536169,2.0831422,1.2130748:2
-0.76270124,-1.1310647,-1.4144212,-1.4994282,-1.4994282,-1.3860856,-1.4427569,-0.36600215,0.59740996,1.2774656,1.5041508,1.4474795,1.1074517,0.73908821,0.68241691,0.79575951,0.73908821,0.512403,0.48406735,0.22904651,-0.054309996,-0.082645645,-0.054309996,-0.42267345:2
-0.75835079,-1.2045958,-1.3958436,-1.5552168,-1.5870915,-1.4277183,-1.4277183,-0.79022543,0.38913623,1.0903783,1.2816262,1.2178769,0.96287974,0.77163191,0.83538118,0.89913046,0.89913046,0.70788263,0.51663479,0.35726159,0.038515197,-0.18460727,0.38913623,-0.025234082:2
-0.75093269,-1.0846806,-1.4740531,-1.5018654,-1.5853024,-1.4462407,-1.5296777,-0.75093269,0.52843412,1.1681175,1.2515545,1.2515545,0.97343127,0.69530805,0.77874502,0.80655734,0.91780663,0.69530805,0.52843412,0.36156019,0.083436971,5.0798611E-9,0.27812322,-0.19468625:2
-0.53448564,-1.2145059,-1.430876,-1.5545161,-1.6163361,-1.461786,-1.0599559,-0.16356548,0.60918484,1.2582951,1.3510251,1.1964751,0.79464491,0.20735467,-0.10174546,-0.039925429,0.021894596,1.011015,1.1346551,1.2892051,0.70191488,0.36190473,-0.16356548,-0.59630567:1
0.09852253,-0.19704506,-0.78818025,-0.88670278,-1.1822704,-1.0837478,-0.73891898,-0.59113519,-0.34482886,-1.0344866,-0.64039645,-0.049261268,0.19704506,-1.1805555E-9,-0.64039645,-0.68965772,-0.54187392,0.09852253,1.7734056,1.9704506,1.9704506,1.7241443,1.0344866,0.54187392:1
-0.84458128,-1.3089871,-1.609485,-1.691439,-1.636803,-1.4455771,-0.95385324,-0.29822141,0.60327233,1.4774481,1.3408581,1.2315861,0.6852263,0.41204638,0.6852263,0.63059032,0.82181626,0.38472839,0.22082044,0.19350244,0.46668237,0.79449827,0.24813843,-0.40749339:2
-1.0471647,-1.3838418,-1.5620826,-1.6214962,-1.6214962,-1.4234509,-1.0471647,-0.1559607,0.67582971,0.99270227,1.2105521,1.0719204,0.79465692,0.43817531,0.41837078,0.51739344,0.51739344,0.37876171,1.2105521,1.0323113,0.73524332,0.37876171,-0.076742565,-0.43322418:1
-1.10434,-1.4081126,-1.5853133,-1.6612564,-1.635942,-1.5093701,-1.0537112,-0.16770779,0.71829564,1.0473826,0.87018194,0.97143947,0.87018194,0.59172372,0.6170381,0.74361002,0.74361002,0.51578057,0.33857988,0.49046618,1.1486402,0.66766687,0.13606481,-0.34490848:2
0.1586937,-0.46312653,-1.0072192,-1.3181293,-1.4735844,-1.3181293,-1.0849467,-1.4735844,-0.46312653,1.091424,1.7909718,1.4023342,0.39187629,0.31414876,-0.15221641,-0.22994394,0.0032386407,-0.22994394,-0.074488888,0.080966169,0.31414876,2.0241544,1.091424,0.62505887:2
-0.070338753,-0.36824405,-0.91440376,-1.3116108,-1.659167,-1.4109126,-0.96405464,-0.56684758,-0.2192914,-0.26894228,0.22756655,1.1709333,1.2205842,-0.02068787,-0.91440376,-0.81510199,-0.61649846,1.0219807,1.2702351,1.4688386,1.5681404,1.2205842,0.77372626,0.17791566:1
0.09385423,-0.85456735,-1.0916728,-1.5066072,-1.5658836,-1.5066072,-1.0916728,-1.0323964,0.44951232,1.4572102,1.8128683,1.753592,1.3979339,0.44951232,-0.083974817,0.09385423,-0.024698468,-0.20252752,0.09385423,-0.20252752,0.09385423,0.74589407,0.50878867,0.21240693:2
-0.48777414,-1.1205622,-1.4369562,-1.5635138,-1.5318744,-1.500235,-1.6900715,-0.36121652,0.36648975,0.8094414,1.2840324,1.4105901,1.094196,0.8727202,0.8410808,0.96763841,0.8094414,0.61960498,0.33485035,0.20829274,-0.10810129,0.018456314,0.36648975,-0.2030195:2
-0.92914205,-1.3199027,-1.5283084,-1.6064605,-1.6325113,-1.476207,-1.0593956,-0.40812781,0.68600207,1.1549149,1.1549149,0.9725599,0.71205278,0.45154567,0.50364709,0.5296978,0.63390065,0.21708926,0.21708926,1.3893713,0.9725599,0.65995136,0.13893713,-0.43417853:1
0.18920959,-0.51717286,-0.92081996,-1.1226435,-1.3244671,-1.1226435,-0.61808463,-1.829026,-0.81990819,0.5928567,0.79468025,0.79468025,0.9965038,0.29012137,-0.41626108,-0.3153493,-0.012613966,-0.21443753,0.088297811,0.18920959,0.29012137,2.5101804,1.803798,0.69376847:2
-0.87998623,-1.3452911,-1.5262429,-1.629644,-1.629644,-1.5262429,-1.1901894,-0.23372951,0.49007801,1.0846342,1.2914363,1.1104844,0.77443096,0.51592827,0.51592827,0.56762881,0.59347908,0.56762881,0.33497639,1.1880353,0.87783203,0.38667693,-0.052777635,-0.28543005:1
-0.85478823,-1.1668022,-1.4008127,-1.5568196,-1.5828208,-1.5048173,-1.5308185,-0.3867673,0.49727224,1.1473013,1.2773071,1.3033083,1.0432967,0.60127689,0.57527573,0.83528736,0.75728387,0.73128271,0.18525829,0.34126526,0.029251313,0.75728387,0.1072548,-0.20475916:2
-1.030172,-1.3640165,-1.5211197,-1.5603956,-1.6193093,-1.4032923,-0.99089616,-0.20537979,0.77651567,1.0907222,1.0710843,0.97289476,0.75687776,0.44267122,0.44267122,0.56049867,0.54086077,0.63905031,1.2674634,1.129998,0.6194124,0.32484376,-0.34284516,-0.59813798:1
-0.70702693,-1.0990419,-1.4630557,-1.5470589,-1.5470589,-1.4070536,-1.6030611,-0.42701626,0.74902853,1.2250467,1.2810488,1.1690445,1.0290392,0.74902853,0.80503066,0.91703493,0.88903386,0.6090232,0.32901253,0.32901253,-0.0630024,-0.2310088,0.105004,-0.091003466:2
-0.45872933,-0.97079927,-1.3365635,-1.556022,-1.556022,-1.3731399,-1.0805285,0.16306989,0.7848691,1.5163976,1.4798212,1.1506333,0.74829267,0.12649347,-0.27584721,-0.27584721,-0.45872933,-0.4221529,-0.05638866,1.4066683,1.296939,0.89459837,0.34595201,-0.092965085:1
-0.055424489,-0.65171553,-1.202138,-1.3856122,-1.3397437,-1.3397437,-0.97279531,-0.55997845,-0.42237282,0.35739239,0.67847217,0.81607779,0.31152385,-0.0095559481,-0.37650428,-0.46824136,-0.65171553,-0.46824136,1.595843,1.9627914,1.4582374,1.5499745,0.90781487,0.2656553:1
-0.98366717,-1.2358481,-1.526826,-1.6044202,-1.5850216,-1.4104348,-1.0612613,-0.1883274,0.9367874,1.03378,1.0919756,0.8785918,0.66520796,0.35483146,0.23844028,0.49062118,0.52941824,1.2471639,1.2471639,1.03378,0.47122265,0.21904174,-0.22712447,-0.61509508:1
-1.1093835,-1.3704149,-1.5109703,-1.5712083,-1.551129,-1.4507323,-1.1495422,-0.22589255,0.35640827,1.0792645,1.0190265,0.85839173,0.67767769,0.41664629,0.43672563,0.53712232,0.71783637,0.93870909,1.1997405,1.1194232,0.71783637,0.41664629,-0.0050198273,-0.54716197:1
-0.91427609,-1.1792836,-1.3912897,-1.5237935,-1.6297965,-1.5237935,-1.2322852,-0.56976626,0.54326551,1.2057844,1.1262821,1.1262821,0.86127458,0.96727761,0.9142761,0.86127458,0.56976627,0.35776022,0.22525644,0.51676475,0.70227005,0.70227005,-0.092752642,-0.62276777:2
1.0743441,0.49274425,0.10501105,0.0080777627,-0.18578883,-0.28272213,0.0080777627,-1.6397883,-1.0581885,-0.67045532,-0.18578883,-0.088855535,-0.28272213,-0.37965542,-0.67045532,-0.86432192,-0.67045532,-0.57352202,-0.47658872,-0.088855535,-0.088855535,2.4314103,2.5283436,1.5590106:2
-0.9710612,-1.3396391,-1.5664563,-1.6515128,-1.7082171,-1.5664563,-1.0277655,-0.23390527,0.44654638,1.126998,1.126998,1.1837023,0.98523726,0.58830714,0.50325068,0.70171574,0.70171574,0.41819423,0.36148993,0.44654638,0.95688511,0.64501144,0.10632057,-0.23390527:1
-1.0093415,-1.3310111,-1.5042178,-1.6526807,-1.5289616,-1.4299864,-1.0588291,-0.3660023,0.64849419,1.1681143,1.1681143,0.99490763,0.82170092,0.42579984,0.47528747,0.45054365,0.54951892,0.22784931,0.27733694,1.4402963,1.0196514,0.62375038,0.05464259,-0.46497757:1
-1.0517361,-1.3405424,-1.5523336,-1.5908411,-1.6293486,-1.4560649,-1.0324824,-0.22382485,0.46931016,0.95065391,0.87363891,0.79662392,0.66184767,0.46931016,0.45005641,0.58483267,0.68110142,1.2009527,1.3164752,1.1239377,0.58483267,0.25751891,-0.069794846,-0.4741236:1
-0.79559579,-1.0977207,-1.3092082,-1.3998457,-1.4904832,-1.3998457,-1.3696332,-0.82580828,0.14099163,1.0775791,1.2588541,1.2890666,1.0171541,0.71502909,0.89630407,1.1984291,1.1380041,0.92651657,0.44311661,0.14099163,-0.22155833,-0.28198333,0.11077914,-0.16113334:2
-0.84235122,-1.0613017,-1.3532358,-1.5721863,-1.6451698,-1.5721863,-0.91533473,-1.1342852,-0.18549973,0.98223628,1.2011868,0.98223628,1.0552198,0.76328578,0.61731878,0.61731878,0.76328578,0.61731878,0.32538478,0.17941777,-0.33146673,1.2741703,0.83626929,0.39836828:2
-0.84185725,-1.3353204,-1.5546373,-1.6917104,-1.7465397,-1.3079058,-1.006345,-0.51288183,0.63853217,1.3238976,1.1868245,1.1045807,0.80301989,0.41921521,0.52887369,0.50145907,0.50145907,0.30955674,0.22731288,0.88526374,1.1045807,0.72077603,0.090239791,-0.34839411:1
-0.97617124,-1.0813479,-1.2654072,-1.3705839,-1.396878,-1.2917013,-1.2654072,-0.71322949,0.39112585,1.1273627,1.4165987,1.2325394,1.0484802,0.75924431,1.1799511,0.91700936,0.91700936,0.78553848,0.83812683,0.18077245,-0.37140522,-0.39769939,-0.10846347,-0.55546444:2
-1.0738356,-1.3535865,-1.5284308,-1.5808841,-1.615853,-1.4584931,-1.0038979,-0.12967621,0.81448316,0.91938976,1.0068119,0.8844209,0.8844209,0.58718554,0.5697011,0.76202987,0.6746077,1.0242964,1.0068119,0.8844209,0.44731007,0.16755915,-0.16464508,-0.72414693:1
-0.88051755,-1.2612819,-1.4788615,-1.6420462,-1.6692437,-1.3972692,-1.0708997,-0.064593959,0.72413219,1.3768711,1.4584634,1.2680813,1.0233042,0.75132965,0.66973729,0.75132965,0.72413219,0.42496021,0.28897294,0.071393308,0.016998401,0.28897294,0.071393308,-0.4453583:2
-0.67757153,-1.2151489,-1.3495433,-1.5287358,-1.6631301,-1.3943414,-0.99115835,-0.90156212,-0.050397889,1.0695551,1.5623344,1.42794,1.2487475,0.80076635,0.71117012,0.62157388,0.80076635,0.26318894,0.30798706,0.12879459,0.17359271,0.89036259,-0.050397889,-0.18479224:2
-0.80157412,-1.1825203,-1.4818351,-1.5362559,-1.5906768,-1.2641516,-1.3457829,-0.39341756,1.1031565,1.3480504,1.3752608,1.2936295,0.91268343,0.66778949,0.64057905,0.72221037,0.77663124,0.34126424,0.17800162,-0.36620712,0.014738995,0.58615818,0.36847468,-0.36620712:2
0.94223181,0.011085078,-0.3879778,-0.92006165,-0.92006165,-0.65401973,-0.25495684,-1.8512084,-0.92006165,0.011085078,0.67618989,0.011085078,0.14410604,0.011085078,-0.52099877,-0.52099877,-0.52099877,-0.3879778,-0.3879778,-0.25495684,0.54316893,2.8045253,1.8733785,1.4743157:2
-0.27346215,-0.86120171,-1.2530281,-1.399963,-1.6448545,-1.6938328,-1.0571149,-0.077548963,0.41223401,1.4897565,1.4897565,1.1958868,0.95099528,-0.27346215,-0.077548963,-0.12652726,-0.12652726,-0.32244044,-0.22448385,0.21632082,1.5877131,1.2938433,0.70610379,0.069385928:2
-0.85276421,-1.2857615,-1.4589605,-1.6610259,-1.54556,-1.372361,-1.314628,-0.21770144,0.79262569,1.3122225,1.3699555,1.283356,0.96582462,0.67715973,0.7637592,0.73489271,0.64829324,0.35962835,0.070963448,0.2152959,0.013230468,0.67715973,0.24416239,-0.41976687:2
-0.041465856,-0.63857386,-1.1361638,-1.3351998,-1.5342358,-1.3351998,-1.7830308,-1.0864048,0.45612415,1.7000992,1.7996172,1.5010632,1.2025092,0.45612415,0.0082931442,0.15757015,0.0082931442,0.0082931442,0.058052145,0.25708815,0.058052145,0.20732915,0.75467816,0.25708815:2
-0.73112666,-1.3102368,-1.4550144,-1.5418809,-1.5129254,-1.4550144,-1.2233703,-0.93381523,0.10858316,1.122026,1.2088926,1.179937,1.0930705,0.65873786,0.77455991,0.91933746,0.97724848,0.54291582,0.31127174,0.16649418,0.68769337,0.57187133,0.13753867,-0.29679398:2
-0.4668821,-1.0055923,-1.3647324,-1.4724744,-1.6520444,-1.4724744,-1.0415063,-0.14365604,0.32322608,1.3647324,1.5083884,1.1851623,0.68236616,0.071828022,-0.21548405,-0.10774203,-0.17957005,-0.071828013,1.1492483,1.5083884,1.1133343,0.68236616,0.071828022,-0.4668821:1
-1.0120017,-1.3305334,-1.5428878,-1.6225207,-1.7817866,-1.4632549,-0.79964721,-0.37493831,0.76646684,1.2442644,1.4300745,1.1380871,0.92573268,0.47447948,0.55411239,0.76646684,0.66028962,0.47447948,0.26212502,0.1559478,0.049770581,0.84609976,0.36830225,-0.18912817:2
-0.7631223,-1.2040919,-1.4098776,-1.5568675,-1.4686736,-1.4686736,-1.5274695,-0.49854057,0.67737822,1.2359397,1.2359397,1.4417254,0.58918431,0.58918431,0.76557213,1.0007559,0.88316401,0.67737822,0.55978634,0.32460258,0.0012249152,-0.057571024,0.23640867,-0.26335681:2
-0.87403563,-1.2174068,-1.4671313,-1.4671313,-1.4671313,-1.4359157,-1.1237601,-0.59309561,0.53066449,1.2174068,1.2486224,1.2174068,0.96768231,0.7491734,0.81160452,0.9052512,1.0925446,0.93646675,0.49944893,0.28094003,-0.031215558,-0.28094003,0.093646675,-0.59309561:2
-0.84553671,-1.1782069,-1.3294206,-1.4806343,-1.5108771,-1.3294206,-1.2084496,-0.48262378,0.3339303,1.2412126,1.3924263,1.3319408,1.3319408,0.84805694,0.84805694,0.96902792,0.8178142,0.75732871,0.3339303,0.031502863,-0.27092458,-0.33141006,0.09198835,-0.36165281:2
-1.014919,-1.4683265,-1.5438944,-1.6194623,-1.594273,-1.3675692,-1.1912441,0.017842429,0.6223857,1.0002252,1.226929,1.2017397,1.0254145,0.49643918,0.44606058,0.59719639,0.647575,0.47124988,0.47124988,0.84908943,0.82390012,0.34530336,0.16897824,-0.61189015:1
0.96975094,0.24449812,-0.15109433,-0.61261886,-0.74448301,-0.74448301,-1.7334642,-1.6675321,-0.94227924,0.24449812,0.70602264,0.77195472,0.83788679,0.24449812,-0.21702641,-0.41482263,-0.61261886,-0.61261886,-0.61261886,-0.21702641,0.24449812,0.50822642,2.3543245,2.1565283:2
-1.0988751,-1.3406277,-1.5823802,-1.6043577,-1.6043577,-1.4944702,-0.94503262,0.15384252,0.79119009,1.2307402,1.2527177,0.94503261,0.8571226,0.48350505,0.54943756,0.54943756,0.57141506,0.48350505,0.54943756,1.0329426,0.70328008,0.37361755,-0.21977503,-0.63734758:1
-0.90782832,-1.2404677,-1.4345073,-1.5176672,-1.5176672,-1.3790674,-1.3236276,-0.71378868,0.53360901,1.2543277,1.3097676,1.3097676,1.0048481,0.69992871,0.7553686,0.92168829,0.92168829,0.58904891,0.47816912,0.28412947,-0.076229863,-0.076229863,0.25640953,-0.13166976:2
-0.4957083,-1.0300047,-1.4574418,-1.5286813,-1.5999208,-1.4930615,-1.0656244,0.038588065,0.53726468,1.2140401,1.4633784,1.1428006,0.64412395,0.14544735,-0.24636999,-0.13951072,-0.17513048,-0.068271209,0.60850419,1.677097,1.2852796,0.75098323,0.14544735,-0.35322927:1
-1.024161,-1.3848137,-1.5512687,-1.6067538,-1.6622388,-1.5512687,-1.1351311,-0.05317314,0.69587465,1.0842698,1.1952398,1.0565273,0.91781474,0.52941958,0.52941958,0.75135967,0.69587465,0.41844954,0.25199447,0.50167707,0.86232971,0.69587465,0.19650945,-0.41382579:2
-0.52578483,-1.0824981,-1.3422977,-1.6763257,-1.6020972,-1.6020972,-1.0824981,-0.34021372,0.21649963,0.36495651,0.84744142,0.84744142,0.6618703,0.25361385,-0.19175683,-0.043299932,0.030928513,0.58764186,1.5897258,1.7752969,1.1814694,0.92166986,0.29072807,-0.080414155:1
-0.26700407,-0.73381912,-1.073321,-1.2006342,-1.2855097,-1.2006342,-0.90357005,-0.52163047,-0.86113232,-0.09725313,0.45443739,0.32712419,0.36956192,-0.054815397,-0.3094418,-0.47919273,-0.47919273,-0.13969087,1.5153807,2.1519467,1.8124448,1.5153807,1.0910034,0.36956192:1
-0.98300119,-1.3098429,-1.5772588,-1.6961103,-1.6663974,-1.3692686,-1.1018527,-0.21046624,0.38379139,0.97804902,1.245465,1.1860392,0.85919749,0.56206868,0.74034597,0.74034597,0.85919749,0.44321715,0.2055141,0.23522698,1.0969005,0.71063309,-0.032188961,-0.29960489:2
-0.90650699,-1.2468016,-1.3829195,-1.4509784,-1.5417236,-1.3829195,-1.4509784,-0.54352608,0.54541663,1.0672017,1.3621237,1.2486921,1.089888,0.794966,0.70422078,0.794966,1.0445154,0.84033861,0.38661248,0.25049464,0.046317881,-0.021741039,0.069004186,-0.31666302:2
-1.0853308,-1.403445,-1.497008,-1.590571,-1.5718584,-1.4408702,-1.0666182,-0.22455117,0.50524018,1.029193,1.1601812,1.0104804,0.89820474,0.54266537,0.52395278,0.67365356,0.61751576,0.63622836,1.0853308,1.0104804,0.61751576,0.28068899,-0.093562981,-0.61751574:1
-0.93176376,-1.2460937,-1.4706151,-1.6053279,-1.6502322,-1.4706151,-1.0215723,-1.1562852,0.011226064,0.72969451,0.95421589,1.0440245,0.99912017,0.63988596,0.72969451,0.77459879,0.77459879,0.99912017,0.5500774,0.28065174,0.32555601,1.0440245,0.5500774,0.1459389:2
-0.92450564,-1.3374362,-1.447551,-1.6402519,-1.6402519,-1.447551,-1.1172066,-0.29134545,0.75474529,1.4154342,1.3879055,1.2227333,0.91991751,0.58957306,0.50698695,0.75474529,0.61710177,0.34181473,0.25922862,0.17664251,0.25922862,0.78227399,0.20417121,-0.34640286:2
-1.0252622,-1.296406,-1.4997638,-1.6127403,-1.590145,-1.4545732,-1.0704529,-0.076259179,0.60160016,1.1890783,1.1438876,0.98572045,0.75976734,0.33045643,0.35305174,0.35305174,0.35305174,0.46602829,1.2568642,1.2568642,0.78236265,0.46602829,-0.14404511,-0.5281654:1
-0.86321448,-1.1502279,-1.3328727,-1.385057,-1.4372412,-1.4111491,-1.5155176,-0.49792472,0.59794454,1.2763398,1.3807083,1.0676028,0.80668154,0.67622091,0.67622091,0.96323429,1.4068004,0.78058941,0.46748391,0.23265478,-0.2630956,-0.2630956,0.10219416,-0.31527985:2
-1.1696835,-1.3484886,-1.4602418,-1.5272938,-1.5496444,-1.4602418,-1.013229,-0.11920343,0.48426388,1.0877312,1.1100818,0.97597799,0.75247156,0.41721195,0.30545875,0.48426388,0.48426388,0.84187412,1.4006401,1.1771337,0.59601708,0.30545875,-0.208606,-0.56621624:1
0.96291757,-0.0080917443,-0.52596338,-0.91436711,-0.97910106,-0.84963315,-0.84963315,-1.5617067,-1.1733029,-0.52596338,0.25084407,0.44504594,0.38031198,-0.20229361,-0.20229361,-0.13755965,-0.33176152,-0.46122943,-0.33176152,-0.0080917443,1.0923855,2.5165325,1.9986608,1.4160553:2
-1.0454234,-1.2125054,-1.5745166,-1.6859047,-1.7415987,-1.4631286,-0.87834129,-0.15431888,0.82032665,0.90386771,0.98740875,0.90386771,0.82032665,0.29123337,0.12415128,0.29123337,0.5418565,0.70893859,1.3494199,1.2658789,0.70893859,0.37477441,0.040610227,-0.377095:1
-0.67412478,-1.208735,-1.4619715,-1.5463836,-1.6307958,-1.4901089,-1.0399107,-0.19578928,1.0141181,1.2673546,1.2673546,1.0703929,0.53578265,0.25440883,-0.19578928,-0.25206405,-0.055102367,0.98598076,1.0422555,1.2110798,0.87343123,0.50764527,0.11372192,-0.39275096:1
-1.0326199,-1.3239547,-1.5376002,-1.6347118,-1.5570225,-1.401644,-1.0714646,-0.25572719,0.67654409,1.0844128,1.0455681,1.0067235,0.85134496,0.50174323,0.40463164,0.54058787,0.77365569,0.56001018,1.1426797,1.0649905,0.63769946,0.32694236,-0.10034865,-0.70244052:1
-1.0106619,-1.3159419,-1.5379637,-1.7322328,-1.5934692,-1.4547055,-0.92740365,0.099447279,0.79326546,1.3760728,1.4870837,1.1818037,1.0707928,0.5157382,0.65450184,0.59899639,0.54349093,0.34922183,0.071694551,0.071694551,0.26596365,0.62674911,0.18270546,-0.31684364:2
-0.70617457,-1.0886858,-1.3240773,-1.500621,-1.500621,-1.4123491,-1.471197,-1.0298379,0.29423941,1.0886858,1.1769576,1.2946534,1.1181097,0.76502245,0.88271822,0.9415661,1.0298379,0.73559851,0.52963093,0.23539152,-0.088271822,-0.11769576,0.20596758,-0.058847881:2
0.12399703,-0.43668521,-0.73859104,-1.0404968,-1.0404968,-1.0836262,-0.69546163,-1.0404968,-0.69546163,0.16712644,0.64154986,0.94345569,0.16712644,-0.1779088,-0.52294402,-0.65233223,-0.65233223,-0.73859104,-0.39355581,1.7197849,2.2373378,1.8060437,1.3747497,0.72780868:1
1.3042447,0.76188548,-0.090393198,-0.24535296,-0.4777926,-0.55527249,-0.55527249,-1.6399908,-1.0201518,-0.32283284,-0.24535296,0.37448609,0.29700621,-0.4777926,-0.55527249,-0.78771213,-0.63275237,-0.63275237,-0.78771213,0.064566563,0.29700621,1.071805,2.6214027,2.2340033:2
-0.27108698,-0.7828017,-1.2579654,-1.3676186,-1.5138228,-1.5138228,-1.1848633,-0.67314855,-1.0386591,-0.12488276,0.38683198,0.6792404,0.93509777,0.35028092,0.16752566,-0.051780655,-0.051780655,0.24062777,1.3371594,1.6661188,1.6295678,1.3006083,0.75234251,0.38683198:1
1.1182896,0.36226283,-0.015750558,-0.46936663,-0.46936663,-0.46936663,-1.9058175,-1.6790095,-0.77177734,-0.015750558,0.43786551,0.66467355,0.58907087,0.05985212,-0.46936663,-0.46936663,-0.39376395,-0.54496931,-0.62057198,-0.54496931,0.28666015,0.74027622,2.6303432,1.9499191:2
-1.1572999,-1.3376584,-1.4922513,-1.5953133,-1.5953133,-1.4922513,-1.105769,-0.35856974,0.49169144,1.0842977,1.0585322,0.98123576,0.72358085,0.46592595,0.54322242,0.64628438,0.62051889,0.41439497,0.36286399,1.4707801,0.85240831,0.5947534,0.10520909,-0.28127327:1
-1.0674414,-1.3016479,-1.4998227,-1.5899022,-1.5538704,-1.4637909,-1.1034732,-0.31077407,0.77017923,0.968354,1.0584334,0.98636989,0.87827456,0.53597268,0.57200446,0.69811568,0.84224278,0.98636989,1.0404176,0.84224278,0.33779791,0.1936708,-0.23871052,-0.5810124:1
-0.96468249,-1.3032438,-1.5376323,-1.6678482,-1.6678482,-1.5376323,-1.1730279,0.024958044,0.59790782,0.98855541,1.0406418,0.88438272,0.88438272,0.41560563,0.67603734,0.46769197,0.54582149,0.28538976,0.41560563,1.3271167,0.88438272,0.75416686,0.10308756,-0.44381904:1
-1.1109045,-1.3682569,-1.4711978,-1.6256092,-1.6770797,-1.5226683,-1.1366397,-0.15870064,0.40747461,0.92217939,0.84497367,0.81923843,0.51041557,0.38173937,0.43320985,0.61335652,0.74203271,0.51041557,0.30453366,1.3854137,1.1795318,0.89644415,0.40747461,-0.28737683:1
-0.8575738,-1.2819402,-1.5471693,-1.5471693,-1.5736922,-1.6797838,-1.0432341,-0.40668447,0.70727737,1.343827,1.3968728,1.2377354,0.89293769,0.65423157,0.46857126,0.62770867,0.60118577,0.38900256,0.28291095,0.15029644,-0.0088409588,0.91946059,0.41552546,-0.14145546:2
-0.71317264,-0.97707793,-1.3163847,-1.429487,-1.4671877,-1.3917862,-0.97707793,-0.86397566,0.19164551,1.2849674,1.4734712,1.4734712,1.2095659,0.87025912,0.83255836,0.98336139,0.98336139,0.68175533,0.26704702,0.0031417277,-0.48696811,-0.48696811,0.116244,-0.26076356:2
-1.0206877,-1.2981561,-1.4765287,-1.5756246,-1.5756246,-1.4567096,-1.2386986,-0.26755892,0.38647396,0.74321917,0.96123012,0.96123012,0.76303835,0.56484657,0.50538902,0.68376163,0.92159177,1.278337,1.0999644,0.9810493,0.52520821,0.20810136,-0.22792056,-0.44593152:1
-1.0311189,-1.3056147,-1.5589955,-1.5589955,-1.6434557,-1.4534202,-1.052234,-0.038710948,0.57362587,1.0803874,1.1015024,1.0381573,0.67920118,0.36247525,0.34136018,0.4469355,0.48916562,0.4469355,1.3126531,1.2070778,0.76366142,0.46805056,-0.10205614,-0.56658751:1
-1.111803,-1.3635319,-1.5145693,-1.5816971,-1.5649151,-1.4810055,-1.0111114,-0.35661605,0.71742758,0.90202882,1.0027204,0.93559269,0.86846496,0.53282633,0.56639019,0.76777337,0.76777337,1.0530662,1.0362843,0.86846496,0.48248053,0.21396963,-0.15523287,-0.57478116:1
-0.96316155,-1.3153681,-1.4636656,-1.4636656,-1.5192772,-1.5192772,-1.4822028,-0.14752516,0.46420214,0.85348314,0.85348314,0.9276319,0.87202033,0.63103685,0.61249966,0.64957404,0.59396247,1.1871526,1.0944666,1.038855,0.51981371,0.29736743,-0.16606235,-0.55534336:1
-0.78223724,-1.1810714,-1.4089766,-1.5229293,-1.5514174,-1.4374648,-1.4944411,-0.69677278,0.38577709,0.98402834,1.2689099,1.3543743,0.92705203,0.55670602,0.7561231,0.95554019,1.0410046,0.72763494,0.61368233,0.47124155,0.1293837,0.043919243,0.072407397,-0.21247415:2
-1.011718,-1.3136608,-1.5904417,-1.6407655,-1.6407655,-1.4897941,-1.011718,0.070243623,0.62380542,1.227691,1.1773672,1.1270434,0.90058634,0.39734833,0.47283403,0.47283403,0.42251023,0.29670073,0.29670073,1.3283386,0.82510063,0.47283403,-0.13105158,-0.28202298:1
-0.99783559,-1.3280196,-1.4834004,-1.5805133,-1.5999359,-1.4834004,-1.1726389,-0.10439641,0.45885871,1.0026912,1.0415364,1.0026912,0.80846534,0.42001353,0.45885871,0.55597167,0.61423944,1.1969171,1.1386494,0.98326866,0.53654908,0.20636504,-0.10439641,-0.5705386:1
-0.80532083,-1.2261416,-1.5267279,-1.6169038,-1.6469625,-1.4064934,-1.0758485,-0.62496905,0.69761072,1.3589006,1.4490765,1.328842,0.90802113,0.36696577,0.66755209,0.75772798,0.5773762,0.4872003,0.21667262,0.27678988,0.42708303,0.66755209,0.12649673,-0.3845:2
-0.6519161,-1.2157354,-1.4976451,-1.6385999,-1.4976451,-1.4271677,-0.93382576,-0.93382576,0.052858064,0.96906448,1.2509741,1.2509741,1.2509741,0.82810965,0.54619999,0.54619999,0.47572256,0.40524514,-0.08809677,0.052858064,-0.29952902,1.391929,0.82810965,0.33476773:2
0.27846704,-0.14925833,-0.63044937,-1.0581748,-1.2185718,-1.0581748,-0.84431206,-1.4859001,-0.79084639,0.1715357,0.70619242,0.81312376,0.75965809,0.1715357,-0.41658668,-0.41658668,-0.5769837,-0.5769837,-0.25618967,-0.095792656,0.9200551,2.4170939,1.8824372,1.4547118:2
-0.52194177,-0.86798052,-1.3178309,-1.5254541,-1.560058,-1.3524348,-1.1794154,-0.79877277,-0.10669528,0.13553184,0.65458996,0.79300546,0.58538221,0.20473959,-0.24511078,-0.17590303,-0.10669528,0.44696671,1.4504791,1.6927062,1.6234984,1.2428558,0.82760933,0.10092797:1
-1.0001648,-1.314902,-1.5876742,-1.6086567,-1.6086567,-1.3988319,-0.97918235,-0.20283064,0.76236338,1.182013,1.2659429,0.99317065,0.74138091,0.34271381,0.36369629,0.40566125,0.46860868,0.48959116,1.140048,1.0980831,0.76236338,0.40566125,-0.11890072,-0.60149773:1
-0.80401955,-1.1367173,-1.3862406,-1.5803143,-1.6634887,-1.4416902,-1.5803143,-0.58222105,0.47132181,1.025818,1.2753413,1.2476165,0.97036843,0.6653955,0.77629474,0.85946918,0.9149188,0.69312031,0.33269775,0.16634888,0.083174445,0.24952332,0.49904662,-0.055449617:2
-0.45089472,-1.0605552,-1.4796968,-1.5559043,-1.5559043,-1.3653854,-0.94624385,-0.10796071,0.4254922,1.1875678,1.3780867,0.95894511,0.84463377,0.19686953,-0.22227205,-0.18416827,-0.33658338,-0.14606449,0.31118086,1.7972283,1.4542942,0.95894511,0.19686953,-0.2984796:1
-1.0152354,-1.2845836,-1.4503363,-1.5539317,-1.5539317,-1.4503363,-1.2224263,-0.20719089,0.51797724,0.97379721,1.1188308,0.93235903,0.82876359,0.51797724,0.55941542,0.64229178,0.55941542,0.66301087,1.160269,1.2638645,0.62157269,0.29006725,-0.1864718,-0.72516812:1
-1.1304725,-1.3993214,-1.6009581,-1.6009581,-1.5785541,-1.4441296,-0.95123987,-0.27911748,0.54983344,1.1099354,1.1547436,1.0875313,0.90829872,0.54983344,0.52742936,0.61704568,0.50502528,0.34819673,0.30338857,1.1771476,0.88589464,0.63944975,0.056943701,-0.43594604:1
-0.77428062,-1.1934401,-1.4728797,-1.5660262,-1.5660262,-1.519453,-1.0537202,-0.96057371,0.15718479,1.0420769,1.22837,1.2749433,0.99550366,0.85578385,0.85578385,0.90235712,0.99550366,0.6229175,0.48319768,0.017464978,-0.26197465,0.34347787,0.48319768,0.11061152:2
-1.0955341,-1.3844662,-1.5702082,-1.6114842,-1.6321222,-1.3638281,-1.0129821,-0.063633841,0.82380037,1.1540084,1.0920944,0.9476284,0.80316236,0.32848825,0.32848825,0.43167828,0.5142303,0.59678231,1.1952844,1.1127324,0.69997234,0.26657424,-0.042995836,-0.51766995:1
-0.88807831,-1.2536198,-1.5910427,-1.6753984,-1.6472798,-1.5348055,-1.1411455,0.039834649,0.79903616,1.4457634,1.3051705,1.0521033,0.77091759,0.43349469,0.51785042,0.65844329,0.65844329,0.32102039,0.20854609,0.20854609,0.43349469,0.93962903,0.29290182,-0.3538254:2
-0.79329388,-1.2663138,-1.6506426,-1.6506426,-1.6802063,-1.4436963,-0.91154887,-0.52722016,0.68489348,1.2170409,1.4535509,1.2170409,0.92140345,0.56663849,0.65532973,0.68489348,0.71445722,0.53707474,0.27100102,0.034491046,0.15274603,0.83271221,0.21187352,-0.23158269:2
-0.85547118,-1.3304886,-1.4888277,-1.6471669,-1.620777,-1.5152176,-1.1457596,-0.35406391,0.70153035,1.2557173,1.3612768,1.3348869,0.99181877,0.54319121,0.62236078,0.70153035,0.62236078,0.41124193,0.27929265,0.20012308,0.22651293,0.7279202,0.20012308,-0.22211462:2
0.80062941,0.20481218,-0.53995937,-0.61443653,-0.53995937,-0.61443653,-2.1039797,-1.5081624,-1.0612995,-0.46548221,0.72615225,1.0240609,0.80062941,0.27928933,-0.093096442,-0.24205076,-0.31652791,-0.39100506,-0.61443653,-0.093096442,0.5027208,0.57719795,2.4391269,1.8433096:2
-0.97139428,-1.2254151,-1.3665377,-1.4512113,-1.5076604,-1.3947622,-1.3100887,-0.80204709,0.29870962,1.0325474,1.2018946,1.2018946,1.2018946,0.89142478,0.94787384,0.91964931,1.060772,0.66562853,0.46805681,0.21403603,-0.18110741,-0.12465835,0.29870962,-0.068209278:2
-0.9986564,-1.3179604,-1.5175253,-1.6173078,-1.5973513,-1.4576558,-1.0784824,-0.040744508,0.75751541,1.1566453,1.0768193,1.1366888,0.97703688,0.55795043,0.53799393,0.45816794,0.43821144,0.33842895,1.0568628,1.0369063,0.61781992,0.29851595,-0.22035299,-0.59952644:1
-1.0442759,-1.3473764,-1.4042078,-1.555758,-1.6125894,-1.4231515,-1.0442759,-0.30546847,0.37650765,1.0963713,1.0963713,1.0205962,0.9258773,0.5280579,0.47122655,0.5280579,0.66066436,1.1342589,1.0963713,0.96376487,0.56594546,0.16812606,-0.26758091,-0.62751275:1
-0.076842574,-0.50243225,-1.0698852,-1.3063239,-1.4481871,-1.2117484,-1.0225974,-0.4551445,-0.69158321,0.017732909,0.49061033,0.6797613,0.77433678,0.25417162,-0.31328128,-0.31328128,-0.54971999,-0.59700773,-0.26599354,1.8619548,1.8619548,1.5782284,1.4836529,0.82162452:1
-1.0982213,-1.4571294,-1.6365835,-1.6141517,-1.5468564,-1.4122659,-1.1430849,0.1803887,0.51686502,1.1673859,1.1898177,0.98793188,0.80847784,0.49443327,0.44956976,0.44956976,0.427138,0.33741098,0.49443327,1.1449542,0.89820486,0.65145556,0.1803887,-0.47013222:1
-0.71035809,-1.0106269,-1.3108956,-1.4443484,-1.5110748,-1.4443484,-0.97726367,0.19044823,1.2247074,1.3581602,1.5583394,1.2580706,0.7242594,0.25717463,-0.24327333,-0.30999972,-0.30999972,-0.41008931,0.023632248,1.5583394,1.0245282,0.6241698,0.12372184,-0.24327333:1
-0.87267355,-1.2164902,-1.4457013,-1.5603069,-1.5603069,-1.4743527,-1.4170499,-0.55750827,0.30203339,0.98966673,1.2188778,1.2188778,0.96101534,0.84640977,0.58854727,1.0183181,1.0183181,0.84640977,0.50259311,0.18742783,-0.041783272,-0.013131883,0.44529033,0.015519506:2
-0.57585941,-1.0681973,-1.3847002,-1.4902011,-1.4902011,-1.3847002,-1.0330303,0.02197937,0.5143172,0.69015213,1.4989929,1.18249,0.61981817,0.057146358,-0.29452353,-0.32969051,-0.22418955,-0.22418955,1.3583249,1.6748278,1.252824,0.79565309,0.26814828,-0.43519147:1
-1.1103525,-1.3463695,-1.5180182,-1.6038425,-1.6467547,-1.4965621,-1.0674403,-0.037548156,0.5632223,1.1854488,1.1639927,0.97088797,0.77778318,0.45594187,0.49885404,0.52031013,0.5632223,0.43448578,0.64904665,1.1854488,0.86360753,0.54176622,-0.037548156,-0.50958209:1
-0.9131274,-1.2641695,-1.3895417,-1.5901372,-1.5399883,-1.3393928,-1.3895417,-0.78775522,0.41581774,1.0426787,1.1429764,1.0928275,0.99252978,0.71671098,0.8671576,0.99252978,1.0677531,0.74178542,0.5913388,0.44089218,-0.010447686,-0.010447686,0.34059443,-0.21104318:2
0.81368332,-0.16928982,-0.89013678,-0.89013678,-1.0211999,-1.0867314,-0.89013678,-1.152263,-0.49694753,0.81368332,0.81368332,1.2068726,1.141341,0.027304812,-0.49694753,-0.43141599,-0.69354215,-0.82460523,-0.75907369,-0.23482136,0.35496252,2.583035,1.6000618,0.68262024:2
-0.46798175,-0.90415892,-1.2312918,-1.3766842,-1.5584247,-1.3766842,-1.2312918,-0.75876653,-0.83146273,-0.24989317,0.47706878,0.91324595,0.94959404,0.36802449,0.004543518,-0.031804579,0.1499359,0.47706878,1.2767269,1.7129041,1.6038598,1.1676826,0.69515736,0.2226321:1
-1.0857745,-1.3643614,-1.5143697,-1.6000887,-1.6000887,-1.4286507,-1.0000555,0.0071432612,0.80004439,1.18578,1.18578,1.0572015,0.80004439,0.39287894,0.3071599,0.4143087,0.43573846,0.37144918,1.18578,1.0572015,0.75718486,0.32858966,-0.1214353,-0.57146026:1
-1.1178645,-1.4190694,-1.505128,-1.6342158,-1.6557304,-1.505128,-1.0102914,0.043925717,0.4742184,1.0335989,1.0551135,0.969055,0.8399672,0.49573304,0.4096745,0.60330622,0.5387623,0.58179157,0.81845256,1.2487452,0.79693793,0.45270377,-0.020618186,-0.49394015:1
-0.32030988,-0.84882117,-1.2812395,-1.4253789,-1.3773325,-1.4253789,-0.94491413,0.40038734,0.68866623,1.7456888,1.8898283,1.6495959,0.88085216,0.16015494,-0.27226339,-0.46444932,-0.32030988,-0.56054228,-0.32030988,-0.12812395,0.35234086,1.265224,0.59257327,0.064061967:2
-0.92155957,-1.2832933,-1.438322,-1.5158363,-1.5933507,-1.5416745,-1.4641601,-0.68901651,0.65456568,1.0421375,1.1713281,1.14549,0.88710876,0.78375628,0.88710876,0.86127064,0.70624192,0.5512132,0.42202262,0.42202262,0.24115578,0.34450826,0.37034638,-0.043063531:2
-0.93962884,-1.3513501,-1.5384961,-1.5384961,-1.5572107,-1.4449231,-1.1454895,-0.22847405,0.78211433,0.89440192,1.0066895,0.93183112,0.74468513,0.44525153,0.46396613,0.52010993,0.65111213,1.2874085,1.2499793,0.95054572,0.42653693,0.18324713,-0.20975945,-0.58405145:1
-0.49341783,-1.0647438,-1.22056,-1.5321923,-1.4802536,-1.2724987,-0.96086633,-0.85698888,0.5972953,1.2724987,1.584131,1.6880084,1.5321923,0.80505018,0.54535657,0.70117274,0.64923402,0.38954041,0.12984681,-0.12984679,-0.649234,0.12984681,0.025969369,-0.38954039:2
-1.0286754,-1.2847771,-1.4896585,-1.6177094,-1.566489,-1.3872178,-1.1055059,-0.38842099,0.61037584,1.22502,1.1994099,1.0457488,0.86647759,0.37988426,0.43110461,0.45671479,0.61037584,0.37988426,0.25183339,1.3530709,0.99452848,0.58476566,-0.0042683627,-0.51647186:1
-0.097203259,-0.85895939,-1.2874472,-1.525496,-1.4778863,-1.1922277,-1.0493984,-0.57330084,0.71216264,1.6643578,1.9976261,1.4739188,0.95021143,0.18845529,-0.14481302,-0.24003253,-0.28764229,-0.33525205,-0.28764229,-0.049593501,0.37889433,1.3310895,0.7597724,-0.049593501:2
-0.13725925,-0.8510074,-1.4000445,-1.4549482,-1.6196593,-1.4549482,-0.96081481,-0.30197037,0.35687408,1.4549482,1.674563,1.5647556,1.0157185,0.30197038,-0.082355551,-0.19216296,-0.082355551,-0.19216296,-0.24706666,-0.027451848,1.5098519,1.0157185,0.46668149,-0.35687407:2
-0.97599916,-1.3559683,-1.5347773,-1.5794796,-1.6465329,-1.4453728,-1.0877548,-0.081954126,0.63328191,1.0803044,1.1026555,1.0803044,0.72268641,0.34271726,0.38741952,0.40977064,0.47682402,0.36506839,1.19206,1.2814646,0.76738867,0.43212177,-0.059603,-0.50662552:1
-1.1466745,-1.3062118,-1.4856913,-1.5654599,-1.5455178,-1.3859805,-1.1267323,-0.18945057,0.60823603,0.98713716,1.086848,0.967195,0.68800469,0.38887222,0.30910356,0.42875654,0.66806252,1.1666166,1.2463853,1.1067902,0.54840953,0.30910356,-0.18945057,-0.5683517:1
-0.70616265,-1.1074791,-1.4779251,-1.6322776,-1.6322776,-1.4470546,-0.79877415,-0.15049368,0.96084426,1.1460673,1.1460673,0.89910326,0.71388027,0.096470303,-0.088752688,0.0038588075,0.12734081,0.89910326,1.4547722,1.3621607,0.92997376,0.1582113,-0.24310517,-0.61355115:1
-0.6410856,-1.0392459,-1.3520862,-1.4374063,-1.4374063,-1.4374063,-1.6080464,-0.81172575,0.5533955,1.122196,1.2359561,1.2643961,1.093756,0.80935573,0.80935573,1.093756,0.97999589,0.63871558,0.52495547,0.26899524,-0.18604517,-0.27136524,-0.043845044,-0.12916512:2
-1.0489301,-1.3995988,-1.5103363,-1.5472488,-1.5841613,-1.418055,-1.0858426,-0.12611769,0.79669469,1.0366259,1.0919947,1.1658197,0.88897593,0.42756973,0.42756973,0.51985097,0.64904471,0.75978219,1.1658197,0.85206343,0.48293847,0.26146351,-0.12611769,-0.67980512:1
-1.1346957,-1.3975205,-1.5794762,-1.6401281,-1.6401281,-1.4783897,-0.87187083,-0.063179037,0.30073226,0.88703382,0.967903,0.86681652,0.68486087,0.36138415,0.42203603,0.58377439,0.74551275,1.0083376,1.2711624,1.0285549,0.72529546,0.50290521,-0.083396331,-0.46752493:1
0.43000648,0.0075439712,-0.53562211,-0.89773284,-1.0184364,-0.83738105,-0.53562211,-0.052807815,-0.53562211,0.3696547,0.79211719,0.43000648,0.0075439712,-0.17351139,-0.53562211,-0.89773284,-1.0787882,-1.13914,-0.83738105,-0.29421496,1.3352833,2.4216155,1.9388012,1.6370422:1
-1.0020782,-1.2391526,-1.4762269,-1.5552517,-1.6079349,-1.5025685,-1.212811,-0.080122345,0.7891503,1.3159822,1.3686654,1.3159822,0.99988306,0.57841753,0.55207594,0.52573434,0.60475913,0.13061041,0.13061041,0.26231839,0.89451668,0.47305115,0.13061041,-0.3962215:2
-1.1992378,-1.4228245,-1.565107,-1.6260852,-1.565107,-1.4431506,-1.0366293,-0.020326067,0.65043408,1.0772814,1.0569554,0.97565111,0.79271653,0.42684736,0.48782556,0.54880375,0.52847769,0.46749949,1.0366293,1.1382596,0.73173834,0.48782556,-0.10163032,-0.42684736:1
-0.9767843,-1.3215317,-1.6203127,-1.6892622,-1.5973296,-1.5053969,-1.0687169,0.057457889,0.74695267,1.0917001,1.0917001,1.0457338,0.83888531,0.42518844,0.49413792,0.49413792,0.4481716,0.47115476,0.74695267,1.2066159,0.81590215,0.37922212,-0.14939055,-0.42518846:1
-1.070522,-1.3321567,-1.5414645,-1.5937914,-1.5937914,-1.5937914,-1.0879643,-0.21584865,0.51672855,1.0574403,1.0051133,1.039998,0.90045945,0.44695929,0.56905549,0.67370937,0.77836326,0.77836326,0.98767102,0.90045945,0.53417086,0.34230541,-0.076310136,-0.42515642:1
-0.34715578,-0.92175845,-1.2808851,-1.3886231,-1.6759244,-1.4963611,-1.1013218,-0.70628244,-0.77810779,0.011970888,0.76613689,0.87387489,0.76613689,0.29927222,-0.13167978,-0.095767112,-0.059854445,1.2689142,1.2689142,1.5203029,1.4125649,1.0534382,0.62248622,0.11970889:1
-1.0169325,-1.2735042,-1.4980044,-1.4338615,-1.4659329,-1.5300758,-1.2414327,-0.18307458,0.39421168,1.2922125,1.4525698,1.324284,0.87528356,0.55456897,0.65078335,0.74699772,0.74699772,0.42628314,0.16971147,0.041425636,0.8432121,0.61871189,0.10556855,-0.60000354:2
-0.98043988,-1.5527452,-1.574757,-1.6407922,-1.5967687,-1.398663,-1.0024516,-0.011923036,0.51635887,0.95659381,1.0006173,0.86854683,0.67044111,0.42831189,0.36227665,0.42831189,0.42831189,0.58239412,1.3528052,1.2207347,0.80251159,0.53837062,0.12014745,-0.51819321:1
-0.17213456,-0.65344285,-0.89409699,-1.2149692,-1.2550782,-1.2149692,-1.0545331,-1.4556233,-0.85398797,-0.25235261,0.50971884,0.79048201,0.83059104,0.30917373,-0.051807485,-0.051807485,-0.25235261,-0.33257066,0.10862861,1.6327715,1.9536437,1.7530986,1.1514632,0.67015494:1
-0.78609519,-1.2500202,-1.2757938,-1.4304355,-1.4046619,-1.4046619,-1.6108508,-0.65722712,0.399491,1.2500202,1.1726994,1.2500202,0.73454797,0.91496326,0.94073687,1.0438313,1.0953785,0.7860952,0.42526461,0.1933021,-0.1933021,-0.24484932,0.14175487,-0.090207645:2
-0.67781334,-1.2810588,-1.5022488,-1.6027898,-1.6832225,-1.522357,-1.2006261,-0.25554149,0.72975948,1.1922477,1.1922477,1.1319231,0.93084131,0.44824491,0.52867765,0.56889401,0.5890022,0.5890022,0.93084131,0.97105767,0.4683531,0.2270549,-0.29575786,-0.47673151:1
-1.0676472,-1.3598454,-1.5396597,-1.5846133,-1.6295668,-1.3373686,-1.090124,0.23600622,0.5506812,1.0226937,1.0002169,0.93278652,0.73049547,0.30343657,0.30343657,0.43829728,0.39334371,0.5506812,1.404799,1.3148919,0.8204026,0.34839014,-0.16857589,-0.57315801:1
-0.66183059,-0.96470221,-1.3348787,-1.4358359,-1.5367931,-1.3012263,-1.0993118,-0.72913538,0.3813939,1.222704,1.4582708,1.4919232,1.222704,0.81887514,1.0207896,0.91983235,0.91983235,0.54965592,0.3813939,0.17947948,-0.45991617,-0.35895897,-0.19069695,-0.49356857:2
0.52937307,-0.18254244,-0.40159337,-1.0587462,-1.1135089,-1.1135089,-0.94922068,-1.5516108,-0.78493248,0.20079669,0.80318673,0.80318673,0.63889853,0.14603395,-0.29206791,-0.23730517,-0.51111883,-0.56588155,-0.67540702,-0.18254244,0.74842399,2.3365433,2.0079669,1.4055768:2
0.48236112,-0.24467592,-0.6361574,-0.8598611,-1.1954167,-1.2513426,-1.0276389,-1.7546759,-0.91578703,-0.07689814,0.65013889,0.70606482,0.76199074,0.090879636,-0.13282406,-0.24467592,-0.30060185,-0.46837962,-0.35652777,0.31458334,0.92976852,2.3279166,1.7686574,1.4331018:2
-1.0087333,-1.4894641,-1.5471518,-1.566381,-1.5471518,-1.4125472,-1.0471918,-0.23956415,0.39500043,1.0103358,0.99110655,1.0103358,0.8949604,0.5680635,0.54883427,0.58729273,0.68343887,1.0487942,1.0680235,0.97187732,0.49114658,0.29885428,-0.047271857,-0.66260721:1
-0.92215376,-1.2532377,-1.4060457,-1.5843217,-1.6097897,-1.4060457,-1.0749618,-0.64200579,0.50405412,1.2680941,1.4718381,1.2935621,1.1916901,0.86060609,0.6823301,0.7077981,0.58045811,0.52952212,0.19843814,0.14750215,0.17297014,0.58045811,-0.005305844,-0.28545382:2
-0.95391869,-1.3820188,-1.456471,-1.4936971,-1.5681493,-1.5495362,-1.1586622,-0.28384898,0.60957731,1.1865818,1.1307426,1.1865818,0.90738607,0.47928598,0.57235122,0.66541645,0.55373817,0.75848169,1.0376774,0.90738607,0.38622074,0.18147721,-0.22800983,-0.4885925:1
-0.91664261,-1.3745492,-1.533821,-1.4940031,-1.573639,-1.533821,-1.1754594,-0.21982832,0.457077,0.97471049,1.1140734,1.1339823,0.99461947,0.57653089,0.53671292,0.71589375,0.93489253,0.75571171,0.61634885,0.99461947,0.53671292,0.31771414,-0.2397373,-0.59809894:1
-1.0989856,-1.3555937,-1.5388853,-1.5572144,-1.630531,-1.4289103,-1.1356439,-0.2741736,0.82557567,1.1188421,1.0271964,0.95387975,0.78891736,0.51398004,0.60562581,0.69727158,0.78891736,0.69727158,1.0271964,0.88056313,0.47732173,0.22071357,-0.12754037,-0.4757943:1
-0.68329038,-1.1096635,-1.4704408,-1.5688346,-1.5688346,-1.4704408,-1.0112697,-0.7816842,0.30064775,1.21899,1.3173838,1.4157776,1.0877982,0.79261682,0.79261682,0.8582127,0.98940445,0.75981887,0.39904157,0.23505188,-0.19132132,-0.25691719,0.13665806,-0.19132132:2
-0.59339106,-0.88804041,-1.3463838,-1.5100779,-1.5755555,-1.5428167,-1.1172121,-0.20052525,0.51972871,1.1417662,1.4691544,1.3709379,0.8798557,0.25781818,-0.23326407,-0.03683117,-0.1023088,-0.20052525,0.78163925,1.5673708,1.1090274,0.71616162,0.028646463,-0.4951746:1
-0.72974132,-1.1081257,-1.3243454,-1.3513728,-1.5135375,-1.3513728,-1.5946199,-0.78379623,0.24324711,1.1081257,1.1081257,1.2702904,1.1892081,0.75676877,0.83785115,0.86487861,1.2162355,0.94596098,0.51352167,0.24324711,-0.21621965,-0.16216474,0.054054912,-0.21621965:2
-0.89736894,-1.3381817,-1.4851193,-1.7580034,-1.6110658,-1.4851193,-1.149262,-0.14168985,0.61398926,1.0967842,1.0548021,0.94984666,0.86588231,0.36209623,0.42506949,0.48804275,0.48804275,0.48804275,1.1177753,1.1597575,0.80290904,0.42506949,-0.057725495,-0.41457397:1
-0.98620087,-1.3011391,-1.5433993,-1.6160774,-1.6645294,-1.3980432,-1.0831049,-0.017160105,0.78229854,1.2910449,1.339497,1.2183669,0.87920262,0.44313427,0.37045621,0.49158631,0.39468223,0.10397,0.20087408,1.0487848,0.90342863,0.46736029,0.10397,-0.42900242:1
-0.67489646,-1.1546138,-1.4650192,-1.5214565,-1.6061125,-1.4932378,-1.5496752,-0.56202179,0.62316224,1.3286289,1.2721916,1.2721916,0.99000492,0.59494357,0.62316224,0.82069291,0.79247425,0.56672491,0.25631956,0.34097557,0.058788898,0.36919423,0.34097557,-0.22339778:2
0.10056887,-0.53699984,-1.2201092,-1.5388935,-1.5388935,-1.4933529,-1.0834873,-0.58254046,-0.44591859,0.28273136,0.51043447,0.41935323,0.69259696,0.1461095,-0.30929673,-0.40037797,-0.30929673,0.1461095,1.3301657,1.9677344,1.6944907,1.4667875,0.69259696,0.0094876247:1
-0.24111803,-0.76354041,-1.0850311,-1.4467082,-1.4065218,-1.4065218,-1.0448448,-0.96447208,-0.3214907,-0.44204971,0.32149069,0.72335406,0.76354039,0.32149069,-0.04018634,-0.24111803,-0.3214907,-0.04018634,1.4467082,1.9289442,1.6074535,1.4467082,0.84391307,0.36167703:1
1.7402473,0.66318879,0.30416929,0.30416929,-0.29419654,-0.054850209,0.54351562,-1.1319087,-1.0122355,-0.054850209,-0.29419654,-0.53354287,-0.054850209,-0.4138697,-0.7728892,-0.53354287,-1.371255,-0.89256236,-0.89256236,-0.65321603,-0.29419654,2.0992668,2.21894,1.3812278:2
-0.72620922,-1.1411859,-1.3783155,-1.5561627,-1.5858039,-1.5265215,-1.0522624,-0.25195013,0.9040564,1.1708271,1.2004683,0.9040564,0.5187209,-0.044461779,-0.13338536,-0.16302655,-0.10374417,0.81513282,1.1708271,1.4375979,1.0819036,0.69656805,0.25195015,-0.48907967:1
-0.92264037,-1.3429179,-1.5267893,-1.658126,-1.658126,-1.4479872,-1.1327791,-0.42356089,0.54833077,1.3100837,1.3100837,1.2050143,0.9423409,0.54833077,0.60086545,0.60086545,0.81100419,0.54833077,0.18058798,0.36445937,0.4432614,0.65340014,0.25939,-0.21342215:2
-1.017714,-1.3787812,-1.4212597,-1.5911737,-1.5699345,-1.442499,-1.017714,-0.019469326,0.42655492,0.8938184,0.95753614,0.83010065,0.68142591,0.29911942,0.32035867,0.36283717,0.63894741,1.1062109,1.4672781,1.3186034,0.70266516,0.29911942,-0.21062257,-0.63540755:1
-0.23853703,-0.69960187,-1.1222447,-1.314355,-1.6601537,-1.4296212,-1.1222447,-0.69960187,-0.89171221,-0.23853703,0.49148233,0.60674854,0.79885888,0.41463818,-0.084848737,-0.16169288,-0.2769591,0.14568369,1.2983458,1.6441445,1.6441445,1.4904562,1.0293913,0.37621611:1
-1.149072,-1.3923538,-1.5487492,-1.5661265,-1.5661265,-1.4271083,-1.1316947,-0.31496305,0.74505047,1.0057095,1.0230868,1.0057095,0.81455957,0.51914596,0.62340958,0.7276732,0.84931411,0.81455957,1.0230868,0.79718229,0.51914596,0.18897782,-0.19332215,-0.36709486:1
-0.18421478,-1.0449706,-1.4362232,-1.2405969,-1.4362232,-1.3579727,-1.0058453,-0.77109376,0.36353891,1.4590463,1.4590463,1.3025452,0.79391682,0.16791259,-0.34071584,-0.26246531,-0.26246531,-0.18421478,0.050536797,1.6937979,1.419921,0.87216735,0.16791259,-0.22334005:1
-1.1015447,-1.2969407,-1.5314158,-1.5900346,-1.6291138,-1.4141783,-1.1015447,-0.10502533,0.59840013,1.0087316,0.95011285,0.83287528,0.77425649,0.36392497,0.38346457,0.42254376,0.55932093,1.2627464,1.282286,1.0673504,0.55932093,0.28576659,-0.10502533,-0.47627765:1
-0.4223829,-0.69426154,-1.3156984,-1.4710577,-1.5487373,-1.4710577,-1.0438198,-0.81078096,-0.4223829,0.31557343,0.43209285,0.70397148,0.7816511,0.27673362,-0.26702367,-0.18934406,-0.30586348,0.19905401,1.3642482,1.6749667,1.6361269,1.4807676,0.7816511,0.31557343:1
-0.8226899,-1.3150082,-1.5741231,-1.7036806,-1.7036806,-1.3927427,-0.97815885,-0.12307959,0.6283537,1.4316099,1.4834329,1.1984065,0.88746863,0.73199966,0.6024422,0.6283537,0.57653071,0.36923876,0.36923876,0.13603533,0.2396813,0.57653071,0.18785832,-0.43401751:2
-0.84354529,-1.273588,-1.5051494,-1.5713099,-1.6374703,-1.4059088,-0.97586612,-0.31426197,0.74430466,0.87662549,1.2074276,1.1412672,0.81046507,0.34734218,0.31426197,0.21502135,0.21502135,0.67814424,1.4720692,1.2074276,0.81046507,0.24810156,-0.18194114,-0.57890363:1
-0.36282649,-0.92144238,-1.3814789,-1.5457777,-1.644357,-1.5457777,-1.0857411,-0.62570456,0.42580768,1.2144418,1.4773199,1.3130211,0.8858443,0.39294793,-0.067088676,-0.099948433,-0.0013691601,0.064350355,0.22864914,1.5101797,1.2144418,0.72154552,0.22864914,-0.39568626:1
-0.75034038,-1.1184801,-1.4252632,-1.3639066,-1.4866199,-1.3639066,-1.5172982,-0.68898375,0.53814872,1.2744282,1.3664631,1.4584981,1.151715,0.84493184,0.69154028,0.66086197,0.84493184,0.7528969,0.41543547,0.10865235,-0.16745245,-0.22880908,0.13933067,-0.13677414:2
-0.46711094,-1.3037275,-1.6104869,-1.6104869,-1.6383741,-1.498938,-1.1364042,-0.60654704,0.59260341,1.3455583,1.2897839,1.178235,1.178235,0.56471619,0.53682897,0.64837786,0.7041523,0.34161844,0.20218234,0.25795678,0.23006956,0.87147562,0.23006956,-0.29978761:2
-0.91691163,-1.2358374,-1.3953003,-1.6185483,-1.4271929,-1.4590854,-1.2358374,-0.85312647,0.55014697,1.2836763,1.4112466,1.3155688,1.0923208,0.58203955,0.67771729,0.70960986,0.77339502,0.42257666,0.16743604,-0.087704595,0.23122119,0.70960986,0.32689893,-0.023919439:2
-1.2292469,-1.3939471,-1.4762972,-1.5998224,-1.5174723,-1.2910095,-1.0645467,-0.096932948,0.78833072,1.0765561,1.0559686,1.035381,0.64421803,0.39716771,0.43834276,0.35599265,0.47951782,1.035381,1.2412563,1.1177312,0.56186792,0.23246749,-0.22045811,-0.57044608:1
-1.1470603,-1.3707116,-1.4723713,-1.5536991,-1.6350268,-1.5333671,-1.1470603,-0.17112716,0.56082267,1.0691212,1.0691212,0.9877934,0.76414207,0.60148655,0.70314625,0.64215043,0.70314625,0.54049073,0.45916297,1.2114447,0.84546983,0.31683939,-0.069467457,-0.37444656:1
0.89950527,0.0057293295,-0.8192946,-1.6443185,-0.61303862,-0.8880466,-0.8192946,-1.3005586,-0.54428663,0.074481324,0.28073731,0.4869933,0.83075327,0.55574529,0.28073731,0.0057293295,-0.68179061,-0.68179061,-1.0255506,-0.75054261,0.76200128,2.0682892,1.7245292,1.7932812:2
-0.89836683,-1.1736111,-1.5635405,-1.6552886,-1.6552886,-1.4947295,-1.1736111,-0.095570941,0.52372874,1.2347765,1.2577135,1.1200914,0.89072115,0.47785469,0.38610659,0.50079171,0.52372874,0.36316956,0.66135089,1.2577135,0.68428791,0.36316956,-0.11850796,-0.41668929:1
-0.25294588,-1.0117835,-1.3747058,-1.5066776,-1.6386494,-1.4406917,-1.2097411,-0.15396705,0.37391999,1.0667717,1.3307153,1.1987435,0.86881409,0.17596235,-0.28593882,-0.12097411,-0.21995294,-0.21995294,1.1657506,1.6276517,1.1327576,0.73684233,0.17596235,-0.41791059:1
-0.97286645,-1.2500668,-1.505944,-1.6338826,-1.5912364,-1.4419747,-1.1647744,-0.43978894,0.54107368,0.92488949,0.90356639,0.92488949,0.81827399,0.39181198,0.32784267,0.71165849,0.77562779,1.1381205,1.2873822,1.0528281,0.47710438,0.17858097,0.0079961686,-0.46111204:1
-0.415745,-0.74212426,-1.3948828,-1.4415084,-1.6280108,-1.3016315,-1.1151291,-0.97525229,0.33026472,1.4492793,1.7756586,1.5425305,0.98302322,0.23701351,0.0038854641,0.050511072,0.0038854641,-0.18261696,-0.18261696,0.0038854641,0.70326958,1.3094025,0.7965208,0.1903879:2
-1.0149996,-1.3558576,-1.469477,-1.6512679,-1.6285441,-1.469477,-1.1513428,0.030298494,0.68929075,1.2119398,1.0301488,0.98470107,0.98470107,0.59839526,0.55294752,0.59839526,0.64384301,0.46205204,0.28026107,1.1437682,0.8029101,0.37115656,-0.060596988,-0.58324602:1
-0.34592969,-0.87028628,-1.2635538,-1.5257321,-1.5694284,-1.4820357,-1.0013755,-0.5644116,-0.34592969,-0.30223331,0.4406052,0.79017626,0.87756901,0.48430158,-0.30223331,-0.30223331,-0.34592969,0.52799797,1.3145329,1.4019256,1.7514967,1.3145329,1.0086582,0.30951605:1
-0.42323646,-0.91230971,-1.1380358,-1.514246,-1.476625,-1.401383,-1.1380358,-0.83706767,-0.53609952,-0.46085748,0.02821577,0.479668,0.74301514,0.25394189,0.02821577,0.1034578,0.06583679,1.1568463,1.3825724,1.6459196,1.5330565,1.3449514,0.8558782,0.21632087:1
-0.98115413,-1.3242007,-1.495724,-1.5937373,-1.642744,-1.495724,-1.0546641,0.17050233,0.75858221,1.1506355,1.3711654,1.1016288,0.70957556,0.24401231,0.36652896,0.51354893,0.46454227,0.24401231,0.34202563,1.3221588,0.88109886,0.4890456,0.02348235,-0.56459753:1
-0.45277827,-0.22949036,-1.4203592,-1.7180765,-1.7180765,-1.4203592,-1.0482127,-1.6436471,0.21708548,0.96137853,1.4079543,1.333525,1.333525,0.66366131,0.58923201,0.4403734,0.4403734,0.14265618,0.4403734,0.14265618,0.14265618,0.96137853,0.36594409,0.068226867:2
0.84832769,0.29557119,-0.53356357,-0.80994182,-0.90206791,-0.71781574,-0.62568965,-1.8233287,-1.5469505,-0.25718532,0.2034451,0.47982335,0.57194944,-0.16505923,-0.44143749,-0.25718532,-0.44143749,-0.16505923,-0.25718532,0.11131902,0.47982335,1.4010842,2.230219,2.322345:2
-0.98227022,-1.2962976,-1.4757418,-1.5878945,-1.565464,-1.5206029,-1.1392839,-0.35421543,0.54300571,1.0589079,1.193491,1.2607826,1.0140468,0.61029729,0.54300571,0.61029729,0.65515835,0.40842254,0.31870042,1.0589079,0.8570331,0.38599201,-0.085049091,-0.51122913:1
-0.98376274,-1.2497944,-1.4493181,-1.6266725,-1.5823339,-1.5601646,-1.0059321,-0.2300065,1.1666595,1.2553367,1.1666595,1.1223209,0.85628927,0.56808835,0.32422604,0.36856464,0.39073394,0.36856464,0.50158045,1.1666595,0.72327346,0.36856464,-0.11916,-0.54037673:1
0.93961434,-0.11745179,-0.68122039,-1.1040468,-1.3154601,-0.9631047,-0.32886502,-0.9631047,-0.25839394,0.51678789,1.0805565,1.2214986,0.93961434,0.023490356,-0.9631047,-0.75169147,-0.82216254,-0.89263362,-0.9631047,-0.11745179,0.58725896,2.1376226,1.6443251,1.1510276:2
-1.0978969,-1.2755912,-1.5802099,-1.6563646,-1.6563646,-1.5802099,-1.1486667,-0.13327072,0.55212155,1.0598195,1.0344346,1.0344346,0.75520075,0.47596685,0.57750644,0.57750644,0.70443095,0.62827625,0.55212155,0.75520075,0.98366483,0.67904605,0.095193369,-0.33634991:2
-1.0253864,-1.2037144,-1.4266245,-1.6495346,-1.7386986,-1.4712065,-0.98080438,-0.84705833,0.35665613,1.1145504,1.3820425,1.2037144,1.0699684,0.75789428,0.53498419,0.66873024,0.62414823,0.44582016,0.49040218,0.49040218,0.13374605,0.66873024,0.40123815,-4.0625001E-9:2
-1.10272,-1.422349,-1.5502006,-1.635435,-1.635435,-1.422349,-1.0174856,-0.44215343,0.51673353,1.0707571,0.98552271,0.96421412,0.81505392,0.45280773,0.45280773,0.70851092,0.90028832,0.66589373,0.58065933,1.1559915,0.77243672,0.47411633,0.04794435,-0.33561044:1
-0.73312329,-1.0601671,-1.3218022,-1.4526197,-1.648846,-1.3218022,-0.86394083,-0.86394083,0.90209595,1.4907748,1.5561836,1.3599573,1.163731,0.83668718,0.50964332,0.37882578,0.50964332,0.44423455,0.18259948,-0.2752619,-0.79853206,0.64046087,0.37882578,-0.013626827:2
0.16295187,-0.78513181,-1.0221527,-1.3776841,-1.4961946,-1.2591737,-0.66662134,-1.614705,-0.074069045,0.99252509,1.1110356,0.99252509,1.1110356,0.16295187,-0.54811088,0.28146234,0.75550417,0.28146234,-0.074069045,-0.66662134,-0.54811088,1.7035879,1.466567,1.1110356:2
-0.22978715,-0.57021255,-0.97872303,-1.5914887,-1.5914887,-1.1829783,-0.50212747,-1.2510633,-0.43404239,0.79148905,1.0638294,1.0638294,0.85957413,0.042553169,-0.36595731,-0.36595731,-0.22978715,-0.16170207,-0.16170207,0.11063825,0.99574429,2.1531906,1.6765951,0.85957413:2
-0.83729149,-1.3051611,-1.6092763,-1.7028502,-1.7028502,-1.398735,-1.1180132,-0.34602849,0.70667794,1.104367,1.1745475,1.0107931,0.77685837,0.40256276,0.40256276,0.63649751,0.56631708,0.40256276,0.49613665,1.2681214,0.8470388,0.54292361,-0.041913297,-0.27584806:1
1.007087,0.29620207,-0.41468288,-0.33569566,-0.65164452,-0.65164452,-0.41468288,-1.6784783,-1.0465806,-0.41468288,0.059240419,0.21721485,-0.019746797,-0.098734012,-0.33569566,-0.57265731,-0.73063173,-0.57265731,-0.33569566,-0.41468288,0.53316372,2.4288568,2.2708824,1.8759463:2
-0.70908579,-1.2181731,-1.5818068,-1.5575646,-1.7515026,-1.6302913,-1.1212041,-0.17575631,0.57575344,1.1818097,1.2302942,1.0848407,0.89090267,0.38181544,0.40605769,0.59999569,0.59999569,0.28484644,0.47878444,1.2302942,0.84241818,0.40605769,-0.10302956,-0.34545206:1
-0.74339557,-0.91304527,-1.2523447,-1.3654445,-1.3937194,-1.3088946,-1.4502693,-0.68684567,0.35932749,1.207576,1.3772257,1.4337756,1.0944762,0.8117267,0.9248265,1.0944762,1.0944762,0.7551768,0.41587739,-0.008246858,-0.31927131,-0.40409616,-0.23444646,-0.48892101:2
-0.47221758,-1.2227621,-1.5229799,-1.5229799,-1.5229799,-1.2978165,-0.9975987,-0.92254426,-0.17199978,1.0288714,1.3290892,1.5542526,1.4041437,0.87876249,0.50349026,0.27832692,0.42843581,0.20327247,0.12821802,-0.021890882,-0.24705423,1.2540348,0.72865359,0.20327247:2
-0.77677379,-1.3357222,-1.4672394,-1.5658774,-1.5987567,-1.532998,-1.1384463,-0.053428878,0.43976083,1.3275023,1.4261403,1.2288644,1.0973471,0.40688152,0.66991603,0.76855398,0.76855398,0.3740022,0.24248494,-0.053428878,0.73567466,0.57127809,-0.053428878,-0.48085995:2
0.74575839,0.041566857,-0.60394204,-0.95603781,-0.95603781,-0.77998992,-0.7213073,-1.4254988,-1.4254988,-0.13448102,0.62839314,0.68707576,0.74575839,0.45234525,-0.3105289,-0.25184628,-0.54525941,-0.77998992,-0.66262467,-0.42789416,1.2152194,2.2128241,1.8020457,1.4499499:2
-1.1247362,-1.3806937,-1.5382059,-1.5972731,-1.5382059,-1.5382059,-1.04598,-0.19935151,0.50945381,0.82447839,0.84416742,0.86385646,0.72603321,0.52914285,0.48976477,0.70634417,0.72603321,1.2182591,1.139503,1.0410578,0.58820995,0.33225249,-0.081217285,-0.49468705:1
-0.91256658,-1.1240627,-1.5000558,-1.6410532,-1.6645528,-1.4765562,-1.218061,-0.39557607,0.63840495,1.014398,1.2023946,1.014398,0.84990107,0.4504084,0.37990969,0.40340926,0.42690883,0.59140581,1.2728933,1.1553955,0.61490538,0.40340926,-0.043082539,-0.44257521:1
-0.54186234,-0.95081505,-1.4415583,-1.7278252,-1.7687205,-1.5642441,-1.2370819,-0.41917653,0.15335727,1.0939485,1.2166343,1.2984249,1.0939485,0.35783362,0.15335727,-0.092014364,0.07156672,0.112462,0.48051944,0.84857687,0.97126269,1.175739,0.64410052,0.07156672:2
0.038482736,-0.5156686,-0.93128209,-1.2083578,-1.3930749,-1.3468956,-0.93128209,-0.46948932,-1.0236406,-0.053875819,0.31555839,0.54645478,0.5002755,-0.1000551,-0.23859293,-0.42331004,-0.46948932,-0.33095149,0.45409623,1.8394745,2.1165502,1.9318331,1.0082476,0.68499261:1
-0.88164789,-1.2663669,-1.5327109,-1.5918985,-1.6214922,-1.4143358,-1.1183981,-0.79286657,0.53885332,1.2491039,1.367479,1.2491039,1.1899164,0.50925954,0.56844709,0.56844709,0.47966577,0.47966577,0.39088444,0.45007199,0.39088444,0.74600974,0.24291557,-0.20099105:2
-1.1459551,-1.4102248,-1.5234832,-1.5989889,-1.5801124,-1.4291012,-1.0326967,-0.14550563,0.6095506,1.1569664,1.0437079,0.9682023,0.79831465,0.45853935,0.40191013,0.47741576,0.51516857,1.0625843,1.1003371,0.94932589,0.6095506,0.30752811,-0.10775281,-0.48528093:1
-0.18963774,4.8940973E-9,-0.88497614,-1.3906768,-1.3906768,-1.3906768,-1.5803145,-1.3906768,0.18963774,1.0746139,1.7067397,1.5803145,1.1378265,0.37927549,-0.25285033,-0.063212577,-0.18963774,-0.31606291,-0.31606291,-0.12642516,1.2642516,1.201039,0.69533839,0.25285033:2
-0.3261549,-0.7588428,-1.0341897,-1.4275423,-1.6242186,-1.388207,-1.1128602,-0.79817807,-0.87684859,-0.24748437,0.38187986,0.7752325,0.81456776,0.38187986,-0.090143311,-0.12947858,-0.24748437,0.42121512,1.2472557,1.7192788,1.6799436,1.4045967,0.7752325,0.46055038:1
-0.96973024,-1.3576223,-1.5617761,-1.4596992,-1.6434376,-1.3780377,-1.1330532,-0.31643829,0.56142276,1.0922225,1.173884,0.96973023,0.683915,0.43893052,0.37768441,0.41851515,0.56142276,0.90848411,1.2963762,1.1126379,0.60225351,0.33685366,-0.17353067,-0.5410074:1
-1.1129653,-1.4394138,-1.5354281,-1.6314423,-1.5546309,-1.4778195,-0.97854538,-0.17202556,0.88413135,1.0953627,1.056957,0.94173991,0.63449425,0.38485717,0.50007428,0.48087143,0.53847999,0.69210282,1.2489855,0.99934847,0.6536971,0.30804576,-0.056808447,-0.46006836:1
-1.1168419,-1.3078457,-1.4776269,-1.6049628,-1.6049628,-1.3927363,-1.0956193,-0.39527186,0.58097002,1.1327589,1.2600948,1.1752042,0.94175505,0.51730207,0.49607942,0.62341532,0.53852472,0.43241147,0.53852472,1.1327589,0.77197386,0.38996617,-0.05570947,-0.48016245:1
-0.68139665,-1.0145239,-1.2870825,-1.4687883,-1.5293569,-1.3779354,-1.5293569,-0.77224954,0.37855369,1.4082197,1.3779354,1.3476511,1.1356611,0.77224952,0.74196523,0.89338671,0.92367101,0.59054375,0.37855369,0.045426441,-0.19684792,-0.16656362,0.13627933,-0.10599503:2
0.18994871,-0.38711066,-0.96417004,-1.3681116,-1.3681116,-1.021876,-1.8297591,-0.79105222,0.18994871,1.4017734,1.9211268,1.8634209,1.5748912,0.59389027,0.24765465,0.016830902,0.074536841,-0.040875035,0.074536841,-0.15628691,-0.56022848,-0.50252254,0.65159621,0.18994871:2
-1.3150228,-1.2897339,-1.2897339,-1.4667561,-1.5173339,-1.5173339,-1.2897339,-0.40462239,0.35404458,1.1380005,1.3150228,1.2138672,1.0621338,0.70808915,0.60693356,0.68280026,0.73337805,0.63222246,0.58164466,0.53106686,0.63222246,0.32875568,0.025288892,-0.45520018:2
0.95,-0.05,-0.95,-1.25,-1.65,-1.35,-0.65,-1.55,-0.15,1.25,1.65,1.75,1.55,0.45,-0.45,-0.35,-0.15,-0.35,-0.35,-0.15,-0.15,0.35,1.15,0.45:2
-0.73050432,-1.1815876,-1.4221654,-1.4823098,-1.4221654,-1.4221654,-1.512382,-0.76057653,0.35209557,1.1339733,1.3444788,1.103901,0.92346773,0.80317885,0.86332329,1.0136844,1.0437566,0.80317885,0.53252888,0.23180669,-0.008771059,-0.068915497,0.20173447,-0.33956547:2
-0.89173524,-1.1288726,-1.4845786,-1.4648172,-1.6031473,-1.5438629,-1.2079184,-0.33841476,0.59037318,1.2227395,1.1634551,1.0646479,0.84727197,0.51132741,0.51132741,0.61013463,0.70894185,0.64965752,1.1832166,0.92631776,0.51132741,0.19514428,-0.29889187,-0.73364367:1
-0.94728637,-0.81420418,-1.4574347,-1.5683365,-1.7235991,-1.6348776,-1.16909,-0.54803981,0.51661763,1.1598482,1.0711267,1.2042089,0.93804454,0.58315872,0.51661763,0.538798,0.64969981,0.47225691,0.56097836,1.2042089,0.73842127,0.47225691,-0.17097364,-0.59240054:1
-0.68536916,-1.1352525,-1.3039587,-1.5289004,-1.5289004,-1.4445473,-1.5570181,-0.68536916,0.66428087,1.1985173,1.3672236,1.3109882,1.0016934,0.63616316,0.83298712,0.91734025,0.86110483,0.57992774,0.41122149,0.21439753,-0.066779565,-0.066779565,0.29875066,-0.29172123:2
-1.0555547,-1.3303736,-1.580209,-1.580209,-1.7051267,-1.3303736,-1.0805382,-0.38099904,0.69329329,1.3678489,1.2679148,1.09303,0.96811226,0.54339204,0.59335912,0.74326038,0.66830975,0.46844141,0.24358954,0.21860599,0.29355662,0.86817809,0.3435237,-0.33103195:2
-1.0557646,-1.365777,-1.531117,-1.5931195,-1.613787,-1.4691145,-1.1177671,-0.16706226,0.5976351,1.093655,1.13499,0.92831504,0.88698005,0.41162763,0.47363012,0.63897009,0.72164008,0.78364256,0.74230757,1.1143225,0.65963759,0.39096014,-0.14639476,-0.5184097:1
0.66029032,-0.3059882,-0.75691818,-1.079011,-1.2722667,-1.2078482,-1.1434296,-1.5943596,-1.0145924,0.016104648,0.85354603,1.0468017,1.304476,0.40261605,-0.37040677,-0.62808104,-0.69249961,-0.37040677,0.66029032,0.46703462,0.78912746,1.9486617,1.4977317,0.78912746:2
-0.90172313,-1.202895,-1.5040669,-1.6331406,-1.6331406,-1.4180178,-1.0738213,-0.60055118,0.13086637,1.1634558,1.4216032,1.1634558,1.1634558,0.64716112,0.86228393,0.73321025,0.86228393,0.56111199,0.25994006,0.0017926834,0.087841808,0.77623481,0.25994006,-0.12728101:2
-0.81358337,-1.2225048,-1.358812,-1.5973495,-1.6655031,-1.4951192,-1.0521209,-0.23427793,0.41318108,0.48133466,1.0265633,0.99248651,0.75394898,0.10648997,-0.097970779,0.10648997,0.14056676,0.58356503,1.5036384,1.6058687,1.1287937,0.75394898,0.27687392,-0.3365083:1
-0.0026159778,-0.44209999,-0.81880058,-1.1327177,-1.1327177,-1.1327177,-2.0116857,-1.2582846,0.49965146,1.6297532,2.0692372,1.6925366,1.3158361,0.3740846,0.24851774,-0.0026159778,-0.37931656,-0.065399408,-0.065399408,-0.0026159778,0.060167453,-0.19096627,0.68800175,0.060167453:2
-1.0114345,-1.3325747,-1.5403714,-1.6159338,-1.5403714,-1.4270278,-1.0681063,-0.29359148,0.76428236,1.0854227,1.1043133,0.9531884,0.76428236,0.44314209,0.4620327,0.4998139,0.68871994,1.0854227,1.0665321,0.9342978,0.55648572,0.21645484,-0.16135725,-0.63362235:1
-0.69707713,-1.0925819,-1.4089857,-1.3694352,-1.5671876,-1.4485362,-0.93437998,-0.38067333,-0.22247142,0.56853809,0.92449236,0.44988666,0.68718951,0.093932385,-0.2620219,-0.10382,-0.2620219,0.33123523,1.6759514,1.7946028,1.5177495,1.0431438,0.52898761,0.13348285:1
-1.0769144,-1.3977329,-1.5180399,-1.538091,-1.5581422,-1.4378352,-1.0167609,-0.014202898,0.66753651,0.98835507,1.0084062,0.94825275,0.74774115,0.34671796,0.36676912,0.5271784,0.66753651,0.98835507,1.228969,1.108662,0.64748536,0.32666681,-0.33502144,-0.67589114:1
-0.90774442,-1.3271066,-1.5367877,-1.6206601,-1.6206601,-1.4529153,-1.1593617,-0.2367649,0.58099137,1.1261622,1.2310028,1.2100347,0.97938545,0.53905515,0.56002326,0.49711893,0.47615082,0.39227838,0.70680003,1.1051941,0.66486381,0.35034216,-0.089988144,-0.46741412:1
-1.0396887,-1.4138597,-1.5775595,-1.6711023,-1.6711023,-1.4138597,-1.0630744,0.24652413,0.69085221,1.1819516,1.2053373,1.0884089,0.83116634,0.45699532,0.52715238,0.48038101,0.55053807,0.26990982,0.26990982,0.99486615,0.76100927,0.7142379,0.036052934,-0.45504651:1
-1.0903131,-1.3826876,-1.5471482,-1.5654216,-1.583695,-1.4375078,-1.0537663,-0.1949163,0.51774643,1.0659486,0.99285492,0.99285492,0.77357408,0.37155921,0.35328581,0.53601983,0.62738685,1.175589,1.1207688,0.99285492,0.59084005,0.38983261,-0.12182268,-0.52383755:1
-1.0777434,-1.3438529,-1.5389999,-1.5922218,-1.5744812,-1.485778,-1.0954841,-0.22619307,0.46569161,0.94468869,0.99791059,1.0688731,0.98016996,0.71406047,0.57213541,0.6253573,0.80276363,0.80276363,1.0156512,0.92694806,0.48343224,0.25280402,-0.26167433,-0.45682129:1
-0.33429209,-1.0433023,-1.4537819,-1.3791492,-1.4910982,-1.4910982,-1.1179349,-0.11039413,0.52398343,1.4195752,1.4195752,1.2329936,0.8971467,0.076187506,-0.14771046,-0.33429209,-0.29697576,-0.035761474,0.44935078,1.6434732,1.2703099,0.67324874,0.11350384,-0.48355739:1
-0.95573627,-1.3919112,-1.59717,-1.5715127,-1.6484847,-1.4945406,-1.1096804,0.044900367,0.6863341,1.1994811,1.2507958,1.1738237,0.91725024,0.4297606,0.5837047,0.5837047,0.50673265,0.37844591,0.14752976,0.45541795,1.045537,0.71199145,0.044900367,-0.39127458:1
-1.0332543,-1.3025062,-1.410207,-1.4371322,-1.4909826,-1.5717581,-1.3025062,-0.575526,0.77073365,1.3092375,1.2553871,1.2284619,1.093836,0.50148172,0.52840691,0.60918249,0.5822573,0.44763133,0.25915498,0.44763133,0.79765884,0.60918249,0.070678638,-0.38704965:2
-0.94999628,-1.162682,-1.4604421,-1.715665,-1.6305907,-1.5880535,-1.2052192,-0.73731054,0.19850669,0.87910105,1.0917868,0.96417535,0.87910105,0.75148961,0.58134102,0.87910105,0.9216382,0.70895246,0.62387816,0.70895246,0.32611813,0.70895246,0.45372957,-0.22686478:2
-0.94451625,-1.3397599,-1.5025074,-1.6187555,-1.6420051,-1.5490066,-1.2467614,-0.084279916,0.45046159,0.91545419,1.0084527,1.054952,0.91545419,0.70620752,0.38071269,0.49696085,0.70620752,0.63645863,0.75270678,1.1712001,0.79920604,0.45046159,-0.084279916,-0.43302436:1
-0.91311238,-1.1593449,-1.4466162,-1.487655,-1.6107713,-1.487655,-1.0772674,-0.91311238,0.071817822,1.0977868,1.1798643,1.2209031,1.056748,0.892593,0.60532169,0.76947672,1.0157093,0.97467051,0.27701162,0.52324417,0.071817822,0.56428293,0.071817822,-0.297531:2
-1.0319648,-1.3223669,-1.529797,-1.612769,-1.612769,-1.509054,-1.0112218,-0.098529299,0.44078897,1.0838223,1.0008502,0.98010724,0.71044811,0.39930295,0.31633091,0.46153198,0.58599004,0.87639219,1.3119954,1.1460513,0.64821907,0.42004596,-0.14001532,-0.5133895:1
0.19860371,-0.240415,-0.93030156,-1.0557355,-1.2438864,-0.67943372,-0.55399979,-1.0557355,-0.49128284,0.51218851,0.7003394,0.51218851,0.32403763,-0.11498108,-0.55399979,-0.74215068,-0.67943372,-0.74215068,-0.36584892,0.13588675,0.95120723,2.5818481,2.1428294,1.3902259:2
0.27332171,-0.41998215,-1.0599549,-1.113286,-1.5399345,-1.4332724,-2.1265763,-1.0066239,0.27332171,1.7132605,1.8199226,1.4466052,1.0199566,0.43331491,0.27332171,-0.04666468,0.16665958,-0.04666468,-0.04666468,0.21999065,0.0066663868,0.16665958,0.69997024,0.32665278:2
-0.96443008,-1.3414743,-1.5299964,-1.5718902,-1.5928371,-1.4462088,-1.0482177,-0.46170453,0.62753417,1.0045783,1.2140473,1.2559411,1.0883659,0.54374658,0.45995899,0.60658727,0.56469348,0.52279968,0.58564038,1.067419,0.71132177,0.37617139,-0.16844795,-0.50359833:1
-0.98574055,-1.2747199,-1.4481075,-1.5636992,-1.6214951,-1.4481075,-1.1783935,-0.38851662,0.74813535,1.0949105,1.191237,1.0949105,0.84446179,0.49768661,0.55548247,0.55548247,0.69033949,0.97931881,0.96005352,0.88299237,0.40136017,0.15091143,-0.21512903,-0.52337364:1
-0.99421379,-1.3011094,-1.4737381,-1.6080049,-1.588824,-1.4929191,-1.1092996,-0.22697485,0.46354019,1.0006074,1.1924172,1.2307791,1.0197884,0.54026408,0.55944506,0.52108311,0.597807,0.63616895,0.94306452,1.0389694,0.57862603,0.23336851,-0.22697485,-0.53387043:1
-0.74924199,-1.2468935,-1.3796006,-1.5123077,-1.6450147,-1.4127774,-0.91512583,0.047000427,0.27923779,1.1750105,1.3077176,1.0091267,0.81006607,0.11335396,-0.35112078,-0.18523695,-0.11888342,0.44512163,1.3740711,1.539955,1.0423034,0.61100547,0.17970749,-0.41747432:1
-0.31032911,-0.80685567,-1.262005,-1.3033822,-1.3861367,-1.3861367,-1.0964962,-0.80685567,0.51721518,1.6344,1.9240405,1.7585316,1.3033822,0.51721518,0.020688607,-0.062065821,-0.14482025,-0.26895189,-0.35170632,-0.22757468,0.062065821,1.0137417,0.47583796,0.18619746:2
1.1545687,0.21978536,-0.11406582,-0.38114676,-0.98207888,-0.78176817,-1.8500919,-1.9168622,-0.84853841,-0.18083605,0.21978536,0.68717701,0.55363654,0.15301512,-0.18083605,-0.38114676,-0.58145747,-0.58145747,-0.18083605,0.019474644,0.55363654,2.1561222,1.822271,1.4216496:2
-0.793748,-1.111729,-1.5164321,-1.5453394,-1.5742468,-1.4008026,-1.0250069,-0.59139646,0.42036122,1.1430453,1.2586748,1.2586748,0.82506429,0.24691705,0.18910232,-0.12887866,0.015658147,0.7383422,1.2875821,1.2586748,0.96960111,0.50708331,-0.013249216,-0.41795229:1
-1.0799681,-1.351702,-1.4980202,-1.6025333,-1.5607281,-1.456215,-1.0381629,-0.53650027,0.52953273,1.0939032,1.1148058,1.1148058,0.90577967,0.50863012,0.57133794,0.63404577,0.69675359,0.52953273,0.57133794,1.1775136,0.73855881,0.50863012,-0.11844811,-0.45288984:1
-0.99286946,-1.3232861,-1.537085,-1.5953938,-1.5565213,-1.4787762,-1.0123057,-0.21541866,0.34823317,0.89244873,1.0868114,0.93132127,0.83413992,0.54259587,0.60090468,0.60090468,0.81470365,1.125684,1.1062477,0.98963008,0.54259587,0.19274301,-0.19598239,-0.70132541:1
0.31992897,-0.69037301,-1.195524,-0.79140321,-1.195524,-1.195524,-0.8924334,-1.5996448,-0.8924334,0.31992897,1.4312611,1.2292007,0.92611014,0.21889877,-0.084191824,-0.48831261,0.11786857,-0.18522202,0.21889877,0.016838372,-0.38728241,2.1384725,1.6333215,1.0271403:2
-0.96196967,-1.320259,-1.566583,-1.6337622,-1.6113691,-1.4546175,-1.0067558,-0.20060475,0.73990489,1.1205873,1.0086219,0.76229798,0.76229798,0.49358094,0.40400859,0.40400859,0.47118785,0.78469106,1.299732,1.2325528,0.67272563,0.31443625,-0.22299783,-0.49171487:1
-0.78931737,-1.1652975,-1.4255915,-1.3966699,-1.5123561,-1.3099053,-1.5701992,-0.76039582,0.54107402,1.2062697,1.2930344,1.2641128,1.0038189,0.801368,0.65676023,0.88813265,1.1195051,0.65676023,0.51215247,0.16509385,-0.12412167,-0.18196477,0.2518585,-0.12412167:2
-0.50387394,-0.95787642,-1.2880601,-1.4944248,-1.5356978,-1.370606,-1.0816953,-0.66896575,-0.13241739,-0.2975092,0.32158509,0.6517687,0.8994064,0.32158509,-0.091144431,-0.17369034,-0.25623625,0.52794985,1.4359548,1.8074114,1.5597737,1.3534089,0.69304164,0.28031213:1
-0.25357747,-0.89419425,-1.1744641,-1.3746568,-1.4947725,-1.3346183,-1.6949652,-0.9342328,0.50715495,1.3479645,1.7483499,1.7083114,1.1477717,0.74738624,0.10676946,-0.053384728,0.066730917,0.066730917,0.026692369,0.22688511,0.14680801,0.90754043,0.50715495,-0.053384728:2
-0.63096648,-1.0184892,-1.3165836,-1.4358214,-1.5550591,-1.346393,-1.6742969,-0.69058536,0.20369784,1.1874094,1.2470282,1.2768377,1.1277905,0.77007719,0.82969607,1.0085527,0.94893383,0.85950551,0.4719828,0.26331672,-0.15401544,-0.24344376,0.05465064,-0.18382488:2
0.018950483,-0.72528672,-1.0974053,-1.2214449,-1.2627914,-1.1800984,-0.93201927,-1.1800984,-0.68394021,0.18433653,0.68049466,0.92857373,0.63914815,0.22568304,-0.10508905,-0.2704751,-0.55990068,-0.60124719,-0.06374254,1.7141575,1.9622366,1.7141575,1.1353063,0.68049466:1
-0.82192428,-1.2133167,-1.3698737,-1.5264307,-1.5264307,-1.3437809,-1.5525236,-0.4566246,0.32616042,1.2394096,1.2394096,1.2915952,1.0045741,0.84801708,0.97848125,0.84801708,0.97848125,0.69146008,0.27397474,0.30006758,0.091324905,-0.11741777,-0.091324931,-0.091324931:2
-0.71701739,-1.0964155,-1.421614,-1.5571133,-1.5029136,-1.4487138,-1.5842132,-0.74411726,0.39407727,1.2341732,1.288373,1.1799735,1.071574,0.7192757,0.69217583,0.99027439,0.74637557,0.74637557,0.47537687,0.33987753,0.041778957,-0.14792013,0.28567778,0.014679088:2
-0.70034067,-1.0570129,-1.4582691,-1.5920212,-1.5474371,-1.4582691,-1.1015969,-0.92326079,0.28050781,1.1276042,1.2167723,1.3951084,1.2167723,0.77093206,0.68176402,0.77093206,0.94926815,0.59259597,0.23592379,0.19133976,0.32509183,0.63717999,0.057587704,-0.61117263:2
-0.65390468,-1.0026538,-1.2879941,-1.5733343,-1.7318566,-1.6684477,-1.2879941,-0.65390468,0.36063835,1.216659,1.2800679,1.3117724,0.83620538,0.6142741,0.6142741,0.89961432,0.89961432,0.58256963,0.23382047,0.07529812,0.17041152,0.96302326,0.17041152,-0.36856445:2
-1.0439193,-1.3207598,-1.577826,-1.5976003,-1.5976003,-1.3998571,-1.0439193,-0.11452627,0.75554382,1.0521586,1.0521586,0.81486678,0.67644654,0.39960605,0.36005741,0.43915469,0.53802629,1.1905789,1.2499018,1.0323843,0.55780061,0.30073445,-0.11452627,-0.60888427:1
-0.87894469,-1.3678131,-1.5878039,-1.6611342,-1.710021,-1.3433697,-0.90338811,-0.43896311,0.56321716,1.1743027,1.1254159,1.1743027,0.85653821,0.46544348,0.41655664,0.46544348,0.58766057,0.4898869,0.53877374,1.2965198,0.85653821,0.44100006,-0.19452889,-0.36563284:1
-0.15082924,-0.68428846,-1.103435,-1.2939562,-1.3701646,-1.3320604,-1.103435,-1.0653308,-0.95101807,-0.18893347,0.5350469,0.80177651,0.80177651,0.26831729,-0.074620776,-0.18893347,-0.30324616,-0.2270377,1.2971315,1.716278,1.716278,1.4876527,0.87798497,0.5350469:1
-0.89984354,-1.2377248,-1.3785087,-1.5756061,-1.462979,-1.462979,-1.462979,-0.59011904,0.28274093,1.1274441,1.1274441,1.2963848,1.0711306,0.78956284,0.81771962,0.90218994,1.0429738,0.70509253,0.45168157,0.3108977,-0.08329712,0.057486745,0.22642738,-0.055140347:2
-0.82552207,-1.2348718,-1.4190792,-1.6032866,-1.6442216,-1.4804817,-1.0097294,-0.10915994,1.0779544,1.3235643,1.2621618,1.0574869,0.85281203,0.38205979,0.42299477,0.40252728,0.23878737,0.77094208,1.0574869,0.91421451,0.50486472,0.054579967,-0.29336734,-0.70271714:1
-1.0285305,-1.2822649,-1.427256,-1.6084949,-1.5722471,-1.4453799,-1.1735216,-0.35794674,0.72948639,1.0375925,1.110088,1.0919641,0.92884913,0.53012366,0.54824754,0.65699085,0.72948639,1.0013447,1.0013447,0.76573416,0.36700869,0.20389371,-0.21295566,-0.59355725:1
-1.0233394,-1.3325498,-1.5534144,-1.5975874,-1.6417603,-1.4429821,-1.0012529,0.080983683,0.54479938,1.1632203,1.052788,0.8760963,0.67731815,0.3018483,0.34602122,0.36810768,0.52271292,0.65523169,1.3619985,1.2073932,0.78775046,0.36810768,-0.18405385,-0.53743724:1
-1.037707,-1.2863741,-1.5541695,-1.4967847,-1.5924259,-1.4585283,-1.0950917,-0.32996213,0.798604,1.1046558,1.1237841,1.0281429,0.8942452,0.49255217,0.51168041,0.54993689,0.72209104,0.8942452,1.0472711,0.93250168,0.41603921,0.1673721,-0.31083389,-0.52124453:1
-0.67224738,-1.0071027,-1.3115166,-1.4028407,-1.4637235,-1.3723994,-1.5550477,-0.82445433,0.45408408,1.2760016,1.3673258,1.3368844,1.0933533,0.72805659,0.84982215,0.97158772,1.0020291,0.72805659,0.3932013,0.088787391,-0.093860953,-0.30695069,-0.15474374,-0.12430234:2
-0.99302489,-1.2993564,-1.4218891,-1.5648438,-1.6669543,-1.5239996,-1.0951354,-0.38036172,0.66116565,1.110452,1.2125625,1.0287636,0.96749723,0.49778881,0.51821091,0.62032144,0.70200986,0.57947723,0.57947723,1.110452,0.70200986,0.37525617,-0.15571856,-0.56416067:1
-0.92542174,-1.2321208,-1.5388198,-1.4877033,-1.5132616,-1.5388198,-1.257679,-0.18423241,0.63363169,1.3237045,1.4003793,1.2981463,0.96588896,0.42916566,0.48028217,0.58251518,0.65918994,0.48028217,0.22469964,0.42916566,0.8380977,0.60807343,-0.1331159,-0.54204795:2
-0.97836169,-1.3087846,-1.515299,-1.5979047,-1.6185562,-1.4533447,-1.1229217,-0.17295576,0.50854157,1.2726446,1.3552504,1.3345989,1.0454789,0.77701021,0.50854157,0.63245017,0.73570734,0.529193,0.42593583,0.38463296,0.28137579,0.42593583,-0.0077442896,-0.44142441:2
-1.0408681,-1.3752572,-1.4932769,-1.6112966,-1.5916266,-1.4932769,-1.0211981,-0.077040621,0.5917376,0.96546661,0.96546661,0.84744692,0.72942723,0.33602828,0.39503812,0.49338786,0.65074744,1.0638163,1.201506,1.1621661,0.72942723,0.31635833,-0.096710568,-0.6474691:1
-0.92201869,-1.2372949,-1.4540473,-1.6510949,-1.6116854,-1.473752,-1.1978854,-0.37028533,0.39820041,1.0090481,1.1469814,1.0484576,0.94993377,0.47701946,0.59524804,0.71347662,0.73318138,0.67406709,1.0484576,1.0681623,0.53613375,0.22085755,-0.21264723,-0.48851391:1
-0.86434203,-1.1362189,-1.4352835,-1.5168466,-1.5440343,-1.4624712,-1.5168466,-0.67402818,0.65816869,1.0387964,1.1475471,1.1475471,1.0931717,0.68535638,0.79410715,0.98442099,1.0116087,0.73973176,0.49504254,0.25035332,0.0056641013,0.0056641013,0.16879025,-0.075898973:2
-0.41331946,-0.8693961,-0.90740249,-1.2874664,-1.4014855,-1.4774983,-1.2874664,-1.0214216,-0.98341526,-0.45132584,0.15677635,0.5748466,0.72687215,0.38481467,0.15677635,-0.14727475,0.15677635,1.106936,1.3729807,1.5630127,1.6390254,1.2209552,0.72687215,0.46082744:1
-0.63519891,-1.1413731,-1.4688975,-1.5879973,-1.7070971,-1.4688975,-1.0818232,-0.21834962,0.49624916,1.0619732,1.2703978,1.0619732,0.76422371,0.16872472,-0.18857467,-0.039699919,0.049624928,1.0917481,1.181073,1.2703978,0.91309845,0.49624916,0.19849967,-0.48632416:1
0.46615603,2.4722222E-9,-0.81577306,-1.1653901,-1.2819291,-1.1071206,-0.99058157,-1.6315461,-0.75750355,0.058269506,0.58269504,0.99058157,0.69923405,2.4722222E-9,-0.29134752,0.058269506,-0.34961702,-0.29134752,-0.52442554,0.11653901,0.64096454,2.3307802,1.8646241,1.3984681:2
-0.85344603,-1.2349632,-1.4734115,-1.4495667,-1.4972563,-1.4257218,-1.544946,-0.66268743,0.52955382,1.1256745,1.1256745,1.3164331,1.1495193,0.81569171,0.64877793,0.83953653,0.93491583,0.69646758,0.33879521,0.12419179,0.10034696,0.36264004,0.21957109,-0.18579094:2
1.2522146,0.1487512,-0.24070649,-0.69507379,-0.82489301,-0.88980265,-1.7985372,-1.7985372,-1.0196219,-0.43543533,0.27857044,0.79784736,0.47329929,0.1487512,-0.11088726,-0.37052571,-0.50034494,-0.43543533,-0.37052571,0.083841592,1.5767627,1.3820339,1.7065819,1.6416723:2
-0.94394329,-1.1081073,-1.5595585,-1.662161,-1.580079,-1.6416405,-1.2312304,-0.14364353,0.45145115,1.0055048,1.1286278,1.1491483,1.0670663,0.55405368,0.57457418,0.71821773,0.73873823,0.51301267,0.73873823,0.9439433,0.59509469,0.26676659,-0.18468455,-0.38988961:1
-0.021442477,-0.75048629,-1.0935657,-1.1364506,-1.3937602,-1.3937602,-1.0935657,-0.70760136,-1.0506808,0.10721232,0.75048627,0.92202599,0.70760134,0.064327383,-0.32163699,-0.36452192,-0.49317671,-0.27875206,0.92202599,1.7797246,1.8654945,1.4366452,0.87914106,0.66471641:1
0.61273647,-0.22758785,-0.8278195,-1.1879585,-1.3080048,-1.1279353,-2.1483291,-1.4280511,0.13255115,1.4530608,1.6931535,1.873223,1.0929218,0.25259748,-0.22758785,0.012504818,0.25259748,-0.10754152,0.072527984,0.012504818,-0.10754152,0.012504818,0.9128523,0.31262064:2
-1.0560869,-1.1913381,-1.3536396,-1.4888909,-1.5429914,-1.5159411,-1.2183884,-0.19047884,0.64807892,1.2161342,1.4054859,1.4325362,1.1349834,0.81038042,0.59397841,0.56692816,0.53987791,0.21527491,-0.0011270849,0.21527491,0.81038042,0.59397841,-0.10932809,-0.51508183:2
-0.80377593,-1.1948021,-1.4033493,-1.4815546,-1.4554861,-1.3251441,-1.5597598,-0.77770752,0.57784972,1.3077652,1.359902,1.4381072,0.94280745,0.65605495,0.78639699,0.78639699,0.8124654,0.55178132,0.36930246,0.1868236,0.030413141,0.212892,0.26502882,-0.28240776:2
-0.94289611,-1.2949106,-1.445774,-1.4960618,-1.5966374,-1.5714935,-1.1691912,-0.54059376,0.59088156,1.3200545,1.2446228,1.2446228,1.0434717,0.74174494,0.76688884,0.81717663,0.71660104,0.33944261,0.31429871,0.13829144,0.11314754,0.66631325,0.26401092,-0.26401091:2
-0.89934535,-1.2423719,-1.4798519,-1.6645585,-1.6645585,-1.4798519,-1.1368253,-0.71463873,0.41998768,1.2907475,1.2115875,1.1324275,0.94772089,0.63108097,0.60469431,0.78940093,0.71024095,0.60469431,0.41998768,0.3408277,0.28805438,0.84217425,0.23528106,-0.18690551:2
-0.9059747,-1.3996752,-1.5436712,-1.6053837,-1.6876672,-1.4819586,-0.96768726,-0.10371139,0.53398509,1.0482564,0.96597303,0.94540217,0.69855192,0.3488474,0.43113082,0.49284338,0.76026448,0.86311875,1.2128233,1.1305399,0.67798107,0.30770569,-0.10371139,-0.61798274:1
-0.85704647,-1.0843295,-1.4252541,-1.5388956,-1.4820748,-1.4252541,-1.0275088,-0.80022571,0.10890646,1.1316801,1.5294255,1.415784,1.2453217,0.9043971,0.73393482,0.3361895,0.79075557,0.44983102,0.27936874,0.052085696,-0.57294267,0.84757634,0.39301026,-0.004735064:2
0.063916924,-0.46505072,-0.99401837,-0.99401837,-1.311399,-1.0469151,-0.67663778,-0.35925719,-1.0998119,-0.83532808,0.80447163,0.75157486,1.0689555,0.43419428,-0.2005669,-0.2005669,-0.57084425,-0.51794749,-0.46505072,0.011020159,1.4392328,2.4442713,1.7566134,0.96316192:1
-1.015474,-1.2432439,-1.5165677,-1.5848987,-1.6304527,-1.4710138,-1.1293589,-0.35494138,0.62446905,0.8977929,0.98890085,0.85223892,0.715577,0.39669919,0.32836823,0.44225317,0.51058412,1.1255628,1.2850017,1.1711168,0.69280001,0.44225317,0.0094904115,-0.53715728:1
1.1290823,0.28227057,0.094090188,-0.094090191,-0.094090191,-0.094090191,-0.094090191,-1.5995332,-1.2231725,-0.75272152,-0.094090191,-0.28227057,-1.3402778E-9,-0.47045095,-0.75272152,-0.75272152,-0.56454114,-0.56454114,-0.56454114,-0.18818038,0.094090188,2.3522547,2.2581646,1.975894:2
-0.91770709,-1.1807632,-1.5633903,-1.6590471,-1.6351329,-1.5394761,-1.0611923,-0.46333745,0.61280116,0.99542823,1.1389134,1.1867418,0.8041147,0.54105859,0.5171444,0.63671536,0.54105859,0.32583086,0.42148763,1.2584843,0.94759985,0.5171444,-0.0089678139,-0.41550906:1
-0.84106758,-1.3051049,-1.5661258,-1.5661258,-1.5081212,-1.5371235,-1.1310909,-0.58004661,0.31902563,1.1310909,1.2761025,1.2761025,1.1020886,0.84106758,0.69605593,0.75406059,0.84106758,0.2900233,0.02900233,-5.0885222E-17,0.31902563,0.81206525,0.49303962,-0.14501165:2
-1.0451395,-1.2187267,-1.5080387,-1.5659011,-1.7973507,-1.5080387,-1.2476579,-0.43758437,0.25676438,1.1825627,1.2114939,0.95111314,0.95111314,0.31462678,0.66180116,0.77752595,0.89325074,0.71966355,0.40142037,0.51714517,0.48821397,0.66180116,0.37248918,-0.0325476:2
-0.95573343,-1.3512093,-1.5593545,-1.5593545,-1.6842416,-1.4760964,-1.1222496,-0.20641067,0.60535565,1.1049041,1.1257187,1.0840896,1.0424606,0.50128304,0.459654,0.52209756,0.52209756,0.459654,0.73024277,1.1465332,0.70942825,0.459654,-0.16478163,-0.39374137:1
-0.93792522,-1.3634106,-1.5052391,-1.5457615,-1.5660228,-1.4039331,-1.2215822,-0.30982768,0.80453891,1.0274122,1.0476734,0.9666286,0.80453891,0.43983712,0.37905349,0.54114317,0.70323286,1.1287183,1.1287183,0.9666286,0.48035954,0.19670259,-0.22878284,-0.532701:1
-0.18866599,-1.0665404,-1.3437639,-1.6209874,-1.6671913,-1.5285796,-0.97413258,-0.41968558,0.78161627,1.2898593,1.6594907,1.5670828,0.92022802,0.31957709,-0.14246208,-0.050054241,-0.0038503234,-0.14246208,-0.096258158,0.13476142,0.73541235,1.2436554,0.73541235,-0.14246208:2
-1.0085048,-1.302652,-1.4917466,-1.5757887,-1.5757887,-1.4287151,-1.1555784,-0.18909465,0.651326,1.1975994,1.1765889,1.0085048,0.75637858,0.42021032,0.39919981,0.44122084,0.44122084,0.42021032,1.1555784,1.260631,0.7773891,0.31515774,-0.14707361,-0.54627342:1
-0.94278376,-1.2707086,-1.560054,-1.617923,-1.5986333,-1.4828952,-1.1742601,-0.2290651,0.6582608,1.1019237,1.1597928,1.082634,0.88973712,0.40749478,0.42678448,0.46536386,0.56181233,0.73541957,1.1597928,0.98618558,0.58110202,0.23388754,-0.2290651,-0.34480326:1
-0.97818482,-1.3299796,-1.4941504,-1.6114154,-1.6583213,-1.4003385,-1.0016378,-0.29804832,0.71042994,0.99186573,0.92150678,0.87460081,0.64007099,0.42899414,0.26482326,0.40554116,0.42899414,0.49935309,1.3202075,1.5312843,0.8980538,0.38208818,-0.040065512,-0.48567218:1
-1.0743673,-1.3645502,-1.5510963,-1.5718236,-1.592551,-1.4060049,-1.0743673,-0.39036499,0.56309285,1.2056405,1.2263679,0.97763974,0.97763974,0.50091082,0.5838202,0.5838202,0.60454754,0.16927331,0.33509207,1.2263679,0.87400302,0.52163817,0.024181904,-0.3489103:1
-0.96145113,-1.267213,-1.5118224,-1.5933589,-1.5933589,-1.5322066,-1.1652924,-0.20723858,0.75081519,1.1992659,1.2604183,1.0361929,0.77119932,0.36351686,0.36351686,0.42466923,0.42466923,0.62851046,1.1381135,1.056577,0.60812633,0.32274861,-0.084933846,-0.43146393:1
0.44637513,-0.33750315,-0.80783011,-1.0691229,-1.17364,-1.17364,-0.86008866,-0.54653736,-0.96460577,-0.023951837,0.55089224,0.81218498,0.65540934,0.080565265,-0.18072749,-0.54653736,-0.80783011,-0.75557156,-0.49427881,0.34185803,2.327683,2.0663903,1.4915462,0.96896064:2
1.5222307,0.64286766,-0.076611165,-0.31643745,-0.55626372,-0.31643745,-1.5955109,-1.9152793,-1.1158584,-0.31643745,0.56292556,0.56292556,0.80275184,0.083273018,-0.47632163,-0.39637954,-1.1158584,-0.55626372,-0.47632163,-0.15655326,0.40304138,0.88269393,1.7620569,2.1617674:2
0.15445788,-0.4365114,-1.0812052,-1.1886541,-1.2423786,-1.0274807,-1.0274807,-1.5647255,-0.97375619,-0.060440039,0.42308028,1.067774,1.0140496,0.3693558,0.04700892,0.1007334,-0.32906244,-0.49023588,-0.22161348,0.20818236,1.1214985,1.8736413,1.8736413,1.3901209:2
0.72173067,0.10530591,-0.51111885,-0.88097371,-1.0042587,-0.94261619,-1.559041,-1.7439684,-0.88097371,-0.017979051,0.47516076,0.84501562,1.029943,0.35187581,-0.26454895,-0.26454895,-0.32619143,-0.44947638,-0.44947638,-0.141264,0.78337314,0.84501562,2.2011501,2.0778651:2
-1.1569093,-1.3669382,-1.3669382,-1.5559642,-1.5559642,-1.5349614,-1.0728977,-0.44281099,0.56532784,0.83836544,1.0483944,1.111403,1.111403,0.54432495,0.52332206,0.60733363,0.6703423,0.6703423,1.111403,1.0063886,0.58633073,0.29229025,-0.12776759,-0.50581967:1
-0.91662145,-1.2836099,-1.5078805,-1.5894335,-1.6098218,-1.4671041,-1.1001157,-0.080703464,0.59210859,1.04065,1.1018147,1.0610382,0.81637925,0.38822615,0.32706141,0.44939088,0.42900263,0.81637925,1.2853089,1.1629794,0.65327332,0.26589668,-0.1418682,-0.69235076:1
-0.29987073,-0.72074194,-1.1837003,-1.3099616,-1.436223,-1.3099616,-0.8470033,-0.8470033,-1.0574389,-0.17360937,0.45769743,0.54187167,0.45769743,-0.13152225,-0.34195785,-0.25778361,-0.089435131,0.54187167,1.3836141,1.7623982,1.6782239,1.5940497,0.96274288,0.62604592:1
-0.73408063,-1.3121691,-1.5323933,-1.6700334,-1.6149774,-1.3947532,-1.0093609,-0.48632842,0.6973766,1.3855772,1.4406332,1.2754651,0.97265683,0.53220845,0.72490462,0.72490462,0.77996067,0.39456834,0.17434415,0.1192881,0.064232057,0.66984857,0.14681613,-0.3486883:2
-0.73793957,-1.1571242,-1.4365806,-1.4715126,-1.5064447,-1.4365806,-0.98246392,-0.91259982,0.37988605,1.1483912,1.3929155,1.2881194,1.1134591,0.86893475,0.9038668,0.93879885,1.008663,0.7641386,0.4148181,0.10042965,-0.28382291,-0.21395881,0.10042965,-0.28382291:2
-0.18665969,-0.59057905,-1.251538,-1.7288973,-1.3984178,-1.5452976,-1.1413782,-0.076499872,0.54773913,1.245418,1.6493374,1.3188579,0.95165849,-0.03977993,-0.22337964,-0.14993975,-0.33353946,-0.3702594,-0.0030599886,1.5758975,1.3188579,0.73133884,0.033659953,-0.33353946:1
-0.45496416,-0.88679454,-1.2569349,-1.6270752,-1.6887653,-1.6887653,-1.0101747,-0.88679454,0.34700656,0.96390711,1.3340475,1.3957375,1.5808077,0.84052701,0.59376679,0.59376679,0.59376679,0.40869662,0.28531651,0.10024634,-0.64003433,0.65545684,0.34700656,0.10024634:2
-0.78366178,-1.1714532,-1.4761464,-1.5038458,-1.6146434,-1.448447,-1.5038458,-0.70056363,0.51820933,1.210694,1.2383934,1.1552952,1.0444977,0.54590871,0.62900687,0.82290257,0.82290257,0.60130749,0.43511117,0.2135161,-0.0080789912,0.73980441,0.43511117,-0.20197469:2
-1.173104,-1.4537135,-1.4225347,-1.3913559,-1.4225347,-1.4537135,-1.3289982,-0.58070594,0.51055355,1.2588458,1.5082765,1.1653092,0.94705734,0.60409008,0.51055355,0.63526892,0.75998429,0.41701702,0.16758628,0.011692072,0.54173239,0.85352082,0.32348049,0.011692072:2
-1.1834923,-1.3923439,-1.4758845,-1.6011955,-1.6220807,-1.6011955,-0.93287042,0.02784688,0.570861,0.98856417,0.96767902,0.86325322,0.69617195,0.34112426,0.27846878,0.40377973,0.54997584,0.61263132,1.2809564,1.2600712,0.84236806,0.50820553,0.0069617222,-0.38985629:1
-0.63849391,-1.0736541,-1.322317,-1.4155656,-1.4155656,-1.4155656,-1.5088142,-0.88715686,0.13857778,1.1021467,1.2264782,1.3197268,1.1021467,0.76023514,0.88456661,1.0088981,1.0710638,0.88456661,0.6048208,0.26290925,-0.20333376,-0.17225089,0.014246307,-0.32766523:2
-0.073624278,-0.62580632,-0.73624273,-1.2332065,-1.5645157,-1.5645157,-0.84667913,-0.73624273,-0.18406069,-0.23927889,0.64421237,1.1963944,0.47855776,0.42333956,-0.90189733,-0.90189733,-0.79146093,0.9203034,1.4172672,1.4172672,1.7485764,0.9203034,0.9755216,0.25768495:1
-0.41057879,-1.0114258,-1.2117081,-1.371934,-1.6923857,-1.4119905,-1.1716517,0.47066349,0.71100229,1.3118493,1.4320187,0.91128463,0.59083289,0.15021175,-0.29040939,-0.41057879,-0.33046585,-0.21029645,-0.13018352,1.5922446,1.6723575,0.83117169,0.19026822,-0.21029645:1
-0.82682528,-1.2016788,-1.6233889,-1.763959,-1.6702456,-1.4828189,-1.1079654,-0.10054664,0.60230365,1.2114406,1.1411555,1.0474422,0.90687211,0.36802022,0.43830525,0.4617336,0.50859028,0.32116354,0.4617336,1.3285823,0.7897304,0.50859028,-0.030261612,-0.28797338:1
-0.53492435,-0.88826888,-1.3201344,-1.3593949,-1.5556974,-1.3986554,-0.96678989,-0.024537821,0.52510923,1.4281008,1.5851428,1.1532773,0.91771425,0.28954621,-0.14231932,-0.37788234,-0.41714284,-0.33862184,-0.26010083,1.6636638,1.4281008,0.64289073,0.28954621,-0.33862184:1
-1.0942168,-1.3465079,-1.5529278,-1.5758634,-1.64467,-1.4611856,-1.0483457,-0.47495702,0.48833607,1.1075959,1.1993381,1.0846604,0.92411151,0.46540052,0.41952943,0.58007827,0.60301382,0.44246497,0.48833607,1.1993381,0.87824041,0.46540052,0.052560627,-0.19973042:1
-0.89592832,-1.147417,-1.5246499,-1.6503943,-1.7132664,-1.3989056,-1.147417,-0.77018399,0.047154129,0.67587576,0.99023657,1.178853,1.0531087,0.80162008,0.61300359,0.67587576,0.55013143,0.55013143,0.29864278,0.17289846,-0.14146237,1.178853,1.1159809,0.48725927:2
-0.70296509,-0.93133954,-1.2739012,-1.5593693,-1.6735565,-1.8162905,-1.2168076,-0.70296509,0.32471992,1.3809517,1.1811241,1.3238581,1.0383901,0.7243752,0.69582839,0.7243752,0.83856242,0.66728159,0.35326672,0.12489228,0.32471992,0.41036033,0.15343908,-0.38895023:2
-1.0443849,-1.3250464,-1.5193506,-1.5841186,-1.6272973,-1.5409399,-1.1523316,-0.18081084,0.48845906,1.0497822,1.157729,1.1145503,0.94183545,0.57481647,0.63958452,0.66117387,0.48845906,0.40210166,0.46686971,1.0929609,0.83388868,0.46686971,0.078261385,-0.48306175:1
-0.80765223,-1.2168058,-1.4469547,-1.523671,-1.5492431,-1.523671,-1.4725268,-0.5519312,0.72667388,1.1102554,1.3148322,1.1613996,0.72667388,0.72667388,0.88010648,0.93125069,0.95682279,0.62438547,0.41980866,0.24080395,-0.040489173,0.061799234,0.39423656,-0.14277759:2
-0.71559963,-1.1904676,-1.3751385,-1.5334278,-1.5861909,-1.40152,-1.6125724,-0.63645497,0.3396625,0.99920133,1.1311091,1.2366353,1.0519644,0.76176735,0.81453046,0.94643822,0.97281978,0.7881489,0.57709648,0.26051784,-0.029679244,-0.056060799,0.41880716,-0.16158701:2
-0.87502834,-1.2123887,-1.3810688,-1.4935223,-1.5216356,-1.2967287,-1.5778624,-0.84691498,0.50252632,1.177247,1.177247,1.2897004,1.0647935,0.7274332,0.7274332,0.95234008,0.98045344,0.5868664,0.33384615,0.19327935,0.16516599,0.24950607,0.24950607,-0.17219433:2
1.8225767,0.73175771,-0.031815555,-0.57722502,-0.46814313,-0.46814313,0.07726634,-0.79538881,-1.3407983,-0.031815555,-0.14089745,-0.031815555,-0.14089745,-0.35906124,-0.79538881,-0.57722502,-0.79538881,-0.79538881,-0.79538881,-0.46814313,-0.14089745,2.1498223,2.2589042,1.7134948:2
-0.58905468,-0.66346158,-1.1843099,-1.4075306,-1.5563445,-1.519141,-1.2215134,-0.51464777,0.41543856,1.3083214,1.4571352,1.1967111,0.82467655,0.22942129,-0.3286305,-0.14261324,-0.10540978,0.04340403,0.37823511,1.8291698,1.271118,0.75026964,0.11781094,-0.58905468:1
0.28280384,-0.28712145,-0.59798979,-1.1161037,-1.2197265,-0.96066953,-0.85704675,-0.49436701,-0.28712145,-0.90885814,-0.33893284,-0.23531006,0.23099245,0.075558273,-0.85704675,-0.80523536,-0.49436701,-0.079875895,1.7853342,1.9407683,1.8889569,1.7335228,1.1635975,0.43823801:1
-1.0267233,-1.284523,-1.4778728,-1.5208394,-1.6067727,-1.5208394,-1.284523,-0.10294087,0.73490828,1.1860578,1.3149577,1.1430912,0.9497414,0.73490828,0.62749172,0.5845251,0.52007517,0.3911753,0.30524205,0.97122471,0.60600841,0.26227543,-0.081457554,-0.42519054:1
-0.59779462,-1.0988871,-1.3889933,-1.3889933,-1.4417399,-1.2307536,-1.4417399,-0.59779462,0.40439047,1.353829,1.4329488,1.4593221,1.2483358,0.85273642,0.905483,0.74724325,0.85273642,0.66812338,0.37801718,-0.043955499,-0.38680829,-0.41318158,-0.017582207,-0.25494184:2
-1.0567083,-1.3842111,-1.5684314,-1.5889004,-1.6503071,-1.4660868,-1.0976461,-0.17654449,0.51939899,1.1334668,1.0925289,1.1539357,0.90830858,0.51939899,0.56033684,0.72408825,0.66268147,0.51939899,0.47846114,0.92877751,0.78549503,0.47846114,-0.012793088,-0.46310947:2
-0.97649311,-1.4036122,-1.4593233,-1.6264569,-1.5521753,-1.3850418,-1.1250563,-0.2708182,0.49056787,1.1033908,1.2705243,1.2519539,0.95482768,0.47199749,0.4534271,0.60199023,0.6577014,0.58341983,1.0105388,0.95482768,0.49056787,0.212012,-0.19653663,-0.5122333:1
-1.0193352,-1.3401751,-1.5206476,-1.5407001,-1.6008576,-1.4805426,-1.1195977,-0.47791782,0.56481197,1.0059669,1.1463343,1.0661244,0.90570439,0.54475947,0.58486446,0.76533692,0.82549441,0.62496945,0.66507444,1.0861769,0.68512694,0.20386704,-0.13702539,-0.43781283:1
-0.77293033,-1.1715763,-1.3576111,-1.4639167,-1.5436459,-1.3841875,-1.7031043,-0.66662473,0.47616051,1.1139941,1.1937233,1.1671469,1.0342649,0.63561891,0.76850092,1.0342649,1.0342649,0.71534812,0.3432785,0.47616051,0.1040909,-0.1085203,0.2103965,-0.1350967:2
-0.91741201,-1.1095881,-1.3841254,-1.4939403,-1.4664866,-1.4115791,-1.5488477,-0.80759711,0.42782057,1.1141637,1.1965249,1.2788861,1.08671,0.70235783,0.89453392,0.83962647,0.94944137,0.78471901,0.51018175,0.20819076,-0.066346499,-0.066346499,0.29055194,-0.011439048:2
-0.42855784,-0.93336218,-1.2804152,-1.6905687,-1.5328174,-1.5328174,-1.0595633,-0.27080649,0.77035247,1.3382573,1.3698076,1.3698076,0.80190274,0.13934704,-0.20770594,-0.27080649,-0.11305513,0.17089731,1.180506,1.3382573,0.99120437,0.39174921,-0.018404309,-0.52320866:1
-1.0335555,-1.2812278,-1.4717449,-1.6432104,-1.6622621,-1.3574346,-1.0145038,-0.27148693,0.75730564,1.0049779,1.0430814,0.89066763,0.87161591,0.50963336,0.41437478,0.58584021,0.7001505,1.0430814,1.0811848,1.0240296,0.54773678,0.24290936,-0.29053864,-0.69062462:1
-0.98579752,-1.0502638,-1.4585505,-1.6734383,-1.6519495,-1.5874832,-1.1791965,-0.1692241,0.56139422,1.2060574,1.2705238,1.1415911,1.0126585,0.4969279,0.45395035,0.4969279,0.582883,0.45395035,0.51841668,1.1415911,0.69032688,0.34650648,-0.23369042,-0.38411184:1
0.97395041,0.35062215,-0.39737177,-0.7090359,-0.77136873,-1.2700313,-2.1426909,-1.4570298,-0.77136873,0.038958012,-0.023374815,0.53762063,0.53762063,0.038958012,-0.33503894,-0.27270612,-0.39737177,-0.27270612,-0.085707642,0.10129084,1.0362832,1.3479474,2.1582741,1.7842772:2
-0.79504357,-1.2624466,-1.5098953,-1.6198725,-1.6473668,-1.4274124,-1.0424922,-0.71256066,0.60716582,1.2945233,1.2395347,1.1845461,1.0195803,0.60716582,0.5796715,0.66215442,0.85461453,0.79962593,0.5246829,0.4147057,-0.025203122,0.5796715,0.11226839,-0.43761765:2
-0.96859644,-1.2707769,-1.4866201,-1.5513731,-1.5729574,-1.4218672,-1.1196867,-0.51532569,0.56389039,1.2330044,1.340926,1.2330044,1.0603298,0.43438446,0.45596878,0.62864336,0.54230607,0.52072175,0.3696315,1.0171612,0.77973361,0.34804717,-0.10522358,-0.51532569:1
-1.0304051,-1.4422239,-1.2363145,-1.6275424,-1.5657696,-1.4628149,-1.0921779,-0.062630775,0.41096089,1.069871,1.090462,0.94632539,0.74041597,0.32859712,0.34918806,0.39036995,0.53450654,0.96691633,1.4199171,1.1522348,0.6580522,0.28741524,-0.14499455,-0.68035903:1
0.54977287,-0.20420135,-0.68889907,-0.95817558,-1.1197415,-1.1197415,-1.8198604,-1.7660051,-1.0658862,0.11893046,0.87290469,0.87290469,0.98061529,0.65748348,0.28049636,-0.15034605,-0.20420135,-0.47347786,-0.25805666,0.011219857,0.92675999,1.465313,1.6807342,1.4114577:2
-0.89646406,-1.2156008,-1.5347376,-1.6677113,-1.6145218,-1.5347376,-1.1624114,0.0077567951,0.75240927,1.2843039,1.2577092,1.1513302,0.96516712,0.4332725,0.38008303,0.59284088,0.45986723,0.22051465,0.30029884,0.80559873,0.99176185,0.56624615,-0.072027399,-0.47094837:1
-0.76047074,-1.1517696,-1.3474191,-1.4592187,-1.5151186,-1.3194691,-1.4871687,-0.5648213,0.69292511,1.2519235,1.2798734,1.3078233,1.1121739,0.80472479,0.91652447,0.88857455,0.86062463,0.66497519,0.38547599,0.21777646,-0.0058228981,-0.11762258,-0.1455725,-0.50892146:2
-0.74679732,-1.1036132,-1.3506396,-1.4878764,-1.5427712,-1.3506396,-1.5976659,-0.63700782,0.37854504,1.3117558,1.3117558,1.256861,1.0098347,0.76280829,0.79025567,0.98238729,0.92749254,0.68046617,0.48833454,0.18641342,-0.14295508,-0.1155077,0.13151867,-0.14295508:2
-0.80745825,-1.120942,-1.3774288,-1.4914229,-1.4914229,-1.2919332,-1.2634347,-0.60796856,0.24698724,1.2159371,1.3014327,1.5579194,1.3299312,0.93095188,0.78845924,0.75996072,0.93095188,0.64596661,0.4179784,0.07599608,-0.1234936,-0.23748772,-0.15199213,-0.23748772:2
-0.97955497,-1.2933114,-1.5622454,-1.6070678,-1.6518901,-1.4501896,-1.1364332,-0.28480864,0.70128293,1.2167399,1.1719175,1.0822728,0.85816114,0.52199356,0.4099377,0.45476004,0.61163824,0.4099377,0.43234887,1.0374505,1.0150393,0.47717121,-0.015874578,-0.41927568:1
-0.39884783,-1.2805114,-1.4694394,-1.5324153,-1.5953913,-1.4064634,-0.96563158,-1.0915835,0.10495995,1.2385275,1.2385275,1.3644794,1.3015034,0.86067162,0.60876773,0.60876773,0.60876773,0.67174371,0.2309119,-0.083967968,-0.33587185,0.79769565,0.54579176,-0.020991996:2
0.037115773,-0.64406769,-0.90606133,-1.168055,-1.2204537,-1.168055,-0.59166896,-0.64406769,-0.95846006,-0.2772766,0.61350177,0.50870431,0.40390686,-0.22487787,-0.015282954,-0.17247914,-0.38207405,-0.48687151,-0.32967533,0.35150813,2.1854636,2.290261,1.8186725,0.98029286:2
-0.59936329,-1.0260286,-1.3307896,-1.6050745,-1.6050745,-1.7879311,-1.0565047,-0.35555449,0.89396558,1.0768221,1.1682504,1.2292026,0.83301338,0.31491969,0.010158699,0.0406348,0.1930153,0.43682409,1.2596787,1.2292026,0.86348948,0.40634799,0.010158699,-0.59936329:1
-1.0020976,-1.339995,-1.4990055,-1.4990055,-1.5785108,-1.5188818,-1.1213555,-0.2467976,0.40912084,1.045163,1.1246682,1.0054103,0.78677085,0.46874979,0.44887348,0.58800769,0.64763664,0.92590507,1.1644209,1.045163,0.70726559,0.25011031,-0.2467976,-0.56481867:1
-0.64768794,-1.0505694,-1.3191571,-1.4198775,-1.6548917,-1.5877447,-1.1177163,-0.211233,0.99741145,1.2995726,1.4674398,1.0309849,0.89669108,0.42666268,-0.17765954,-0.14408609,-0.11051263,0.057354658,0.39308923,1.6017337,1.0309849,0.52738305,0.090928115,-0.37910029:1
-0.29284315,-1.0045632,-1.2269757,-1.5383533,-1.4493883,-1.3604233,-1.1380107,0.018534375,0.2409469,1.219562,1.397492,1.130597,0.81921946,0.018534375,-0.20387815,-0.070430634,-0.33732566,-0.42629067,-0.42629067,0.46335942,1.8867996,1.664387,0.50784193,0.10749939:2
0.1563451,-0.49881532,-1.0348557,-1.1539758,-1.451776,-1.451776,-1.7495761,-1.0944157,0.1563451,1.6453461,1.8835862,1.6453461,1.4071059,0.57326538,0.037225032,0.27546518,0.4541453,0.09678507,0.09678507,0.09678507,-0.3201352,-0.20101512,0.27546518,0.1563451:2
-0.95838417,-1.3361051,-1.4752655,-1.5746657,-1.6343059,-1.4553854,-1.0776645,-0.18306214,0.71154018,1.1886614,1.2085415,1.1489013,0.91034069,0.3338192,0.4133394,0.4133394,0.53261971,0.53261971,1.1489013,1.029621,0.57237982,0.25429899,-0.14330204,-0.56078313:1
-1.1398499,-1.3177777,-1.4512235,-1.6513923,-1.5846693,-1.3622596,-0.98416305,-0.094524132,0.50598214,1.1064884,1.0397655,0.90631966,0.75063285,0.43925922,0.26133143,0.41701825,0.3725363,0.55046409,1.440103,1.3066572,0.83959674,0.35029533,-0.11676511,-0.58382555:1
-0.8869813,-1.3924905,-1.5329097,-1.5329097,-1.7294965,-1.4486581,-0.99931667,-0.38147217,0.65762994,1.4158937,1.2754744,1.2473906,0.9665522,0.60146226,0.6295461,0.76996531,0.76996531,0.37679153,0.20828849,0.26445617,0.20828849,0.65762994,0.15212081,-0.29722065:2
0.99357049,0.010918354,-0.44765265,-0.64418307,-0.77520335,-0.84071349,-1.8888757,-1.7578554,-1.102754,-0.25112222,0.4039792,0.53499948,0.66601979,0.14193864,-0.25112222,-0.18561207,-0.18561207,-0.12010192,-0.18561207,-0.054591788,0.53499948,0.99357049,2.3692834,2.0417327:2
-0.87992473,-1.3649358,-1.5266062,-1.6276502,-1.5670238,-1.5063974,-1.1830567,-0.17261681,0.99949345,1.039911,1.0197022,0.91865826,0.77719667,0.43364711,0.45385591,0.45385591,0.4942735,0.61552629,1.2217902,1.0601198,0.67615268,0.33260312,-0.2130344,-0.45553999:1
-1.0182047,-1.3705392,-1.5215397,-1.59704,-1.6725402,-1.4712062,-0.96787124,-0.5400365,0.54213371,1.322303,1.1713025,1.1713025,0.8944682,0.59246721,0.69313421,0.64280071,0.76863446,0.69313421,0.39113322,0.49180022,0.038798726,0.71830096,0.34079972,-0.31353576:2
-0.98500015,-1.3499402,-1.5121358,-1.613508,-1.5729591,-1.4513124,-1.0255491,-0.072650096,0.61668106,1.0829933,1.1032678,0.98162108,0.73832773,0.39366216,0.33283882,0.4544855,0.51530884,0.83969996,1.2857378,1.1843656,0.61668106,0.27201548,-0.19429677,-0.64033459:1
-0.60919748,-1.1016855,-1.4710516,-1.6249541,-1.6557346,-1.4710516,-1.1016855,-0.17827043,0.25265663,0.99138872,1.2068523,1.1760718,1.0221692,0.37577864,0.22187612,-0.30139244,-0.024367908,0.89904721,1.2376328,1.3299743,0.8374862,0.49890066,-0.085928916,-0.42451446:1
-0.78041664,-1.3014562,-1.4385719,-1.5756875,-1.6305338,-1.465995,-1.2740331,-0.67072411,0.70043251,1.2214721,1.3037415,1.1940489,1.0843564,0.70043251,0.67300938,0.81012505,0.81012505,0.56331685,0.42620119,0.28908553,0.097123596,0.097123596,0.31650866,-0.1496846:2
-0.35788607,-0.83711548,-1.3163449,-1.3900725,-1.5006639,-1.3532087,-1.1688897,-0.68966028,-0.76338788,0.010751939,0.60057276,0.71116416,0.67430036,0.15820715,-0.099839463,-0.13670326,-0.24729467,0.96921076,1.4484402,1.7433506,1.5590316,1.2641212,0.67430036,0.04761574:1
-0.75455421,-1.1771045,-1.3581975,-1.448744,-1.5091084,-1.3280154,-1.267651,-0.66400771,0.63382552,1.086558,1.3280154,1.267651,1.3280154,0.81491853,0.72437202,0.96582938,0.99601154,0.75455419,0.54327902,0.06036433,-0.30182169,-0.36218602,-0.030182174,-0.30182169:2
0.050084569,-0.55093018,-1.031742,-1.1519449,-1.2721479,-0.91153903,-0.43072723,-1.8731626,-1.1519449,0.29049047,0.53089637,0.89150522,0.65109932,0.29049047,-1.031742,0.41069342,0.53089637,0.050084569,0.41069342,0.050084569,0.050084569,2.2137376,1.7329258,1.252114:2
-0.71029345,-1.2259513,-1.5292795,-1.6809436,-1.6202779,-1.4686139,-1.1956185,-0.2553012,0.44235357,1.2310068,1.3826709,1.1400083,1.0186771,0.62435047,0.59401765,0.77601455,0.74568173,0.44235357,-0.10363712,-0.042971488,0.80634736,0.80634736,0.19969104,-0.37663247:2
-1.0686693,-1.2622396,-1.5042024,-1.6251838,-1.6251838,-1.552595,-1.2380433,-0.028228993,0.60087443,1.2299778,1.157389,1.2299778,0.91542614,0.67346328,0.67346328,0.55248186,0.62507071,0.26212643,0.14114501,0.310519,0.93962242,0.649267,0.21373386,-0.27019184:2
-0.25090847,-0.9283613,-1.2294515,-1.3799965,-1.5305416,-1.304724,-1.0036338,-1.3799965,-0.025090858,1.1792698,1.4050874,1.5556325,1.5556325,0.87817959,0.72763452,0.35127183,0.42654436,0.35127183,-0.025090858,-0.17563593,-0.7025437,0.95345213,0.57708944,-0.025090858:2
-0.94885127,-1.4753815,-1.659667,-1.607014,-1.607014,-1.554361,-1.0541573,-0.1853825,0.60441278,1.1046165,1.2099225,1.0519634,0.84135136,0.57808627,0.52543325,0.6570658,0.76237183,0.36747419,0.18318863,0.42012721,1.0519634,0.68339231,0.15686212,-0.10640298:2
0.29155834,-0.52795699,-1.0322741,-1.4735516,-1.410512,-1.1583534,-1.9778687,-1.1583534,0.039399773,1.4262719,1.930589,1.5523511,1.1110737,0.48067726,0.2285187,0.16547906,0.16547906,0.16547906,0.039399773,0.16547906,0.039399773,-0.27579843,0.92195472,0.29155834:2
-0.98888442,-1.2951196,-1.5794809,-1.513859,-1.5794809,-1.4919851,-1.163876,-0.24517042,0.65166117,1.2641315,1.1547618,1.0453921,0.89227453,0.58603935,0.38917388,0.65166117,0.76103088,0.56416541,0.52041752,1.0235182,0.73915694,0.36729994,-0.17954859,-0.57327953:1
-0.76694875,-1.1731671,-1.4270536,-1.3762763,-1.5793855,-1.4778309,-1.5793855,-0.71617145,0.37554042,0.88331338,1.1118112,1.3656977,1.0610339,0.78175879,0.75637014,0.88331338,1.0356453,0.78175879,0.6294269,0.37554042,0.17243124,-0.13223254,0.14704259,-0.13223254:2
-0.91447083,-1.1895762,-1.4646817,-1.4952489,-1.5869507,-1.4952489,-0.9450381,-0.91447083,0.33878723,1.102969,1.2558053,1.2252381,1.0112672,0.82786354,0.91956536,1.0112672,1.0418344,0.73616173,0.46105631,0.12481634,-0.02802001,-0.05858728,0.15538361,-0.11972182:2
-1.0283851,-1.1060805,-1.5981514,-1.5981514,-1.6499484,-1.4427606,-1.131979,-0.43272026,0.47372619,0.68091395,0.93989865,0.83630477,0.78450783,0.47372619,0.24063996,0.42192925,0.37013231,1.1988833,1.3801726,1.3024772,0.83630477,0.21474149,0.085249138,-0.25143097:1
-0.0058191939,-0.65756846,-1.0765501,-1.1231036,-1.0765501,-1.1696571,-0.93688957,-0.47135438,-0.79722901,0.087287843,0.7390371,0.92525118,0.92525118,0.2269484,-0.28514031,-0.61101494,-0.70412197,-0.84378253,-0.47135438,1.623554,2.0425356,1.716661,1.1114652,0.83214414:1
-0.92025113,-1.278254,-1.5261022,-1.636257,-1.6913343,-1.3333314,-1.0304059,-0.56224819,0.62191535,1.4480759,1.3929986,1.0349956,1.0349956,0.48422192,0.67699273,0.70453141,0.59437667,0.31898979,0.18129635,0.23637373,0.071141608,0.86976353,0.59437667,-0.28686132:2
-0.81772966,-1.1448215,-1.3827065,-1.4421777,-1.4124421,-1.3232352,-1.4719133,-0.69878716,0.37169529,1.1448215,1.263764,1.2934996,1.1150859,0.75825839,0.90693651,0.84746526,1.025879,0.87720089,0.66905152,0.2527528,-0.28248843,-0.19328156,-0.044603443,-0.31222405:2
-1.1411425,-1.4225803,-1.5281195,-1.5632992,-1.5281195,-1.4225803,-1.070783,-0.26164924,0.47712508,1.1103602,1.1279501,1.1103602,0.98723115,0.5650744,0.58266427,0.72338318,0.72338318,0.67061359,0.93446156,0.89928183,0.47712508,0.24845684,-0.2792391,-0.41995802:1
-0.81554657,-1.25913,-1.5086456,-1.6472654,-1.6749894,-1.4809217,-1.0927862,-0.011551649,0.5429276,1.4300944,1.4855423,1.2637506,1.014235,0.43203175,0.57065156,0.5429276,0.51520364,0.34885986,0.23796401,0.26568797,0.73699534,0.5429276,0.043896278,-0.48285902:2
-0.82567084,-1.244668,-1.5897245,-1.688312,-1.5897245,-1.5157838,-1.1707273,0.012323447,0.89961152,1.022846,1.244668,1.2200211,0.85031774,0.43132059,0.4066737,0.4066737,0.4066737,0.20949857,0.25879235,1.1460804,0.89961152,0.60384883,0.1355579,-0.52990815:1
-0.32721977,-0.75460886,-1.181998,-1.4491161,-1.3956925,-1.2354216,-0.91487977,-0.32721977,0.15359295,1.8631493,1.4891839,1.6494548,1.0083711,0.26044023,-0.38064341,-0.2203725,-0.38064341,-0.54091432,-0.43406704,-0.32721977,1.4891839,1.168642,0.58098204,0.20701659:2
-0.9038307,-1.2475054,-1.3890185,-1.6316124,-1.6922608,-1.3485862,-1.1666407,-0.27712982,0.9964881,1.2188658,1.2188658,0.9964881,0.77411037,0.43043569,0.36978722,0.39000338,0.43043569,0.59216495,1.117785,1.117785,0.59216495,0.26870644,-0.25691367,-0.60058834:1
-1.0005715,-1.207141,-1.4911742,-1.4911742,-1.4911742,-1.3878894,-1.336247,-0.58743229,0.29048849,1.0909456,1.2458728,1.271694,0.96183967,0.80691248,0.83273368,0.96183967,1.0393033,0.88437608,0.47123688,0.21302489,-0.071008306,-0.071008306,0.16138249,-0.096829504:2
-0.15342527,-0.76712637,-1.2392041,-1.3336197,-1.5696586,-1.3336197,-0.95595748,-0.9087497,0.60189916,1.5460547,1.687678,1.6404702,0.97956138,0.27144472,0.035405834,-0.24784083,-0.43667194,-0.34225638,-0.29504861,0.035405834,0.88514582,1.5460547,0.36586027,-0.011801943:2
-1.0616414,-1.3878356,-1.5328108,-1.6052984,-1.4784451,-1.4603232,-1.0616414,-0.24615585,0.69618305,1.0223773,1.1311087,0.98613348,0.98613348,0.49684213,0.62369545,0.53308593,0.73242686,1.076743,1.0042554,0.78679256,0.47872022,-0.02869303,-0.19179015,-0.49986248:1
0.57648629,-0.17924362,-0.76057433,-0.93497354,-1.0512397,-1.2256389,-1.1093728,-1.9232358,-0.87684047,0.1695548,0.69275243,1.0415508,0.92528472,0.40208708,-0.29550977,-0.29550977,-0.52804205,-0.64430819,-0.41177591,0.75088551,1.2159501,2.029813,1.4484823,0.98341779:2
-0.34867646,-1.0734842,-1.3699965,-1.5017797,-1.6335629,-1.5347255,-1.0405384,-0.15100161,0.37613129,1.1997765,1.4962887,1.0679932,0.67264356,0.24434807,-0.18394742,-0.24983904,-0.11805581,-0.052164192,1.2656681,1.4962887,1.2656681,0.50791452,0.079619035,-0.41456807:1
-0.77112208,-1.1307485,-1.4073842,-1.4627114,-1.5733657,-1.4350478,-1.6563564,-0.74345851,0.50140225,1.2483187,1.1376644,1.165328,1.0546737,0.72271083,0.72271083,0.91635583,0.9440194,0.69504725,0.4460751,0.28009367,0.031121517,0.11411224,0.22476652,-0.024205628:2
-0.75044786,-1.0592036,-1.2993469,-1.6081026,-1.676715,-1.5394902,-1.1278159,-0.68183549,0.0042882816,0.0042882816,0.65610585,0.69041204,0.69041204,0.34735016,0.0042882816,0.10720684,0.38165635,1.1020863,1.1706987,1.6852915,1.2736172,1.0334739,0.58749348,0.0042882816:1
-1.1518389,-1.4171696,-1.5830012,-1.5166686,-1.5332517,-1.4005864,-1.0357568,-0.32268074,0.4401448,0.9044734,1.0205556,1.0039724,0.97080606,0.62255961,0.55622695,0.78839125,0.85472391,1.0703051,0.92105656,0.85472391,0.50647746,0.17481419,-0.22318175,-0.50509554:1
-0.68230884,-1.1271418,-1.4329644,-1.5441726,-1.5163706,-1.4329644,-1.6275788,-0.71011091,0.56878377,1.3472414,1.2638352,1.2360332,0.93021053,0.70779406,0.70779406,0.87460641,0.87460641,0.45757554,0.40197142,0.17955496,-0.070663568,0.37416937,0.31856525,-0.098465628:2
-0.73552071,-0.9331233,-1.394196,-1.5259311,-1.5259311,-1.394196,-0.99899082,-1.1307259,-0.4720506,0.64769735,1.5698427,1.5039752,1.4381077,0.64769735,0.45009477,0.45009477,0.77943241,0.71356488,0.38422725,-0.010977912,0.2524922,0.97703499,0.45009477,-0.14271297:2
-1.1095608,-1.335757,-1.5002633,-1.6030797,-1.5825164,-1.5208266,-1.1506874,-0.12252293,0.67944534,0.9467681,1.1112744,1.0907111,0.88507823,0.61775547,0.47381245,0.65888205,0.63831876,0.61775547,0.57662889,1.1112744,0.78226178,0.370996,-0.10195964,-0.53378871:1
-0.83518872,-1.2801023,-1.4440179,-1.7250159,-1.6547664,-1.6079334,-1.1864363,-0.085860527,0.61663466,1.1552143,1.1552143,1.1317978,0.82738321,0.4058861,0.42930261,0.45271911,0.56980164,0.3824696,0.61663466,1.2488803,0.8039667,0.3824696,-0.062444021,-0.29660908:1
-1.0760003,-1.3437133,-1.5496464,-1.6114263,-1.6526129,-1.4878664,-1.0965936,-0.10811486,0.55087097,1.1686702,1.1686702,1.086297,0.46849774,0.46849774,0.50968435,0.57146427,0.59205758,0.57146427,0.71561742,1.2716367,0.75680404,0.3655312,0.015444976,-0.35523455:1
-0.91482103,-1.3162968,-1.5421269,-1.5672191,-1.6174036,-1.4668502,-1.0402822,-0.51334529,0.69108195,1.2932956,1.2682033,1.3183878,1.1678344,0.66598971,0.61580524,0.69108195,0.69108195,0.46525184,0.23942173,0.31469844,0.18923727,0.59071301,0.063776095,-0.28751518:2
-0.74071078,-1.1198424,-1.5621625,-1.6674769,-1.6674769,-1.5200368,-1.2040938,-0.19307627,0.41774684,1.0917585,1.2391986,1.17601,1.0706957,0.54412403,0.52306117,0.62837549,0.5651869,0.37562111,0.5019983,1.2602615,0.64943836,0.24924391,-0.19307627,-0.42476779:1
-0.9732068,-1.375913,-1.5369955,-1.6175368,-1.6443839,-1.5101484,-1.1879834,-0.060405943,0.79870073,1.2819482,1.1208657,1.0403245,0.74500657,0.47653573,0.50338282,0.61077115,0.6913124,0.3691474,0.26175906,0.55707698,1.0940187,0.63761823,0.10067656,-0.38257095:1
-1.0527313,-1.3426273,-1.5210248,-1.6325232,-1.5656242,-1.4987251,-1.1196303,-0.58443775,0.44134807,1.1103388,1.2664366,1.0657394,1.02114,0.64204529,0.66434499,0.66434499,0.82044283,0.6197456,0.44134807,0.50824715,0.55284653,0.66434499,0.062253311,-0.22764268:2
-0.29671594,-0.79984296,-0.95465128,-1.2642679,-1.4190762,-1.4964804,-1.0320554,-0.64503465,-0.99335336,-0.14190762,0.32251732,0.3612194,0.59343188,0.24511317,-0.33541802,-0.29671594,-0.33541802,0.94175059,1.4448776,1.7931963,1.8318984,1.3287714,0.78694227,0.3612194:1
-0.84284933,-1.1722124,-1.5839163,-1.693704,-1.7485979,-1.5564694,-1.1173186,0.28247461,0.74907234,1.3254578,1.3803516,1.243117,0.88630696,0.52949693,0.44715616,0.74907234,0.63928463,0.25502768,0.20013383,0.062899202,0.36481538,0.63928463,0.1726869,-0.21157005:1
-1.0916509,-1.0542763,-1.5401466,-1.6148959,-1.6335832,-1.4653973,-1.1103382,-0.23203421,0.85183031,1.0947655,1.0573908,1.0760781,0.83314299,0.47808392,0.38464733,0.47808392,0.49677124,0.57152052,1.1882021,1.1508274,0.59020784,0.27252341,-0.19465957,-0.58709327:1
-1.0025835,-1.1982095,-1.4916486,-1.5405551,-1.7117279,-1.4182888,-1.149303,-0.36679886,0.56242489,1.0025835,1.3204758,0.90477049,0.88031723,0.24453256,0.31789233,0.46461186,0.53797163,0.70914442,1.2471161,1.1982095,0.66023791,0.36679884,-0.14671956,-0.39125212:1
-0.67615274,-1.0994831,-1.2123712,-1.2970373,-1.2970373,-1.4381474,-1.2405932,-0.90192895,0.39628429,1.186501,1.4122772,1.3276112,1.186501,0.76317064,0.79139267,0.98894685,0.96072483,1.0453909,0.48095037,0.33984024,-0.36571044,-0.45037652,-0.28104435,-0.61970868:2
0.38587292,-0.085022848,-1.0268144,-1.2361014,-1.2884231,-1.1837796,-0.97449262,-1.3930666,-0.60824036,0.17658591,0.38587292,0.75212517,0.54283817,0.019620655,-0.1373446,-0.55591861,-0.55591861,-0.55591861,0.071942406,1.7985602,2.1124907,1.5892732,1.1706992,0.59515992:2
-0.18635031,-0.52389046,-0.98800818,-1.2411633,-1.2411633,-1.3677408,-0.94581566,-1.1567782,-0.90362314,0.024612298,0.36215245,0.40434497,0.48873001,0.31995993,-0.35512038,-0.52389046,-0.31292786,-0.14415779,1.3325804,1.8388907,1.8388907,1.543543,1.1216178,0.61530757:1
-0.050946326,-0.89743907,-1.1796033,-1.0855485,-1.1796033,-0.99149383,-1.4617675,-1.0855485,0.32527267,1.2658201,1.1717654,1.1717654,2.0182581,0.98365593,0.23121792,-0.050946326,0.32527267,-0.14500107,-0.42716532,-0.61527483,-0.99149383,1.3598749,0.70149168,0.60743693:2
-0.80967144,-1.4768685,-1.5602682,-1.7826672,-1.5324683,-1.4490687,-1.2266696,-0.0034749855,0.63592221,1.2197197,1.3587191,1.1641199,0.94172087,0.49692281,0.66372208,0.63592221,0.69152196,0.41352318,0.10772453,0.24672392,0.49692281,0.71932184,0.16332428,-0.1146745:1
-1.070605,-1.4154979,-1.5663885,-1.6526117,-1.6526117,-1.5232769,-0.96282593,-0.10059375,0.65385941,1.1280871,1.1280871,1.0634197,0.78319424,0.35207816,0.37363396,0.65385941,0.5676362,0.41674557,0.63230361,1.0634197,0.89097327,0.5460804,0.071852693,-0.38081921:1
-0.71251409,-1.0615006,-1.4686515,-1.3523227,-1.7013091,-1.4104871,-0.94517175,-1.1778294,0.39260981,1.2069116,1.3232404,1.265076,1.2069116,0.97425397,0.62526748,0.79976072,0.62526748,0.45077423,-0.13086992,0.10178774,-0.3635276,0.97425397,0.3344454,0.04362332:2
-0.89036856,-1.2705972,-1.5367572,-1.4987343,-1.6128029,-1.5177457,-1.30862,-0.33903715,0.83967144,1.1628657,0.95374001,0.80164858,0.68758001,0.30735143,0.40240858,0.53548858,0.80164858,1.08682,1.1248429,0.99176287,0.49746572,0.28834,-0.034854281,-0.47211714:1
-0.8887014,-1.2778249,-1.4480665,-1.6426283,-1.5453474,-1.5210271,-1.1562238,-0.47525765,0.54619162,0.95963537,0.93531515,0.86235449,0.66779272,0.37595008,0.61915228,0.2786692,0.57051184,0.49755119,1.3973994,1.3244387,0.91099493,0.5218714,-0.013173457,-0.49957787:1
-0.506963,-1.1074179,-1.4550496,-1.5182554,-1.5498583,-1.4234467,-1.2022265,-0.19093412,0.50432941,1.1679901,1.3260045,1.1363872,0.85196118,0.21990342,-0.19093412,-0.2541399,-0.15933124,0.59913807,1.2627987,1.4524161,1.1363872,0.37791786,-0.19093412,-0.28574279:1
-0.87002909,-1.1860043,-1.6073046,-1.6073046,-1.6336359,-1.5809734,-1.159673,-0.63304765,0.57819082,1.0521537,1.2364726,1.0521537,0.89416606,0.39387192,0.47286573,0.63085336,0.94682861,0.81517225,0.65718463,0.6835159,0.44653446,0.63085336,-0.0010971484,-0.21174732:2
-0.79708701,-1.303315,-1.5697507,-1.6763251,-1.5431072,-1.5164636,-1.2233842,-0.21092832,0.61502258,1.3343991,1.4942606,1.2278248,0.98803266,0.53509185,0.48180469,0.64166616,0.61502258,0.50844827,0.13543819,0.2420125,0.21536892,0.72159689,0.2420125,-0.15764116:2
-0.45333752,-0.93824449,-1.2110046,-1.5746849,-1.4837648,-1.4231514,-1.5746849,-0.81701775,0.39524968,1.3044503,1.3044503,1.3044503,1.0923035,0.66800985,0.7589299,1.0013834,1.0013834,0.84984996,0.33463631,0.1527962,-0.2714974,-0.42303083,-0.029043918,0.031569453:2
-0.20468052,-0.83852989,-1.4327636,-1.4327636,-1.5119948,-1.4723792,-1.3931481,-0.12544935,0.46878442,1.2610961,1.4987896,1.3403273,0.86494027,-0.0066025993,-0.48198961,-0.046218184,-0.046218184,-0.16506494,0.27070649,1.6572519,1.0234026,0.86494027,0.31032208,-0.40275844:1
-0.77650741,-1.384463,-1.6182921,-1.5481434,-1.4078459,-1.5247605,-1.127251,-0.54267833,0.60308416,1.1175082,1.0005936,1.164274,0.81353034,0.88367906,0.41602091,0.57970126,0.60308416,0.55631835,0.64984998,1.2344227,0.74338161,0.36925509,-0.26208343,-0.54267833:1
-0.86003056,-1.1956523,-1.6511389,-1.6990848,-1.531274,-1.507301,-1.0757874,-0.47646292,0.69821298,1.2735644,1.0817806,0.96191574,0.77013191,0.48245619,0.29067237,0.48245619,0.60232108,0.55437512,0.50642917,1.3454834,0.8899968,0.45848321,-0.04494932,-0.35659803:1
-0.67079839,-1.1687106,-1.5559756,-1.5006521,-1.6112992,-1.4453285,-1.0027399,-1.113387,0.3803496,0.82293823,1.2655269,1.3208504,1.0995561,0.71229107,0.93358538,0.98890896,0.65696749,0.26970244,0.26970244,0.10373171,-0.28353334,0.98890896,0.43567318,0.10373171:2
-0.84848886,-1.359114,-1.522514,-1.522514,-1.522514,-1.522514,-1.1957139,-0.27658865,0.64253667,1.2348619,1.2144369,1.0714618,0.80593672,0.51998663,0.51998663,0.56083664,0.56083664,0.56083664,1.0918868,1.0714618,0.56083664,0.091061474,-0.25616365,-0.48083872:1
0.19842461,-0.30285862,-1.0547835,-1.0547835,-1.3054251,-1.2051684,-0.85427017,-0.60362856,-1.0046551,-0.15247365,0.44906623,0.95034946,0.90022113,0.3989379,-0.25273029,-0.15247365,-0.50337191,-0.55350023,-0.60362856,-0.15247365,1.8526593,2.1033009,1.7524026,1.1508627:1
-0.84912405,-1.3155443,-1.5666937,-1.6025722,-1.6384506,-1.4231797,-1.1361519,-0.59797468,0.40662278,1.0524354,1.2677063,1.3035848,1.1959494,0.65777215,0.65777215,0.65777215,0.87304304,0.62189367,0.3707443,0.11959494,0.011959498,0.72952911,0.15547342,0.047837979:2
-0.98032599,-1.2850342,-1.5026829,-1.6332721,-1.655037,-1.3938585,-1.1109152,-0.52326374,0.71733383,1.2396907,1.3702799,1.2396907,1.0655717,0.60850948,0.69556896,0.80439331,0.71733383,0.41262565,0.2385067,0.2385067,0.21674183,0.54321487,0.10791748,-0.13149609:2
-0.78938848,-1.2900299,-1.4481271,-1.632574,-1.6589235,-1.5008262,-1.1846317,-0.6839903,0.42269064,1.0550797,1.3449247,1.213177,1.1341284,0.6861861,0.50173928,0.6861861,0.79158429,0.52808883,0.44904019,0.50173928,0.44904019,0.58078792,0.15919518,-0.31509664:2
-1.1004187,-1.3755234,-1.55059,-1.6506281,-1.6256186,-1.5755995,-1.2004568,-0.20007613,0.47518081,1.0003807,1.1504377,1.0754092,0.65024742,0.50019033,0.67525694,0.72527597,0.77529501,0.60022839,0.42516178,0.47518081,0.97537114,0.67525694,0.1500571,-0.050019031:2
-1.1038085,-1.3687225,-1.5957917,-1.6147141,-1.5957917,-1.3687225,-1.1605758,-0.19553177,0.95873649,1.0533487,1.0155038,0.88304676,0.76951218,0.42890843,0.35321871,0.39106357,0.54244302,0.93981406,1.0911935,1.0155038,0.67490003,0.25860656,-0.0063074697,-0.36583364:1
-1.0140271,-1.364593,-1.5491013,-1.6413555,-1.6413555,-1.475298,-1.1247321,-0.27599374,0.49894132,0.96021219,0.99711386,0.96021219,0.83105634,0.646548,0.62809716,0.75725301,0.86795801,0.7019005,0.97866302,0.90485968,0.59119549,0.29598214,-0.12838706,-0.40514958:1
-1.0244926,-1.3517484,-1.5262849,-1.6571872,-1.5917361,-1.4826508,-1.0463096,-0.21726152,0.65542073,1.135396,1.0699448,0.98267657,0.76450601,0.30634783,0.34998194,0.43725017,0.45906722,0.54633545,1.3535665,1.157213,0.69905484,0.32816489,-0.086359182,-0.26089563:1
-0.47338035,-0.55173296,-1.0610249,-1.4136117,-1.452788,-1.1393775,-1.1785538,-0.63008557,-0.94349601,-0.042440995,0.34932205,0.7802614,0.7802614,0.27096944,-0.12079361,-0.15996991,-0.43420404,-0.39502774,0.7802614,1.7988453,1.7204927,1.5637875,1.367906,0.58437988:1
-0.82161442,-1.2135398,-1.6054652,-1.5319792,-1.8014279,-1.4584932,-1.2380351,-0.18473566,0.55012444,1.2849845,1.1625079,0.94204983,0.77058247,0.67260112,0.35416174,0.42764775,0.5256291,0.28067573,0.42764775,1.3829659,0.79507781,0.55012444,-0.037763646,-0.23372634:1
-0.84128246,-1.1827756,-1.5029254,-1.609642,-1.609642,-1.5242687,-1.2468055,-0.15829626,0.6100632,1.1436462,1.0155862,0.99424293,0.80215307,0.3752867,0.50334661,0.46065997,0.58871988,0.80215307,1.2290194,1.1223028,0.63140652,0.24722679,-0.32904281,-0.52113268:1
-0.84755793,-1.3371221,-1.4350349,-1.7287734,-1.6553388,-1.6308606,-1.214731,-0.064255293,0.5966563,1.1351769,1.1351769,0.91487299,0.74352555,0.40083065,0.35187423,0.49874348,0.54769989,0.5721781,0.74352555,1.2820461,0.79248195,0.44978706,-0.015298881,-0.23560275:1
-0.15475765,-0.9450095,-1.3401354,-1.6562361,-1.577211,-1.4191606,-0.86598431,-1.2611102,-0.075732468,0.71451938,1.425746,1.5047712,1.3467208,1.1096453,0.79354457,0.55646901,0.6354942,0.47744382,0.16134308,-0.23378284,-0.54988357,0.16134308,0.87256975,0.31939345:2
-0.76097695,-1.2408511,-1.4949021,-1.5513579,-1.5795858,-1.52313,-1.1279395,-0.11173541,0.67864558,1.610166,1.4407987,1.2714313,1.0738361,0.62218979,0.50927822,0.65041768,0.65041768,0.50927822,-0.33755855,0.05763194,0.19877141,0.56573401,0.0011761543,-0.11173541:2
-0.81717002,-1.3186902,-1.5826483,-1.6882315,-1.6882315,-1.3186902,-1.1339196,-0.4740246,0.37064104,1.3208899,1.0305361,1.0305361,0.81936966,0.47622425,0.39703685,0.55541165,0.50262005,0.42343265,0.29145364,1.2944941,0.97774447,0.74018225,0.053891424,-0.26285819:1
0.0044605012,-0.26316947,-1.0125334,-1.1731114,-1.4942673,-1.5477933,-1.3336894,-0.049065493,0.64677243,1.7172923,1.6637663,1.5567143,1.1285064,0.27209047,-0.42374746,-0.47727345,-0.47727345,-0.69137743,-0.47727345,-0.049065493,1.3961364,0.9144024,0.27209047,-0.10259149:2
1.1030012,0.41640678,-0.27018761,-0.42276414,-0.80420546,-0.7279172,-1.9485294,-1.6433764,-0.7279172,-0.19389934,0.18754199,0.34011852,0.56898331,0.26383025,-0.11761108,-0.34647587,-0.4990524,-0.27018761,-0.34647587,-0.19389934,0.26383025,0.56898331,2.2473251,2.5524782:2
-0.61583907,-1.044727,-1.3746408,-1.5395977,-1.6715632,-1.5395977,-1.1766925,-0.35190804,0.17595402,0.63783332,1.0337299,0.90176434,0.5058678,0.10997126,-0.021994255,-0.18695115,0.14296264,0.96774709,1.4956092,1.6935575,1.132704,0.76979882,0.10997126,-0.15395977:1
-0.74074285,-1.2762196,-1.5707319,-1.7313749,-1.6510534,-1.5171842,-1.1691243,-0.68719518,0.59794906,1.1869735,1.1601997,1.1334258,0.73181825,0.59794906,0.73181825,0.73181825,0.86568745,0.59794906,0.35698451,0.19634148,0.089246135,0.81213977,0.41053219,0.14279381:2
-0.68362293,-1.1988825,-1.3344772,-1.6056664,-1.6599043,-1.5243097,-1.3073582,-0.059887633,0.40113411,1.3774155,1.4858912,1.3231776,1.2689398,0.53672874,0.50960981,0.75368015,0.50960981,0.31977733,0.26553948,0.048588072,0.6994423,0.37401518,-0.16836333,-0.33107689:2
-0.019618175,-0.76510886,-1.3144178,-1.7067813,-1.7460177,-1.3536541,-1.2359451,-0.84358156,-0.29427264,0.37274534,1.1574724,1.3144178,0.76510886,0.21579993,-0.25503629,-0.058854527,-0.019618175,0.92205426,1.2359451,1.4321268,1.0789997,0.92205426,0.41198169,-0.21579993:1
-0.98144494,-0.9519278,-1.3946849,-1.2470992,-1.6013049,-1.5127535,-1.2766164,-0.62723925,0.34682641,1.1733064,1.2913749,1.4389606,1.2028235,0.81910067,0.90765209,0.90765209,0.93716923,0.73054924,0.40586069,0.081172142,-0.27303356,-0.3025507,-0.0073792818,-0.066413565:2
-0.36838216,-0.87248405,-1.1439235,-1.415363,-1.4929172,-1.4541401,-1.2214777,-0.79492992,-0.98881526,0.019388537,0.44593629,0.75615285,0.95003819,0.36838216,-0.058165602,-0.13571974,-0.058165602,0.83370699,1.3378089,1.5704713,1.5704713,1.2602547,0.67859871,0.21327388:1
-0.85572706,-1.3823283,-1.4613185,-1.5403087,-1.5666388,-1.4086584,-1.1190277,-0.64508656,0.48710618,1.4349885,1.1190277,1.1190277,0.90838719,0.27646567,0.2501356,0.5397663,0.56609637,0.32912579,0.2501356,1.4613185,0.90838719,0.46077611,0.013165027,-0.14481535:2
-0.60581453,-0.98910669,-1.3468461,-1.5001629,-1.5257157,-1.6023742,-1.6023742,-0.63136734,0.74848439,1.4128575,1.3617519,1.3617519,1.1062238,0.59516752,0.74848439,0.69737877,0.64627315,0.49295628,0.262981,0.18632257,-0.14586396,0.08411133,0.21187538,0.033005711:2
-0.69290644,-1.2430638,-1.5181424,-1.5931639,-1.6431782,-1.4181138,-1.2930781,-0.36781349,0.55745106,1.0325869,1.1826298,1.3076656,1.1326155,0.60746536,0.73250111,0.73250111,0.78251541,0.63247251,0.38240101,0.45742246,0.68248681,0.35739386,-0.16775629,-0.64289214:2
-0.99314533,-1.2684349,-1.5437245,-1.6813692,-1.6354876,-1.4519613,-1.1307901,-0.16727664,0.63565125,1.1403488,1.0944672,1.0944672,1.002704,0.61271045,0.65859204,0.63565125,0.72741443,0.68153284,0.68153284,1.0485856,0.19977611,0.19977611,-0.23609903,-0.30492143:1
-0.86589896,-1.3291155,-1.6028343,-1.5396684,-1.6238896,-1.5396684,-1.1817284,-0.15001897,0.6921928,1.1132987,0.98696692,0.86063515,0.75535869,0.35530809,0.52375045,0.46058457,0.56586104,0.83957985,1.1975199,1.1132987,0.67113751,0.3131975,-0.12896368,-0.48690368:1
-0.48952153,-0.86131003,-0.93566774,-1.2702774,-1.6420659,-1.4189928,-1.0100254,-0.67541578,0.58866515,1.369421,1.5924941,1.4065998,0.7002017,0.14251894,-0.26644843,-0.22926958,-0.41516383,-0.30362728,0.068161233,1.7040306,1.3322421,0.8489171,0.25405549,-0.48952153:1
-0.77320257,-1.2252577,-1.4964907,-1.5416962,-1.6321073,-1.3834769,-1.2704632,-0.72799706,0.17611313,1.0350178,1.0576206,1.1254288,0.94460679,0.53775721,0.44734619,0.60556547,0.71857925,0.67337374,1.0350178,1.1932371,0.67337374,0.42474343,-0.14032544,-0.456764:1
-0.39086085,-0.94266441,-1.1934842,-1.2938121,-1.3439761,-1.3439761,-0.99282837,-0.89250045,0.26127062,1.2645498,1.6658615,1.7160255,1.4652057,0.91340209,0.61241833,0.71274625,0.81307417,0.66258229,0.11077874,-0.19020501,-0.79217253,-0.29053293,0.060614779,-0.59151669:2
-0.20559864,-0.6384379,-1.2444128,-1.5474003,-1.6339682,-1.4175485,-1.0279932,-0.89814145,-0.8115736,-0.11903079,0.48694415,1.0063513,1.0929191,0.44366023,0.22724061,0.010820973,0.010820973,-0.16231472,0.27052453,1.2660548,1.742178,1.4824744,1.2660548,0.4003763:1
-0.97336582,-1.2421181,-1.5315437,-1.5315437,-1.6142367,-1.552217,-1.2007716,-0.2291286,0.7631877,1.1146331,1.0732865,0.94924701,0.68049468,0.26702956,0.32904933,0.43241561,0.55645514,0.63914817,1.1973261,1.2179993,0.84588073,0.30837607,-0.12576232,-0.3738414:1
-0.47718369,-0.9079953,-1.4106088,-1.5183117,-1.5901137,-1.4465098,-1.1593021,-0.83619336,0.27673662,1.2819637,1.7845772,1.3896666,1.3896666,0.67164727,0.16903372,-0.010471113,-0.010471113,0.20493469,0.34853856,0.6357463,0.67164727,0.70754824,0.24083565,-0.40538175:2
-0.18081492,-1.0907223,-1.3356974,-1.5806724,-1.6856617,-1.4756831,-1.3007009,-0.70576148,0.4841174,0.79908533,1.0090639,1.0090639,0.62410315,0.13415302,-0.14581848,-0.11082204,-0.11082204,1.1840461,1.3590283,1.3940247,0.97406752,0.7640889,0.3091352,-0.32080067:1
-0.99565142,-1.2429788,-1.4522559,-1.566407,-1.5854322,-1.4522559,-1.2049285,-0.27269434,1.0210183,1.1161443,1.1351695,1.0019932,0.84979166,0.50733831,0.46928793,0.54538868,0.67856498,0.98296797,1.0210183,0.84979166,0.33611163,0.06975901,-0.27269434,-0.53904695:1
-0.91589142,-1.3272391,-1.6357499,-1.6871684,-1.6614592,-1.4300761,-1.2501114,-0.067486737,0.65237178,1.2179749,1.2951026,1.1665564,0.88375488,0.54953485,0.54953485,0.60095332,0.57524408,0.39527945,0.18960559,0.44669792,0.85804564,0.57524408,0.11247789,-0.093195971:1
-0.92632743,-1.3997836,-1.523294,-1.6262192,-1.5850491,-1.3791986,-1.173348,-0.22643559,1.0910078,1.173348,1.0292527,0.88515731,0.59696655,0.32936086,0.39111602,0.41170107,0.53521139,0.92632742,1.1939331,0.94691247,0.67930676,0.24702064,-0.22643559,-0.37053096:1
-0.91017258,-1.285033,-1.4213459,-1.5576588,-1.5235806,-1.5576588,-1.1487201,-0.73978146,0.31664351,1.1004426,1.2367555,1.2026773,1.0663644,0.62334753,0.7255822,0.89597332,0.93005155,0.7255822,0.14625238,-0.024138742,0.11217415,0.89597332,0.28256527,-0.092295192:2
-0.78542678,-1.2277229,-1.5647105,-1.6700191,-1.6278957,-1.375155,-1.1645378,-0.23782196,0.85738765,1.0048197,1.0890666,1.0680049,0.87844937,0.52040008,0.28872112,0.43615318,0.47827663,0.52040008,1.2154369,1.1522518,0.66783214,0.33084457,-0.23782196,-0.61693298:1
-0.31543361,-1.0196575,-1.2661358,-1.3717694,-1.5478254,-1.4421918,-1.0900799,-0.59712314,0.49442384,1.4803373,1.5155484,1.4099149,0.98738054,0.84653577,0.81132458,0.98738054,0.88174696,0.705691,0.35357907,-0.13937764,-0.66754553,-0.59712314,-0.20980003,-0.20980003:2
-0.84819419,-0.95793359,-1.3420216,-1.2322822,-1.5066307,-1.451761,-1.5066307,-1.5066307,0.4412439,1.2368546,1.2368546,1.1819849,0.9625061,0.60585302,0.55098331,0.77046213,0.98994095,0.82533184,0.60585302,0.41380904,0.11202566,0.22176507,0.13946051,0.057155958:2
-1.1510784,-1.4005733,-1.51398,-1.6500681,-1.582024,-1.445936,-1.0376717,-0.47063798,0.5500227,1.026331,1.026331,1.1397378,0.70879214,0.4592973,0.50466,0.64074809,0.57270405,0.43661596,0.36857191,1.2758258,1.0036497,0.59538539,0.16443978,-0.22114315:1
-1.1170122,-1.4017408,-1.5988606,-1.7083715,-1.6645672,-1.4674474,-1.0075012,-0.37233737,0.56945717,1.0732078,1.1170122,0.85418575,0.65706597,0.45994619,0.41614179,0.50375059,0.54755498,0.50375059,0.41614179,1.2922298,0.94179455,0.59135937,0.19711979,0.19711979:1
-0.75545674,-1.2874165,-1.5090664,-1.6863863,-1.5755614,-1.5312314,-1.2652515,-0.13483702,0.77392757,1.2172274,1.0399074,0.97341248,0.66310262,0.33062777,0.2641328,0.35279276,0.41928773,0.44145272,1.2393924,1.2837223,0.77392757,0.33062777,-0.068342054,-0.28999195:1
-0.49762499,-1.0563618,-1.4404934,-1.5452565,-1.6150987,-1.4055723,-1.1262039,-0.46270394,0.13095394,0.41032236,0.96905919,0.75953288,0.82937498,0.13095394,-0.28809868,-0.11349342,0.026190787,0.37540131,1.5976381,1.7373223,1.3531908,0.89921709,0.48016446,-0.14841447:1
-0.80508384,-1.3192551,-1.5086866,-1.4275016,-1.5357482,-1.6169331,-1.3192551,-0.61565234,0.49387497,0.71036811,1.0080462,0.84567632,0.68330647,0.27738183,0.41269004,0.54799825,0.65624482,0.43975169,1.251601,1.4951557,0.8997996,0.65624482,-0.020296227,-0.20972773:1
-0.6373796,-1.1752527,-1.5194914,-1.7346407,-1.5194914,-1.5625213,-1.2182825,-0.25011098,0.67503071,1.2129038,1.1698739,1.0622993,0.84715012,0.41685164,0.2877621,0.39533671,0.45988148,0.5674561,1.2344187,1.0192695,0.52442625,0.37382179,0.09412779,-0.7234393:1
-0.8274066,-1.3117422,-1.5012648,-1.6697293,-1.564439,-1.5223228,-1.1222196,-0.069316139,0.75194852,1.215226,1.194168,1.0678195,0.77300659,0.33078715,0.37290329,0.4360775,0.5624259,0.70983238,1.1099357,1.0467615,0.58348397,0.22549681,-0.27989682,-0.51153557:1
-0.88857408,-1.1998993,-1.5556996,-1.6001746,-1.6224121,-1.533462,-1.3777994,-0.68843643,0.3344893,0.97937728,1.2239899,1.0238523,1.0238523,0.69028956,0.66805204,0.62357701,0.66805204,0.71252708,0.71252708,0.62357701,0.44567688,0.62357701,0.13435166,-0.021310952:2
-0.76232109,-1.3505079,-1.5052939,-1.6291227,-1.5981655,-1.6600799,-1.1647647,-0.32892026,0.75458178,1.2808542,1.095111,1.1570254,1.0022394,0.59979577,0.53788137,0.66171018,0.72362458,0.38309537,0.16639496,0.13543776,0.94032499,0.66171018,0.042566145,-0.14317706:2
-0.87537342,-1.2046675,-1.5120086,-1.5778674,-1.5559145,-1.4241969,-1.1827145,-0.26069115,1.0784381,1.2540616,1.3418734,1.0784381,0.81500283,0.55156757,0.37594407,0.5076617,0.41984994,1.0345322,0.83695577,0.74914402,0.37594407,0.024697048,-0.3485029,-0.50217347:1
-1.0977121,-1.403036,-1.5993156,-1.6647421,-1.6647421,-1.4902714,-1.0322855,-0.15993156,0.73423126,1.0395551,1.061364,1.0831728,0.66880471,0.49433392,0.40709853,0.62518702,0.51614277,0.58156932,0.45071622,1.1704082,0.77784896,0.64699586,0.058156937,-0.20354926:1
-0.33616015,-0.87658987,-1.2626111,-1.4556217,-1.4942238,-1.5714281,-1.1854069,-0.027343163,0.47448444,1.3623332,1.6325481,1.3237311,1.0149141,0.12706533,-0.4133644,-0.25895591,-0.065945286,-0.065945286,0.32007594,1.5553439,1.285129,0.39728019,-0.065945286,-0.4133644:1
0.54115991,0.15755289,-0.66446217,-0.88366619,-1.1028702,-1.1028702,-0.77406418,-1.8152833,-0.88366619,0.10275188,0.59596092,0.70556294,0.48635891,0.3219559,-0.11645213,-0.33565615,-0.50005916,-0.50005916,-0.50005916,-0.28085515,0.76036394,2.349593,2.020787,1.417976:2
-0.35452,-0.8801404,-1.1100994,-1.5043147,-1.5043147,-1.6357198,-1.3729096,-0.15741234,0.53246444,1.1894899,1.550854,1.2551925,0.86097718,0.26965423,-0.091709795,-0.32166872,-0.25596617,-0.05885852,1.2223412,1.4523001,0.99238229,0.49961316,-0.091709795,-0.4859251:1
-0.83853908,-1.2545584,-1.5405717,-1.5405717,-1.5665729,-1.4625681,-1.4625681,-0.50052333,0.7215336,1.1895554,1.3195614,1.0595493,1.0855506,0.74753481,0.66953118,0.85153966,0.85153966,0.51352391,0.35751665,0.14950696,0.071503323,0.20150938,0.30551423,0.071503323:2
-0.33907546,-0.79970627,-1.0684076,-1.3371089,-1.5290384,-1.4138807,-1.0684076,-0.76132037,-0.79970627,-0.14714595,0.77411567,0.69734387,0.77411567,0.42864256,-0.22391776,-0.41584726,-0.33907546,0.12155535,1.2347465,1.7337632,1.6186055,1.4650619,0.92765928,0.46702846:1
-0.094248018,-0.65973612,-1.5079683,-1.3060082,-1.3464002,-1.5483603,-1.2656162,-0.90208816,0.35006406,1.3598642,1.1579042,0.91555216,0.67320012,0.067320009,-0.29620805,-0.25581604,-0.25581604,-0.25581604,1.1579042,1.7233923,1.4406483,0.75398413,0.26928005,-0.17503203:1
-0.33966915,-0.78271587,-1.1371532,-1.5802,-1.5802,-1.4915906,-1.0485439,-0.78271587,-0.11814579,0.0590729,0.67933831,0.72364299,0.76794766,0.19198691,0.014768226,-0.20675514,-0.20675514,0.45781494,1.8755644,1.9198691,1.4768224,0.81225233,0.28059626,0.014768226:1
-0.95293793,-1.3820282,-1.5107553,-1.5536643,-1.6394824,-1.3820282,-1.2103921,-0.26639354,0.74196856,1.2568769,1.385604,1.0852408,0.8277866,0.37724184,0.39869635,0.33433282,0.50596892,0.37724184,0.93505917,1.0423318,0.634696,0.39869635,-0.094757434,-0.30930256:1
-0.58749977,-0.90978534,-1.3126423,-1.232071,-1.3932137,-1.232071,-0.74864255,-1.0709282,0.62107116,1.7490708,1.6684994,1.5073566,1.2656424,1.185071,0.54049977,0.45992837,0.45992837,0.13764278,-0.18464279,-0.34578558,-0.90978534,0.37935698,0.13764278,-0.18464279:2
-1.0511278,-1.4594796,-1.6182831,-1.5729107,-1.5729107,-1.4141072,-1.1418727,-0.098306913,0.67302428,1.1494347,1.2174934,1.0360037,0.69571049,0.40078974,0.3327311,0.49153459,0.60496564,0.46884837,0.67302428,1.285552,0.78645534,0.42347595,-0.052934491,-0.2571104:1
-0.68167678,-1.2489115,-1.3086204,-1.4578927,-1.6967283,-1.6370194,-1.3384748,-0.80109461,0.6617738,1.0498817,1.3185719,1.4081352,1.0200273,0.4527926,0.63191935,0.90060946,0.75133718,0.42293815,0.39308369,0.18410249,-0.11444209,0.57221043,0.36322923,0.15424803:2
-0.8107111,-1.1778256,-1.566535,-1.7608897,-1.6313199,-1.523345,-1.2642054,-0.076482181,0.5497719,0.98167125,1.1112411,0.96007628,0.72253163,0.44179706,0.48498699,0.57136687,0.91688635,0.65774673,1.1112411,1.0248612,0.50658196,0.24744234,0.0098976914,-0.48678657:1
-0.82797369,-1.1786449,-1.5585387,-1.7338743,-1.5877613,-1.5000935,-1.1494223,-0.27274427,0.89615975,1.3344988,1.3637214,1.1883858,0.92538235,0.28248513,0.51626594,0.66237894,0.72082414,0.54548854,0.077926928,0.077926928,0.31170773,0.89615975,0.22403993,-0.21429908:2
-0.69176574,-1.201225,-1.3810342,-1.4709388,-1.2311932,-1.4409706,-1.7706207,-0.63182936,0.62683468,1.3161031,1.3760395,1.3161031,1.1662621,0.65680287,0.65680287,0.71673926,0.95648479,0.47699372,0.20727999,0.14734361,-0.18230649,-0.12237011,0.32715276,0.1773118:2
-0.73427081,-1.2807049,-1.4173134,-1.6905305,-1.57669,-1.4856177,-1.1896326,-0.16506863,0.60904633,1.2920889,1.4286975,1.2693209,0.85949529,0.35859737,0.33582929,0.4952059,0.51797398,0.35859737,0.51797398,1.1782485,0.63181442,0.35859737,-0.11953246,-0.55212611:1
0.83015174,0.10418908,-0.54111104,-0.94442362,-0.86376111,-0.78309859,-0.54111104,-0.2991235,-0.13779847,0.74948922,1.3947894,1.2334643,0.10418908,-0.057135946,-0.78309859,-1.0250862,-1.1864112,-1.1057487,-0.94442362,-0.54111104,0.1848516,2.3627396,1.7981019,0.99147675:2
-0.86165254,-1.2849823,-1.6024797,-1.6659792,-1.5813132,-1.3696483,-1.1579834,-0.26899081,0.59883528,1.191497,0.91633263,1.0433316,0.85283316,0.51416932,0.34483739,0.53533581,0.51416932,0.72583422,1.2973295,1.0856646,0.62000177,0.26017143,-0.26899081,-0.43832274:1
0.86222239,-0.1910313,-0.43885569,-0.8725484,-0.99646059,-0.93450449,-1.9877581,-1.8638459,-0.93450449,-0.0051629999,0.86222239,1.1100467,1.1100467,0.5524419,-0.0671191,-0.1910313,-0.37689959,-0.37689959,-0.624724,0.3046175,0.86222239,1.2339589,1.2339589,1.7296077:2
0.31423806,-0.4517172,-0.27495829,-1.2176725,-1.2765921,-1.2176725,-2.101467,-1.0409136,0.37315769,1.6693897,1.9639878,1.7283093,1.3158719,0.5499166,-0.098199385,-0.33387792,0.19639878,-0.039279751,-0.039279751,-0.039279751,-0.27495829,-0.4517172,0.37315769,0.37315769:2
-1.0085051,-1.2646334,-1.6061378,-1.6274818,-1.4780736,-1.4353856,-1.1152252,-0.13340015,0.76304883,1.3606815,1.2539614,1.0405211,0.86976895,0.29348032,0.37885641,0.46423251,0.44288848,0.33616837,1.0832092,1.1045532,0.57095262,0.33616837,-0.21877623,-0.41087243:1
-0.76714746,-1.1722913,-1.5324193,-1.6224512,-1.5099113,-1.5999432,-1.1497834,-0.22695561,1.0334921,1.16854,1.056,1.0109841,0.65085616,0.22320427,0.1331723,0.42577622,0.53831619,0.65085616,1.28108,1.146032,0.67336415,0.22320427,0.020632328,-0.65460749:1
-0.99683472,-1.2450094,-1.5924539,-1.5676364,-1.5924539,-1.493184,-1.1209221,-0.42603309,0.59148286,1.1622845,1.137467,0.98856226,0.79002256,0.34330824,0.24403839,0.49221301,0.49221301,0.46739555,0.41776063,1.3608242,1.0381972,0.7652051,0.045498695,-0.30194578:1
-1.1452991,-1.4374939,-1.5418491,-1.5835912,-1.6044623,-1.4374939,-1.0409438,-0.22697271,0.50351418,1.1296458,0.98354843,0.8583221,0.69135367,0.29480364,0.39915891,0.46177207,0.54525629,0.60786945,1.3174853,1.1713879,0.83745105,0.46177207,0.065222048,-0.31045693:1
-0.93629871,-1.3781476,-1.4412688,-1.5254305,-1.5885518,-1.4623093,-1.1677434,-0.24196483,0.49444989,1.0204604,1.0835817,0.95733915,0.78901578,0.32612652,0.45236905,0.49444989,0.78901578,1.2308646,1.1256625,1.0625413,0.53653073,0.15780316,-0.26300525,-0.5154903:1
-0.75456296,-1.3532244,-1.6226221,-1.6226221,-1.592689,-1.592689,-1.3232914,-0.12596837,0.68222467,1.3407523,1.2509531,1.1312208,0.95162235,0.6522916,0.59242545,0.59242545,0.62235852,0.38289392,0.20329547,0.26316162,0.38289392,0.71215775,0.23322854,-0.0062360649:1
-0.78228177,-1.2562589,-1.5459116,-1.5985757,-1.6249078,-1.5722437,-1.1509306,-0.28197252,0.45532528,0.69231386,1.0082986,0.98196658,0.79764212,0.61331767,0.16567257,0.27100083,0.50798941,1.0872948,1.3242834,1.1926231,0.79764212,0.37632909,-0.044983948,-0.41363285:1
-0.79104981,-1.333484,-1.333484,-1.6475248,-1.7046231,-1.6189756,-1.333484,-0.16296816,0.40801517,1.2073918,1.2644902,1.1788427,0.95044931,0.43656433,0.49366267,0.77915432,0.86480182,0.550761,0.60785933,0.35091683,0.66495766,0.43656433,-0.10586982,-0.16296816:2
-0.19222592,-0.69621319,-0.92882271,-1.1614322,-1.3165052,-1.3165052,-1.0451275,-0.69621319,-0.92882271,-0.15345766,0.38929786,0.54437087,0.46683437,0.0016153435,-0.34729892,-0.42483543,-0.50237193,-0.075921161,1.3585042,1.9012597,1.9400279,1.5523454,1.0871264,0.54437087:1
-0.49489131,-1.0307135,-1.2688567,-1.2986246,-1.477232,-1.5367677,-1.6856072,-0.88187398,0.57675303,1.1423431,1.3209505,1.4400221,1.0530394,0.69582462,0.63628883,0.93396781,0.90419991,0.84466411,0.45768144,0.070698758,-0.28651602,-0.22698022,0.16000245,-0.048372834:2
0.35239265,-0.17291316,-0.75074955,-1.1709942,-1.1709942,-1.0134025,-1.6963,-1.1709942,0.45745381,2.0333712,2.0859018,1.560596,1.0878208,0.87769845,-0.015321414,0.037209166,-0.015321414,0.037209166,-0.17291316,-0.067851995,-0.75074955,-0.69821897,0.29986206,0.037209166:2
-0.56861853,-1.0818848,-1.353614,-1.6253432,-1.6857275,-1.564959,-1.2328455,-0.74977135,0.48810617,1.3032938,1.3636781,1.2731017,0.94098819,0.54849044,0.85041179,0.85041179,0.85041179,0.72964325,0.27676123,0.095608419,-0.14592865,0.48810617,0.03522415,-0.085544388:2
-0.89011503,-1.2232957,-1.4976798,-1.5760752,-1.615273,-1.4976798,-1.2428946,-0.43934118,0.83458491,1.0501724,1.0697713,1.0305736,0.81498605,0.42300879,0.57979969,0.57979969,0.67779401,0.65819514,1.1285679,0.91298036,0.71699173,0.24661903,-0.26295141,-0.47853891:1
0.20964707,-0.57508693,-1.1751776,-1.4521426,-1.6829467,-1.4983034,-0.99053434,0.2558079,0.76357696,1.7791151,1.7791151,1.5021501,0.90205943,0.2558079,-0.20580034,-0.25196116,-0.34428281,-0.43660446,-0.5289261,-0.29812199,1.0405419,0.99438108,0.20964707,-0.25196116:2
0.13000026,-0.78764868,-1.2923556,-1.4300029,-1.6135327,-1.4300029,-1.1547082,0.13000026,0.72647206,1.644121,1.9194157,1.5064737,1.0017668,0.1758827,-0.65000134,-0.14529442,-0.099411978,-0.19117687,-0.32882421,-0.14529442,0.72647206,1.0476492,0.40529494,-0.14529442:2
-0.18615959,-0.59232597,-1.1203423,-1.485892,-1.4452754,-1.4046587,-1.1203423,-0.8360258,-0.67355925,-0.22677623,0.58555652,0.74802308,0.6667898,0.057540235,-0.18615959,-0.10492632,-0.5110927,0.26062343,1.4385059,1.6822058,1.885289,1.1541895,0.95110627,0.46370662:1
-0.84073644,-1.1955608,-1.5503851,-1.6450049,-1.7159697,-1.5503851,-1.1482509,0.15277157,0.6968355,1.2882093,1.2172445,1.0989697,0.88607513,0.38932111,0.41297606,0.29470129,0.43663101,0.38932111,0.62587064,1.2172445,0.72049045,0.36566615,-0.17839776,-0.36763738:1
-1.0997906,-1.3029709,-1.5615641,-1.6169769,-1.6169769,-1.4507384,-1.1552034,-0.23165638,0.82118722,1.0797804,0.96895474,0.91354192,0.74730346,0.43329747,0.45176841,0.54412312,0.74730346,0.82118722,1.1536641,1.0058966,0.56259406,0.24858807,-0.15777261,-0.30554014:1
0.14516143,-0.64662817,-1.1217019,-1.2800598,-1.2800598,-1.4384178,-1.8607056,-1.1744879,0.46187726,1.5703827,1.9398845,1.5703827,0.989737,0.51466324,0.09237545,-0.065982469,-0.065982469,-0.065982469,0.039589477,0.1979474,0.1979474,0.40909129,0.83137908,0.039589477:2
-0.93077246,-1.3855691,-1.5460855,-1.706602,-1.599591,-1.5728382,-0.9575252,-0.23520118,0.2731009,1.2094468,1.3432106,1.1559414,0.96867217,0.64763928,0.62088654,0.7278975,0.78140299,0.56738106,0.19284268,0.2731009,0.78140299,0.51387557,0.059078968,-0.1816957:2
-0.84409689,-1.3437417,-1.6162752,-1.4800085,-1.5481418,-1.5254307,-1.1620527,-0.18547421,0.47314847,1.2226157,1.1999046,1.0409267,0.72297086,0.29145946,0.40501509,0.45043735,0.4958596,0.60941524,1.2226157,1.1544823,0.72297086,0.33688171,-0.14005195,-0.50342999:1
-0.48475508,-0.96951016,-1.3850145,-1.4542652,-1.3850145,-1.2465131,-0.83100871,-1.2465131,-0.20775218,1.3157638,1.1080116,1.3157638,1.4542652,1.1080116,1.2465131,0.90025944,0.96951016,0.20775218,0.20775218,0.069250728,-0.69250726,-0.20775218,0.2770029,-0.069250726:2
0.16252767,-0.56616783,-0.9519478,-1.2091344,-1.3377278,-1.2519989,-0.86621892,-1.2091344,-0.48043895,0.16252767,0.76262985,0.89122317,0.63403653,0.16252767,-0.2232523,-0.52330339,-0.52330339,-0.60903227,-0.13752342,1.6627831,2.0485631,1.8342409,1.0198165,0.54830764:1
0.92671992,0.057919997,-0.98463991,-0.98463991,-1.0425599,-0.92671992,-1.5059199,-1.7375998,-0.81087993,0.11583999,0.98463991,0.92671992,0.81087993,0.28959997,-0.23167998,-0.11583999,-0.11583999,-0.40543996,-0.46335996,0.057919997,0.11583999,0.98463991,2.2009598,1.8534398:2
-0.79638467,-1.3600456,-1.5393923,-1.5650133,-1.693118,-1.5393923,-1.0782151,-0.41207036,0.71525163,1.2789126,1.2789126,0.99708215,0.81773546,0.40780018,0.43342114,0.58714686,0.79211449,0.89459832,0.71525163,0.61276782,0.33093732,0.58714686,-0.0021350877,-0.46331227:2
-0.2935372,-0.48602062,-1.0634709,-1.3714443,-1.4869344,-1.3329476,-1.1404642,-0.71700071,-0.56301398,-0.5245173,0.20691967,0.20691967,0.66887985,-0.024060432,-0.13955047,-0.13955047,-0.25504052,0.28391303,1.4388135,2.0162638,1.746787,1.4388135,1.01535,0.51489313:1
-0.77556409,-1.166253,-1.3895038,-1.5290356,-1.5848483,-1.3895038,-1.6964737,-0.4127815,0.48022183,1.2615997,1.4011315,1.4011315,1.0383489,0.59184724,0.53603454,0.70347266,0.78719172,0.53603454,0.42440912,0.36859642,0.0058138123,-0.022092542,0.256971,0.17325194:2
0.97306642,0.20485609,-0.25607011,-0.56335424,-0.79381734,-0.71699631,-0.56335424,-1.6388487,-1.3315646,-0.56335424,-0.025607005,0.66578228,0.28167712,-0.025607005,-0.33289114,-0.40971218,-0.48653321,-0.40971218,-0.56335424,-0.17924908,0.35849815,2.355845,2.2022029,1.8180978:2
-0.38212754,-1.2068632,-1.4707786,-1.5037681,-1.6027364,-1.4377892,-1.0749055,0.3766293,0.54157643,1.1023967,1.5642487,1.3003333,0.83848128,0.21168216,-0.25016983,0.04673502,-0.2171804,-0.18419097,1.2343544,1.201365,1.0034284,0.47559758,-0.019243835,-0.54707467:1
-1.0997477,-1.4332854,-1.5222287,-1.5667004,-1.5667004,-1.4555212,-1.1886911,-0.6105592,0.41228959,0.92371397,0.96818566,0.79029891,0.65688386,0.43452543,0.5234688,0.72359138,0.6791197,0.63464801,0.6791197,1.3017233,1.0348932,0.65688386,0.212167,-0.18807819:1
-0.907775,-1.2777361,-1.4216099,-1.586037,-1.688804,-1.5449303,-1.1955225,-0.085639151,0.6542831,1.0242442,1.0447976,0.88037047,0.69538989,0.40764235,0.53096273,0.7159433,0.77760349,1.168118,1.1064578,0.96258405,0.42819575,-0.065085755,-0.16785273,-0.45560028:1
-0.92834935,-1.095871,-1.4029941,-1.6542767,-1.6542767,-1.6263564,-1.291313,-0.17450176,0.57934584,1.4169543,1.4169543,1.193592,0.97022976,0.57934584,0.57934584,0.52350527,0.57934584,0.49558499,0.21638218,0.16054162,0.71894724,0.55142555,-0.034900353,-0.1186612:2
-0.92708764,-1.2814693,-1.4080341,-1.6864768,-1.534599,-1.4586601,-1.2814693,-0.62333196,0.46512588,1.0473243,1.0979502,0.89544642,0.79419453,0.38918696,0.5410648,0.51575183,0.51575183,0.51575183,0.79419453,1.4523318,0.9207594,0.56637777,-0.091759525,-0.21832439:1
-0.10666823,-0.54139155,-0.97611488,-1.2659304,-1.2176278,-1.1693252,-1.1210226,-1.6040485,-0.73460192,0.086542133,0.85938359,1.1975017,1.052594,0.85938359,-0.01006305,-0.10666823,-0.2998786,-0.2998786,-0.25157601,0.23144991,0.811081,2.1635536,1.5839225,0.85938359:2
-0.71676689,-1.4536079,-1.6236482,-1.5669681,-1.5953081,-1.5669681,-1.2552276,-0.20664614,0.7852553,1.238696,1.3520561,1.1536758,0.89861547,0.50185489,0.55853497,0.50185489,0.58687502,0.50185489,0.19011444,0.1617744,0.36015469,0.89861547,0.36015469,-0.064945934:2
-0.47845857,-1.1814997,-1.4451402,-1.5916071,-1.5037269,-1.5330203,-1.2986733,-0.9178593,0.40034289,1.1033841,1.3084377,1.4549046,1.1326774,0.60539656,0.869037,0.869037,0.72257009,0.40034289,0.19528921,0.19528921,-0.068351225,0.63468994,0.25387598,-0.12693799:2
0.54147636,-0.13950701,-0.70699314,-0.99073622,-1.2177307,-1.1609821,-0.76374176,-0.59349593,-1.2744793,-0.30975285,0.42797913,0.76847082,0.54147636,0.087487449,-0.30975285,-0.42325008,-0.4799987,-0.70699314,-0.59349593,0.20098468,2.1304376,2.1304376,1.6764486,1.1657111:2
-0.30062385,-0.94997139,-1.2024954,-1.4910943,-1.6714686,-1.4910943,-1.1303457,-0.80567194,-0.48099817,0.31264881,0.70947229,0.63732257,0.63732257,0.38479853,-0.12024954,0.060124772,0.096199634,1.3588198,1.4670444,1.6834936,1.4309695,0.78162203,0.24049908,-0.1563244:1
0.90937687,-0.11367211,-0.68203265,-0.79570476,-1.1367211,-0.56836054,-0.56836054,-1.4777374,-0.79570476,0.34101633,0.79570476,0.34101633,0.34101633,-3.1944443E-9,-0.45468844,-0.79570476,-0.34101633,-0.56836054,-0.11367211,-0.45468844,-3.1944443E-9,2.6144585,2.3871143,1.1367211:2
-0.75799038,-1.0281652,-1.0281652,-1.2082817,-1.4784565,-1.3583788,-1.6885924,-0.99814575,0.3527282,1.2232914,1.3433691,1.2833302,1.2833302,0.71296126,0.7730001,1.0731943,1.0131555,0.7730001,0.3527282,0.082553414,-0.2176408,-0.42777675,0.022514572,-0.097563112:2
-1.0086585,-1.4348522,-1.5414006,-1.6692587,-1.6266394,-1.4987813,-1.0299682,-0.028412906,0.50432924,1.0370714,0.97314233,0.88790359,0.69611641,0.37647112,0.35516143,0.33385175,0.52563892,0.61087767,1.3140973,1.2714779,0.73873578,0.52563892,-0.071032278,-0.24150977:1
-0.79933901,-1.1796936,-1.5362761,-1.6789091,-1.4649596,-1.5838204,-1.2747823,-0.56161737,0.53190217,1.0786619,1.0786619,1.0311176,0.67453515,0.53190217,0.38926918,0.43681351,0.50813,0.34172485,1.1737506,1.2450671,0.81716813,0.55567433,0.080231057,-0.39521222:1
-0.60520039,-1.1512458,-1.5334776,-1.6426867,-1.6972913,-1.4242685,-0.82361857,-0.93282766,0.2138678,0.97833143,1.2513542,1.3605632,1.3059587,0.8145178,0.8145178,0.8145178,0.75991325,0.15926326,0.15926326,-0.059154934,-0.11375948,0.92372689,0.43228598,-0.0045503881:2
0.45180969,-0.46571155,-0.96617768,-1.3832328,-1.4666438,-1.2164107,-0.88276666,-1.6334658,-0.2988895,0.8688648,1.452742,1.2025089,1.0356869,0.034754586,-0.13206746,-0.2988895,-0.13206746,-0.21547848,-0.13206746,-0.048656435,0.034754586,2.1200301,1.452742,0.61863173:2
-0.7699491,-1.2019206,-1.3699095,-1.7298857,-1.5858952,-1.5618968,-1.1059269,-0.50596655,0.50196682,1.1259256,1.0539304,0.88594143,0.54996365,0.30997951,0.33397792,0.35797633,0.45396999,0.54996365,1.4139066,1.4139066,0.8379446,0.4779684,-0.025998282,-0.4099729:1
-0.91943843,-1.3099964,-1.6224427,-1.4662195,-1.563859,-1.4271637,-1.1537732,-0.27501787,0.89665589,1.1505185,1.0528791,0.95523958,0.8185443,0.48657007,0.40845849,0.54515376,0.52562587,1.1700464,1.0333512,0.97476747,0.44751428,0.11554005,-0.33360156,-0.50935262:1
-0.7869407,-1.2839558,-1.4579112,-1.5324634,-1.5324634,-1.4082096,-1.5076127,-0.73723918,0.30649269,1.0271647,1.1265677,1.1514185,1.0023139,0.70410482,0.85320937,0.97746316,1.0271647,0.75380634,0.40589572,0.23194041,-0.066268699,-0.041417941,0.50529875,0.28164193:2
-0.80758584,-1.157022,-1.2735007,-1.6695284,-1.6462327,-1.436571,-1.1337263,-0.83088158,0.47368016,1.1492568,1.1725525,1.0793695,0.7532291,0.28731419,0.42708866,0.45038441,0.47368016,0.40379292,1.2424398,1.2890312,0.82311634,0.47368016,-0.062121988,-0.4814454:1
1.7829162,0.56302617,0.46918848,-0.093837695,0.18767539,0.18767539,0.18767539,-1.5014031,-0.84453926,-0.65686387,-0.46918848,-0.093837695,-0.65686387,-0.56302617,-0.56302617,-0.75070156,-0.84453926,-0.56302617,-0.37535078,-0.46918848,-0.84453926,2.2521047,1.9705916,1.6890785:2
0.19868755,-0.72723501,-0.81982726,-1.097604,-1.6068614,-1.6068614,-1.2364924,-1.097604,0.56905656,1.4949791,1.9579404,1.819052,1.2634985,0.47646431,0.013503031,-0.17168147,-0.12538534,-0.26427374,-0.40316212,0.10609529,0.013503031,0.75424107,0.52276044,-0.032793096:2
-0.19803807,-0.8257814,-1.3638471,-1.2741695,-1.63288,-1.2741695,-1.0051366,-1.0948143,-0.018682831,1.2368038,1.5955143,1.8645471,0.96777096,0.96777096,0.25035002,0.25035002,0.1606724,0.34002764,-0.018682831,-0.018682831,-0.91545902,1.0574486,0.78841573,0.1606724:2
0.4209822,-0.46775803,-0.98229184,-1.0758434,-1.0758434,-1.4968257,-1.9645837,-1.0290676,0.5613096,1.5436015,2.0113595,1.7307047,1.3097225,0.467758,-0.28065482,-1.1315972E-8,-0.046775813,0.1871032,-0.28065482,-0.14032742,0.093551592,0.04677579,0.5145338,-0.046775813:2
-0.3385207,-0.91066836,-1.1776706,-1.4065297,-1.4446728,-1.5209592,-1.1776706,-0.87252519,-1.0632411,-0.10966164,0.57691556,0.92020416,0.88206098,0.46248603,-0.071518461,0.0047678942,-0.033375283,0.99649051,1.3779223,1.4923518,1.4160655,1.0346337,0.76763145,0.19548378:1
1.0925835,0.51273575,-0.0026844804,-0.45367718,-0.51810471,-0.58253224,-1.7422278,-1.6133727,-0.7113873,0.061743049,0.57716328,0.8348734,0.38388069,-0.067112009,-0.51810471,-0.64695977,-0.64695977,-0.77581483,-0.38924966,-0.32482213,0.25502564,0.57716328,2.3811341,2.3167066:2
-1.009503,-1.3546937,-1.527289,-1.5488634,-1.6135867,-1.527289,-1.0958007,-0.10337742,0.75959933,1.1479388,1.2342365,0.9537691,0.73802491,0.2633877,0.43598305,0.41440863,0.39283421,0.22023886,1.2558109,1.1479388,0.80274817,0.37125979,-0.081803003,-0.27597277:1
-0.73961511,-1.0966707,-1.4027184,-1.6577581,-1.6067501,-1.5557422,-1.0456628,-0.99465481,0.025503978,0.84163101,1.0456628,1.3517104,1.2496945,0.89263895,1.0456628,0.99465483,0.63759925,0.53558337,0.28054367,0.076511917,0.076511917,0.63759925,0.43356749,-0.025503961:2
-0.74769628,-1.2071241,-1.34225,-1.3692752,-1.504401,-1.4233255,-1.6125017,-0.66662078,0.27926006,1.1710906,1.1981158,1.1981158,1.0359648,0.79273823,0.95488923,0.90083889,1.1440654,0.73868789,0.41438589,0.30628523,-0.18016778,-0.23421812,0.14413423,0.0090083878:2
-0.80854647,-1.0910081,-1.5711929,-1.6276852,-1.7124237,-1.5711929,-1.3452236,-0.41310017,0.9709619,1.0839466,1.2534236,1.2251774,0.91446957,0.4907771,0.60376176,0.68850025,0.54726943,0.43428477,0.29305395,0.29305395,0.40603861,0.82973108,0.18006929,-0.074146192:2
-0.90129652,-1.1301972,-1.5021608,-1.7310615,-1.6452238,-1.4735482,-1.3018727,-0.12875664,0.61517063,1.3018727,1.3018727,1.2446475,0.90129651,0.41488251,0.50072028,0.61517063,0.64378322,0.35765734,0.12875664,0.35765734,0.98713427,0.64378322,0.042918881,-0.24320699:2
-0.61863745,-0.97916788,-1.3724738,-1.5363513,-1.5363513,-1.4052493,-1.2741473,0.56128033,0.62683132,1.1840147,1.4789942,1.0856882,0.79070879,0.069647931,-0.22533152,-0.19255603,-0.22533152,0.0040969422,1.0856882,1.3806677,1.1840147,0.62683132,-0.15978053,-0.55308646:1
-0.82229569,-1.2812514,-1.6204796,-1.6404342,-1.600525,-1.4608428,-1.2413422,-0.20370318,0.77407208,1.1532094,1.1133002,0.87384506,0.6144353,0.27520715,0.45479853,0.43484393,0.59448071,0.97361805,1.2529824,0.93370886,0.57452611,0.31511635,-0.12388479,-0.34338536:1
0.58212124,-0.12457848,-0.88563971,-1.2661703,-1.4292549,-0.94000123,-1.1030858,-0.55947061,-0.66819364,0.092867594,0.79956731,1.2344594,1.1800979,0.69084427,0.20159062,-0.72255516,-0.66819364,-0.88563971,-0.77691668,-0.34202454,1.0170134,2.1042437,1.6149901,0.85392883:2
-1.0463002,-1.2716251,-1.5470222,-1.4468778,-1.5470222,-1.246589,-1.2716251,-0.54557831,0.53097391,1.3822012,1.2570207,1.2570207,0.85644319,0.45586562,0.35572123,0.38075733,0.53097391,0.38075733,0.43082952,1.2820568,0.85644319,0.43082952,-0.019820247,-0.44543392:1
-0.50098702,-0.93297583,-1.3649646,-1.580959,-1.580959,-1.5089609,-0.93297583,-1.4369628,0.0029999206,1.1549701,1.2989663,1.3709645,1.2269682,1.0829719,0.43498873,0.21899433,0.65098313,0.50698686,0.72298127,0.43498873,-0.14099635,0.65098313,0.36299059,-0.14099635:2
-1.212196,-1.3759009,-1.5396058,-1.6097651,-1.6331515,-1.3525145,-1.0484911,-0.37028495,0.2143755,0.75226311,0.91596802,0.96274086,0.91596802,0.40146684,0.54178535,0.49501251,0.51839893,0.75226311,1.3369236,1.2433779,0.72887669,0.51839893,0.074056983,-0.22996644:1
-0.63647601,-1.0320548,-1.3363461,-1.4276335,-1.4884918,-1.6406374,-1.5797792,-0.81905081,0.70240582,1.2197011,1.432705,1.3414176,0.97626802,0.70240582,0.76326409,0.70240582,0.85455149,0.55026016,0.24596883,0.30682709,0.032964902,0.093823167,0.21553969,-0.18003903:2
0.18375622,-0.28320076,-1.2171147,-1.4246511,-1.0614624,-1.6840717,-1.2689988,-1.1652306,0.85824964,1.8959318,1.9478159,1.532743,1.0139019,0.33940854,-0.23131665,-0.17943254,-0.23131665,-0.23131665,-0.12754843,0.079988004,-0.023780213,0.44317676,0.59882908,0.23564033:2
-1.1496812,-1.4485827,-1.5606708,-1.5046268,-1.6353962,-1.4299014,-1.0189118,-0.1969325,0.83054151,1.1481244,1.1294431,1.073399,0.77449748,0.40087055,0.47559594,0.53163998,0.60636536,0.60636536,1.073399,0.94262959,0.56900267,0.32614517,-0.15956981,-0.38374597:1
-0.88380102,-1.3252636,-1.5354839,-1.4724178,-1.59855,-1.5354839,-1.2411755,-0.042919964,0.69285097,1.1553356,1.2184016,1.1132915,0.77693907,0.46160867,0.41956462,0.46160867,0.56671881,0.54569678,0.94511529,1.1132915,0.73489502,0.23036638,-0.21109618,-0.58949265:1
-0.40284561,-1.0808052,-1.3166173,-1.5524293,-1.4934763,-1.4639998,-1.5819058,-0.8449932,0.65830864,1.3362683,1.3657448,1.2773153,1.0120267,0.59935563,0.74673816,0.86464419,0.95307371,0.59935563,0.21616105,-0.019651016,-0.13755705,-0.019651016,0.42249659,-0.13755705:2
-1.0101776,-1.1284423,-1.4832364,-1.6724599,-1.648807,-1.3413188,-1.1284423,-0.34789532,0.40899874,1.1658928,1.0476281,1.0003222,0.59822226,0.10151053,0.45630462,0.45630462,0.5036105,0.52726344,1.4497281,1.3314634,0.81109871,0.40899874,-0.13501886,-0.37154826:1
-0.94843065,-1.2693498,-1.475655,-1.6590373,-1.5673462,-1.5673462,-1.2235042,-0.0085960432,0.56447384,1.0916981,1.0458526,0.88539298,0.74785621,0.2664775,0.31232309,0.49570546,0.44985986,0.65616503,1.2750805,1.3209261,0.72493341,0.35816868,-0.14613282,-0.32951519:1
-0.93670299,-1.229677,-1.424993,-1.6398406,-1.5812458,-1.5031194,-1.2882718,-0.27262858,0.66488823,1.0555202,1.1336466,1.1727098,0.84067263,0.37191423,0.37191423,0.62582503,0.60629343,0.78207783,1.0945834,0.97739383,0.56723023,0.29378783,-0.21403377,-0.46794458:1
-0.62537539,-1.1953378,-1.2496199,-1.4396073,-1.7924412,-1.6295948,-1.4396073,-0.27254154,0.48740829,1.3016403,1.4644867,1.3830635,1.0573707,0.56883149,0.62311362,0.51454936,0.3245619,0.27027977,0.18885657,0.37884403,0.92166534,0.40598509,0.026010176,-0.27254154:2
0.34972127,-0.35664644,-0.93836103,-1.1045652,-0.97991208,-1.1045652,-1.0214631,-0.89680999,-0.85525895,-0.14889123,0.51592543,0.51592543,0.26661919,-0.19044228,-0.56440165,-0.64750374,-0.73060582,-0.39819749,2.2195182,1.8040077,1.7209057,1.3469463,0.84833377,0.34972127:1
-0.65912631,-1.3157654,-1.4650015,-1.6440849,-1.4948487,-1.6142376,-1.3157654,-0.30095956,0.4750684,1.3704853,1.2510964,1.1615547,1.0123185,0.53476286,0.65415177,0.65415177,0.80338791,0.4750684,0.11690165,-0.062181731,0.8929296,0.56461009,0.20644334,-0.30095956:2
-0.99164739,-1.2592893,-1.4651676,-1.6092825,-1.5475189,-1.3828163,-1.2387014,-0.22989749,0.61420375,1.1288996,0.94360911,1.211251,0.7583186,0.51126457,0.4083254,0.53185241,0.67596726,1.1288996,1.1083118,0.86125777,0.53185241,0.22303488,-0.291661,-0.62106636:1
1.2030304,0.42502271,0.07924152,-0.18009437,-0.18009437,0.07924152,0.07924152,-1.5632191,-0.95810205,-0.43943026,-0.52587555,-0.0072037775,-0.18009437,-0.69876616,-0.87165675,-1.0445473,-0.35298496,-0.26653966,-0.52587555,-0.35298496,-0.18009437,2.1539286,2.6726004,1.6352569:2
-1.154312,-1.4552188,-1.4953397,-1.5755815,-1.5154001,-1.4150979,-1.154312,-0.63274014,0.53076618,0.81161254,1.0723984,1.1325798,0.99215663,0.73137072,0.51070573,0.71131027,0.65112891,0.59094755,0.67118936,1.052338,0.75143118,0.45052437,-0.071047431,-0.19141016:2
-0.89160751,-1.2869623,-1.5340591,-1.5093494,-1.5834785,-1.4599301,-1.4846398,-0.81747848,0.29445698,1.208715,1.208715,0.98632795,0.9369086,0.51684408,0.7145215,0.76394086,0.81336021,0.51684408,0.46742472,0.51684408,0.36858602,0.56626343,0.54155375,0.14619892:2
-0.58060799,-1.1742341,-1.3929384,-1.3929384,-1.4866688,-1.6428862,-1.2054775,-0.20568623,0.41918333,1.1690268,1.575192,1.3252442,0.82534857,0.41918333,-0.018225366,-0.049468846,0.044261591,0.45042681,1.2002703,1.2002703,0.88783553,0.35669638,-0.14319928,-0.58060799:1
-0.6321951,-1.1869991,-1.3558525,-1.5970716,-1.6211935,-1.5005839,-1.1628772,-0.55982936,0.52565666,1.3940455,1.4664112,1.3216798,1.1769483,0.83924152,0.76687578,0.74275387,0.52565666,0.42916902,0.21207181,0.16382798,0.019096515,0.45329093,-0.0050253963,-0.4150979:2
-0.20481136,-0.65167251,-0.89541494,-1.3016524,-1.4235236,-1.3422761,-1.1797812,-0.81416746,-1.0172862,-0.0016926557,0.60766345,0.68891094,0.48579224,0.24204979,-0.042316397,-0.36730633,-0.36730633,-0.2454351,1.2982671,1.9076232,1.785752,1.460762,0.85140589,0.52641598:1
-0.76070666,-1.112417,-1.6559692,-1.5600482,-1.4961009,-1.5920219,-1.2722853,-0.76070666,0.55021341,1.4135023,1.061792,1.2216603,0.96587098,0.39034511,0.77402903,0.74205537,0.86995001,0.67810806,0.32639779,0.19850314,0.32639779,0.61416074,0.16652948,-0.089259792:2
-1.0798552,-1.3906463,-1.5115095,-1.563308,-1.5115095,-1.459711,-1.1143875,-0.35467596,0.47410031,1.043884,1.1820134,1.0784163,0.8539561,0.62949586,0.57769735,0.68129438,0.76762524,0.95755314,0.95755314,0.81942376,0.47410031,0.14604304,-0.19928041,-0.45827299:1
-0.41836986,-1.0698771,-1.2998209,-1.3381449,-1.4147928,-1.2998209,-0.80160944,-0.57166569,0.92296866,1.6894478,1.459504,1.1912363,1.0379405,0.30978534,-0.26507403,-0.45669382,-0.3800459,-0.3800459,-0.07345424,1.497828,1.1912363,0.80799679,0.11816555,-0.45669382:1
-0.80092285,-1.2008288,-1.3341308,-1.4940932,-1.5207536,-1.4940932,-1.547414,-0.77426245,0.55875754,1.1986071,1.2519279,1.3319091,1.0919655,0.61207835,0.66539915,0.85202195,0.93200315,0.58541795,0.45211594,0.18551195,0.025549545,0.13219115,0.26549314,0.025549545:2
-0.41978867,-0.87042444,-1.2888719,-1.7395077,-1.5785664,-1.6429429,-1.2244954,-0.25884733,0.61023593,1.09306,0.93211862,1.3505661,1.0286834,0.38491805,-0.13009425,-0.097905981,-0.033529445,0.063035362,1.3827544,1.3505661,0.89993035,0.61023593,0.030847093,-0.45197694:1
-0.85784952,-1.135321,-1.3572983,-1.496034,-1.5515283,-1.3295511,-1.6070227,-0.88559668,0.50176103,1.1954399,1.2786813,1.1399456,0.94571549,0.72373826,0.86247403,0.89022118,1.0012098,0.72373826,0.19654234,0.2797838,0.030059411,0.0023122563,0.36302526,0.085553718:2
-0.83433063,-1.173309,-1.5607128,-1.7544147,-1.7059893,-1.4638619,-1.173309,-0.059522975,0.5457955,1.1269012,1.054263,0.95741206,0.57000824,0.23102989,0.37630632,0.37630632,0.40051906,0.49737002,1.3448159,1.2963904,0.73949741,0.27945537,0.27945537,-0.35007584:1
-0.4778666,-0.95573317,-1.4898193,-1.6022585,-1.4898193,-1.6584781,-1.7146977,-0.67463519,0.56219599,1.1806115,1.3492703,1.1806115,1.1243919,0.61841559,0.5059764,0.70274499,0.70274499,0.5059764,0.36542739,0.33731759,0.33731759,0.4778666,0.1967686,-0.084329399:2
-0.90853352,-1.2624192,-1.534639,-1.561861,-1.6435269,-1.534639,-1.1263093,-0.44575989,0.67034121,1.3236687,1.3508907,1.2420027,1.0242269,0.56145329,0.64311923,0.72478516,0.72478516,0.45256538,0.31645549,0.50700934,0.1803456,0.47978736,0.017013731,-0.20076209:2
-0.5860394,-1.2367308,-1.6371563,-1.6121297,-1.53705,-1.4619702,-1.3118106,-0.68614577,0.51513073,1.1908487,1.3410083,1.2409019,1.1658221,0.64026369,0.66529029,0.74037007,0.81544985,0.51513073,0.33994457,0.46507754,0.16475841,0.28989139,-0.035454339,0.01459885:2
-0.58635944,-1.4079252,-1.354921,-1.5139337,-1.5139337,-1.5404358,-1.4079252,-0.74537218,0.50022755,1.03027,1.1362785,1.0567721,0.81825301,0.4472233,0.47372543,0.50022755,0.55323179,0.52672967,0.34121482,1.3217933,1.0567721,0.65924028,0.15569997,-0.50685308:2
-0.28246322,-1.0118619,-1.3551084,-1.44092,-1.3980142,-1.5696374,-1.1405793,-1.0118619,-0.025028392,1.0476168,1.6053922,1.3479574,1.21924,0.87599353,0.79018193,1.004711,0.96180514,0.53274709,0.27531225,-0.025028392,-0.58280386,-0.32536903,0.23240645,0.27531225:2
-0.79589475,-1.1791345,-1.5220332,-1.6027152,-1.6632267,-1.4816921,-1.1387934,-0.31180248,0.49501796,1.0396218,1.1808153,1.0396218,0.87825766,0.27314234,0.43450643,0.3941654,0.53535898,0.85808715,1.2211564,1.1404743,0.69672306,0.23280132,-0.11009737,-0.61436015:1
0.15033169,-0.32783176,-0.84946461,-1.0233422,-0.97987282,-1.0233422,-0.84946461,-1.4145669,-1.0233422,-0.11048474,0.10686229,0.49808693,0.41114812,-0.023545933,-0.32783176,-0.54517878,-0.63211759,-0.67558699,1.367475,1.8891079,1.8891079,1.6717608,1.1935974,0.62849514:1
-0.70155479,-1.0333245,-1.3927417,-1.4203892,-1.4756842,-1.5033316,-1.6692165,-0.70155479,0.65317168,1.3167112,1.2614162,1.2890637,0.95729395,0.73611412,0.7637616,0.98494142,0.81905655,0.59787672,0.40434437,0.12786959,-0.038015292,-0.2868426,0.12786959,0.18316455:2
-0.67511085,-1.1707945,-1.4186364,-1.2017748,-1.5735375,-1.5115771,-1.0468736,-0.70609108,0.40919721,1.1217425,1.4005646,1.4315448,1.3386041,0.84292043,0.8119402,0.99782158,0.99782158,0.68801928,0.16135537,0.099394907,-0.27236786,-0.33432832,-0.17942717,-0.2104074:2
-0.77791351,-1.2288779,-1.5671011,-1.5445529,-1.5896494,-1.4994565,-1.1837814,-0.23675629,0.82300995,1.2288779,1.138685,0.98084747,0.64262421,0.43969025,0.41714203,0.39459381,0.43969025,0.46223846,1.1612332,1.3190707,0.71026886,0.2593045,-0.23675629,-0.55243133:1
-0.86967889,-1.1785167,-1.4358816,-1.5130911,-1.4873546,-1.4616181,-1.5388276,-0.50936804,0.44288209,1.0348213,0.98334837,1.1635038,0.98334837,0.85466593,0.9061389,1.0862943,0.98334837,0.93187539,0.52009155,0.31419964,-0.071847704,-0.12332068,0.082571234,-0.097584194:2
0.89930603,-0.25400247,-0.47368027,-1.5171499,-1.2425526,-0.91303589,-2.1212638,-1.1876332,0.2402726,1.5583395,1.7230978,1.8329367,1.1739033,0.51486986,0.2402726,0.020594797,-0.089244108,-0.30892192,-0.25400247,-0.14416356,-0.25400247,-0.25400247,0.67962822,0.1304337:2
-0.38531557,-0.80886858,-1.4794941,-1.4794941,-1.5500863,-1.4794941,-1.2677176,-0.032354743,0.39119825,1.0265277,1.2030081,1.0265277,0.60297474,0.17942175,-0.3147234,-0.24413124,-0.35001948,0.0029413401,1.555969,1.6618572,1.3088964,0.53238258,0.10882959,-0.20883515:1
-0.28216198,-0.73362116,-1.3731883,-1.4860531,-1.5989179,-1.2979451,-0.99697236,-0.43264837,0.43264839,1.3731883,1.2979451,1.0345939,0.65837798,0.018810804,-0.39502678,-0.47026997,-0.31978358,-0.24454039,1.4484315,1.6741611,1.2227019,0.69599958,0.16929719,-0.39502678:1
-0.49148107,-1.022812,-1.3416105,-1.4744432,-1.4744432,-1.5010097,-1.5275763,-0.70401342,0.3852149,1.3150439,1.2884774,1.2884774,1.075945,0.83684615,0.78371306,0.83684615,0.96967887,0.81027961,0.43834799,0.25238217,0.039849821,-0.43834798,-0.11954945,-0.22581563:2
-0.83116338,-1.3237046,-1.5699752,-1.487885,-1.4605216,-1.5426118,-1.2416144,-0.55752934,0.56437018,1.166365,1.1937284,0.97482123,0.94745783,0.45491657,0.42755317,0.50964337,0.48227997,0.37282636,0.48227997,1.4399991,0.92009442,0.48227997,-0.010261279,-0.39334891:2
-0.81304464,-1.0906696,-1.2493125,-1.5269375,-1.5269375,-1.5665982,-1.1303303,-0.77338392,0.25779464,1.1303303,1.2493125,1.2493125,1.2096518,1.0113482,0.97168749,0.97168749,1.0113482,0.57508035,0.37677678,0.019830357,-0.33711607,-0.21813393,0.29745535,-0.099151787:2
-0.86144591,-1.3194957,-1.4444184,-1.5693411,-1.5693411,-1.5693411,-1.2570344,-0.17437123,0.90829193,1.1373168,1.1164964,1.0748555,0.78336926,0.32531946,0.36696035,0.47106258,0.51270347,0.47106258,1.1164964,1.0956759,0.72090792,0.3461399,-0.21601212,-0.46585745:1
-0.088967941,-0.72953716,-1.0284695,-1.2419925,-1.5836295,-1.2846972,-0.94306023,-0.98576484,-0.857651,0.039145902,0.59430589,0.80782896,0.72241973,0.3380782,-0.088967941,-0.2597864,-0.30249101,-0.38790024,0.12455513,1.7900351,1.8327397,1.6192166,1.1921705,0.72241973:1
-0.73591229,-1.0517733,-1.078095,-1.3676343,-1.5518866,-1.499243,-1.499243,-0.97280806,0.71178401,1.132932,1.238219,1.3171843,1.2908625,0.71178401,0.76442751,0.97500152,0.94867976,0.63281876,0.47488825,0.21167075,-0.13051201,-0.26212077,-0.051546765,-0.20947727:2
-0.32859526,-0.94077274,-1.3368876,-1.4089085,-1.5529502,-1.372898,-1.1928458,-0.9047623,-0.50864746,-0.14854306,0.39161353,0.71570749,1.0398015,0.31959265,0.24757177,-0.11253262,-0.1845535,0.35560309,1.2558641,1.5439476,1.6159685,1.3999058,0.85974925,0.24757177:1
0.4766838,-0.48671925,-1.0888462,-1.2694842,-1.510335,-1.1490589,-0.90820807,-0.96842076,0.23583304,1.7411503,1.9820011,1.801363,1.018598,0.11540766,-0.54693194,-0.30608118,-0.36629387,-0.48671925,-0.42650656,-0.0050177212,0.29604573,1.3196615,0.53689649,-0.0050177212:2
-0.73124782,-1.063827,-1.4731552,-1.5754873,-1.7034024,-1.4731552,-1.3708232,-0.68008179,0.44557083,1.4944744,1.3409763,1.1618952,0.9316481,0.49673686,0.5734859,0.70140097,0.26648973,0.77815001,0.52231987,0.59906891,0.36882179,0.49673686,0.11299165,-0.21958754:2
-1.0055433,-1.1924401,-1.6129577,-1.6129577,-1.5195093,-1.4961473,-1.1924401,-0.094421781,0.67652722,1.1904932,1.0035965,0.88678604,0.67652722,0.37282004,0.30273376,0.48963049,0.58307886,0.72325141,1.3073037,1.1904932,0.65316513,0.27937167,-0.07105969,-0.53830152:1
0.55440989,-0.17467709,-0.72149233,-1.1467931,-1.2075504,-1.2683076,-1.0252786,-1.5720939,-0.72149233,0.25062366,0.79743889,1.1619824,1.2834969,0.31138091,-0.11391984,-0.053162593,0.0075946563,-0.59997783,-0.72149233,-0.41770609,0.37213816,1.2227397,2.0733412,1.7087977:2
0.1047259,-0.50966607,-0.95649659,-1.3474733,-1.5150347,-1.3474733,-1.1799119,-1.4591809,-0.90064277,0.4398488,0.77497169,0.94253314,0.66326406,0.4398488,-0.34210462,0.16057972,-0.23039699,-0.062835542,0.048872089,0.77497169,1.3335098,2.1154633,1.2218022,0.8308255:2
-0.44323823,-1.1644394,-1.4949899,-1.3747897,-1.4348898,-1.4048398,-1.7654404,0.0676126,0.72871368,1.3297147,1.4499149,1.3297147,0.99916412,0.54841338,0.78881377,0.84891387,0.93906402,0.39816314,0.24791289,0.1277127,-0.23288789,-0.41318818,0.037562551,-0.11268769:2
-1.1695954,-1.4291358,-1.528959,-1.5688883,-1.6088176,-1.5089944,-1.0897369,-0.13143391,0.54736401,0.9865862,0.9865862,1.1063741,0.7669751,0.44754079,0.56732865,0.52739936,0.62722259,0.54736401,1.1862326,1.0464801,0.62722259,0.42757614,-0.071539983,-0.29115107:1
-0.98662972,-1.3528016,-1.5236818,-1.6457391,-1.7189735,-1.4504474,-1.0598641,-0.083405808,0.50246916,1.3812816,1.3568702,1.1615785,0.9418754,0.52688062,0.60011499,0.60011499,0.67334936,0.40482333,0.1362973,0.18512022,0.72217228,0.72217228,0.063062935,-0.15664018:1
-0.33417379,-1.0580159,-1.4344138,-1.3765065,-1.4923212,-1.5791823,-1.5212749,-0.79743275,0.50548309,1.1714179,1.4030473,1.2582789,1.1135105,0.70815889,0.82397363,0.96874206,0.76606626,0.73711257,0.41862203,0.24489992,-0.1025443,-0.47894221,0.013270441,0.042224126:2
-0.44710017,-1.0118583,-1.3199082,-1.5509456,-1.4996039,-1.4739331,-1.5766164,-0.75515005,0.34869535,1.2471742,1.2985158,1.1958325,1.0161368,0.78509935,0.81077017,0.96479511,1.0674784,0.81077017,0.400037,0.16899959,-0.24173359,-0.19039194,0.11765794,-0.16472112:2
-0.64251105,-0.95489211,-1.6364508,-1.4376628,-1.4944594,-1.6648491,-1.2104766,-0.67090933,0.91939426,1.5157581,1.402165,1.3737667,0.86259771,0.69220804,0.80580115,0.63541148,0.6070132,0.3514287,0.09584419,-0.017748924,-0.10294376,0.46502181,0.09584419,0.010649354:2
-0.56673137,-1.0661404,-1.3599105,-1.5067955,-1.5655495,-1.4480415,-1.6536805,-0.59610837,0.7258568,1.2546429,1.3133969,1.2840199,1.1077579,0.69647979,0.7552338,0.96087283,0.78461081,0.54959477,0.31457874,-0.0085682986,-0.15545331,-0.12607631,0.16769372,0.13831672:2
-0.92930619,-1.2588109,-1.6089096,-1.5471275,-1.5677215,-1.4235632,-1.2794049,-0.29089086,0.67702916,1.1300981,1.0271279,1.0477219,0.84178151,0.57405895,0.49168277,0.61524703,0.71821726,0.80059343,1.1918802,0.8829696,0.34752447,0.22396022,-0.14673256,-0.51742533:1
-0.86758006,-1.1713481,-1.5303468,-1.5855773,-1.6960384,-1.4198856,-1.3094245,-0.64665782,0.7341062,1.2587965,1.2035659,1.0931048,0.67887564,0.43033811,0.56841452,0.51318396,0.48556868,0.26464643,0.34749227,1.1207201,0.95502845,0.62364508,0.043724191,-0.09435221:2
-1.019922,-1.3105299,-1.4223021,-1.4446566,-1.5340744,-1.5340744,-1.3552388,-0.23751608,0.50018091,1.0590423,1.0813967,0.90256109,0.701371,0.23192746,0.43311755,0.43311755,0.65666209,0.88020663,1.3272957,1.1484601,0.701371,0.43311755,-0.10338935,-0.52812398:1
-0.83966127,-1.3369153,-1.3892578,-1.4416003,-1.310744,-1.415429,-1.4677716,-0.63029118,0.52124428,1.2016971,1.2016971,1.2016971,1.097012,0.88764194,0.80912815,0.99232698,1.0184982,0.67827185,0.57358681,0.023990328,-0.23772229,-0.29006481,0.15484663,-0.002180934:2
0.11869993,-0.73168768,-0.94428459,-0.94428459,-0.90176521,-1.1143621,-1.0718427,-1.4970365,-0.73168768,-0.0088582164,0.33129682,0.28877744,0.54389373,0.16121931,-0.093896977,-0.34901326,-0.56161017,-0.60412955,0.076180545,1.8194752,1.8194752,1.8619946,1.4368008,1.0966457:1
-0.73167617,-1.1712925,-1.5132163,-1.7086013,-1.659755,-1.3422544,-1.3666775,-0.2187905,0.41621079,1.2465971,1.1977509,0.97794272,0.68486519,0.5139033,0.48948017,0.5139033,0.46505705,0.5139033,0.73371145,1.3442896,0.85582708,0.39178767,-0.047828615,-0.5851374:1
-0.95302723,-1.1540564,-1.5561148,-1.6454611,-1.5337782,-1.4667685,-1.2434027,-0.10423735,0.7668891,1.1019377,1.1689475,1.1466109,0.92324513,0.32015759,0.32015759,0.43184046,0.49885019,0.40950389,1.2136206,1.0572646,0.72221595,0.25314786,-0.23825681,-0.43928599:1
-0.59244345,-0.94717051,-1.2132158,-1.5088217,-1.4792611,-1.4201399,-1.5383823,-0.7106858,0.61954066,1.5359189,1.4767977,1.240313,1.240313,0.7673436,0.7673436,0.82646477,0.85602536,0.47173772,0.057889489,-0.0012316875,-0.20815581,-0.2377164,0.057889489,-0.060352863:2
-0.75959786,-1.058456,-1.4116521,-1.438821,-1.6018345,-1.4931588,-1.5203278,-0.97694926,0.082638815,0.97921333,1.0607201,1.0063823,0.92487548,0.43583484,0.87053763,0.89770656,1.1693958,1.087889,0.54451054,0.32715914,0.29999021,0.59884839,0.16414559,-0.18905044:2
-0.63729418,-0.9437526,-1.3337906,-1.5845293,-1.3895103,-1.4173701,-1.5009497,-0.86017303,0.36566061,1.062157,1.3407555,1.3686154,1.0342971,0.83927815,0.75569858,1.0342971,1.1457365,0.69997887,0.36566061,0.17064162,-0.13581678,-0.38655548,0.0034824906,0.0034824906:2
-0.91190859,-1.2326701,-1.5040837,-1.5534317,-1.6521275,-1.4547358,-1.1339743,-0.41842931,0.59320322,0.91396475,1.1360304,0.96331268,0.83994286,0.34646358,0.22309376,0.22309376,0.4698334,1.1607044,1.3334221,1.1853784,0.56852926,0.34646358,-0.072993806,-0.36908138:1
-0.85092255,-1.2251503,-1.3320725,-1.7330308,-1.599378,-1.4657253,-1.2518809,-0.5568865,0.61925779,1.2875216,1.3944438,1.2340605,0.99348551,0.80637165,0.85983276,0.67271889,0.64598834,0.51233558,0.32522172,0.27176061,0.1648384,0.40541337,-0.022275459,-0.15592822:2
0.45465814,-0.067715041,-0.88029555,-1.1124614,-1.2865858,-1.1705029,-0.82225409,-1.1124614,-0.067715041,0.28053375,0.57074107,0.57074107,0.62878254,-0.067715041,-0.2998809,-0.35792237,-0.64812969,-0.76421262,-0.41596383,-0.24183944,0.80290693,2.311985,2.311985,1.3833216:2
2.020761,-0.17042563,-0.68170251,-1.0469003,-1.2660189,-1.1929794,-0.90082118,-1.4120981,0.34085127,1.363405,1.7286028,1.6555632,1.2173259,0.7790886,-0.24346518,-0.31650474,-0.024346512,-0.097386067,-0.097386067,-0.24346518,-0.97386073,-0.60866296,0.34085127,-0.17042563:2
-0.79600314,-0.94205876,-1.1757478,-1.4386479,-1.4094368,-1.467859,-1.5847035,-0.82521426,0.46007521,1.1903533,1.2779867,1.336409,1.1319311,0.81060871,0.83981983,0.95666433,0.98587546,0.86903096,0.34323071,0.021908344,-0.35783628,-0.32862515,0.051119469,0.051119469:2
-0.93839001,-1.1355135,-1.6283223,-1.6036818,-1.6776032,-1.4558392,-1.1108731,-0.44558125,0.73715977,1.2299685,1.2299685,1.0574855,0.86036196,0.44147451,0.51539583,0.41683408,0.51539583,0.31827232,0.26899145,1.3285303,0.81108108,0.51539583,-0.026693806,-0.22381731:1
0.73517838,-0.44110703,-1.0012429,-1.1132701,-1.0572565,-1.3933381,-1.8974604,-0.94522937,0.34308325,1.3513279,1.6874094,1.9114638,1.743423,0.45511043,0.17504247,-0.049011895,0.11902888,0.007001696,-0.16103907,-0.049011895,-0.44110703,-0.49712062,0.51112402,0.007001696:2
-0.87162707,-1.2423444,-1.3482636,-1.5601021,-1.4541829,-1.3217838,-1.4277031,-0.79218764,0.37292398,1.1143587,1.1673183,1.1673183,1.1408385,0.77012112,0.84956055,1.0349192,1.0084394,0.84956055,0.47884321,0.31996436,0.0022066437,-0.18315202,0.055166263,-0.1301924:2
-0.19642556,-0.71542152,-1.0181691,-1.2776671,-1.3641664,-1.4506658,-1.0614188,-0.71542152,-0.93166983,-0.023426907,0.45231939,0.66856771,0.62531804,0.23607108,-0.28292489,-0.19642556,-0.54242287,-0.10992624,1.4470616,1.8363086,1.66331,1.6200603,0.79831669,0.53881872:1
-1.0672417,-1.3645006,-1.51313,-1.5874447,-1.5874447,-1.51313,-1.0672417,-0.42318095,0.44382393,1.0631131,0.9392553,0.98879844,0.81539746,0.3942808,0.54291021,0.64199648,0.49336707,0.41905237,0.91448374,1.4346867,0.88971217,0.44382393,-0.15069371,-0.15069371:1
-1.0328703,-1.2617612,-1.5593194,-1.6737649,-1.5822085,-1.467763,-1.1473157,-0.1173066,0.56936616,1.0500371,0.95848072,0.86692435,0.63803343,0.29469706,0.31758615,0.36336434,0.56936616,0.66092252,1.4620408,1.1415935,0.84403526,0.47780979,0.020027953,-0.3919757:1
0.70787592,-0.64224504,-0.75475512,-0.75475512,-0.97977528,-1.4298156,-1.0922854,-1.8798559,-0.19220472,1.3829364,1.8329767,1.9454868,1.1579162,0.37034568,-0.19220472,-0.3047148,0.70787592,0.2578356,-0.3047148,-0.64224504,-0.41722488,-0.19220472,1.0454062,0.37034568:2
-0.43482661,-0.9751016,-1.4585055,-1.486941,-1.3731989,-1.2310213,-1.6575542,-0.88979502,0.33293262,1.0722563,1.3566116,1.4419181,1.0153852,0.70259447,0.87320763,0.95851421,1.0153852,0.84477211,0.50354577,0.16231946,-0.1220358,-0.23577791,-0.1220358,-0.29264898:2
0.062451477,-0.96306758,-1.1208397,-1.2786119,-1.5152702,-1.1997258,-0.96306758,-1.8308145,-0.41086501,0.53576797,1.1668566,1.0090845,1.6401731,0.53576797,0.8513123,0.69354013,0.53576797,0.22022364,-0.41086501,-0.17420676,-0.48975109,1.0090845,0.77242622,1.3246288:2
-0.97934557,-1.4245026,-1.5580498,-1.6915969,-1.6470812,-1.3577291,-1.0906348,-0.11128927,0.71225132,1.0906348,1.068377,0.97934557,0.75676703,0.2893521,0.46741493,0.37838351,0.40064137,0.35612566,1.3132134,1.2019241,0.71225132,0.37838351,-0.044515708,-0.20032068:1
-0.98463039,-1.4533063,-1.5273077,-1.4779734,-1.6506435,-1.5026406,-1.0586319,-0.44195308,0.54473291,1.3587488,1.1614116,0.9887416,0.76673725,0.52006576,0.34739571,0.47073146,0.54473291,0.19939281,0.32272856,1.3340817,0.890073,0.61873436,0.15005851,-0.12128014:1
-0.41297403,-1.1731387,-1.2900871,-1.5239839,-1.4070355,-1.5824581,-1.7286436,-0.79305634,0.37642767,1.2535407,1.2827778,1.2827778,0.90269549,0.75650998,0.87345839,0.78574708,0.93193259,0.66879868,0.34719057,0.11329377,-0.032891728,0.37642767,0.025582472,-0.032891728:2
1.2373196,0.75706614,0.19677049,-0.52360963,-0.28348292,-0.44356739,-1.4040742,-1.9643699,-1.1639475,-0.76373634,0.11672825,0.4368972,0.59698167,-0.12339845,-0.12339845,-0.20344068,-0.84377857,-0.60365187,-0.36352516,-0.043356216,0.27681272,0.75706614,2.1177842,2.3579109:2
-1.005977,-1.3970696,-1.5274338,-1.6056523,-1.6317251,-1.4231424,-1.0581227,-0.51059311,0.58446614,1.2102143,1.3405784,1.3405784,1.0537772,0.45410194,0.63661182,0.63661182,0.76697601,0.50624761,0.21944639,0.24551923,0.11515504,0.66268466,0.34981058,0.036936519:2
-0.010691989,-0.86605121,-1.2937309,-1.0371231,-1.2937309,-1.5075707,-1.2081949,-0.99435509,0.41698762,1.1868109,1.4006508,1.144043,0.67359538,0.20314782,-0.39560364,-0.4383716,-0.4383716,-0.48113956,0.1176119,1.8283304,1.4861867,1.144043,0.33145171,0.032075972:2
-0.763112,-1.0624605,-1.5523036,-1.5250901,-1.5250901,-1.5795171,-1.3345956,-0.817539,0.40706866,1.0057657,1.2506873,1.1962603,1.0601927,0.7608442,0.7608442,0.89691172,1.0329792,0.57034968,0.51592267,0.40706866,0.18936063,0.35264165,-0.055560899,-0.19162842:2
-1.2598921,-1.1702998,-1.5510672,-1.5286691,-1.5734652,-1.3270863,-1.1479017,-0.25197842,0.86792567,1.226295,1.1591007,1.0471103,0.75593526,0.28557554,0.30797362,0.4647602,0.55435252,0.50955636,1.1814988,1.1814988,0.55435252,0.33037171,-0.13998801,-0.47595924:1
-0.75747271,-1.2441091,-1.3831481,-1.522187,-1.661226,-1.4526676,-1.1398299,-0.72271297,0.35483903,1.1890728,1.4671508,1.3628716,1.2238326,0.66767671,0.63291697,0.63291697,0.77195594,0.45911826,0.28531955,-0.027518127,-0.027518127,0.80671568,0.28531955,-0.20131684:2
0.91295034,0.59654878,0.042846036,-0.58995708,-0.74815786,-0.66905747,-1.7764629,-1.9346637,-0.98545903,-0.19445513,0.28014722,0.67564917,0.51744839,0.12194644,0.12194644,-0.58995708,-0.51085669,-0.51085669,-0.27355552,0.042846036,0.438348,0.51744839,2.4949582,2.0203558:2
-0.9521658,-1.408192,-1.5348659,-1.6362051,-1.5602007,-1.408192,-1.053505,-0.54680919,0.5932563,1.1759564,1.0746173,0.74526503,0.89727376,0.41591278,0.61859109,0.64392587,0.61859109,0.3652432,0.31457362,1.3279652,1.0239477,0.66926066,0.01055616,-0.39480045:1
-0.6390164,-1.3784071,-1.6407715,-1.6407715,-1.6407715,-1.4976636,-1.1875966,-0.18584147,0.55354919,1.1021294,1.149832,1.1736833,0.88746755,0.43429264,0.43429264,0.43429264,0.52969787,0.3627387,0.72050837,1.2690886,0.79206231,0.33888739,-0.18584147,-0.18584147:1
-0.47668336,-1.0047018,-1.3127126,-1.4447173,-1.6207234,-1.3127126,-1.1367065,-0.65268952,-0.21267411,-0.5206849,0.31534438,0.75535978,0.97536749,0.35934592,0.051335125,-0.12467103,-0.25667565,0.57935362,1.3713814,1.4593844,1.5473875,1.3713814,1.019369,0.27134283:1
0.27403158,-0.15622361,-0.83233891,-0.95526896,-1.016734,-1.2011291,-0.83233891,-1.3855242,-0.77087388,0.33549661,1.134542,1.0730769,1.0730769,0.27403158,0.089636502,-0.46354875,-0.64794382,-0.77087388,-0.77087388,-0.094758582,0.33549661,2.2409125,1.8106573,1.257472:2
0.45157748,-0.48441948,-0.97704946,-1.6174684,-1.7159944,-1.3218905,-1.2233645,-0.28736749,0.69789248,1.5353634,1.8309414,1.6338894,1.1412595,0.35305149,-0.23810449,-0.23810449,-0.33663049,-0.38589349,-0.53368248,-0.13957849,0.15599949,1.1905225,0.55010349,-0.041052496:2
-0.32666971,-0.81262465,-1.2661826,-1.6225495,-1.6225495,-1.5577556,-1.1365946,-0.16468473,0.61284316,1.2283861,1.4875621,1.1635921,0.83962213,0.22407921,-0.16468473,-0.29427271,-0.13228773,-0.067493749,1.2931801,1.4875621,0.90441613,0.51565217,-0.035096754,-0.55344868:1
-0.87793799,-1.1166973,-1.4449914,-1.4748363,-1.6837508,-1.3554567,-1.1166973,-0.78840323,0.37554854,1.3305859,1.5096554,1.4499656,1.0321367,0.49492821,0.55461805,0.73368755,0.85306722,0.49492821,0.1367892,0.10694429,0.07709937,0.8232223,0.07709937,-0.19150489:2
-0.90556361,-1.2817764,-1.513292,-1.6001104,-1.6869287,-1.513292,-0.99238196,-0.76086636,0.19413547,1.1780767,1.2359556,1.2070162,0.88868226,0.30989327,0.94656116,0.91762171,0.83080336,0.54140886,0.39671161,0.19413547,0.30989327,0.77292446,0.28095382,0.049438224:2
-0.048721308,-1.1814914,-1.5469012,-1.5834421,-1.729606,-1.4372782,-0.96224563,0.46285231,0.71863912,1.0840488,1.3032947,1.1936718,0.68209815,0.024360638,-0.1948852,-0.30450811,-0.30450811,-0.085262281,0.53593426,1.5956225,1.1571308,0.7551801,0.28014745,-0.41413103:1
0.23076381,-0.34882903,-0.73522427,-1.3148171,-1.5080147,-0.92842188,-1.1860187,-1.1860187,-0.091232217,1.7119456,1.7763448,1.840744,1.3899495,0.23076381,-0.026833011,-0.41322824,-0.47762744,-0.60642585,-0.54202665,-0.28442984,0.35956222,1.1967519,0.55275983,0.35956222:2
-0.46179411,-0.87119468,-1.2805952,-1.3683239,-1.4560526,-1.1928665,-1.4852955,-0.6372515,0.62019311,1.1758082,1.4974801,1.2635369,1.0588366,0.94186499,0.8248934,0.64943601,1.0880795,0.70792181,0.47397863,-1.2805952,-0.14012224,-0.25709383,0.064578048,0.064578048:2
-1.097752,-1.414697,-1.5731695,-1.5731695,-1.5335514,-1.4345061,-1.097752,-0.067680942,0.70487237,1.0614354,1.0812445,0.96239014,0.7841086,0.54639989,0.40773647,0.42754553,0.46716365,0.40773647,1.1208626,1.2199079,0.80391766,0.38792741,-0.028062823,-0.56290742:1
-0.48817267,-0.94290884,-1.3708958,-1.5046417,-1.5313909,-1.5046417,-1.4511434,-0.6219186,0.44804886,1.2505245,1.464518,1.4912672,1.2505245,0.7690391,0.90278503,0.7690391,0.68879154,0.44804886,0.3678013,0.046811061,-0.14043324,-0.27417917,0.073560247,-0.14043324:2
-0.90043525,-1.2615353,-1.4281968,-1.6226353,-1.5948584,-1.5393045,-1.6226353,0.15508782,0.65507244,1.0161725,1.2661648,1.0439494,0.90506475,0.59951859,0.82173398,0.87728783,0.82173398,0.51618782,0.34952628,0.3773032,0.071757051,0.51618782,0.21064167,-0.23378911:2
-0.67695063,-1.0953235,-1.478832,-1.6880185,-1.6880185,-1.5485608,-0.99073032,-0.46776416,0.26438844,0.61303255,1.0314054,1.0314054,0.7873546,0.33411727,0.055201985,0.055201985,0.1249308,1.1011343,1.4149139,1.3800495,0.96167664,0.61303255,0.15979521,-0.29344211:1
-1.0932485,-1.0672188,-1.5357539,-1.5357539,-1.5878134,-1.4836944,-1.2494269,-0.70280263,0.39044591,1.0411891,0.98912963,0.98912963,0.85898099,0.46853509,0.46853509,0.52059454,0.572654,0.46853509,0.98912963,1.3535458,0.93707017,0.49456481,-0.078089185,-0.20823782:1
-0.34210586,-0.85957692,-1.2045576,-1.4805422,-1.7220287,-1.4805422,-1.2390557,-0.92857306,-0.27310972,-0.13511744,0.69283625,0.83082853,0.72733432,0.34785554,-0.13511744,-0.066121297,-0.066121297,0.83082853,1.3138015,1.6242841,1.4172957,1.1413112,0.76183239,0.24436133:1
-0.6165858,-1.1680662,-1.4744442,-1.5663576,-1.5663576,-1.5357198,-1.2906174,-0.67786141,0.3944617,1.4667848,1.4055092,1.3135958,1.129769,0.4863751,0.63956412,0.63956412,0.79275313,0.4557373,0.11872146,0.057445861,0.27191049,0.57828851,0.27191049,-0.12638096:2
-0.26682499,-1.1112822,-1.3575822,-1.3223965,-1.5335108,-1.5335108,-1.3223965,-0.26682499,0.22577501,1.1054179,1.210975,0.96467503,0.75356074,0.12021787,-0.23163928,-0.3020107,-0.12608214,0.36651787,1.5276465,1.5980179,1.2813465,0.57763216,0.049846439,-0.40756785:1
0.43102458,-0.51847884,-1.1181652,-1.218113,-1.3680346,-1.6678778,-1.8177994,-1.0182175,0.48099845,1.4804758,1.5804235,1.6303974,1.1806326,0.33107686,0.1311814,-0.11868793,-0.21863566,-0.31858339,-0.11868793,0.1311814,0.53097231,0.6808939,0.88078936,0.031233665:2
-0.61221533,-1.0498842,-1.3625047,-1.4250289,-1.2374565,-1.5500771,-1.2999806,-0.67473944,0.32564645,1.169722,1.2947703,1.2322462,0.95088763,0.38817057,-0.20580856,-0.08076032,0.23186027,0.63826704,1.3572944,1.5136047,0.8258394,0.29438439,-0.08076032,-0.64347739:1
-1.2627064,-1.4497741,-1.5199244,-1.6602251,-1.706992,-1.4030071,-1.0990223,-0.16368418,0.65473667,1.0522554,1.0522554,1.0288719,0.91195465,0.65473667,0.70150357,0.70150357,0.74827048,0.4910525,0.30398487,0.4442856,0.56120286,0.81842084,0.28060142,-0.14030072:2
0.71432123,0.62902914,0.11727662,-0.30918381,-0.30918381,-0.30918381,0.031984528,-1.6738572,-1.5885651,-0.22389173,-0.13859964,0.28786079,-0.13859964,-0.47976799,-0.47976799,-0.56506007,-0.56506007,-0.82093633,-0.47976799,-0.30918381,0.11727662,2.420163,2.1642867,1.9084104:2
-0.58214415,-1.1312408,-1.4973052,-1.6803374,-1.6803374,-1.4667998,-1.1922515,-0.70416563,0.57705992,1.3701995,1.4617156,1.248178,1.0346404,0.51604918,0.60756529,0.66857603,0.63807066,0.51604918,0.27200621,0.1804901,-0.094058228,0.72958677,0.21099547,-0.0025421181:2
