/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class TransferResult
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=836");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=838");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=837");
    private final StatusCode statusCode;
    private final UInteger[] availableSequenceNumbers;

    public TransferResult(StatusCode statusCode, UInteger[] availableSequenceNumbers) {
        this.statusCode = statusCode;
        this.availableSequenceNumbers = availableSequenceNumbers;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public UInteger[] getAvailableSequenceNumbers() {
        return this.availableSequenceNumbers;
    }

    protected TransferResult(TransferResultBuilder<?, ?> b) {
        super(b);
        this.statusCode = ((TransferResultBuilder)b).statusCode;
        this.availableSequenceNumbers = ((TransferResultBuilder)b).availableSequenceNumbers;
    }

    public static TransferResultBuilder<?, ?> builder() {
        return new TransferResultBuilderImpl();
    }

    public TransferResultBuilder<?, ?> toBuilder() {
        return new TransferResultBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferResult)) {
            return false;
        }
        TransferResult other = (TransferResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StatusCode this$statusCode = this.getStatusCode();
        StatusCode other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        return Arrays.deepEquals(this.getAvailableSequenceNumbers(), other.getAvailableSequenceNumbers());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransferResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StatusCode $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAvailableSequenceNumbers());
        return result;
    }

    @Override
    public String toString() {
        return "TransferResult(statusCode=" + this.getStatusCode() + ", availableSequenceNumbers=" + Arrays.deepToString(this.getAvailableSequenceNumbers()) + ")";
    }

    private static final class TransferResultBuilderImpl
    extends TransferResultBuilder<TransferResult, TransferResultBuilderImpl> {
        private TransferResultBuilderImpl() {
        }

        @Override
        protected TransferResultBuilderImpl self() {
            return this;
        }

        @Override
        public TransferResult build() {
            return new TransferResult(this);
        }
    }

    public static abstract class TransferResultBuilder<C extends TransferResult, B extends TransferResultBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private StatusCode statusCode;
        private UInteger[] availableSequenceNumbers;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TransferResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(TransferResult instance, TransferResultBuilder<?, ?> b) {
            b.statusCode(instance.statusCode);
            b.availableSequenceNumbers(instance.availableSequenceNumbers);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B statusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return (B)this.self();
        }

        public B availableSequenceNumbers(UInteger[] availableSequenceNumbers) {
            this.availableSequenceNumbers = availableSequenceNumbers;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TransferResult.TransferResultBuilder(super=" + super.toString() + ", statusCode=" + this.statusCode + ", availableSequenceNumbers=" + Arrays.deepToString(this.availableSequenceNumbers) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<TransferResult> {
        @Override
        public Class<TransferResult> getType() {
            return TransferResult.class;
        }

        @Override
        public TransferResult decode(SerializationContext context, UaDecoder decoder) {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            UInteger[] availableSequenceNumbers = decoder.readUInt32Array("AvailableSequenceNumbers");
            return new TransferResult(statusCode, availableSequenceNumbers);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, TransferResult value) {
            encoder.writeStatusCode("StatusCode", value.getStatusCode());
            encoder.writeUInt32Array("AvailableSequenceNumbers", value.getAvailableSequenceNumbers());
        }
    }
}

