/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.io.File;
import java.util.HashMap;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BindingMethod;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.classes.MungedClass;
import org.jibx.runtime.JiBXException;

public class BoundClass {
    private static final String ACCESS_PREFIX = "JiBX_access_";
    private static final Type[] EMPTY_TYPE_ARGS = new Type[0];
    private static HashMap s_nameMap;
    private static String s_modifyPackage;
    private static File s_modifyRoot;
    private static String s_mungeName;
    private static MungedClass s_genericMunge;
    private final ClassFile m_boundClass;
    private final MungedClass m_directMungedClass;
    private final MungedClass m_mungedClass;
    private HashMap m_loadMap;
    private HashMap m_storeMap;

    private BoundClass(ClassFile bound, MungedClass dmunge, MungedClass munge) {
        this.m_boundClass = bound;
        this.m_directMungedClass = dmunge;
        this.m_mungedClass = munge;
    }

    public ClassFile getClassFile() {
        return this.m_boundClass;
    }

    public String getClassName() {
        return this.m_boundClass.getName();
    }

    public ClassFile getDirectMungedFile() {
        if (this.m_directMungedClass == null) {
            throw new IllegalStateException("Internal error - no direct access to class " + this.m_boundClass.getName());
        }
        return this.m_directMungedClass.getClassFile();
    }

    public ClassFile getMungedFile() {
        return this.m_mungedClass.getClassFile();
    }

    public boolean isDirectAccess() {
        return this.m_boundClass == this.m_mungedClass.getClassFile();
    }

    public boolean isLimitedDirectAccess() {
        return this.isDirectAccess() || this.m_boundClass.isModifiable();
    }

    public ClassItem getLoadMethod(ClassItem item, ClassFile from) throws JiBXException {
        BindingMethod method;
        if (this.m_loadMap == null) {
            this.m_loadMap = new HashMap();
        }
        if ((method = (BindingMethod)this.m_loadMap.get(item)) == null) {
            String name = "JiBX_access_load_" + item.getName();
            ClassFile cf = item.getClassFile();
            Type type = Type.getType((String)Utility.getSignature((String)item.getTypeName()));
            ExceptionMethodBuilder mb = new ExceptionMethodBuilder(name, type, EMPTY_TYPE_ARGS, cf, 1);
            mb.appendLoadLocal(0);
            if (item.isMethod()) {
                mb.addMethodExceptions(item);
                mb.appendCall(item);
            } else {
                mb.appendGetField(item);
            }
            mb.appendReturn(type);
            method = this.m_directMungedClass.getUniqueMethod(mb, true);
            this.m_loadMap.put(item, method);
        }
        method.makeAccessible(from);
        return method.getItem();
    }

    public ClassItem getStoreMethod(ClassItem item, ClassFile from) throws JiBXException {
        BindingMethod method;
        if (this.m_storeMap == null) {
            this.m_storeMap = new HashMap();
        }
        if ((method = (BindingMethod)this.m_storeMap.get(item)) == null) {
            Type type;
            String name = "JiBX_access_store_" + item.getName();
            ClassFile cf = item.getClassFile();
            if (item.isMethod()) {
                String sig = item.getSignature();
                int start = sig.indexOf(40);
                int end = sig.indexOf(41);
                type = Type.getType((String)sig.substring(start + 1, end));
            } else {
                type = Type.getType((String)Utility.getSignature((String)item.getTypeName()));
            }
            ExceptionMethodBuilder mb = new ExceptionMethodBuilder(name, (Type)Type.VOID, new Type[]{type}, cf, 1);
            mb.appendLoadLocal(0);
            mb.appendLoadLocal(1);
            if (item.isMethod()) {
                mb.addMethodExceptions(item);
                mb.appendCall(item);
            } else {
                mb.appendPutField(item);
            }
            mb.appendReturn();
            method = this.m_directMungedClass.getUniqueMethod(mb, true);
            this.m_storeMap.put(item, method);
        }
        method.makeAccessible(from);
        return method.getItem();
    }

    public BindingMethod getUniqueMethod(MethodBuilder builder) throws JiBXException {
        return this.m_mungedClass.getUniqueMethod(builder, true);
    }

    public BindingMethod getUniqueNamed(MethodBuilder builder) throws JiBXException {
        if (builder.getClassFile() == this.m_boundClass) {
            return this.m_directMungedClass.getUniqueMethod(builder, false);
        }
        return this.m_mungedClass.getUniqueMethod(builder, false);
    }

    public void addFactory(String fact) {
        if (!this.isLimitedDirectAccess()) {
            throw new IllegalStateException("Internal error: not directly modifiable class");
        }
        this.m_directMungedClass.addFactory(fact);
    }

    private static BoundClass createInstance(String key, ClassFile bound, MungedClass dmunge, MungedClass munge) {
        BoundClass inst = new BoundClass(bound, dmunge, munge);
        s_nameMap.put(key, inst);
        return inst;
    }

    private static BoundClass findOrCreateInstance(ClassFile bound, MungedClass munge) {
        String key = bound.getName() + ':' + munge.getClassFile().getName();
        BoundClass inst = (BoundClass)s_nameMap.get(key);
        if (inst == null) {
            inst = BoundClass.createInstance(key, bound, null, munge);
        }
        return inst;
    }

    public static BoundClass getInstance(ClassFile cf, BoundClass context) throws JiBXException {
        BoundClass inst = (BoundClass)s_nameMap.get(cf.getName());
        if (inst == null) {
            if (!cf.isInterface() && cf.isModifiable()) {
                if (cf.isExtendable()) {
                    MungedClass munge = MungedClass.getInstance(cf);
                    inst = BoundClass.createInstance(cf.getName(), cf, munge, munge);
                } else {
                    MungedClass dmunge = MungedClass.getInstance(cf);
                    inst = BoundClass.createInstance(cf.getName(), cf, dmunge, BoundClass.getGenericMunge());
                }
                if (s_modifyRoot == null) {
                    s_modifyRoot = cf.getRoot();
                }
                if (s_modifyPackage == null && (s_modifyPackage = cf.getPackage()) != null && s_modifyPackage.length() == 0) {
                    s_modifyPackage = null;
                }
            } else {
                inst = context != null && context.getClassFile().isSuperclass(cf.getName()) ? BoundClass.findOrCreateInstance(cf, context.m_mungedClass) : BoundClass.findOrCreateInstance(cf, BoundClass.getGenericMunge());
            }
        }
        return inst;
    }

    private static MungedClass getGenericMunge() throws JiBXException {
        if (s_genericMunge == null) {
            String mname;
            if (s_modifyPackage == null) {
                mname = s_mungeName;
                MungedClass.checkDirectory(s_modifyRoot, "");
            } else {
                mname = s_modifyPackage + '.' + s_mungeName;
                MungedClass.checkDirectory(s_modifyRoot, s_modifyPackage);
            }
            ClassFile base = ClassCache.requireClassFile("java.lang.Object");
            int acc = 1025;
            ClassFile gen = new ClassFile(mname, s_modifyRoot, base, acc, new String[0]);
            gen.addDefaultConstructor();
            s_genericMunge = MungedClass.getInstance(gen);
            MungedClass.delayedAddUnique(gen);
        }
        return s_genericMunge;
    }

    public static BoundClass getInstance(String name, BoundClass context) throws JiBXException {
        BoundClass inst = (BoundClass)s_nameMap.get(name);
        if (inst == null) {
            ClassFile cf = ClassCache.requireClassFile(name);
            return BoundClass.getInstance(cf, context);
        }
        return inst;
    }

    public static void reset() {
        s_nameMap = new HashMap();
        s_modifyPackage = null;
        s_modifyRoot = null;
        s_genericMunge = null;
        s_mungeName = null;
    }

    public static void setModify(File root, String pkg, String name) {
        if (s_modifyRoot == null) {
            s_modifyRoot = root;
        }
        if (s_modifyPackage == null && pkg != null && pkg.length() > 0) {
            s_modifyPackage = pkg;
        }
        if (s_mungeName == null) {
            s_mungeName = "JiBX_" + name + "MungeAdapter";
        }
    }

    public String deriveClassName(String prefix, String suffix) {
        String tname;
        int split;
        String pack = this.m_mungedClass.getClassFile().getPackage();
        if (pack.length() > 0) {
            pack = pack + '.';
        }
        if ((split = (tname = this.m_boundClass.getName()).lastIndexOf(46)) >= 0) {
            tname = tname.substring(split + 1);
        }
        return pack + prefix + tname + suffix;
    }

    static {
        s_mungeName = "JiBX_MungeAdapter";
    }
}

