/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.impl;

import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreLeafNode;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreModelStreamException;
import org.apache.axiom.core.CoreNSAwareElement;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.InputContext;
import org.apache.axiom.core.NodeConsumedException;
import org.apache.axiom.core.impl.mixin.CoreAttributeSupport;
import org.apache.axiom.core.impl.mixin.CoreChildNodeSupport;
import org.apache.axiom.core.impl.mixin.CoreElementSupport;
import org.apache.axiom.core.impl.mixin.CoreNSAwareElementSupport;
import org.apache.axiom.core.impl.mixin.CoreParentNodeSupport;
import org.apache.axiom.core.stream.DocumentElementExtractingFilterHandler;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlInput;
import org.apache.axiom.core.stream.XmlReader;

public final class TreeWalkerImpl
implements XmlReader {
    private static final int STATE_NONE = 0;
    private static final int STATE_START_FRAGMENT = 1;
    private static final int STATE_LEAF = 2;
    private static final int STATE_NOT_VISITED = 3;
    private static final int STATE_ATTRIBUTES_VISITED = 4;
    private static final int STATE_VISITED = 5;
    private static final int STATE_PASS_THROUGH = 6;
    private static final int STATE_STREAMING = 7;
    private static final int STATE_ATTRIBUTE = 8;
    private final XmlHandler handler;
    private final CoreParentNode root;
    private final boolean preserve;
    private final boolean incremental;
    private CoreNode node;
    private XmlReader reader;
    private int state = 0;

    public TreeWalkerImpl(XmlHandler handler, CoreParentNode root, boolean preserve, boolean incremental) {
        this.handler = handler;
        this.root = root;
        this.preserve = preserve;
        this.incremental = incremental;
    }

    @Override
    public boolean proceed() throws StreamException {
        if (this.incremental && !this.handler.drain()) {
            return false;
        }
        try {
            CoreParentNode parent;
            CoreNode nextNode;
            CoreNode previousNode = this.node;
            if (this.state == 6 || this.state == 7) {
                nextNode = previousNode;
            } else if (previousNode == null) {
                if (this.state == 0 && !(this.root instanceof CoreDocument)) {
                    nextNode = null;
                    this.state = 1;
                } else {
                    nextNode = this.root;
                    this.state = 3;
                }
            } else if (this.state == 5 && previousNode == this.root) {
                nextNode = null;
            } else if (this.state == 3 && previousNode instanceof CoreElement) {
                CoreElement element = (CoreElement)previousNode;
                CoreAttribute firstAttribute = CoreElementSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreElementSupport$org_apache_axiom_core_CoreElement$coreGetFirstAttribute(element);
                if (firstAttribute == null) {
                    nextNode = element;
                    this.state = 4;
                } else {
                    nextNode = firstAttribute;
                    this.state = 3;
                }
            } else if (this.state == 3 || this.state == 4) {
                parent = (CoreParentNode)previousNode;
                int nodeState = CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$getState(parent);
                if (this.preserve || nodeState == 0 || nodeState == 5) {
                    CoreChildNode child = CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetFirstChild(parent);
                    if (child == null) {
                        nextNode = parent;
                        this.state = 5;
                    } else {
                        nextNode = child;
                        this.state = 3;
                    }
                } else {
                    CoreChildNode child = CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetFirstChildIfAvailable(parent);
                    if (child == null) {
                        nextNode = parent;
                        if (nodeState == 3 || nodeState == 4) {
                            throw new NodeConsumedException();
                        }
                        CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetInputContext(parent).setPassThroughHandler(this.handler);
                        this.state = 6;
                    } else {
                        nextNode = child;
                        this.state = 3;
                    }
                }
            } else if (previousNode instanceof CoreChildNode) {
                CoreChildNode previousChildNode = (CoreChildNode)previousNode;
                if (this.preserve) {
                    CoreChildNode sibling = CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetNextSibling(previousChildNode);
                    if (sibling == null) {
                        nextNode = CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent(previousChildNode);
                        this.state = 5;
                    } else {
                        nextNode = sibling;
                        this.state = 3;
                    }
                } else {
                    CoreChildNode sibling = CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetNextSiblingIfAvailable(previousChildNode);
                    if (sibling == null) {
                        CoreParentNode parent2 = CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent(previousChildNode);
                        nextNode = parent2;
                        int nodeState = CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$getState(parent2);
                        if (nodeState == 2 && CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetInputContext(parent2) == null) {
                            nodeState = 0;
                        }
                        if (nodeState == 0) {
                            this.state = 5;
                        } else {
                            if (nodeState == 3 || nodeState == 4) {
                                throw new NodeConsumedException();
                            }
                            CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetInputContext(parent2).setPassThroughHandler(this.handler);
                            this.state = 6;
                        }
                    } else {
                        nextNode = sibling;
                        this.state = 3;
                    }
                }
            } else {
                CoreAttribute attribute = (CoreAttribute)previousNode;
                CoreAttribute nextAttribute = CoreAttributeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreAttributeSupport$org_apache_axiom_core_CoreAttribute$coreGetNextAttribute(attribute);
                if (nextAttribute == null) {
                    nextNode = CoreAttributeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreAttributeSupport$org_apache_axiom_core_CoreAttribute$coreGetOwnerElement(attribute);
                    this.state = 4;
                } else {
                    nextNode = nextAttribute;
                    this.state = 3;
                }
            }
            if (this.state == 3) {
                if (nextNode instanceof CoreNSAwareElement) {
                    XmlInput input = CoreNSAwareElementSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreNSAwareElementSupport$org_apache_axiom_core_CoreNSAwareElement$getXmlInput((CoreNSAwareElement)nextNode, this.preserve, this.incremental);
                    if (input != null) {
                        this.reader = input.createReader(new DocumentElementExtractingFilterHandler(this.handler));
                        this.state = 7;
                    }
                } else if (nextNode instanceof CoreLeafNode) {
                    this.state = 2;
                } else if (nextNode instanceof CoreAttribute) {
                    this.state = 8;
                }
            }
            switch (this.state) {
                case 1: {
                    this.handler.startFragment();
                    break;
                }
                case 2: {
                    ((CoreLeafNode)nextNode).internalSerialize(this.handler, this.preserve);
                    break;
                }
                case 8: {
                    CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$internalSerialize((CoreAttribute)nextNode, this.handler, this.preserve);
                    break;
                }
                case 3: {
                    CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$serializeStartEvent((CoreParentNode)nextNode, this.handler);
                    break;
                }
                case 4: {
                    this.handler.attributesCompleted();
                    break;
                }
                case 5: {
                    if (nextNode == null) {
                        this.handler.completed();
                        break;
                    }
                    CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$serializeEndEvent((CoreParentNode)nextNode, this.handler);
                    break;
                }
                case 6: {
                    parent = (CoreParentNode)nextNode;
                    CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetInputContext(parent).getBuilder().next();
                    if (CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetInputContext(parent) != null) break;
                    this.state = 5;
                    break;
                }
                case 7: {
                    if (!this.reader.proceed()) break;
                    this.state = 5;
                    this.reader = null;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.node = nextNode;
            return this.state == 5 && (nextNode == null || nextNode instanceof CoreDocument);
        }
        catch (CoreModelException ex) {
            throw new CoreModelStreamException(ex);
        }
    }

    @Override
    public void dispose() {
        if (!this.preserve && this.node != null) {
            CoreParentNode parent;
            CoreParentNode coreParentNode = parent = this.node instanceof CoreParentNode ? (CoreParentNode)this.node : CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent((CoreChildNode)this.node);
            while (true) {
                InputContext context;
                if ((context = CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetInputContext(parent)) != null) {
                    context.discard();
                }
                if (parent == this.root) break;
                parent = CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent((CoreChildNode)((Object)parent));
            }
        }
        if (this.reader != null) {
            this.reader.dispose();
        }
    }
}

