/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.util.xml.QNameCacheEntry;

public final class QNameCache {
    private static final QNameCacheEntry[] cache = new QNameCacheEntry[1024];

    private QNameCache() {
    }

    public static QName getQName(String namespaceURI, String localPart, String prefix) {
        int index = (namespaceURI.hashCode() ^ localPart.hashCode() ^ prefix.hashCode()) & cache.length - 1;
        QNameCacheEntry entry = cache[index];
        QName qname = (QName)entry.get();
        if (!(qname != null && qname.getNamespaceURI().equals(namespaceURI) && qname.getLocalPart().equals(localPart) && qname.getPrefix().equals(prefix))) {
            qname = new QName(namespaceURI, localPart, prefix);
            entry.set(qname);
        }
        return qname;
    }

    public static QName getQName(String namespaceURI, String localPart) {
        return QNameCache.getQName(namespaceURI, localPart, "");
    }

    static {
        for (int i = 0; i < cache.length; ++i) {
            QNameCache.cache[i] = new QNameCacheEntry();
        }
    }
}

