/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description.java2wsdl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.ws.commons.schema.constants.Constants;
import org.w3c.dom.Document;

public class TypeTable {
    private static HashMap<String, QName> simpleTypetoxsd;
    public static final QName ANY_TYPE;
    private HashMap<String, QName> complexTypeMap = new HashMap();
    private HashMap<String, QName> simpleTypeEnum;
    private Map<QName, String> qNameToClassMap = new HashMap<QName, String>();
    private static Map<QName, String> qNameToJavaTypeMap;

    public TypeTable() {
        this.simpleTypeEnum = new HashMap();
    }

    private static void populateSimpleTypes() {
        simpleTypetoxsd = new HashMap();
        simpleTypetoxsd.put("int", new QName("http://www.w3.org/2001/XMLSchema", "int", "xs"));
        simpleTypetoxsd.put("java.lang.String", new QName("http://www.w3.org/2001/XMLSchema", "string", "xs"));
        simpleTypetoxsd.put("boolean", new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xs"));
        simpleTypetoxsd.put("float", new QName("http://www.w3.org/2001/XMLSchema", "float", "xs"));
        simpleTypetoxsd.put("double", new QName("http://www.w3.org/2001/XMLSchema", "double", "xs"));
        simpleTypetoxsd.put("short", new QName("http://www.w3.org/2001/XMLSchema", "short", "xs"));
        simpleTypetoxsd.put("long", new QName("http://www.w3.org/2001/XMLSchema", "long", "xs"));
        simpleTypetoxsd.put("byte", new QName("http://www.w3.org/2001/XMLSchema", "byte", "xs"));
        simpleTypetoxsd.put("char", new QName("http://www.w3.org/2001/XMLSchema", "unsignedShort", "xs"));
        simpleTypetoxsd.put("java.lang.Integer", new QName("http://www.w3.org/2001/XMLSchema", "int", "xs"));
        simpleTypetoxsd.put("java.lang.Double", new QName("http://www.w3.org/2001/XMLSchema", "double", "xs"));
        simpleTypetoxsd.put("java.lang.Float", new QName("http://www.w3.org/2001/XMLSchema", "float", "xs"));
        simpleTypetoxsd.put("java.lang.Long", new QName("http://www.w3.org/2001/XMLSchema", "long", "xs"));
        simpleTypetoxsd.put("java.lang.Character", ANY_TYPE);
        simpleTypetoxsd.put("java.lang.Boolean", new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xs"));
        simpleTypetoxsd.put("java.lang.Byte", new QName("http://www.w3.org/2001/XMLSchema", "byte", "xs"));
        simpleTypetoxsd.put("java.lang.Short", new QName("http://www.w3.org/2001/XMLSchema", "short", "xs"));
        simpleTypetoxsd.put("java.util.Date", new QName("http://www.w3.org/2001/XMLSchema", "date", "xs"));
        simpleTypetoxsd.put("java.util.Calendar", new QName("http://www.w3.org/2001/XMLSchema", "dateTime", "xs"));
        simpleTypetoxsd.put("java.sql.Date", new QName("http://www.w3.org/2001/XMLSchema", "date", "xs"));
        simpleTypetoxsd.put("java.sql.Time", new QName("http://www.w3.org/2001/XMLSchema", "time", "xs"));
        simpleTypetoxsd.put("java.sql.Timestamp", new QName("http://www.w3.org/2001/XMLSchema", "dateTime", "xs"));
        simpleTypetoxsd.put("java.math.BigDecimal", new QName("http://www.w3.org/2001/XMLSchema", "decimal", "xs"));
        simpleTypetoxsd.put("java.math.BigInteger", new QName("http://www.w3.org/2001/XMLSchema", "integer", "xs"));
        simpleTypetoxsd.put("org.apache.axis2.databinding.types.Day", new QName("http://www.w3.org/2001/XMLSchema", "gDay", "xs"));
        simpleTypetoxsd.put("org.apache.axis2.databinding.types.Duration", new QName("http://www.w3.org/2001/XMLSchema", "duration", "xs"));
        simpleTypetoxsd.put("org.apache.axis2.databinding.types.Month", new QName("http://www.w3.org/2001/XMLSchema", "gMonth", "xs"));
        simpleTypetoxsd.put("org.apache.axis2.databinding.types.MonthDay", new QName("http://www.w3.org/2001/XMLSchema", "gMonthDay", "xs"));
        simpleTypetoxsd.put("org.apache.axis2.databinding.types.Time", new QName("http://www.w3.org/2001/XMLSchema", "time", "xs"));
        simpleTypetoxsd.put("org.apache.axis2.databinding.types.Year", new QName("http://www.w3.org/2001/XMLSchema", "gYear", "xs"));
        simpleTypetoxsd.put("org.apache.axis2.databinding.types.YearMonth", new QName("http://www.w3.org/2001/XMLSchema", "gYearMonth", "xs"));
        simpleTypetoxsd.put("java.lang.Object", ANY_TYPE);
        simpleTypetoxsd.put(URI.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "anyURI", "xs"));
        simpleTypetoxsd.put(OMElement.class.getName(), ANY_TYPE);
        simpleTypetoxsd.put(ArrayList.class.getName(), ANY_TYPE);
        simpleTypetoxsd.put(Vector.class.getName(), ANY_TYPE);
        simpleTypetoxsd.put(List.class.getName(), ANY_TYPE);
        simpleTypetoxsd.put(Document.class.getName(), ANY_TYPE);
        simpleTypetoxsd.put("base64Binary", new QName("http://www.w3.org/2001/XMLSchema", "base64Binary", "xs"));
        simpleTypetoxsd.put(XMLGregorianCalendar.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "date", "xs"));
    }

    private static void populateJavaTypeMap() {
        qNameToJavaTypeMap = new HashMap<QName, String>();
        qNameToJavaTypeMap.put(Constants.XSD_STRING, String.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_INT, Integer.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_INTEGER, BigInteger.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_LONG, Long.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_SHORT, Short.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_DECIMAL, BigDecimal.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_FLOAT, Float.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_DOUBLE, Double.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_BOOLEAN, Boolean.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_BYTE, Byte.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_QNAME, QName.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_UNSIGNEDINT, Long.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_UNSIGNEDSHORT, Integer.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_UNSIGNEDBYTE, Short.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_UNSIGNEDLONG, BigInteger.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_TIME, XMLGregorianCalendar.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_DATE, XMLGregorianCalendar.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_DATETIME, XMLGregorianCalendar.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_DURATION, Duration.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_NOTATION, QName.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_ANYURI, URI.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_ANY, Object.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_ANYSIMPLETYPE, Object.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_ANYTYPE, Object.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_NONNEGATIVEINTEGER, BigInteger.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_NONPOSITIVEINTEGER, BigInteger.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_NEGATIVEINTEGER, Integer.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_POSITIVEINTEGER, Integer.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_NORMALIZEDSTRING, String.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_POSITIVEINTEGER, Integer.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_POSITIVEINTEGER, Integer.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_POSITIVEINTEGER, Integer.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_POSITIVEINTEGER, Integer.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_BASE64, DataHandler.class.getName());
        qNameToJavaTypeMap.put(Constants.XSD_HEXBIN, DataHandler.class.getName());
    }

    public QName getSimpleSchemaTypeName(String typeName) {
        QName qName = simpleTypetoxsd.get(typeName);
        if (qName == null && (typeName.startsWith("java.lang") || typeName.startsWith("javax.")) && !Exception.class.getName().equals(typeName)) {
            return ANY_TYPE;
        }
        return qName;
    }

    public boolean isSimpleType(String typeName) {
        if (simpleTypetoxsd.keySet().contains(typeName)) {
            return true;
        }
        return typeName.startsWith("java.lang") || typeName.startsWith("javax.");
    }

    public Map<String, QName> getSimpleTypeEnumMap() {
        return this.simpleTypeEnum;
    }

    public void addSimpleTypeEnum(String className, QName simpleSchemaType) {
        this.simpleTypeEnum.put(className, simpleSchemaType);
    }

    public QName getSimpleTypeEnum(String className) {
        return this.simpleTypeEnum.get(className);
    }

    public Map<String, QName> getComplexSchemaMap() {
        return this.complexTypeMap;
    }

    public void addComplexSchema(String name, QName schemaType) {
        this.complexTypeMap.put(name, schemaType);
    }

    public QName getComplexSchemaType(String name) {
        return this.complexTypeMap.get(name);
    }

    public String getClassNameForQName(QName qname) {
        String className = this.qNameToClassMap.get(qname);
        if (className == null) {
            className = qNameToJavaTypeMap.get(qname);
        }
        return className;
    }

    public void addClassNameForQName(QName qname, String className) {
        this.qNameToClassMap.put(qname, className);
    }

    public QName getQNamefortheType(String typeName) {
        QName type = this.getSimpleSchemaTypeName(typeName);
        if (type == null) {
            type = this.getComplexSchemaType(typeName);
        }
        return type;
    }

    public QName getSchemaTypeName(String name) {
        QName qName = this.getSimpleSchemaTypeName(name);
        if (qName == null) {
            qName = this.getSchemaTypeNameByClass(name);
        }
        if (qName == null) {
            qName = this.getComplexSchemaType(name);
        }
        return qName;
    }

    private QName getSchemaTypeNameByClass(String name) {
        try {
            Class<?> thisClass = Class.forName(name);
            if (XMLGregorianCalendar.class.isAssignableFrom(thisClass)) {
                return simpleTypetoxsd.get(XMLGregorianCalendar.class.getName());
            }
            if (Calendar.class.isAssignableFrom(thisClass)) {
                return simpleTypetoxsd.get(Calendar.class.getName());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        ANY_TYPE = new QName("http://www.w3.org/2001/XMLSchema", "anyType", "xs");
        TypeTable.populateSimpleTypes();
        TypeTable.populateJavaTypeMap();
    }
}

